/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.algebra.sql.datatype;

import org.aksw.commons.util.reflect.MultiMethod;
import org.aksw.sparqlify.algebra.sql.exprs.S_Concat;
import org.aksw.sparqlify.algebra.sql.exprs.S_Function;
import org.aksw.sparqlify.algebra.sql.exprs.S_LogicalAnd;
import org.aksw.sparqlify.algebra.sql.exprs.S_LogicalNot;
import org.aksw.sparqlify.algebra.sql.exprs.S_LogicalOr;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExpr;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExprColumn;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExprValue;
import org.aksw.sparqlify.core.DatatypeSystemDefault;
import org.aksw.sparqlify.core.SqlDatatype;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlDatatypeEvaluator {
    private static final Logger logger = LoggerFactory.getLogger(SqlDatatypeEvaluator.class);

    public static SqlDatatype eval(SqlExpr expr) {
        return (SqlDatatype)MultiMethod.invokeStatic(SqlDatatypeEvaluator.class, (String)"_eval", (Object[])new Object[]{expr});
    }

    public static SqlDatatype _eval(S_Concat expr) {
        return DatatypeSystemDefault._STRING;
    }

    public static SqlDatatype _eval(S_LogicalAnd expr) {
        return DatatypeSystemDefault._BOOLEAN;
    }

    public static SqlDatatype _eval(S_LogicalOr expr) {
        return DatatypeSystemDefault._BOOLEAN;
    }

    public static SqlDatatype _eval(S_LogicalNot expr) {
        return DatatypeSystemDefault._BOOLEAN;
    }

    public static SqlDatatype _eval(S_Function expr) {
        return expr.getDatatype();
    }

    public static SqlDatatype _eval(SqlExprColumn expr) {
        return expr.getDatatype();
    }

    public static SqlDatatype _eval(SqlExprValue expr) {
        SqlDatatype result = SqlDatatypeEvaluator.getDatatype(expr.getObject());
        return result;
    }

    public static SqlDatatype getDatatype(Object o) {
        if (o == null) {
            throw new NullPointerException("Should not happen");
        }
        for (SqlDatatype datataype : DatatypeSystemDefault.getDefaultDatatypes()) {
            Class<?> correspondingClass = datataype.getCorrespondingClass();
            if (correspondingClass == null || !datataype.getCorrespondingClass().isAssignableFrom(o.getClass())) continue;
            return datataype;
        }
        throw new RuntimeException("Unsupported datatype: " + o + ", " + (o != null ? o.getClass() : ""));
    }
}

