/*
 * Decompiled with CFR 0.152.
 */
package sparql;

import com.google.common.base.Joiner;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingHashMap;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.aksw.commons.util.Pair;

public class ViewTable {
    private DataSource dataSource;
    private String tableName;
    private List<String> varNames;
    private boolean isCreated = false;
    private Connection conn;

    private void prepare() throws SQLException {
        if (!this.isCreated) {
            ViewTable.createTable(this.dataSource, this.tableName, this.varNames);
            this.isCreated = true;
            this.conn = this.dataSource.getConnection();
        }
    }

    public static List<String> toStringSet(Set<Var> varNames) {
        ArrayList<String> result = new ArrayList<String>();
        for (Var varName : varNames) {
            result.add(varName.getVarName());
        }
        return result;
    }

    public ViewTable(DataSource dataSource, String tableName, Set<Var> varNames) {
        this.dataSource = dataSource;
        this.tableName = tableName;
        this.varNames = ViewTable.toStringSet(varNames);
    }

    public static Pair<List<String>, List<String>> getValues(Binding binding) {
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        Iterator it = binding.vars();
        while (it.hasNext()) {
            Var key = (Var)it.next();
            keys.add(key.getName());
            values.add(binding.get(key).toString());
        }
        return Pair.create(keys, values);
    }

    public static Pair<String, String> toParts(Binding binding) {
        Pair<List<String>, List<String>> pair = ViewTable.getValues(binding);
        return Pair.create((Object)("(" + Joiner.on((String)", ").join((Iterable)pair.getKey()) + ")"), (Object)("('" + Joiner.on((String)"', '").join((Iterable)pair.getValue()) + "')"));
    }

    public static String toSqlPredicate(Binding binding) {
        Pair<String, String> pair = ViewTable.toParts(binding);
        return (String)pair.getKey() + " = " + (String)pair.getValue();
    }

    private ResultSet executeQuery(String query) throws SQLException {
        return this.conn.createStatement().executeQuery(query);
    }

    public Iterable<Binding> lookup(Binding binding) throws SQLException {
        this.prepare();
        String sql = "SELECT * FROM " + this.tableName + " WHERE TRUE AND " + ViewTable.toSqlPredicate(binding);
        ResultSet rs = this.executeQuery(sql);
        ResultSetMetaData meta = rs.getMetaData();
        ArrayList<Binding> result = new ArrayList<Binding>();
        while (rs.next()) {
            BindingHashMap item = new BindingHashMap();
            for (int i = 1; i <= meta.getColumnCount(); ++i) {
                Object o = rs.getObject(i);
                Node node = Node.createURI((String)o.toString());
                item.add(Var.alloc((String)meta.getColumnName(i)), node);
            }
        }
        return result;
    }

    public void insert(Binding binding) throws SQLException {
        this.prepare();
        Pair<String, String> pair = ViewTable.toParts(binding);
        String sql = "INSERT INTO " + this.tableName + (String)pair.getKey() + " VALUES " + (String)pair.getValue() + ";";
        System.out.println(sql);
    }

    public void remove(Binding binding) throws SQLException {
        this.prepare();
        String sql = "DELETE FROM " + this.tableName + " WHERE " + ViewTable.toSqlPredicate(binding) + ";";
        this.conn.createStatement().execute(sql);
    }

    public void clear() throws SQLException {
        this.prepare();
        String sql = "DELETE FROM " + this.tableName;
        this.conn.createStatement().execute(sql);
    }

    public void createIndex(String var) {
    }

    public static void createTable(DataSource dataSource, String tableName, Iterable<String> varNames) throws SQLException {
        ArrayList<String> columns = new ArrayList<String>();
        for (String varName : varNames) {
            columns.add("\t" + varName + " text");
        }
        String sql = "CREATE TABLE " + tableName + "(\n" + Joiner.on((String)",\n").join(columns) + ");";
        Connection conn = dataSource.getConnection();
        try {
            conn.createStatement().execute(sql);
        }
        catch (Exception e) {
            System.err.println("Exception type: " + e.getClass());
            e.printStackTrace();
        }
    }
}

