/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.views.transform;

import com.hp.hpl.jena.sdb.core.JoinType;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.op.OpDisjunction;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpExtend;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGroup;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpNull;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpSlice;
import com.hp.hpl.jena.sparql.expr.ExprList;
import java.util.ArrayList;
import org.aksw.commons.util.reflect.MultiMethod;
import org.aksw.sparqlify.algebra.sparql.domain.OpRdfViewPattern;
import org.aksw.sparqlify.algebra.sql.nodes.SqlNodeEmpty;
import org.aksw.sparqlify.algebra.sql.nodes.SqlNodeOld;
import org.aksw.sparqlify.core.ColRelGenerator;
import org.aksw.sparqlify.core.RdfViewInstance;
import org.aksw.sparqlify.core.SqlNodeBinding;
import org.aksw.sparqlify.database.Clause;
import org.aksw.sparqlify.database.OpFilterIndexed;
import org.aksw.sparqlify.expr.util.ExprUtils;
import org.aksw.sparqlify.views.transform.EmptyRewriteException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewRewriter {
    private static final Logger logger = LoggerFactory.getLogger(ViewRewriter.class);

    public SqlNodeOld rewrite(ColRelGenerator generator, OpLeftJoin op) {
        SqlNodeOld a = this.rewriteMM(generator, op.getLeft());
        if (a instanceof SqlNodeEmpty) {
            return a;
        }
        SqlNodeOld b = this.rewriteMM(generator, op.getRight());
        if (b instanceof SqlNodeEmpty) {
            return a;
        }
        if (b.getAliasName() == null) {
            String newAlias = generator.nextRelation();
        }
        a = SqlNodeBinding.join(generator, a, b, JoinType.LEFT);
        return a;
    }

    public SqlNodeOld rewrite(ColRelGenerator generator, OpDisjunction op) {
        ArrayList<SqlNodeOld> bindings = new ArrayList<SqlNodeOld>();
        for (Op item : op.getElements()) {
            SqlNodeOld binding = this.rewriteMM(generator, item);
            if (binding instanceof SqlNodeEmpty) continue;
            bindings.add(binding);
        }
        SqlNodeOld result = SqlNodeBinding.union(generator, bindings);
        return result;
    }

    public SqlNodeOld rewrite(ColRelGenerator generator, OpRdfViewPattern op) {
        SqlNodeOld a = null;
        for (RdfViewInstance inst : op.getConjunction().getViewBindings()) {
            SqlNodeOld b = SqlNodeBinding.create(generator, inst);
            if (b instanceof SqlNodeEmpty) {
                return new SqlNodeEmpty();
            }
            if (a == null) {
                a = b;
                continue;
            }
            if (!((a = SqlNodeBinding.join(generator, a, b, JoinType.INNER)) instanceof SqlNodeEmpty)) continue;
            return new SqlNodeEmpty();
        }
        return a;
    }

    public SqlNodeOld rewrite(ColRelGenerator generator, OpJoin op) {
        SqlNodeOld a = this.rewriteMM(generator, op.getLeft());
        SqlNodeOld b = this.rewriteMM(generator, op.getRight());
        SqlNodeOld result = SqlNodeBinding.join(generator, a, b, JoinType.INNER);
        return result;
    }

    public SqlNodeOld rewrite(ColRelGenerator generator, OpDistinct op) {
        SqlNodeOld subNode = this.rewriteMM(generator, op.getSubOp());
        if (subNode instanceof SqlNodeEmpty) {
            return subNode;
        }
        SqlNodeOld result = SqlNodeBinding.distinct(subNode);
        return result;
    }

    public SqlNodeOld rewrite(ColRelGenerator generator, OpSlice op) {
        SqlNodeOld subNode = this.rewriteMM(generator, op.getSubOp());
        if (subNode instanceof SqlNodeEmpty) {
            return subNode;
        }
        SqlNodeOld result = SqlNodeBinding.slice(subNode, generator, op.getStart(), op.getLength());
        return result;
    }

    public SqlNodeOld rewrite(ColRelGenerator generator, OpFilterIndexed filter) {
        SqlNodeOld subNode = this.rewriteMM(generator, filter.getSubOp());
        if (subNode instanceof SqlNodeEmpty) {
            return subNode;
        }
        ExprList exprs = new ExprList();
        for (Clause clause : filter.getRestrictions().getCnf()) {
            exprs.add(ExprUtils.orifyBalanced(clause.getExprs()));
        }
        SqlNodeOld result = SqlNodeBinding.filter(subNode, exprs, generator);
        return result;
    }

    public SqlNodeOld rewrite(ColRelGenerator generator, OpFilter filter) {
        SqlNodeOld subNode = this.rewriteMM(generator, filter.getSubOp());
        SqlNodeOld result = SqlNodeBinding.filter(subNode, filter.getExprs(), generator);
        return result;
    }

    public SqlNodeOld rewrite(ColRelGenerator generator, OpProject op) {
        SqlNodeOld subNode = this.rewriteMM(generator, op.getSubOp());
        if (subNode instanceof SqlNodeEmpty) {
            return subNode;
        }
        SqlNodeOld result = SqlNodeBinding.project(subNode, op.getVars(), generator);
        return result;
    }

    public SqlNodeOld rewrite(ColRelGenerator generator, OpGroup op) {
        SqlNodeOld subNode = this.rewriteMM(generator, op.getSubOp());
        SqlNodeOld result = SqlNodeBinding.group(subNode, op.getGroupVars(), op.getAggregators(), generator.forColumn());
        return result;
    }

    public SqlNodeOld rewrite(ColRelGenerator generator, OpOrder order) {
        SqlNodeOld subNode = this.rewriteMM(generator, order.getSubOp());
        if (subNode instanceof SqlNodeEmpty) {
            return subNode;
        }
        SqlNodeOld result = SqlNodeBinding.order(subNode, order.getConditions(), generator);
        return result;
    }

    public SqlNodeOld rewriteMM(Op op) throws EmptyRewriteException {
        if (op instanceof OpNull) {
            throw new EmptyRewriteException();
        }
        ColRelGenerator generator = new ColRelGenerator();
        return this.rewriteMM(generator, op);
    }

    public SqlNodeOld rewrite(ColRelGenerator generator, OpExtend op) {
        SqlNodeOld subNode = this.rewriteMM(generator, op.getSubOp());
        if (subNode instanceof SqlNodeEmpty) {
            return subNode;
        }
        SqlNodeOld result = SqlNodeBinding.extend(subNode, op.getVarExprList());
        return result;
    }

    public SqlNodeOld rewriteMM(ColRelGenerator generator, Op op) {
        SqlNodeOld result = (SqlNodeOld)MultiMethod.invoke((Object)this, (String)"rewrite", (Object[])new Object[]{generator, op});
        return result;
    }
}

