/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.database;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import org.aksw.commons.util.strings.StringUtils;
import org.aksw.sparqlify.database.Column;
import org.aksw.sparqlify.database.Constraint;
import org.aksw.sparqlify.database.Index;
import org.aksw.sparqlify.database.IndexCollection;
import org.aksw.sparqlify.database.IndexMap;
import org.aksw.sparqlify.database.IndexMetaNode;
import org.aksw.sparqlify.database.IsPrefixOfConstraint;
import org.aksw.sparqlify.database.MetaIndexFactory;
import org.aksw.sparqlify.database.PrefixIndexMetaFactory;
import org.aksw.sparqlify.database.StartsWithConstraint;
import org.aksw.sparqlify.database.Table;
import org.aksw.sparqlify.database.TableBuilder;
import org.aksw.sparqlify.database.TreeIndex;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.lang.time.StopWatch;

public class TableImpl<T>
implements Table<T> {
    private IndexMap<String, Column> columns;
    private IndexCollection<T> indexes = new IndexCollection();

    @Override
    public IndexCollection<T> getIndexes() {
        return this.indexes;
    }

    public TableImpl(IndexMap<String, Column> columns) {
        this.columns = columns;
    }

    @Override
    public void addIndex(Index<T> index) {
        if (index.getTable() != this) {
            throw new RuntimeException("Index has a different table set");
        }
        this.indexes.add(index);
    }

    public static void main2(String[] args) {
        TreeMap<String, String> m = new TreeMap<String, String>();
        m.put("m", "2");
        m.put("malta", "3");
        m.put("mali", "4");
        m.put("malibu", "5");
        m.put("macedonien", "6");
        boolean inclusive = true;
        System.out.println(StringUtils.longestPrefixLookup((String)"malibuu", (boolean)inclusive, m));
        System.out.println(StringUtils.longestPrefixLookup((String)"malibu", (boolean)inclusive, m));
        System.out.println(StringUtils.longestPrefixLookup((String)"malib", (boolean)inclusive, m));
        System.out.println(StringUtils.longestPrefixLookup((String)"mali", (boolean)inclusive, m));
        System.out.println(StringUtils.longestPrefixLookup((String)"mal", (boolean)inclusive, m));
        System.out.println(StringUtils.longestPrefixLookup((String)"ma", (boolean)inclusive, m));
        System.out.println(StringUtils.longestPrefixLookup((String)"m", (boolean)inclusive, m));
        System.out.println(StringUtils.longestPrefixLookup((String)"", (boolean)inclusive, m));
        System.out.println(StringUtils.getAllPrefixes((String)"malibu", (boolean)false, m));
    }

    public static void main(String[] args) {
        TableBuilder<String> builder = new TableBuilder<String>();
        builder.addColumn("g", String.class);
        builder.addColumn("s", String.class);
        builder.addColumn("p", String.class);
        builder.addColumn("o", String.class);
        Table<String> table = builder.create();
        TreeSet<String> set = new TreeSet<String>();
        set.add("Das");
        set.add("Das blah");
        set.add("Das ist");
        set.add("Das ist ein Satz");
        set.add("Das ist noch ein Satz");
        set.add("Das ist noch einer");
        System.out.println(set.tailSet("Da"));
        System.out.println(set.headSet("Das ist ", false));
        Transformer<Object, Set<String>> prefixExtractor = new Transformer<Object, Set<String>>(){

            public Set<String> transform(Object input) {
                return Collections.singleton((String)input);
            }
        };
        PrefixIndexMetaFactory factory = new PrefixIndexMetaFactory(prefixExtractor);
        IndexMetaNode root = IndexMetaNode.create(table, (MetaIndexFactory)factory, "s");
        TreeIndex index = TreeIndex.attach(table, root);
        for (int i = 0; i < 1000; ++i) {
            table.add(Arrays.asList(UUID.randomUUID().toString(), UUID.randomUUID().toString(), UUID.randomUUID().toString(), UUID.randomUUID().toString()));
        }
        table.add(Arrays.asList("aaa", "bbb", "ccc", "ddd"));
        table.add(Arrays.asList("bbb", "ccc", "ddd", "aaa"));
        table.add(Arrays.asList("ccc", "ddd", "aaa", "bbb"));
        table.add(Arrays.asList("ddd", "aaa", "bbb", "ccc"));
        table.add(Arrays.asList("Das", "ddd", "test", "ist"));
        HashMap<String, Constraint> constraints = new HashMap<String, Constraint>();
        constraints.put("s", new StartsWithConstraint("dd"));
        constraints.put("g", new IsPrefixOfConstraint("Das"));
        Collection<List<Object>> rs = table.select(constraints);
        System.out.println(rs);
        StopWatch sw = new StopWatch();
        sw.start();
        for (int i = 0; i < 10000000; ++i) {
            Collection<List<Object>> x = table.select(constraints);
        }
        sw.stop();
        System.out.println(sw.getTime());
    }

    public static <T> void printTable(Collection<? extends List<T>> table, PrintStream out) {
        for (List<T> row : table) {
            for (int i = 0; i < row.size(); ++i) {
                T o;
                String value;
                if (i != 0) {
                    out.print("\t");
                }
                String string = value = (o = row.get(i)) == null ? "(null)" : o.toString();
                if (value.isEmpty()) {
                    value = "(empty string)";
                }
                out.print(value);
            }
            out.println();
        }
    }

    @Override
    public IndexMap<String, Column> getColumns() {
        return this.columns;
    }

    @Override
    public void add(List<? extends T> row) {
        for (Index<? extends T> index : this.indexes) {
            if (index.preAdd(row)) continue;
            throw new RuntimeException("Row rejected");
        }
        for (Index<Object> index : this.indexes) {
            index.add(row);
            index.postAdd(row);
        }
    }

    @Override
    public Collection<List<Object>> select(Map<String, Constraint> constraints) {
        IndexMap<String, Column> cols = this.getColumns();
        Collection<List<Object>> result = this.indexes.get(constraints, cols);
        return result;
    }

    @Override
    public int[] getIndexes(List<String> columnNames) {
        int[] result = new int[columnNames.size()];
        for (int i = 0; i < result.length; ++i) {
            String columnName = columnNames.get(i);
            result[i] = this.columns.getIndex(columnName);
        }
        return result;
    }
}

