/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.cast;

import com.google.common.base.Function;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aksw.sparqlify.algebra.sparql.expr.E_RdfTerm;
import org.aksw.sparqlify.algebra.sql.exprs2.ExprSqlBridge;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExpr;
import org.aksw.sparqlify.core.RdfViewSystemOld;
import org.aksw.sparqlify.core.TypeToken;
import org.aksw.sparqlify.core.algorithms.DatatypeToStringPostgres;
import org.aksw.sparqlify.core.algorithms.ExprEvaluator;
import org.aksw.sparqlify.core.algorithms.ExprSqlRewrite;
import org.aksw.sparqlify.core.cast.ExprBindingSubstitutorImpl;
import org.aksw.sparqlify.core.cast.SqlExprSerializerSystemImpl;
import org.aksw.sparqlify.core.cast.SqlLiteralMapperDefault;
import org.aksw.sparqlify.core.cast.TypeSystem;
import org.aksw.sparqlify.core.cast.TypedExprTransformerImpl;
import org.aksw.sparqlify.core.transformations.RdfTermEliminatorImpl;
import org.aksw.sparqlify.core.transformations.SqlTranslationUtils;
import org.aksw.sparqlify.type_system.FunctionModel;
import org.aksw.sparqlify.type_system.MethodDeclaration;
import org.aksw.sparqlify.type_system.MethodEntry;
import org.aksw.sparqlify.type_system.MethodSignature;
import org.aksw.sparqlify.util.SparqlifyCoreInit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stringtemplate.v4.ST;

public class NewWorldTest {
    private static final Logger logger = LoggerFactory.getLogger(NewWorldTest.class);

    public static <K, V> void putForAll(Map<K, V> map, Collection<K> keys, V value) {
        for (K key : keys) {
            map.put(key, value);
        }
    }

    public static <K, V> V getNotNull(Map<K, V> map, Object key) {
        V result = map.get(key);
        if (result == null) {
            throw new NullPointerException("No entry found for key " + key + " in map " + map);
        }
        return result;
    }

    public static <I, O> MethodDeclaration<O> transform(MethodDeclaration<I> dec, Function<I, O> fn) {
        MethodSignature<O> s = NewWorldTest.transform(dec.getSignature(), fn);
        MethodDeclaration result = MethodDeclaration.create((String)dec.getName(), s);
        return result;
    }

    public static <I, O> MethodSignature<O> transform(MethodSignature<I> sig, Function<I, O> fn) {
        Object returnType = fn.apply(sig.getReturnType());
        List items = sig.getParameterTypes();
        ArrayList<Object> paramTypes = new ArrayList<Object>(items.size());
        for (Object item : items) {
            Object paramType = fn.apply(item);
            paramTypes.add(paramType);
        }
        Object vat = sig.getVarArgType();
        Object varArgType = vat == null ? null : fn.apply(vat);
        MethodSignature result = MethodSignature.create((Object)returnType, paramTypes, (Object)varArgType);
        return result;
    }

    public static <I, O> FunctionModel<O> transform(FunctionModel<I> srcModel, FunctionModel<O> dstModel, Function<I, O> fn) {
        Collection sqlMethods = srcModel.getMethodEntries();
        ArrayList dstDecs = new ArrayList();
        Iterator i$ = sqlMethods.iterator();
        if (i$.hasNext()) {
            MethodEntry sqlMethod = (MethodEntry)i$.next();
            MethodDeclaration dec = sqlMethod.getDeclaration();
            String sqlFnId = sqlMethod.getId();
            Object sparqlFnName = null;
            throw new RuntimeException("Not fully implemented");
        }
        for (MethodDeclaration sparqlDec : dstDecs) {
            dstModel.registerFunction(sparqlDec);
        }
        return dstModel;
    }

    public static void testExprRewrite(TypeSystem typeSystem) {
        ExprBindingSubstitutorImpl exprBindingSubstitutor = new ExprBindingSubstitutorImpl();
        ExprEvaluator exprEvaluator = SqlTranslationUtils.createDefaultEvaluator();
        TypedExprTransformerImpl typedExprTransformer = new TypedExprTransformerImpl(typeSystem);
        DatatypeToStringPostgres typeSerializer = new DatatypeToStringPostgres();
        SqlLiteralMapperDefault sqlLiteralMapper = new SqlLiteralMapperDefault(typeSerializer);
        SqlExprSerializerSystemImpl serializerSystem = new SqlExprSerializerSystemImpl(typeSerializer, sqlLiteralMapper);
        Expr e0 = ExprUtils.parse((String)"?f = <http://aksw.org/sparqlify/urlDecode>('foobar')");
        Expr a = ExprUtils.parse((String)"<http://aksw.org/sparqlify/uri>(?website)");
        Expr b = ExprUtils.parse((String)"<http://aksw.org/sparqlify/uri>(<http://aksw.org/sparqlify/plainLiteral>(?foo))");
        Expr c = ExprUtils.parse((String)"<http://aksw.org/sparqlify/typedLiteral>(1, 'http://www.w3.org/2001/XMLSchema#int')");
        Expr d = ExprUtils.parse((String)"<http://aksw.org/sparqlify/typedLiteral>(2, 'http://www.w3.org/2001/XMLSchema#int')");
        Expr e = ExprUtils.parse((String)"<http://aksw.org/sparqlify/typedLiteral>(?x, 'http://www.w3.org/2001/XMLSchema#int')");
        Expr f = ExprUtils.parse((String)"<http://aksw.org/sparqlify/uri>('http://foobar')");
        HashMap<Var, Expr> binding = new HashMap<Var, Expr>();
        binding.put(Var.alloc((String)"a"), a);
        binding.put(Var.alloc((String)"b"), b);
        binding.put(Var.alloc((String)"c"), c);
        binding.put(Var.alloc((String)"d"), d);
        binding.put(Var.alloc((String)"e"), e);
        binding.put(Var.alloc((String)"f"), f);
        HashMap<String, TypeToken> typeMap = new HashMap<String, TypeToken>();
        typeMap.put("website", TypeToken.String);
        typeMap.put("foo", TypeToken.String);
        typeMap.put("x", TypeToken.Int);
        logger.debug("[ExprRewrite Phase 0]: " + e0);
        Expr e1 = exprBindingSubstitutor.substitute(e0, binding);
        logger.debug("[ExprRewrite Phase 1]: " + e1);
        RdfTermEliminatorImpl exprTrns = SparqlifyCoreInit.createDefaultTransformer(typeSystem);
        E_RdfTerm e2 = exprTrns._transform(e1);
        logger.debug("[ExprRewrite Phase 2]: " + (Object)((Object)e2));
        Expr e3 = exprEvaluator.transform((Expr)e2);
        logger.debug("[ExprRewrite Phase 3]: " + e3);
        ExprSqlRewrite e4 = typedExprTransformer.rewrite(e3, typeMap);
        logger.debug("[ExprRewrite Phase 4]: " + e4);
        Expr et = e4.getExpr();
        if (et instanceof ExprSqlBridge) {
            ExprSqlBridge bridge = (ExprSqlBridge)et;
            SqlExpr ex = bridge.getSqlExpr();
            String e5 = serializerSystem.serialize(ex);
            logger.debug("[ExprRewrite Phase 5]: " + e5);
        } else {
            logger.debug("Done rewriting: ");
            logger.debug("" + et);
            logger.debug("" + e4.getProjection());
        }
    }

    public static void main(String[] args) throws IOException {
        RdfViewSystemOld.initSparqlifyFunctions();
        TypeSystem typeSystem = SparqlifyCoreInit.createDefaultDatatypeSystem();
        String str = "$1$::text --- $rest;separator=\"+\"$";
        ST s = new ST(str, '$', '$');
        s.add("rest", Arrays.asList(1, 2, 3));
    }
}

