/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.algorithms;

import com.hp.hpl.jena.sparql.expr.E_Add;
import com.hp.hpl.jena.sparql.expr.E_Bound;
import com.hp.hpl.jena.sparql.expr.E_Divide;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.E_Function;
import com.hp.hpl.jena.sparql.expr.E_GreaterThan;
import com.hp.hpl.jena.sparql.expr.E_GreaterThanOrEqual;
import com.hp.hpl.jena.sparql.expr.E_LangMatches;
import com.hp.hpl.jena.sparql.expr.E_LessThan;
import com.hp.hpl.jena.sparql.expr.E_LessThanOrEqual;
import com.hp.hpl.jena.sparql.expr.E_LogicalAnd;
import com.hp.hpl.jena.sparql.expr.E_LogicalNot;
import com.hp.hpl.jena.sparql.expr.E_LogicalOr;
import com.hp.hpl.jena.sparql.expr.E_Multiply;
import com.hp.hpl.jena.sparql.expr.E_NotEquals;
import com.hp.hpl.jena.sparql.expr.E_OneOf;
import com.hp.hpl.jena.sparql.expr.E_StrConcat;
import com.hp.hpl.jena.sparql.expr.E_Subtract;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import java.util.HashMap;
import java.util.Map;
import org.aksw.sparqlify.algebra.sparql.expr.E_StrConcatPermissive;
import org.aksw.sparqlify.core.algorithms.DatatypeAssigner;
import org.aksw.sparqlify.core.algorithms.DatatypeAssignerConstant;
import org.aksw.sparqlify.core.algorithms.DatatypeAssignerNodeValue;
import org.aksw.sparqlify.core.datatypes.TypeSystem;
import org.aksw.sparqlify.core.datatypes.XClass;

public class DatatypeAssignerMap
implements DatatypeAssigner {
    private Map<Class<?>, DatatypeAssigner> map;

    public DatatypeAssignerMap(Map<Class<?>, DatatypeAssigner> map) {
        this.map = map;
    }

    @Override
    public XClass assign(Expr expr, Map<String, XClass> typeMap) {
        DatatypeAssigner assigner = expr.isConstant() ? this.map.get(NodeValue.class) : this.map.get(expr.getClass());
        if (assigner == null) {
            if (expr.isVariable() && typeMap != null) {
                String varName = expr.getVarName();
                XClass result = typeMap.get(varName);
                return result;
            }
            return null;
        }
        XClass result = assigner.assign(expr, typeMap);
        return result;
    }

    public Map<Class<?>, DatatypeAssigner> getMap() {
        return this.map;
    }

    public static DatatypeAssignerMap createDefaultAssignments(TypeSystem datatypeSystem) {
        HashMap map = new HashMap();
        XClass xBoolean = datatypeSystem.getByName("boolean");
        DatatypeAssignerConstant aBoolean = DatatypeAssignerConstant.create(xBoolean);
        XClass xString = datatypeSystem.getByName("string");
        DatatypeAssignerConstant aString = DatatypeAssignerConstant.create(xString);
        map.put(E_LogicalAnd.class, aBoolean);
        map.put(E_LogicalOr.class, aBoolean);
        map.put(E_LogicalNot.class, aBoolean);
        map.put(E_LessThan.class, aBoolean);
        map.put(E_LessThanOrEqual.class, aBoolean);
        map.put(E_Equals.class, aBoolean);
        map.put(E_NotEquals.class, aBoolean);
        map.put(E_GreaterThan.class, aBoolean);
        map.put(E_GreaterThanOrEqual.class, aBoolean);
        map.put(E_OneOf.class, aBoolean);
        map.put(E_Bound.class, aBoolean);
        map.put(E_StrConcatPermissive.class, aString);
        map.put(E_StrConcat.class, aString);
        map.put(E_Add.class, aString);
        map.put(E_Subtract.class, aString);
        map.put(E_Multiply.class, aString);
        map.put(E_Divide.class, aString);
        map.put(E_LangMatches.class, aString);
        map.put(E_Function.class, aString);
        map.put(ExprFunction.class, aString);
        map.put(NodeValue.class, new DatatypeAssignerNodeValue(datatypeSystem));
        DatatypeAssignerMap result = new DatatypeAssignerMap(map);
        return result;
    }
}

