/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.compile.sparql;

import java.util.ArrayList;
import org.aksw.commons.util.reflect.MultiMethod;
import org.aksw.sparqlify.algebra.sql.nodes.SqlAlias;
import org.aksw.sparqlify.algebra.sql.nodes.SqlDistinct;
import org.aksw.sparqlify.algebra.sql.nodes.SqlGroup;
import org.aksw.sparqlify.algebra.sql.nodes.SqlJoin;
import org.aksw.sparqlify.algebra.sql.nodes.SqlMyRestrict;
import org.aksw.sparqlify.algebra.sql.nodes.SqlNodeEmpty;
import org.aksw.sparqlify.algebra.sql.nodes.SqlNodeOld;
import org.aksw.sparqlify.algebra.sql.nodes.SqlNodeOrder;
import org.aksw.sparqlify.algebra.sql.nodes.SqlProjection;
import org.aksw.sparqlify.algebra.sql.nodes.SqlQuery;
import org.aksw.sparqlify.algebra.sql.nodes.SqlSelectBlock;
import org.aksw.sparqlify.algebra.sql.nodes.SqlSlice;
import org.aksw.sparqlify.algebra.sql.nodes.SqlTable;
import org.aksw.sparqlify.algebra.sql.nodes.SqlUnionN;

public class SqlSelectBlockCollector {
    public static void copyProjection(SqlNodeOld target, SqlNodeOld source) {
        target.getSparqlVarToExprs().clear();
        target.getAliasToColumn().clear();
        target.getSparqlVarToExprs().putAll(source.getSparqlVarToExprs());
        target.getAliasToColumn().putAll(source.getAliasToColumn());
    }

    public static SqlSelectBlock _makeSelect(SqlNodeOld node) {
        SqlSelectBlock result = (SqlSelectBlock)MultiMethod.invokeStatic(SqlSelectBlockCollector.class, (String)"makeSelect", (Object[])new Object[]{node});
        SqlSelectBlockCollector.copyProjection(result, node);
        return result;
    }

    public static SqlSelectBlock makeSelect(SqlGroup node) {
        SqlSelectBlock result;
        if (node.getSubNode() instanceof SqlSlice) {
            SqlSelectBlock tmp = SqlSelectBlockCollector._makeSelect(node.getSubNode());
            result = new SqlSelectBlock(tmp.getAliasName(), tmp);
            SqlSelectBlockCollector.copyProjection(result, result);
        } else {
            result = SqlSelectBlockCollector._makeSelect(node.getSubNode());
        }
        System.err.println("TODO Handle group by vars if present");
        return result;
    }

    public static SqlSelectBlock makeSelect(SqlTable node) {
        return new SqlSelectBlock(node);
    }

    public static SqlSelectBlock makeSelect(SqlQuery node) {
        return new SqlSelectBlock(node);
    }

    public static SqlSelectBlock makeSelect(SqlMyRestrict node) {
        SqlSelectBlock result = SqlSelectBlockCollector._makeSelect(node.getSubNode());
        result.getConditions().addAll(node.getConditions());
        return result;
    }

    public static SqlSelectBlock makeSelect(SqlSlice node) {
        SqlSelectBlock result = SqlSelectBlockCollector._makeSelect(node.getSubNode());
        SqlSelectBlock.slice(null, result, node.getStart(), node.getLength());
        return result;
    }

    public static SqlSelectBlock makeSelect(SqlDistinct node) {
        SqlSelectBlock result = SqlSelectBlockCollector._makeSelect(node.getSubNode());
        result.setDistinct(true);
        return result;
    }

    public static SqlSelectBlock makeSelect(SqlAlias node) {
        SqlSelectBlock result = SqlSelectBlockCollector._makeSelect(node.getSubNode());
        SqlSelectBlock wrap = new SqlSelectBlock(node.getAliasName(), result);
        SqlSelectBlockCollector.copyProjection(wrap, result);
        return wrap;
    }

    public static SqlSelectBlock makeSelect(SqlNodeOrder node) {
        SqlSelectBlock result = SqlSelectBlockCollector._makeSelect(node.getSubNode());
        result.getSortConditions().addAll(node.getConditions());
        SqlSelectBlockCollector.copyProjection(result, node);
        return result;
    }

    public static SqlSelectBlock makeSelect(SqlProjection node) {
        SqlSelectBlock result = SqlSelectBlockCollector._makeSelect(node.getSubNode());
        if (result.isDistinct()) {
            // empty if block
        }
        SqlSelectBlock wrap = new SqlSelectBlock(node.getAliasName(), result);
        wrap.getSparqlVarToExprs().putAll(node.getSparqlVarToExprs());
        wrap.getAliasToColumn().putAll(node.getAliasToColumn());
        return wrap;
    }

    public static SqlSelectBlock makeSelect(SqlJoin node) {
        SqlNodeOld join = SqlSelectBlockCollector.makeSelectOrTable(node);
        return new SqlSelectBlock(join);
    }

    public static SqlSelectBlock makeSelect(SqlUnionN node) {
        ArrayList<SqlNodeOld> wrapped = new ArrayList<SqlNodeOld>();
        for (SqlNodeOld arg : node.getArgs()) {
            SqlSelectBlock argSelect = SqlSelectBlockCollector._makeSelect(arg);
            wrapped.add(argSelect);
        }
        SqlUnionN union = new SqlUnionN(node.getAliasName(), wrapped);
        union.getSparqlVarToExprs().putAll(node.getSparqlVarToExprs());
        union.getAliasToColumn().putAll(node.getAliasToColumn());
        SqlSelectBlock result = new SqlSelectBlock(union);
        SqlSelectBlockCollector.copyProjection(result, union);
        return result;
    }

    public static SqlNodeOld _makeSelectOrTable(SqlNodeOld node) {
        return (SqlNodeOld)MultiMethod.invokeStatic(SqlSelectBlockCollector.class, (String)"makeSelectOrTable", (Object[])new Object[]{node});
    }

    public static SqlNodeOld makeSelectOrTable(SqlNodeEmpty node) {
        return node;
    }

    public static SqlNodeOld makeSelectOrTable(SqlProjection node) {
        return SqlSelectBlockCollector._makeSelect(node);
    }

    public static SqlNodeOld makeSelectOrTable(SqlTable node) {
        return node;
    }

    public static SqlNodeOld makeSelectOrTable(SqlQuery node) {
        return node;
    }

    public static SqlNodeOld makeSelectOrTable(SqlAlias node) {
        SqlNodeOld tmp = SqlSelectBlockCollector._makeSelectOrTable(node.getSubNode());
        SqlAlias result = new SqlAlias(node.getAliasName(), tmp);
        SqlSelectBlockCollector.copyProjection(result, node);
        return result;
    }

    public static SqlNodeOld makeSelectOrTable(SqlMyRestrict node) {
        return SqlSelectBlockCollector._makeSelect(node);
    }

    public static SqlNodeOld makeSelectOrTable(SqlSlice node) {
        return SqlSelectBlockCollector._makeSelect(node);
    }

    public static SqlNodeOld makeSelectOrTable(SqlDistinct node) {
        return SqlSelectBlockCollector._makeSelect(node);
    }

    public static SqlNodeOld makeSelectOrTable(SqlJoin node) {
        SqlNodeOld left = SqlSelectBlockCollector._makeSelectOrTable(node.getLeft());
        SqlNodeOld right = SqlSelectBlockCollector._makeSelectOrTable(node.getRight());
        SqlJoin join = SqlJoin.create(node.getJoinType(), left, right);
        join.getConditions().addAll(node.getConditions());
        SqlSelectBlockCollector.copyProjection(join, node);
        return join;
    }

    public static SqlNodeOld makeSelectOrTable(SqlUnionN node) {
        return SqlSelectBlockCollector.makeSelect(node);
    }
}

