/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.compile.sparql;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import org.aksw.commons.factory.Factory1;
import org.aksw.commons.util.reflect.MultiMethod;
import org.aksw.sparqlify.algebra.sql.exprs.S_Arithmetic;
import org.aksw.sparqlify.algebra.sql.exprs.S_Cast;
import org.aksw.sparqlify.algebra.sql.exprs.S_Concat;
import org.aksw.sparqlify.algebra.sql.exprs.S_Equals;
import org.aksw.sparqlify.algebra.sql.exprs.S_Function;
import org.aksw.sparqlify.algebra.sql.exprs.S_GeographyFromText;
import org.aksw.sparqlify.algebra.sql.exprs.S_GeometryFromText;
import org.aksw.sparqlify.algebra.sql.exprs.S_GreaterThan;
import org.aksw.sparqlify.algebra.sql.exprs.S_GreaterThanOrEqual;
import org.aksw.sparqlify.algebra.sql.exprs.S_Intersects;
import org.aksw.sparqlify.algebra.sql.exprs.S_IsNotNull;
import org.aksw.sparqlify.algebra.sql.exprs.S_LessThan;
import org.aksw.sparqlify.algebra.sql.exprs.S_LessThanOrEqual;
import org.aksw.sparqlify.algebra.sql.exprs.S_LogicalAnd;
import org.aksw.sparqlify.algebra.sql.exprs.S_LogicalNot;
import org.aksw.sparqlify.algebra.sql.exprs.S_LogicalOr;
import org.aksw.sparqlify.algebra.sql.exprs.S_Regex;
import org.aksw.sparqlify.algebra.sql.exprs.S_String;
import org.aksw.sparqlify.algebra.sql.exprs.SqlAggregator;
import org.aksw.sparqlify.algebra.sql.exprs.SqlAggregatorCount;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExpr;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExprAggregator;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExprColumn;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExprValue;
import org.aksw.sparqlify.algebra.sql.exprs.SqlStringTransformer;
import org.aksw.sparqlify.compile.sparql.DatatypeToString;
import org.aksw.sparqlify.compile.sparql.SqlAlgebraToString;
import org.aksw.sparqlify.compile.sparql.SqlExprSerializer;
import org.aksw.sparqlify.core.SqlDatatype;

abstract class SqlExprSerializerDefault
implements SqlExprSerializer {
    protected DatatypeToString datatypeSerializer;

    public SqlExprSerializerDefault(DatatypeToString datatypeSerializer) {
        this.datatypeSerializer = datatypeSerializer;
    }

    @Override
    public String serialize(SqlExpr expr) {
        try {
            String result = (String)MultiMethod.invoke((Object)this, (String)"_serialize", (Object[])new Object[]{expr});
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Error serializing expression" + expr, e);
        }
    }

    public String _serialize(SqlExprAggregator expr) {
        String result = this._serializeAgg(expr.getAggregator());
        return result;
    }

    public String _serializeAgg(SqlAggregator aggregator) {
        String result = (String)MultiMethod.invoke((Object)this, (String)"serializeAgg", (Object[])new Object[]{aggregator});
        return result;
    }

    public String serializeAgg(SqlAggregatorCount aggregator) {
        return "COUNT(*)";
    }

    public List<String> serializeArgs(List<SqlExpr> exprs) {
        ArrayList<String> result = new ArrayList<String>();
        for (SqlExpr expr : exprs) {
            String tmp = this.serialize(expr);
            result.add(tmp);
        }
        return result;
    }

    public String _serialize(S_Cast expr) {
        String tmp = this.serialize(expr.getExpr());
        Factory1<String> caster = this.datatypeSerializer.asString(expr.getDatatype());
        String result = caster.create(tmp);
        return result;
    }

    public String _serialize(S_Function expr) {
        List<String> args = this.serializeArgs(expr.getArgs());
        SqlStringTransformer transformer = expr.getTransformer();
        if (transformer == null) {
            return expr.getFuncName() + "(" + Joiner.on((String)", ").join(this.serializeArgs(expr.getArgs())) + ")";
        }
        return transformer.transform(expr, args);
    }

    public String _serialize(SqlExprColumn expr) {
        String columnAlias = SqlAlgebraToString.escapeAlias(expr.getColumnName());
        if (expr.getTableName() == null) {
            return columnAlias;
        }
        return expr.getTableName() + "." + columnAlias;
    }

    public abstract String serializeConstant(Object var1, SqlDatatype var2);

    public String _serialize(S_String expr) {
        return expr.getSqlString();
    }

    public String _serialize(SqlExprValue expr) {
        return this.serializeConstant(expr.getObject(), expr.getDatatype());
    }

    public String _serialize(S_GeographyFromText expr) {
        return "ST_GeographyFromText(" + this.serialize(expr.getExpr()) + ")";
    }

    public String _serialize(S_GeometryFromText expr) {
        return "ST_GeomFromText(" + this.serialize(expr.getExpr()) + ", 4326)";
    }

    public String _serialize(S_Intersects expr) {
        return "ST_Intersects(" + this.serialize(expr.getLeft()) + ", " + this.serialize(expr.getRight()) + ")";
    }

    public String _serialize(S_LessThan expr) {
        return "(" + this.serialize(expr.getLeft()) + " < " + this.serialize(expr.getRight()) + ")";
    }

    public String _serialize(S_LessThanOrEqual expr) {
        return "(" + this.serialize(expr.getLeft()) + " <= " + this.serialize(expr.getRight()) + ")";
    }

    public String _serialize(S_Equals expr) {
        return "(" + this.serialize(expr.getLeft()) + " = " + this.serialize(expr.getRight()) + ")";
    }

    public String _serialize(S_GreaterThanOrEqual expr) {
        return "(" + this.serialize(expr.getLeft()) + " >= " + this.serialize(expr.getRight()) + ")";
    }

    public String _serialize(S_GreaterThan expr) {
        return "(" + this.serialize(expr.getLeft()) + " > " + this.serialize(expr.getRight()) + ")";
    }

    public String _serialize(S_LogicalAnd expr) {
        return "(" + this.serialize(expr.getLeft()) + " AND " + this.serialize(expr.getRight()) + ")";
    }

    public String _serialize(S_LogicalOr expr) {
        return "(" + this.serialize(expr.getLeft()) + " OR " + this.serialize(expr.getRight()) + ")";
    }

    public String _serialize(S_LogicalNot expr) {
        return "(NOT " + this.serialize(expr.getExpr()) + ")";
    }

    public String _serialize(S_Arithmetic expr) {
        return "(" + this.serialize(expr.getLeft()) + " " + expr.getSymbol() + " " + this.serialize(expr.getRight()) + ")";
    }

    public String _serialize(S_IsNotNull expr) {
        String arg = this.serialize(expr.getExpr());
        String result = "(" + arg + " IS NOT NULL)";
        return result;
    }

    public String _serialize(S_Concat concat) {
        List<String> args = this.serializeArgs(concat.getArgs());
        String result = "(" + Joiner.on((String)" || ").join(args) + ")";
        return result;
    }

    public String _serialize(S_Regex expr) {
        String arg = this.serialize(expr.getExpr());
        String result = arg + " ~* " + "'" + expr.getPattern() + "'";
        return result;
    }
}

