/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.algebra.sparql.transform;

import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import java.util.Map;
import org.aksw.commons.util.reflect.MultiMethod;
import org.aksw.sparqlify.algebra.sparql.transform.ExprDatatypeHash;
import org.aksw.sparqlify.core.SqlDatatype;

public class ExprStructuralHash {
    public static int hash(Expr expr, Map<String, SqlDatatype> columnToDatatype) {
        return (Integer)MultiMethod.invokeStatic(ExprDatatypeHash.class, (String)"_hash", (Object[])new Object[]{expr, columnToDatatype});
    }

    public static int _hashArgs(Iterable<Expr> exprs, Map<String, SqlDatatype> columnToDatatype) {
        int result = 1;
        for (Expr expr : exprs) {
            result *= 7531 + ExprStructuralHash.hash(expr, columnToDatatype);
        }
        return result;
    }

    public static int _hash(ExprFunction expr, Map<String, SqlDatatype> columnToDatatype) {
        return expr.getClass().hashCode() * ExprStructuralHash._hashArgs(expr.getArgs(), columnToDatatype);
    }

    public static int _hash(ExprVar expr, Map<String, SqlDatatype> columnToDatatype) {
        SqlDatatype datatype = columnToDatatype.get(expr.getVarName());
        if (datatype == null) {
            throw new RuntimeException("No datatype information for column " + expr.getVarName());
        }
        return datatype.hashCode();
    }

    public static int _hash(NodeValue expr, Map<String, SqlDatatype> columnToDatatype) {
        return expr.hashCode();
    }
}

