/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.changesets;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import org.aksw.changesets.AbstractPartition;
import org.aksw.changesets.FileLineIterable;

public class FileLinePartition
extends AbstractPartition<String> {
    private File file;
    private PrintStream out;
    private int size;

    public FileLinePartition(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public void open() {
        if (this.out != null) {
            throw new IllegalStateException();
        }
        try {
            this.out = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.file)));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean add(String item) {
        this.out.println(item);
        ++this.size;
        return true;
    }

    @Override
    public void close() {
        this.out.flush();
        this.out.close();
        this.out = null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterator<String> iterator() {
        return new FileLineIterable(this.file).iterator();
    }

    @Override
    public void flush() {
        this.out.flush();
    }
}

