/*
 * Decompiled with CFR 0.152.
 */
package sparql;

import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.sparql.expr.E_LogicalNot;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import java.util.HashSet;
import java.util.Set;

public class ClauseUtils {
    public static Set<Set<Expr>> filterByVars(Set<Set<Expr>> clauses, Set<Var> requiredVars) {
        HashSet<Set<Expr>> result = new HashSet<Set<Expr>>();
        for (Set<Expr> clause : clauses) {
            Set<Var> clauseVars = ClauseUtils.getVarsMentioned(clause);
            if (!clauseVars.containsAll(requiredVars)) continue;
            result.add(clause);
        }
        return result;
    }

    public static boolean isSatisfiable(Set<Expr> clause) {
        for (Expr expr : clause) {
            Expr child;
            if (expr.equals(NodeValue.FALSE)) {
                return false;
            }
            if (!ClauseUtils.isSatisfiable(expr)) {
                return false;
            }
            if (!(expr instanceof E_LogicalNot) || !clause.contains(child = ((E_LogicalNot)expr).getArg())) continue;
            return false;
        }
        return true;
    }

    public static boolean isSatisfiable(Expr expr) {
        Expr folded = expr.copySubstitute(BindingRoot.create(), true);
        return !folded.equals(NodeValue.FALSE);
    }

    public static Set<Var> getVarsMentioned(Set<Expr> clause) {
        HashSet<Var> result = new HashSet<Var>();
        for (Expr expr : clause) {
            result.addAll(expr.getVarsMentioned());
        }
        return result;
    }
}

