/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.web;

import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URLEncoder;
import org.aksw.commons.sparql.api.core.QueryExecutionFactory;
import org.aksw.commons.sparql.api.http.QueryExecutionFactoryHttp;
import org.aksw.sparqlify.config.lang.ConfiguratorConstructViewSystem;
import org.aksw.sparqlify.config.lang.ConstructConfigParser;
import org.aksw.sparqlify.config.syntax.ConstructConfig;
import org.aksw.sparqlify.core.sparql.QueryExecutionFactoryExWrapper;
import org.aksw.sparqlify.sparqlview.Dialect;
import org.aksw.sparqlify.sparqlview.SparqlViewSystem;
import org.aksw.sparqlify.web.HttpSparqlEndpoint;
import org.aksw.sparqlify.web.QueryExecutionFactoryStreamingWrapper;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainConstructView {
    private static final Logger logger = LoggerFactory.getLogger(HttpSparqlEndpoint.class);
    private static final Options cliOptions = new Options();

    public static void printHelpAndExit(int exitCode) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(HttpSparqlEndpoint.class.getName(), cliOptions);
        System.exit(exitCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ConstructConfig config;
        File configFile;
        GnuParser cliParser = new GnuParser();
        cliOptions.addOption("P", "port", true, "Server port");
        cliOptions.addOption("C", "context", true, "Context e.g. /sparqlify");
        cliOptions.addOption("B", "backlog", true, "Maximum number of connections");
        cliOptions.addOption("t", "type", true, "Database type (posgres, mysql,...)");
        cliOptions.addOption("d", "database", true, "Database name");
        cliOptions.addOption("u", "username", true, "");
        cliOptions.addOption("p", "password", true, "");
        cliOptions.addOption("h", "hostname", true, "");
        cliOptions.addOption("c", "config", true, "Construct view config file");
        cliOptions.addOption("s", "service", true, "Backend Sparql Service");
        cliOptions.addOption("t", "timeout", true, "Maximum query execution timeout");
        cliOptions.addOption("n", "resultsetsize", true, "Maximum result set size");
        CommandLine commandLine = cliParser.parse(cliOptions, args);
        String portStr = commandLine.getOptionValue("P", "7000");
        String backLogStr = commandLine.getOptionValue("B", "100");
        String contextStr = commandLine.getOptionValue("C", "/sparql");
        int port = Integer.parseInt(portStr);
        int backLog = Integer.parseInt(backLogStr);
        String hostName = commandLine.getOptionValue("h", "localhost");
        String dialectStr = commandLine.getOptionValue("d", "").trim().toLowerCase();
        Dialect dialect = null;
        if (!dialectStr.isEmpty()) {
            for (Dialect candidate : Dialect.values()) {
                if (!candidate.toString().toLowerCase().equals(dialectStr)) continue;
                dialect = candidate;
                break;
            }
        } else {
            dialect = Dialect.DEFAULT;
        }
        if (dialect == null) {
            throw new RuntimeException("No dialect '" + dialectStr + "' found");
        }
        String serviceStr = commandLine.getOptionValue("s", "").trim();
        String maxQueryExecutionTimeStr = commandLine.getOptionValue("t", null);
        Integer maxQueryExecutionTime = maxQueryExecutionTimeStr == null ? null : Integer.valueOf(Integer.parseInt(maxQueryExecutionTimeStr));
        String maxResultSetSizeStr = commandLine.getOptionValue("n", null);
        Long maxResultSetSize = maxResultSetSizeStr == null ? null : Long.valueOf(Long.parseLong(maxResultSetSizeStr));
        String configFileStr = commandLine.getOptionValue("c");
        if (configFileStr == null) {
            logger.error("No config file given");
            MainConstructView.printHelpAndExit(-1);
        }
        if (!(configFile = new File(configFileStr)).exists()) {
            logger.error("File does not exist: " + configFileStr);
            MainConstructView.printHelpAndExit(-1);
        }
        ConstructConfigParser parser = new ConstructConfigParser();
        FileInputStream in = new FileInputStream(configFile);
        try {
            config = parser.parse(in);
        }
        finally {
            ((InputStream)in).close();
        }
        SparqlViewSystem system = new SparqlViewSystem();
        ConfiguratorConstructViewSystem.configure(config, system);
        QueryExecutionFactoryStreamingWrapper backend = new QueryExecutionFactoryStreamingWrapper((QueryExecutionFactory)new QueryExecutionFactoryHttp(serviceStr));
        QueryExecutionFactory qef = null;
        HttpSparqlEndpoint.sparqler = QueryExecutionFactoryExWrapper.wrap(qef);
        ServletHolder sh = new ServletHolder(ServletContainer.class);
        sh.setInitParameter("com.sun.jersey.config.property.resourceConfigClass", "com.sun.jersey.api.core.PackagesResourceConfig");
        sh.setInitParameter("com.sun.jersey.config.property.packages", "org.aksw.sparqlify.rest");
        Server server = new Server(9999);
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)server, "/", 1);
        context.addServlet(sh, "/*");
        server.start();
        Point2D.Double a = new Point2D.Double(12.34593062612, 51.33298118419);
        Point2D.Double b = new Point2D.Double(12.404552986346, 51.348557018545);
        String polygon = "POLYGON((" + a.x + " " + a.y + "," + b.x + " " + a.y + "," + b.x + " " + b.y + "," + a.x + " " + b.y + "," + a.x + " " + a.y + "))";
        String qs = URLEncoder.encode("Prefix geo:<http://www.georss.org/georss/> Prefix ogc:<http://www.opengis.net/ont/geosparql#> Prefix rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#> Prefix lgdo:<http://linkedgeodata.org/ontology/> Prefix rdfs:<http://www.w3.org/2000/01/rdf-schema#> Prefix owl:<http://www.w3.org/2002/07/owl#> Select * { ?a rdf:type lgdo:TramRoute . ?a lgdo:hasMember ?b . ?b a lgdo:TramStop . ?b rdfs:label ?l . ?b geo:geometry ?geo . Filter(ogc:intersects(?geo, ogc:geomFromText('" + polygon + "'))) . } Limit 100", "UTF8");
        qs = URLEncoder.encode("Select * {?s ?p ?o . } Limit 10");
    }
}

