/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.views.transform;

import com.google.common.collect.Sets;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.op.OpDisjunction;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGroup;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpNull;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpSlice;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.aksw.commons.util.reflect.MultiMethod;
import org.aksw.sparqlify.algebra.sparql.domain.OpRdfViewPattern;
import org.aksw.sparqlify.expr.util.ExprUtils;
import org.aksw.sparqlify.views.transform.GetVarsMentioned;
import sparql.ClauseUtils;
import sparql.CnfUtils;

public class FilterPlacementOptimizer {
    public static Op optimize(Op op) {
        HashSet cnf = new HashSet();
        return (Op)MultiMethod.invokeStatic(FilterPlacementOptimizer.class, (String)"_optimize", (Object[])new Object[]{op, cnf});
    }

    public static Op optimize(Op op, Set<Set<Expr>> cnf) {
        if (op instanceof OpNull) {
            return op;
        }
        return (Op)MultiMethod.invokeStatic(FilterPlacementOptimizer.class, (String)"_optimize", (Object[])new Object[]{op, cnf});
    }

    public static Set<Set<Expr>> filterByVars(Set<Set<Expr>> cnf, Op op) {
        return ClauseUtils.filterByVars(cnf, GetVarsMentioned.getVarsMentioned(op));
    }

    public static Op _optimize(OpOrder op, Set<Set<Expr>> cnf) {
        return new OpOrder(FilterPlacementOptimizer.optimize(op.getSubOp(), cnf), op.getConditions());
    }

    public static Op _optimize(OpJoin op, Set<Set<Expr>> cnf) {
        Set<Set<Expr>> leftCnf = FilterPlacementOptimizer.filterByVars(cnf, op.getLeft());
        Set<Set<Expr>> rightCnf = FilterPlacementOptimizer.filterByVars(cnf, op.getLeft());
        Sets.SetView union = Sets.union(leftCnf, rightCnf);
        Sets.SetView remaining = Sets.difference(cnf, (Set)union);
        Op result = OpJoin.create((Op)FilterPlacementOptimizer.optimize(op.getLeft(), leftCnf), (Op)FilterPlacementOptimizer.optimize(op.getRight(), rightCnf));
        if (!remaining.isEmpty()) {
            result = OpFilter.filter((ExprList)FilterPlacementOptimizer.cnfToExprList((Set<Set<Expr>>)remaining), (Op)result);
        }
        return result;
    }

    public static Op _optimize(OpDisjunction op, Set<Set<Expr>> cnf) {
        ArrayList<Op> args = new ArrayList<Op>();
        for (Op element : op.getElements()) {
            Set<Var> elementVars = GetVarsMentioned.getVarsMentioned(element);
            boolean elementHasRequiredVars = true;
            for (Set<Expr> clause : cnf) {
                Set<Var> clauseVars = ClauseUtils.getVarsMentioned(clause);
                if (!clauseVars.containsAll(elementVars)) continue;
                elementHasRequiredVars = false;
                break;
            }
            if (!elementHasRequiredVars) continue;
            args.add(FilterPlacementOptimizer.optimize(element, cnf));
        }
        OpDisjunction result = OpDisjunction.create();
        result.getElements().addAll(args);
        return result;
    }

    public static Op _optimize(OpDistinct op, Set<Set<Expr>> cnf) {
        return new OpDistinct(FilterPlacementOptimizer.optimize(op.getSubOp(), cnf));
    }

    public static Op _optimize(OpProject op, Set<Set<Expr>> cnf) {
        return new OpProject(FilterPlacementOptimizer.optimize(op.getSubOp(), cnf), op.getVars());
    }

    public static Op _optimize(OpGroup op, Set<Set<Expr>> cnf) {
        return new OpGroup(FilterPlacementOptimizer.optimize(op.getSubOp(), cnf), op.getGroupVars(), op.getAggregators());
    }

    public static Op _optimize(OpFilter op, Set<Set<Expr>> cnf) {
        Set<Set<Expr>> newCnf = CnfUtils.toSetCnf(op.getExprs());
        newCnf.addAll(cnf);
        return FilterPlacementOptimizer.optimize(op.getSubOp(), newCnf);
    }

    public static Op _optimize(OpNull op, Set<Set<Expr>> cnf) {
        return op;
    }

    public static Op _optimize(OpSlice op, Set<Set<Expr>> cnf) {
        return op.copy(FilterPlacementOptimizer.optimize(op.getSubOp(), cnf));
    }

    public static Op _optimize(OpLeftJoin op, Set<Set<Expr>> cnf) {
        Set<Var> rightVars = GetVarsMentioned.getVarsMentioned(op.getRight());
        HashSet<Set<Expr>> leftClauses = new HashSet<Set<Expr>>();
        HashSet<Set<Expr>> nonPushable = new HashSet<Set<Expr>>();
        for (Set<Expr> clause : cnf) {
            Set<Var> clauseVars = ClauseUtils.getVarsMentioned(clause);
            if (Sets.intersection(clauseVars, rightVars).isEmpty()) {
                leftClauses.add(clause);
                continue;
            }
            nonPushable.add(clause);
        }
        Op leftJoin = OpLeftJoin.create((Op)FilterPlacementOptimizer.optimize(op.getLeft(), leftClauses), (Op)FilterPlacementOptimizer.optimize(op.getRight()), (ExprList)new ExprList());
        return FilterPlacementOptimizer.surroundWithFilterIfNeccessary(leftJoin, nonPushable);
    }

    public static ExprList cnfToExprList(Set<Set<Expr>> cnf) {
        ExprList result = new ExprList();
        for (Set<Expr> clause : cnf) {
            Expr expr = ExprUtils.orifyBalanced(clause);
            result.add(expr);
        }
        return result;
    }

    public static Op surroundWithFilterIfNeccessary(Op op, Set<Set<Expr>> cnf) {
        if (cnf.isEmpty()) {
            return op;
        }
        ExprList exprs = FilterPlacementOptimizer.cnfToExprList(cnf);
        Op result = OpFilter.filter((ExprList)exprs, (Op)op);
        return result;
    }

    public static Op _optimize(OpRdfViewPattern op, Set<Set<Expr>> cnf) {
        return FilterPlacementOptimizer.surroundWithFilterIfNeccessary((Op)op, cnf);
    }
}

