/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.util;

import java.util.List;
import org.aksw.sparqlify.config.lang.ConfigParser;
import org.aksw.sparqlify.config.syntax.Config;
import org.aksw.sparqlify.config.v0_2.bridge.SyntaxBridge;
import org.aksw.sparqlify.core.cast.TypeSystem;
import org.aksw.sparqlify.core.domain.input.ViewDefinition;
import org.antlr.runtime.RecognitionException;

public class ViewDefinitionFactory {
    private ConfigParser parser = new ConfigParser();
    private SyntaxBridge syntaxBridge;

    public ViewDefinitionFactory(ConfigParser parser, SyntaxBridge syntaxBridge) {
        this.parser = parser;
        this.syntaxBridge = syntaxBridge;
    }

    public ViewDefinition create(String viewDefStr) {
        Config config;
        try {
            config = this.parser.parse(viewDefStr, null);
        }
        catch (RecognitionException e) {
            throw new RuntimeException(e);
        }
        List<org.aksw.sparqlify.config.syntax.ViewDefinition> syntacticViewDefs = config.getViewDefinitions();
        org.aksw.sparqlify.config.syntax.ViewDefinition syntacticViewDef = syntacticViewDefs.get(0);
        ViewDefinition result = this.syntaxBridge.create(syntacticViewDef);
        return result;
    }

    public TypeSystem getDatatypeSystem() {
        return this.syntaxBridge.getSchemaProvider().getDatatypeSystem();
    }
}

