/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.sparqlview;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.algebra.Op;
import org.aksw.commons.sparql.api.core.QueryExecutionFactory;
import org.aksw.commons.sparql.api.core.QueryExecutionFactoryBackQuery;
import org.aksw.commons.sparql.api.core.QueryExecutionStreaming;
import org.aksw.sparqlify.core.interfaces.CandidateViewSelector;
import org.aksw.sparqlify.sparqlview.Dialect;
import org.aksw.sparqlify.sparqlview.MyOpAsQuery;
import org.aksw.sparqlify.sparqlview.SparqlView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutionFactorySparqlView
extends QueryExecutionFactoryBackQuery {
    private static Logger logger = LoggerFactory.getLogger(QueryExecutionFactorySparqlView.class);
    private QueryExecutionFactory factory;
    private CandidateViewSelector<SparqlView> candidateViewSelector;
    private Dialect dialect;

    public QueryExecutionFactorySparqlView(QueryExecutionFactory factory, CandidateViewSelector<SparqlView> candidateViewSelector, Dialect dialect) {
        this.factory = factory;
        this.candidateViewSelector = candidateViewSelector;
        this.dialect = dialect;
    }

    public String getId() {
        return this.factory.getId() + "-" + ((Object)((Object)this)).hashCode();
    }

    public String getState() {
        return null;
    }

    public QueryExecutionStreaming createQueryExecution(Query query) {
        Op rewrittenOp = this.candidateViewSelector.getApplicableViews(query);
        Query rewritten = MyOpAsQuery.asQuery(rewrittenOp, this.dialect);
        System.out.println("Rewritten query: " + rewritten);
        QueryExecutionStreaming result = this.factory.createQueryExecution(rewritten);
        return result;
    }
}

