/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.database;

import java.util.List;
import java.util.Set;
import org.aksw.sparqlify.database.MapStoreAccessor;
import org.aksw.sparqlify.database.MetaIndexFactory;
import org.aksw.sparqlify.database.PatriciaPrefixMapStoreAccessor;
import org.aksw.sparqlify.database.Table;
import org.apache.commons.collections15.Transformer;

public class PatriciaAccessorFactory
implements MetaIndexFactory {
    private Transformer<Object, Set<String>> prefixExtractor;

    public PatriciaAccessorFactory(Transformer<Object, Set<String>> prefixExtractor) {
        this.prefixExtractor = prefixExtractor;
    }

    @Override
    public MapStoreAccessor create(Table table, List<String> columnNames) {
        int[] indexColumns = new int[columnNames.size()];
        for (int i = 0; i < indexColumns.length; ++i) {
            String columnName = columnNames.get(i);
            indexColumns[i] = table.getColumns().getIndex(columnName);
        }
        PatriciaPrefixMapStoreAccessor accessor = new PatriciaPrefixMapStoreAccessor(indexColumns, this.prefixExtractor);
        return accessor;
    }
}

