/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import org.aksw.commons.collections.SinglePrefetchIterator;

class TsvRowIterator
extends SinglePrefetchIterator<List<String>> {
    private BufferedReader reader;
    private String separator;
    private boolean isReaderClosable = true;

    public TsvRowIterator(File file, String separator) throws FileNotFoundException {
        this(new BufferedReader(new InputStreamReader(new FileInputStream(file))), separator);
    }

    public TsvRowIterator(BufferedReader reader, String separator) {
        this.reader = reader;
        this.separator = separator;
    }

    protected List<String> prefetch() throws Exception {
        String line = this.reader.readLine();
        if (line == null) {
            return (List)this.finish();
        }
        String[] cells = line.split(this.separator);
        List<String> result = Arrays.asList(cells);
        return result;
    }

    public void close() {
        if (this.isReaderClosable) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

