/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.csv;

import au.com.bytecode.opencsv.CSVReader;
import com.google.common.base.Joiner;
import java.io.IOException;
import org.aksw.sparqlify.csv.ReaderStringBase;

public class ReaderCSVReader
extends ReaderStringBase {
    private static final String newLine = "\n";
    private static final Joiner joiner = Joiner.on((String)"\",\"");
    private CSVReader csvReader;

    public ReaderCSVReader(CSVReader csvReader) {
        this.csvReader = csvReader;
    }

    public static String encodeCell(String cell) {
        String result = cell.replace("\"", "\\\"");
        return result;
    }

    public static String[] encodeCells(String[] cells) {
        String[] result = new String[cells.length];
        for (int i = 0; i < cells.length; ++i) {
            String rawCell = cells[i];
            result[i] = ReaderCSVReader.encodeCell(rawCell);
        }
        return result;
    }

    public static String createLine(String[] cells) {
        Object[] encodedCells = ReaderCSVReader.encodeCells(cells);
        String result = "\"" + joiner.join(encodedCells) + "\"" + newLine;
        return result;
    }

    @Override
    protected String nextString() {
        try {
            String str;
            String[] strs = this.csvReader.readNext();
            String result = strs == null ? null : (strs.length == 0 ? newLine : (strs.length == 1 ? ((str = strs[0]).isEmpty() ? newLine : ReaderCSVReader.createLine(strs)) : ReaderCSVReader.createLine(strs)));
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.csvReader.close();
    }
}

