/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.sparql;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.Syntax;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aksw.sparqlify.core.sparql.QueryEx;

public class QueryFactoryEx {
    static String[] queryForms = new String[]{"ask", "construct", "select", "describe"};
    static Pattern[] explainPatterns = null;

    public static void main(String[] args) {
        System.out.println(QueryFactoryEx.create("expLain sElect * { ?s ?p ?o \n\n }"));
        System.out.println(QueryFactoryEx.create("Prefix ex: <http://example.org/>\n\n expLain sElect * { ?s ?p ?o \n\n }"));
        System.out.println(QueryFactoryEx.create("Prefix ex: <http://example.org/>\n\n expLain\nconstruct { ?s ?p ?o \n\n } { ?s ?p ?o }"));
    }

    public static QueryEx create(String queryString) {
        boolean isExplain = false;
        for (int i = 0; i < queryForms.length; ++i) {
            String queryForm = queryForms[i];
            Pattern pattern = explainPatterns[i];
            Matcher m = pattern.matcher(queryString);
            if (!m.find()) continue;
            isExplain = true;
            queryString = m.replaceAll(" " + queryForm + " ");
            break;
        }
        Query query = QueryFactory.create((String)queryString, null, (Syntax)Syntax.syntaxSPARQL_11);
        QueryEx result = new QueryEx(query, isExplain);
        return result;
    }

    static {
        explainPatterns = new Pattern[queryForms.length];
        int i = 0;
        for (String queryForm : queryForms) {
            Pattern explainPattern;
            QueryFactoryEx.explainPatterns[i] = explainPattern = Pattern.compile("(^|\\s|\n)+explain(\\s|\n)+" + queryForm + "(\\s|\n)+", 10);
            ++i;
        }
    }
}

