/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.sparql;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import org.aksw.commons.sparql.api.core.QueryExecutionBaseSelect;
import org.aksw.commons.sparql.api.core.QueryExecutionFactory;
import org.aksw.commons.sparql.api.core.QueryExecutionStreaming;
import org.aksw.commons.sparql.api.core.QueryExecutionTimeoutHelper;
import org.aksw.commons.sparql.api.core.ResultSetClosable;
import org.aksw.sparqlify.core.interfaces.SparqlSqlStringRewriter;
import org.aksw.sparqlify.core.sparql.QueryExecutionSelect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutionSparqlify
extends QueryExecutionBaseSelect {
    public static Logger logger = LoggerFactory.getLogger(QueryExecutionSparqlify.class);
    private SparqlSqlStringRewriter rewriter;
    private Connection conn;
    private boolean closeConnWhenDone;
    protected QueryExecutionTimeoutHelper timeoutHelper = new QueryExecutionTimeoutHelper((QueryExecution)this);

    public QueryExecutionSparqlify(SparqlSqlStringRewriter rewriter, Connection conn, boolean closeConnWhenDone, Query query, QueryExecutionFactory subFactory) {
        super(query, subFactory);
        this.rewriter = rewriter;
        this.conn = conn;
        this.closeConnWhenDone = closeConnWhenDone;
    }

    protected QueryExecutionStreaming executeCoreSelectX(Query dummy) {
        QueryExecutionSelect result = new QueryExecutionSelect(this.rewriter, this.conn, dummy, false);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultSetClosable executeCoreSelect(Query query) {
        this.timeoutHelper.startExecutionTimer();
        try {
            ResultSetClosable result;
            ResultSetClosable resultSetClosable = result = super.executeCoreSelect(query);
            return resultSetClosable;
        }
        finally {
            this.timeoutHelper.stopExecutionTimer();
        }
    }

    public void setTimeout(long timeout, TimeUnit timeoutUnits) {
        this.timeoutHelper.setTimeout(timeout, timeoutUnits);
    }

    public void setTimeout(long timeout) {
        this.timeoutHelper.setTimeout(timeout);
    }

    public void setTimeout(long timeout1, TimeUnit timeUnit1, long timeout2, TimeUnit timeUnit2) {
        this.timeoutHelper.setTimeout(timeout1, timeUnit1, timeout2, timeUnit2);
    }

    public void setTimeout(long timeout1, long timeout2) {
        this.timeoutHelper.setTimeout(timeout1, timeout2);
    }

    public void close() {
        super.close();
        if (this.closeConnWhenDone) {
            try {
                logger.trace("Closed connection: [" + this.conn + "]");
                this.conn.close();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

