/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.domain.input;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.sparqlify.algebra.sparql.transform.ConstantExpander;
import org.aksw.sparqlify.algebra.sparql.transform.NodeExprSubstitutor;
import org.aksw.sparqlify.core.domain.input.RestrictedExpr;
import org.aksw.sparqlify.restriction.RestrictionSetImpl;

public class VarDefinition {
    private Multimap<Var, RestrictedExpr> varToExprs;

    public VarDefinition() {
        this.varToExprs = HashMultimap.create();
    }

    public VarDefinition(Multimap<Var, RestrictedExpr> varToExprs) {
        this.varToExprs = varToExprs;
    }

    boolean isEmpty() {
        return this.varToExprs.isEmpty();
    }

    public Multimap<Var, RestrictedExpr> getMap() {
        return this.varToExprs;
    }

    public Collection<RestrictedExpr> getDefinitions(Var viewVar) {
        return this.varToExprs.get((Object)viewVar);
    }

    public void applyExprTransform(Function<Expr, Expr> transform) {
        HashMultimap newVarToExprs = HashMultimap.create();
        for (Map.Entry entry : this.varToExprs.entries()) {
            Var var = (Var)entry.getKey();
            RestrictedExpr restExpr = (RestrictedExpr)entry.getValue();
            Expr expr = restExpr.getExpr();
            Expr ne = (Expr)transform.apply((Object)expr);
            RestrictionSetImpl r = restExpr.getRestrictions();
            RestrictedExpr nre = new RestrictedExpr(ne, r);
            newVarToExprs.put((Object)var, (Object)nre);
        }
        this.varToExprs = newVarToExprs;
    }

    public VarDefinition copyProject(Collection<Var> viewVars) {
        HashMultimap map = HashMultimap.create();
        for (Var var : viewVars) {
            Collection restExprs = this.varToExprs.get((Object)var);
            map.putAll((Object)var, (Iterable)restExprs);
        }
        VarDefinition result = new VarDefinition((Multimap<Var, RestrictedExpr>)map);
        return result;
    }

    public VarDefinition copyExpandConstants() {
        HashMultimap resultMap = HashMultimap.create();
        for (Map.Entry entry : this.varToExprs.entries()) {
            Var var = (Var)entry.getKey();
            RestrictedExpr restExpr = (RestrictedExpr)entry.getValue();
            Expr expr = restExpr.getExpr();
            Expr expandedExpr = expr.isConstant() ? ConstantExpander._transform(expr.getConstant()) : expr;
            RestrictedExpr finalExpr = new RestrictedExpr(expandedExpr, restExpr.getRestrictions());
            resultMap.put((Object)var, (Object)finalExpr);
        }
        VarDefinition result = new VarDefinition((Multimap<Var, RestrictedExpr>)resultMap);
        return result;
    }

    public VarDefinition copyRenameVars(Map<Var, Var> oldToNew) {
        HashMultimap resultMap = HashMultimap.create();
        for (Map.Entry entry : this.varToExprs.asMap().entrySet()) {
            Var var = (Var)entry.getKey();
            Var renamedVar = oldToNew.get(var);
            Var newVar = renamedVar == null ? var : renamedVar;
            resultMap.putAll((Object)newVar, (Iterable)entry.getValue());
        }
        VarDefinition result = new VarDefinition((Multimap<Var, RestrictedExpr>)resultMap);
        return result;
    }

    public static VarDefinition copyRename(VarDefinition varDef, Map<String, String> oldToNew) {
        HashMap<Var, Expr> map = new HashMap<Var, Expr>();
        for (Map.Entry<String, String> entry : oldToNew.entrySet()) {
            map.put(Var.alloc((String)entry.getKey()), (Expr)new ExprVar(Var.alloc((String)entry.getValue())));
        }
        VarDefinition result = VarDefinition.copySubstitute(varDef, map);
        return result;
    }

    public VarDefinition copySubstitute(Map<Var, Expr> map) {
        VarDefinition result = VarDefinition.copySubstitute(this, map);
        return result;
    }

    public static VarDefinition copySubstitute(VarDefinition varDef, Map<Var, Expr> map) {
        NodeExprSubstitutor substitutor = new NodeExprSubstitutor(map);
        HashMultimap newVarToExpr = HashMultimap.create();
        for (Map.Entry entry : varDef.getMap().entries()) {
            RestrictedExpr before = (RestrictedExpr)entry.getValue();
            Expr newExpr = substitutor.transformMM(before.getExpr());
            RestrictedExpr after = new RestrictedExpr(newExpr, before.getRestrictions());
            newVarToExpr.put(entry.getKey(), (Object)after);
        }
        VarDefinition result = new VarDefinition((Multimap<Var, RestrictedExpr>)newVarToExpr);
        return result;
    }

    public VarDefinition extend(VarDefinition that) {
        HashMultimap map = HashMultimap.create(this.varToExprs);
        map.putAll(that.varToExprs);
        VarDefinition result = new VarDefinition((Multimap<Var, RestrictedExpr>)map);
        return result;
    }

    public String toPrettyString() {
        return VarDefinition.toIndentedString(this);
    }

    public static String toIndentedString(VarDefinition varDef) {
        Multimap<Var, RestrictedExpr> map = varDef.getMap();
        String result = VarDefinition.toIndentedString(map);
        return result;
    }

    public List<String> getReferencedNames() {
        Set<Var> tmp = this.getReferencedVars();
        ArrayList<String> result = new ArrayList<String>(tmp.size());
        for (Var var : tmp) {
            String name = var.getName();
            result.add(name);
        }
        return result;
    }

    public Set<Var> getReferencedVars() {
        HashSet<Var> result = new HashSet<Var>();
        for (Map.Entry entry : this.varToExprs.entries()) {
            Set tmp = ((RestrictedExpr)entry.getValue()).getExpr().getVarsMentioned();
            result.addAll(tmp);
        }
        return result;
    }

    public static String toIndentedString(Multimap<Var, RestrictedExpr> varToExprs) {
        String result = "";
        for (Map.Entry entry : varToExprs.asMap().entrySet()) {
            RestrictedExpr restExpr;
            String firstLabel;
            Var var = (Var)entry.getKey();
            String varName = var.getName();
            Collection restExprs = (Collection)entry.getValue();
            Iterator it = restExprs.iterator();
            if (!it.hasNext()) {
                firstLabel = "(empty definition set)";
            } else {
                restExpr = (RestrictedExpr)it.next();
                firstLabel = varName + ": " + restExpr.getExpr() + " [" + restExpr.getRestrictions() + "]";
            }
            result = result + firstLabel + "\n";
            while (it.hasNext()) {
                restExpr = (RestrictedExpr)it.next();
                result = result + "    " + restExpr.getExpr() + " [" + restExpr.getRestrictions() + "]" + "\n";
            }
        }
        return result;
    }

    public String toString() {
        return this.toPrettyString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.varToExprs == null ? 0 : this.varToExprs.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VarDefinition other = (VarDefinition)obj;
        return !(this.varToExprs == null ? other.varToExprs != null : !this.varToExprs.equals(other.varToExprs));
    }

    public static VarDefinition create(VarExprList varExprs) {
        HashMultimap map = HashMultimap.create();
        for (Map.Entry entry : varExprs.getExprs().entrySet()) {
            Var var = (Var)entry.getKey();
            Expr expr = (Expr)entry.getValue();
            RestrictedExpr restExpr = new RestrictedExpr(expr);
            map.put((Object)var, (Object)restExpr);
        }
        VarDefinition result = new VarDefinition((Multimap<Var, RestrictedExpr>)map);
        return result;
    }
}

