/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.datatypes;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.MultiMaps;
import org.aksw.commons.collections.multimaps.BiHashMultimap;
import org.aksw.commons.collections.multimaps.IBiSetMultimap;
import org.aksw.commons.factory.Factory1;
import org.aksw.commons.util.reflect.Caster;
import org.aksw.commons.util.reflect.ClassUtils;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExpr;
import org.aksw.sparqlify.algebra.sql.exprs.evaluators.SqlExprEvaluator;
import org.aksw.sparqlify.core.TypeToken;
import org.aksw.sparqlify.core.cast.ExprSubstitutorSql;
import org.aksw.sparqlify.core.datatypes.CoercionSystemImpl;
import org.aksw.sparqlify.core.datatypes.CoercionSystemOld;
import org.aksw.sparqlify.core.datatypes.SparqlFunction;
import org.aksw.sparqlify.core.datatypes.SparqlFunctionImpl;
import org.aksw.sparqlify.core.datatypes.SqlMethodCandidate;
import org.aksw.sparqlify.core.datatypes.TypeDistance;
import org.aksw.sparqlify.core.datatypes.TypeSystem;
import org.aksw.sparqlify.core.datatypes.XClass;
import org.aksw.sparqlify.core.datatypes.XClassImpl;
import org.aksw.sparqlify.core.datatypes.XClassUtils;
import org.aksw.sparqlify.core.datatypes.XMethod;
import org.aksw.sparqlify.expr.util.NodeValueUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatatypeSystemCustom
implements TypeSystem {
    private static final Logger logger = LoggerFactory.getLogger(DatatypeSystemCustom.class);
    private Map<TypeToken, XClass> nameToType;
    private IBiSetMultimap<TypeToken, TypeToken> typeHierarchy;
    private transient Map<Class<?>, TypeToken> classToToken;
    private CoercionSystemImpl coercionSystem = new CoercionSystemImpl();
    private Multimap<String, XMethod> sqlFunctions = HashMultimap.create();
    private Map<String, SparqlFunctionImpl> sparqlFunctions = new HashMap<String, SparqlFunctionImpl>();

    @Override
    public SparqlFunctionImpl createSparqlFunction(String name, SqlExprEvaluator evaluator) {
        SparqlFunctionImpl result = new SparqlFunctionImpl(name, evaluator);
        this.sparqlFunctions.put(name, result);
        return result;
    }

    public SparqlFunctionImpl getOrCreateSparqlFunction(String name) {
        SparqlFunctionImpl result = this.sparqlFunctions.get(name);
        if (result == null) {
            result = this.createSparqlFunction(name, null);
        }
        return result;
    }

    @Override
    public SparqlFunction getSparqlFunction(String name) {
        SparqlFunction result = this.sparqlFunctions.get(name);
        return result;
    }

    @Override
    public void registerSqlFunction(String sparqlFunctionName, XMethod method) {
        SparqlFunctionImpl fn = this.getOrCreateSparqlFunction(sparqlFunctionName);
        ExprSubstitutorSql substitutor = fn.getSubstitutor();
        this.sqlFunctions.put((Object)method.getName(), (Object)method);
    }

    public static Map<XMethod, TypeDistance[]> findMethodCandidates(Collection<XMethod> candidates, CoercionSystemOld coercions, XClass ... typeSignature) {
        HashMap<XMethod, TypeDistance[]> bestMatches = new HashMap<XMethod, TypeDistance[]>();
        for (XMethod m : candidates) {
            TypeDistance[] d = XClassUtils.getTypeDistance(typeSignature, m.getSignature().getParameterTypes().toArray(new XClass[0]), coercions);
            if (d == null || Arrays.asList(d).contains(null)) continue;
            boolean canBeAdded = true;
            Iterator it = bestMatches.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                int rel = XClassUtils.getRelation(d, (TypeDistance[])entry.getValue());
                if (rel == -1) {
                    it.remove();
                    continue;
                }
                if (rel <= 0) continue;
                canBeAdded = false;
            }
            if (!canBeAdded) continue;
            bestMatches.put(m, d);
        }
        return bestMatches;
    }

    public static Map<XMethod, Integer[]> findMethodCandidates(Collection<XMethod> candidates, XClass ... typeSignature) {
        HashMap<XMethod, Integer[]> bestMatches = new HashMap<XMethod, Integer[]>();
        for (XMethod m : candidates) {
            Integer[] d = XClassUtils.getDistance(typeSignature, m.getSignature().getParameterTypes().toArray(new XClass[0]));
            if (d == null || Arrays.asList(d).contains(null)) continue;
            boolean canBeAdded = true;
            Iterator it = bestMatches.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                int rel = ClassUtils.getRelation((Integer[])d, (Integer[])((Integer[])entry.getValue()));
                if (rel == -1) {
                    it.remove();
                    continue;
                }
                if (rel <= 0) continue;
                canBeAdded = false;
            }
            if (!canBeAdded) continue;
            bestMatches.put(m, d);
        }
        return bestMatches;
    }

    @Override
    public SqlMethodCandidate lookupMethod(String sparqlFunctionName, List<TypeToken> argTypes) {
        SparqlFunction fn = this.sparqlFunctions.get(sparqlFunctionName);
        if (fn == null) {
            return null;
        }
        Collection<XMethod> candidates = fn.getSqlMethods();
        SqlMethodCandidate result = this.lookupMethod(candidates, argTypes);
        return result;
    }

    public SqlMethodCandidate lookupMethod(Collection<XMethod> candidates, List<TypeToken> argTypes) {
        List<XClass> resolved = XClassUtils.resolve(this, argTypes);
        XClass[] tmp = resolved.toArray(new XClass[0]);
        Map<XMethod, TypeDistance[]> bestMatches = DatatypeSystemCustom.findMethodCandidates(candidates, this.coercionSystem, tmp);
        if (bestMatches.size() == 0) {
            logger.debug("No method found:  " + argTypes);
            return null;
        }
        if (bestMatches.size() > 1) {
            throw new RuntimeException("Multiple matches: " + bestMatches);
        }
        Map.Entry<XMethod, TypeDistance[]> entry = bestMatches.entrySet().iterator().next();
        XMethod method = entry.getKey();
        TypeDistance[] typeDistances = entry.getValue();
        ArrayList<XMethod> argCoercions = new ArrayList<XMethod>(typeDistances.length);
        for (TypeDistance item : typeDistances) {
            argCoercions.add(item.getCoercion());
        }
        SqlMethodCandidate result = new SqlMethodCandidate(method, argCoercions);
        return result;
    }

    @Override
    public List<TypeToken> getDirectSuperClasses(TypeToken typeToken) {
        Set superClasses = this.typeHierarchy.get((Object)typeToken);
        ArrayList<TypeToken> result = new ArrayList<TypeToken>(superClasses);
        return result;
    }

    private void initNameToType(Map<String, String> typeToClass, Map<String, String> typeToUri, Map<String, String> typeHierarchy) {
        HashSet<String> all = new HashSet<String>();
        all.addAll(typeToClass.keySet());
        all.addAll(typeToUri.keySet());
        all.addAll(typeHierarchy.keySet());
        all.addAll(typeHierarchy.values());
        HashMap<TypeToken, XClass> nameToClass = new HashMap<TypeToken, XClass>();
        for (String typeName : all) {
            TypeToken typeToken = TypeToken.alloc(typeName);
            String className = typeToClass.get(typeName);
            Class<?> clazz = null;
            if (className != null) {
                try {
                    clazz = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    logger.error("Class '" + className + "' not found");
                }
            }
            String uri = typeToUri.get(typeName);
            Node node = null;
            if (uri != null) {
                node = Node.createURI((String)uri);
            }
            XClassImpl datatype = new XClassImpl(this, typeToken, node, clazz);
            TypeToken token = TypeToken.alloc(typeName);
            nameToClass.put(token, datatype);
        }
        BiHashMultimap subToSuperType = new BiHashMultimap();
        for (Map.Entry<String, String> entry : typeHierarchy.entrySet()) {
            TypeToken subType = TypeToken.alloc(entry.getKey());
            TypeToken superType = TypeToken.alloc(entry.getValue());
            subToSuperType.put((Object)subType, (Object)superType);
        }
        this.nameToType = nameToClass;
        this.typeHierarchy = subToSuperType;
    }

    private void initClassToTypeCache() {
        this.classToToken = new HashMap();
        for (Map.Entry<TypeToken, XClass> entry : this.nameToType.entrySet()) {
            TypeToken oldMapping;
            TypeToken typeName = entry.getKey();
            XClass datatype = entry.getValue();
            Class<?> clazz = datatype.getCorrespondingClass();
            if (clazz == null || (oldMapping = this.classToToken.get(clazz)) != null && !this.isSuperClassOf(typeName, oldMapping)) continue;
            this.classToToken.put(clazz, typeName);
        }
        for (Map.Entry<Object, Object> entry : this.classToToken.entrySet()) {
            logger.debug("[DatatypeSytem] Added type mapping: " + entry);
        }
    }

    public DatatypeSystemCustom(Map<String, String> typeToClass, Map<String, String> typeToUri, Map<String, String> typeHierarchy) {
        this.initNameToType(typeToClass, typeToUri, typeHierarchy);
        this.initClassToTypeCache();
        this.coercionSystem = new CoercionSystemImpl();
    }

    @Override
    public TypeToken getTokenForClass(Class<?> clazz) {
        TypeToken result = this.classToToken.get(clazz);
        return result;
    }

    @Override
    public XClass getByName(TypeToken name) {
        return this.nameToType.get(name);
    }

    @Override
    public XClass getByName(String name) {
        return this.nameToType.get(TypeToken.alloc(name));
    }

    @Override
    public XClass getByClass(Class<?> clazz) {
        TypeToken typeName = this.classToToken.get(clazz);
        XClass result = this.nameToType.get(typeName);
        return result;
    }

    @Override
    public XClass requireByName(String name) {
        XClass result = this.nameToType.get(TypeToken.alloc(name));
        if (result == null) {
            throw new RuntimeException("No registered datatype found with name '" + name + "'");
        }
        return result;
    }

    @Override
    public NodeValue cast(NodeValue value, TypeToken to) {
        XClass targetType = this.getByName(to);
        Class<?> targetClazz = targetType.getCorrespondingClass();
        if (targetClazz == null) {
            logger.warn("No class corresponding to '" + to + "' found.");
            return null;
        }
        NodeValue result = this.tryCast(value, targetType);
        return result;
    }

    public NodeValue tryCast(NodeValue nodeValue, XClass targetType) {
        Class<?> targetClazz = targetType.getClass();
        Object value = NodeValueUtils.getValue(nodeValue);
        Object castedValue = Caster.tryCast((Object)value, targetClazz);
        TypeMapper typeMapper = TypeMapper.getInstance();
        RDFDatatype datatype = typeMapper.getSafeTypeByName(targetType.getName());
        Node tmp = Node.createLiteral((String)("" + castedValue), (RDFDatatype)datatype);
        NodeValue result = NodeValue.makeNode((Node)tmp);
        return result;
    }

    @Override
    public Factory1<SqlExpr> cast(TypeToken from, TypeToken to) {
        return null;
    }

    @Override
    public TypeToken mostGenericDatatype(TypeToken from, TypeToken to) {
        throw new RuntimeException("This method does not make sense. We coulde always return object");
    }

    @Override
    public Set<TypeToken> supremumDatatypes(TypeToken from, TypeToken to) {
        return MultiMaps.getCommonParent((Map)this.typeHierarchy.asMap(), (Object)from, (Object)to);
    }

    @Override
    public Integer compare(TypeToken a, TypeToken b) {
        return null;
    }

    public static DatatypeSystemCustom create(Map<String, String> typeToClass, Map<String, String> typeToUri, Map<String, String> typeHierarchy, Logger logger) {
        DatatypeSystemCustom result = new DatatypeSystemCustom(typeToClass, typeToUri, typeHierarchy);
        return result;
    }

    @Override
    public boolean isSuperClassOf(TypeToken a, TypeToken b) {
        Set superClasses = MultiMaps.transitiveGet((Map)this.typeHierarchy.asMap(), (Object)a);
        boolean result = superClasses.contains(b);
        return result;
    }

    @Override
    public void registerCoercion(XMethod method) {
        this.coercionSystem.register(method);
    }
}

