/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.cast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.aksw.sparqlify.core.cast.DirectSuperTypeProvider;
import org.aksw.sparqlify.core.cast.TypeResolver;
import org.aksw.sparqlify.core.datatypes.XClass;

public class TypeSystemUtils {
    public static List<XClass> getDirectSuperClasses(String name, DirectSuperTypeProvider typeHierarchy, TypeResolver typeResolver) {
        Collection<String> typeNames = typeHierarchy.getDirectSuperTypes(name);
        ArrayList<XClass> result = new ArrayList<XClass>(typeNames.size());
        for (String typeName : typeNames) {
            XClass type = typeResolver.resolve(typeName);
            result.add(type);
        }
        return result;
    }

    public static <T> Set<T> getAllSuperTypes(T typeName, DirectSuperTypeProvider<T> typeHierarchyProvider) {
        HashSet<T> open = new HashSet<T>();
        HashSet done = new HashSet();
        open.add(typeName);
        while (!open.isEmpty()) {
            Iterator it = open.iterator();
            Object name = it.next();
            it.remove();
            done.add(name);
            Collection<T> superTypes = typeHierarchyProvider.getDirectSuperTypes(name);
            for (T superType : superTypes) {
                if (done.contains(superType)) continue;
                open.add(superType);
            }
        }
        return done;
    }

    public static <T> boolean isSuperClassOf(T a, T b, DirectSuperTypeProvider<T> typeHierarchyProvider) {
        Set<T> superClasses = TypeSystemUtils.getAllSuperTypes(a, typeHierarchyProvider);
        boolean result = superClasses.contains(b);
        return result;
    }
}

