/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.cast;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import org.aksw.sparqlify.algebra.sparql.transform.MethodSignature;
import org.aksw.sparqlify.core.TypeToken;
import org.aksw.sparqlify.core.cast.ExprTypeEvaluator;
import org.aksw.sparqlify.core.cast.TypeSystem;
import org.aksw.sparqlify.core.datatypes.SparqlFunction;
import org.aksw.sparqlify.expr.util.ExprUtils;

public class ExprTypeEvaluatorTypeSystem
implements ExprTypeEvaluator {
    private TypeSystem typeSystem;

    public ExprTypeEvaluatorTypeSystem(TypeSystem typeSystem) {
        this.typeSystem = typeSystem;
    }

    @Override
    public TypeToken evaluateType(Expr expr) {
        TypeToken result;
        if (expr.isFunction()) {
            ExprFunction fn = expr.getFunction();
            String fnId = ExprUtils.getFunctionId(fn);
            SparqlFunction f = this.typeSystem.getSparqlFunction(fnId);
            MethodSignature<TypeToken> signature = f.getSignature();
            result = signature.getReturnType();
        } else {
            if (expr.isVariable()) {
                throw new RuntimeException("Cannot obtain datatype of a variable");
            }
            if (expr.isConstant()) {
                NodeValue nodeValue = expr.getConstant();
                Node node = nodeValue.getNode();
                result = TypeToken.alloc(node.getLiteralDatatypeURI());
            } else {
                result = null;
            }
        }
        return result;
    }
}

