/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.QuadPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.BindingHashMap;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.Expr;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.jena.util.QuadUtils;
import org.aksw.sparqlify.algebra.sparql.transform.SparqlSubstitute;
import org.aksw.sparqlify.config.syntax.ViewTemplateDefinition;

public class RdfViewTemplate {
    private QuadPattern quadPattern;
    private Map<Node, Expr> binding;

    public RdfViewTemplate(QuadPattern quadPattern, Map<Node, Expr> binding) {
        this.quadPattern = quadPattern;
        this.binding = binding;
    }

    public QuadPattern getQuadPattern() {
        return this.quadPattern;
    }

    public Map<Node, Expr> getBinding() {
        return this.binding;
    }

    public RdfViewTemplate create(ViewTemplateDefinition definition) {
        return RdfViewTemplate.create(definition.getConstructTemplate(), definition.getVarBindings());
    }

    public static RdfViewTemplate create(QuadPattern quadPattern, List<Expr> bindings) {
        HashMap<Node, Expr> bindingMap = new HashMap<Node, Expr>();
        for (Expr expr : bindings) {
            if (!(expr instanceof E_Equals)) {
                throw new RuntimeException("Binding expr must have form ?var = ... --- instead got: " + expr);
            }
            Expr definition = expr.getFunction().getArg(2);
            definition = SparqlSubstitute.substituteExpr(definition);
            Var var = expr.getFunction().getArg(1).asVar();
            bindingMap.put((Node)var, definition);
        }
        return new RdfViewTemplate(quadPattern, bindingMap);
    }

    public Set<Var> getVarsMentioned() {
        return QuadUtils.getVarsMentioned((QuadPattern)this.quadPattern);
    }

    public RdfViewTemplate copySubstitute(Map<Node, Node> map) {
        BindingHashMap tmp = new BindingHashMap();
        for (Map.Entry<Node, Node> entry : map.entrySet()) {
            tmp.add((Var)entry.getKey(), entry.getValue());
        }
        RdfViewTemplate result = new RdfViewTemplate(QuadUtils.copySubstitute((QuadPattern)this.quadPattern, map), QuadUtils.copySubstitute(this.binding, map));
        return result;
    }

    public Model instanciate(Model result, Map<Var, Object> assignment) {
        return null;
    }
}

