/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core;

import com.hp.hpl.jena.sparql.expr.NodeValue;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.aksw.commons.util.StreamUtils;
import org.aksw.commons.util.reflect.MultiMethod;
import org.aksw.commons.util.strings.StringUtils;
import org.aksw.sparqlify.algebra.sparql.expr.old.NodeValueGeom;
import org.apache.commons.lang.NotImplementedException;
import org.h2.jdbc.JdbcClob;
import org.postgis.PGgeometry;
import org.postgresql.util.PGobject;

public class MakeNodeValue {
    public static NodeValue makeNodeValue(Object o) {
        if (o == null) {
            return null;
        }
        return (NodeValue)MultiMethod.invokeStatic(MakeNodeValue.class, (String)"_makeNodeValue", (Object[])new Object[]{o});
    }

    public static NodeValue _makeNodeValue(byte[] bytes) {
        String str = StringUtils.bytesToHexString((byte[])bytes);
        String uc = str.toUpperCase();
        NodeValue result = NodeValue.makeString((String)uc);
        return result;
    }

    public static NodeValue _makeNodeValue(BigDecimal o) {
        return NodeValue.makeDecimal((BigDecimal)o);
    }

    public static NodeValue _makeNodeValue(Float o) {
        return NodeValue.makeFloat((float)o.floatValue());
    }

    public static NodeValue _makeNodeValue(Boolean o) {
        return NodeValue.makeBoolean((boolean)o);
    }

    public static NodeValue _makeNodeValue(Integer o) {
        return NodeValue.makeNodeInteger((long)o.intValue());
    }

    public static NodeValue _makeNodeValue(Double o) {
        return NodeValue.makeNodeDouble((double)o);
    }

    public static NodeValue _makeNodeValue(String o) {
        return NodeValue.makeNodeString((String)o);
    }

    public static NodeValue _makeNodeValue(Long o) {
        return NodeValue.makeNodeInteger((long)o);
    }

    public static NodeValue _makeNodeValue(Calendar o) {
        return NodeValue.makeDate((Calendar)o);
    }

    public static NodeValue _makeNodeValue(Timestamp o) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(o);
        return NodeValue.makeNodeDateTime((Calendar)cal);
    }

    public static NodeValue _makeNodeValue(Date o) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(o);
        return NodeValue.makeNodeDate((Calendar)cal);
    }

    public static NodeValue _makeNodeValue(JdbcClob o) {
        String str;
        try {
            str = StreamUtils.toString((InputStream)o.getAsciiStream());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        NodeValue result = NodeValue.makeString((String)str);
        return result;
    }

    public static NodeValue _makeNodeValue(PGobject o) {
        String type = o.getType();
        if (type.equals("geography") || type.equals("geometry")) {
            try {
                PGgeometry geom = new PGgeometry(o.getValue());
                return new NodeValueGeom(geom);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            throw new NotImplementedException();
        }
        return null;
    }
}

