/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.config.lang;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.QuadPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.aksw.sparqlify.algebra.sparql.transform.SparqlSubstitute;
import org.aksw.sparqlify.algebra.sql.nodes.SqlNodeBase0;
import org.aksw.sparqlify.algebra.sql.nodes.SqlQuery;
import org.aksw.sparqlify.algebra.sql.nodes.SqlTable;
import org.aksw.sparqlify.config.lang.SparqlifyConfigLexer;
import org.aksw.sparqlify.config.lang.SparqlifyConfigParser;
import org.aksw.sparqlify.config.lang.SparqlifyConfigTree;
import org.aksw.sparqlify.config.syntax.Config;
import org.aksw.sparqlify.config.syntax.ViewDefinition;
import org.aksw.sparqlify.core.ConstraintContainer;
import org.aksw.sparqlify.core.RdfView;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;
import org.apache.log4j.PropertyConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sparql.FilterUtils;
import sparql.PatternUtils;

public class AntlrTest {
    private static final Logger logger = LoggerFactory.getLogger((String)"Parser");
    public static final Pattern patternCreateView = Pattern.compile("Create\\s+View", 2);

    public static void printAst(CommonTree ast, int ident) {
        int i;
        String p = "";
        for (i = 0; i < ident; ++i) {
            p = p + " ";
        }
        System.out.println(p + ast.getText() + " | " + ast.getType());
        for (i = 0; i < ast.getChildCount(); ++i) {
            AntlrTest.printAst((CommonTree)ast.getChild(i), ident + 2);
        }
    }

    public static void main(String[] args) throws Exception {
        Config config;
        System.out.println("Start");
        PropertyConfigurator.configure((String)"log4j.properties");
        InputStream in = AntlrTest.class.getResourceAsStream("/sparqlifyb.txt");
        ANTLRInputStream cs = new ANTLRInputStream(in);
        String str = "?s ?p ?o . ";
        ANTLRStringStream csStr = new ANTLRStringStream(str);
        SparqlifyConfigLexer lexer = new SparqlifyConfigLexer((CharStream)cs);
        CommonTokenStream tokens = new CommonTokenStream();
        tokens.setTokenSource((TokenSource)lexer);
        SparqlifyConfigParser parser = new SparqlifyConfigParser((TokenStream)tokens);
        CommonTree ast = parser.sparqlifyConfig().getTree();
        System.out.println("ast built");
        AntlrTest.printAst(ast, 0);
        System.out.println("done with ast");
        SparqlifyConfigTree treeParser = new SparqlifyConfigTree((TreeNodeStream)new CommonTreeNodeStream((Object)ast));
        try {
            config = treeParser.sparqlifyConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(treeParser.getRuleInvocationStack());
            return;
        }
        ArrayList<RdfView> result = new ArrayList<RdfView>();
        for (ViewDefinition item : config.getViewDefinitions()) {
            RdfView rdfView = RdfView.create(item);
            result.add(rdfView);
            System.out.println(item);
        }
        System.out.println(config.getViewDefinitions().size());
        System.out.println("done");
    }

    public static void parse(InputStream in) {
        Scanner scanner = new Scanner(in);
        while (scanner.hasNext()) {
            String p = scanner.next(patternCreateView);
            System.out.println(p);
        }
    }

    public static RdfView create(String str) {
        HashMap<String, String> defaultPrefixes = new HashMap<String, String>();
        defaultPrefixes.put("bif", "http://bif/");
        defaultPrefixes.put("rdf", RDF.getURI());
        defaultPrefixes.put("rdfs", RDFS.getURI());
        defaultPrefixes.put("geo", "http://ex.org/");
        defaultPrefixes.put("beef", "http://aksw.org/beef/");
        defaultPrefixes.put("wso", "http://aksw.org/wortschatz/ontology/");
        defaultPrefixes.put("rdf", RDF.getURI());
        defaultPrefixes.put("owl", OWL.getURI());
        return AntlrTest.create(str, defaultPrefixes);
    }

    public static RdfView create(String str, Map<String, String> defaultPrefixes) {
        PrefixMappingImpl defaultPrefixMapping = new PrefixMappingImpl();
        defaultPrefixMapping.setNsPrefixes(defaultPrefixes);
        String[] parts1 = str.split("\\swith\\s", 2);
        String[] parts2 = parts1[1].split(";");
        String sqlStr = parts2[parts2.length - 1].trim();
        String queryStr = "Select * " + parts1[0];
        String[] bindingStrs = Arrays.copyOf(parts2, parts2.length - 1);
        Query query = new Query();
        query.setPrefixMapping((PrefixMapping)defaultPrefixMapping);
        QueryFactory.parse((Query)query, (String)queryStr, null, (Syntax)Syntax.syntaxSPARQL);
        Op op = Algebra.compile((Query)query);
        op = Algebra.toQuadForm((Op)op);
        QuadPattern quadPattern = new QuadPattern();
        for (Quad quad : PatternUtils.collectQuads(op)) {
            quadPattern.add(quad);
        }
        HashMap<Node, Expr> binding = new HashMap<Node, Expr>();
        for (String bindingStr : bindingStrs) {
            Expr expr = ExprUtils.parse((String)bindingStr, (PrefixMapping)defaultPrefixMapping);
            if (!(expr instanceof E_Equals)) {
                throw new RuntimeException("Binding expr must have form ?var = ... --- instead got: " + bindingStr);
            }
            Expr definition = expr.getFunction().getArg(2);
            definition = SparqlSubstitute.substituteExpr(definition);
            Var var = expr.getFunction().getArg(1).asVar();
            binding.put((Node)var, definition);
        }
        System.out.println("Binding = " + binding);
        SqlNodeBase0 sqlExpr = sqlStr.startsWith("select") ? new SqlQuery(null, sqlStr) : new SqlTable(sqlStr);
        ExprList filter = FilterUtils.collectExprs(op, new ExprList());
        return new RdfView("test", quadPattern, filter, binding, new ConstraintContainer(), sqlExpr);
    }
}

