/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.algebra.sql.nodes;

import java.util.List;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExpr;
import org.aksw.sparqlify.algebra.sql.nodes.Schema;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOp;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpBase1;
import org.aksw.sparqlify.core.algorithms.SqlExprUtils;
import org.openjena.atlas.io.IndentedWriter;

public class SqlOpFilter
extends SqlOpBase1 {
    private List<SqlExpr> exprs;

    public SqlOpFilter(Schema schema, SqlOp subOp, List<SqlExpr> exprs) {
        super(schema, subOp);
        assert (exprs != null) : "Null pointer exception";
        this.exprs = exprs;
    }

    public List<SqlExpr> getExprs() {
        return this.exprs;
    }

    public static SqlOp createIfNeeded(SqlOp op, List<SqlExpr> exprs) {
        SqlOp result = exprs.isEmpty() ? op : SqlOpFilter.create(op, exprs);
        return result;
    }

    public static SqlOpFilter create(SqlOp op, List<SqlExpr> exprs) {
        SqlOpFilter result = new SqlOpFilter(op.getSchema(), op, exprs);
        return result;
    }

    @Override
    public void write(IndentedWriter writer) {
        writer.println((Object)("SqlOpFilter" + this.exprs + "("));
        writer.incIndent();
        this.subOp.write(writer);
        writer.println();
        writer.decIndent();
        writer.print((Object)")");
    }

    @Override
    public boolean isEmpty() {
        boolean containsFalse = SqlExprUtils.containsFalse(this.exprs, true);
        boolean result = containsFalse || this.subOp.isEmpty();
        return result;
    }
}

