/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.algebra.sql.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExpr;
import org.aksw.sparqlify.algebra.sql.nodes.SchemaImpl;

public class Projection {
    private List<String> names = new ArrayList<String>();
    private Map<String, SqlExpr> nameToExpr = new HashMap<String, SqlExpr>();

    public Projection() {
    }

    public Projection(Map<String, SqlExpr> nameToExpr) {
        this.nameToExpr = nameToExpr;
        this.names = new ArrayList<String>(nameToExpr.keySet());
    }

    public Projection(List<String> names, Map<String, SqlExpr> nameToExpr) {
        this.names = names;
        this.nameToExpr = nameToExpr;
    }

    public boolean isEmpty() {
        boolean result = this.names.isEmpty();
        return result;
    }

    public void add(Projection other) {
        this.names.addAll(other.getNames());
        SchemaImpl.validateNames(this.names);
        this.nameToExpr.putAll(other.getNameToExpr());
    }

    public void project(List<String> columnNames) {
        this.names = columnNames;
        this.nameToExpr.keySet().retainAll(columnNames);
    }

    public void extend(Projection other) {
        this.names.addAll(other.getNames());
        SchemaImpl.validateNames(this.names);
        this.nameToExpr.putAll(other.getNameToExpr());
    }

    public void rename(String oldName, String newName) {
        Collections.replaceAll(this.names, oldName, newName);
        SqlExpr val = this.nameToExpr.get(oldName);
        this.nameToExpr.remove(oldName);
        this.nameToExpr.put(newName, val);
    }

    public void renameAll(Map<String, String> oldToNew) {
        for (Map.Entry<String, String> entry : oldToNew.entrySet()) {
            this.rename(entry.getKey(), entry.getValue());
        }
    }

    public void put(String name, SqlExpr expr) {
        if (!this.nameToExpr.containsKey(name)) {
            this.names.add(name);
        }
        this.nameToExpr.put(name, expr);
    }

    public List<String> getNames() {
        return this.names;
    }

    public Map<String, SqlExpr> getNameToExpr() {
        return this.nameToExpr;
    }

    public String toString() {
        return "Projection [names=" + this.names + ", nameToExpr=" + this.nameToExpr + "]";
    }
}

