/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.algebra.sql.exprs2;

import org.aksw.sparqlify.algebra.sql.exprs2.SqlExprVarBase;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExprVisitor;
import org.aksw.sparqlify.core.TypeToken;
import org.openjena.atlas.io.IndentedWriter;

public class S_ColumnRef
extends SqlExprVarBase {
    private String columnName;
    private String relationAlias;

    public S_ColumnRef(TypeToken datatype, String columnName) {
        this(datatype, columnName, null);
    }

    public S_ColumnRef(TypeToken datatype, String columnName, String relationAlias) {
        super(datatype);
        this.columnName = columnName;
        this.relationAlias = relationAlias;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getRelationAlias() {
        return this.relationAlias;
    }

    @Override
    public void asString(IndentedWriter writer) {
        writer.print((Object)this.getVarName());
    }

    @Override
    public String toString() {
        return this.getVarName() + "(" + this.datatype + ")";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.columnName == null ? 0 : this.columnName.hashCode());
        result = 31 * result + (this.relationAlias == null ? 0 : this.relationAlias.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        S_ColumnRef other = (S_ColumnRef)obj;
        if (this.columnName == null ? other.columnName != null : !this.columnName.equals(other.columnName)) {
            return false;
        }
        return !(this.relationAlias == null ? other.relationAlias != null : !this.relationAlias.equals(other.relationAlias));
    }

    @Override
    public String getVarName() {
        String result = this.relationAlias == null ? "" + this.columnName : this.relationAlias + "." + this.columnName;
        return result;
    }

    @Override
    public <T> T accept(SqlExprVisitor<T> visitor) {
        T result = visitor.visit(this);
        return result;
    }
}

