// $ANTLR 3.5 org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g 2013-05-15 14:30:11

    package org.aksw.sparqlify.config.lang;
    
    import com.hp.hpl.jena.sparql.expr.*;
    import org.apache.commons.lang.NotImplementedException;
	import com.hp.hpl.jena.graph.*;
	import com.hp.hpl.jena.vocabulary.*;
    import com.hp.hpl.jena.sparql.syntax.*;
    import com.hp.hpl.jena.shared.*;
    import org.aksw.sparqlify.config.syntax.*;
	import com.hp.hpl.jena.shared.impl.*;
    import com.hp.hpl.jena.sparql.core.*;
    import com.hp.hpl.jena.datatypes.*;
    import org.aksw.sparqlify.algebra.sparql.expr.*;
	import com.hp.hpl.jena.rdf.model.AnonId;    
	import org.aksw.sparqlify.util.*;

	import org.aksw.sparqlify.algebra.sql.nodes.*;
	import com.hp.hpl.jena.sdb.core.JoinType;

    import java.util.Collection;
    import java.util.List;
    import java.util.ArrayList;


    import org.slf4j.Logger;
    import org.slf4j.LoggerFactory;

	import com.hp.hpl.jena.shared.PrefixMapping;
	import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;


    import org.aksw.sparqlify.core.SparqlifyConstants;


import org.antlr.runtime.*;
import org.antlr.runtime.tree.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

/**
 * @author Simone Tripodi   (simone.tripodi)
 * @author Michele Mostarda (michele.mostarda)
 * @author Juergen Pfundt   (Juergen.Pfundt)
 * @version $Id: Sparql.g 161 2011-05-23 22:14:39Z Juergen.Pfundt@web.de $
 */
@SuppressWarnings("all")
public class SparqlifyConfigTree extends TreeParser {
	public static final String[] tokenNames = new String[] {
		"<invalid>", "<EOR>", "<DOWN>", "<UP>", "A", "ABS", "ADD", "ALIASED_LOGICAL_TABLE", 
		"ALIASED_VAR", "ALL", "AND", "ANY", "ARG_LIST", "AS", "ASC", "ASK", "ASTERISK", 
		"AVG", "BASE", "BIND", "BINDINGS", "BINDING_VALUE", "BLANK_NODE", "BLANK_NODE_LABEL", 
		"BNODE", "BOUND", "BY", "CEIL", "CLEAR", "CLOSE_BRACE", "CLOSE_CURLY_BRACE", 
		"CLOSE_SQUARE_BRACKET", "COALESCE", "COLLECTION", "COMMA", "COMMENT", 
		"CONCAT", "CONSTRAIN", "CONSTRAINTS", "CONSTRUCT", "CONSTRUCT_QUADS", 
		"CONSTRUCT_TRIPLES", "CONSTRUCT_VIEW_DEFINITION", "CONTAINS", "COPY", 
		"COUNT", "CREATE", "DATA", "DATATYPE", "DAY", "DECIMAL", "DECIMAL_NEGATIVE", 
		"DECIMAL_POSITIVE", "DECLARE", "DEFAULT", "DEFINE", "DELETE", "DESC", 
		"DESCRIBE", "DIGIT", "DISTINCT", "DIVIDE", "DOT", "DOUBLE", "DOUBLE_NEGATIVE", 
		"DOUBLE_POSITIVE", "DROP", "ECHAR", "ENCODE_FOR_URI", "EOL", "EQUAL", 
		"EXISTS", "EXPONENT", "EXPRESSION_LIST", "FALSE", "FILTER", "FLOOR", "FROM", 
		"FULL_JOIN", "FUNCTION", "FUNCTION_DECLARATION", "FUNCTION_SIGNATURE", 
		"FUNCTION_TEMPLATE", "GRAPH", "GRAPH_TOKEN", "GREATER", "GREATER_EQUAL", 
		"GROUP", "GROUP_BY", "GROUP_CONCAT", "GROUP_GRAPH_PATTERN", "HAVING", 
		"HOURS", "IF", "IMPORT", "IN", "INSERT", "INTEGER", "INTEGER_NEGATIVE", 
		"INTEGER_POSITIVE", "INTO", "INVERSE", "IRI", "IRI_REF", "IRI_REF_CHARACTERS", 
		"ISBLANK", "ISIRI", "ISLITERAL", "ISNUMERIC", "ISURI", "JOIN_MEMBER", 
		"LANG", "LANGMATCHES", "LANGTAG", "LCASE", "LESS", "LESS_EQUAL", "LIMIT", 
		"LOAD", "MACRO_DEF", "MAX", "MD5", "MIN", "MINUS", "MINUS_KEYWORD", "MINUTES", 
		"MODIFY", "MONTH", "MOVE", "NAME", "NAMED", "NAMED_VIEW_TEMPLATE_DEFINITION", 
		"NAME_SUFFIX", "NEGATION", "NESTED_ML_COMMENT", "NOT", "NOT_EQUAL", "NOT_EXISTS", 
		"NOW", "OBJECT", "OFFSET", "OPEN_BRACE", "OPEN_CURLY_BRACE", "OPEN_SQUARE_BRACKET", 
		"OPTIONAL", "OR", "ORDER", "ORDER_BY", "ORDER_CONDITION", "PARAM_TYPE", 
		"PARAM_TYPE_LIST", "PATH", "PATH_NEGATED", "PATH_PRIMARY", "PIPE", "PLAIN_LITERAL", 
		"PLUS", "PNAME_LN", "PNAME_NS", "PN_CHARS", "PN_CHARS_BASE", "PN_CHARS_U", 
		"PN_LOCAL", "PN_PREFIX", "PREDICATE", "PREFIX", "PREFIX_CONSTRAINT", "PREFIX_DECL", 
		"PROLOGUE", "PROPERTY_LIST", "QUERY", "QUESTION_MARK", "RAND", "REDUCED", 
		"REFERENCE", "REGEX", "REGEX_CONSTRAINT", "RELATION_REF", "ROUND", "SAMETERM", 
		"SAMPLE", "SECONDS", "SELECT", "SELECT_CLAUSE", "SEMICOLON", "SEPARATOR", 
		"SERVICE", "SHA1", "SHA224", "SHA256", "SHA384", "SHA512", "SIGN", "SILENT", 
		"SINGLE_LINE_COMMENT", "SQL_QUERY", "SQL_RELATION", "SQL_TABLE", "STR", 
		"STRDT", "STRENDS", "STRING_LIST", "STRING_LITERAL1", "STRING_LITERAL2", 
		"STRING_LITERAL_LONG1", "STRING_LITERAL_LONG2", "STRLANG", "STRLEN", "STRSTARTS", 
		"SUBJECT", "SUBSELECT", "SUBSTR", "SUM", "TEMPLATE", "TIMEZONE", "TO", 
		"TODO", "TRIPLE", "TRIPLES_BLOCK", "TRIPLES_TEMPLATE", "TRUE", "TYPED_LITERAL", 
		"TZ", "UCASE", "UNARY", "UNARY_MINUS", "UNARY_NOT", "UNARY_PLUS", "UNDEF", 
		"UNION", "UPDATE", "URI", "USING", "VAR", "VAR1", "VAR2", "VAR3", "VARNAME", 
		"VAR_BINDING", "VAR_BINDINGS", "VAR_HEAD", "VIEW", "VIEW_DEFINITION", 
		"VIEW_TEMPLATE_DEFINITION", "WHERE", "WHERE_CLAUSE", "WITH", "WS", "YEAR"
	};
	public static final int EOF=-1;
	public static final int A=4;
	public static final int ABS=5;
	public static final int ADD=6;
	public static final int ALIASED_LOGICAL_TABLE=7;
	public static final int ALIASED_VAR=8;
	public static final int ALL=9;
	public static final int AND=10;
	public static final int ANY=11;
	public static final int ARG_LIST=12;
	public static final int AS=13;
	public static final int ASC=14;
	public static final int ASK=15;
	public static final int ASTERISK=16;
	public static final int AVG=17;
	public static final int BASE=18;
	public static final int BIND=19;
	public static final int BINDINGS=20;
	public static final int BINDING_VALUE=21;
	public static final int BLANK_NODE=22;
	public static final int BLANK_NODE_LABEL=23;
	public static final int BNODE=24;
	public static final int BOUND=25;
	public static final int BY=26;
	public static final int CEIL=27;
	public static final int CLEAR=28;
	public static final int CLOSE_BRACE=29;
	public static final int CLOSE_CURLY_BRACE=30;
	public static final int CLOSE_SQUARE_BRACKET=31;
	public static final int COALESCE=32;
	public static final int COLLECTION=33;
	public static final int COMMA=34;
	public static final int COMMENT=35;
	public static final int CONCAT=36;
	public static final int CONSTRAIN=37;
	public static final int CONSTRAINTS=38;
	public static final int CONSTRUCT=39;
	public static final int CONSTRUCT_QUADS=40;
	public static final int CONSTRUCT_TRIPLES=41;
	public static final int CONSTRUCT_VIEW_DEFINITION=42;
	public static final int CONTAINS=43;
	public static final int COPY=44;
	public static final int COUNT=45;
	public static final int CREATE=46;
	public static final int DATA=47;
	public static final int DATATYPE=48;
	public static final int DAY=49;
	public static final int DECIMAL=50;
	public static final int DECIMAL_NEGATIVE=51;
	public static final int DECIMAL_POSITIVE=52;
	public static final int DECLARE=53;
	public static final int DEFAULT=54;
	public static final int DEFINE=55;
	public static final int DELETE=56;
	public static final int DESC=57;
	public static final int DESCRIBE=58;
	public static final int DIGIT=59;
	public static final int DISTINCT=60;
	public static final int DIVIDE=61;
	public static final int DOT=62;
	public static final int DOUBLE=63;
	public static final int DOUBLE_NEGATIVE=64;
	public static final int DOUBLE_POSITIVE=65;
	public static final int DROP=66;
	public static final int ECHAR=67;
	public static final int ENCODE_FOR_URI=68;
	public static final int EOL=69;
	public static final int EQUAL=70;
	public static final int EXISTS=71;
	public static final int EXPONENT=72;
	public static final int EXPRESSION_LIST=73;
	public static final int FALSE=74;
	public static final int FILTER=75;
	public static final int FLOOR=76;
	public static final int FROM=77;
	public static final int FULL_JOIN=78;
	public static final int FUNCTION=79;
	public static final int FUNCTION_DECLARATION=80;
	public static final int FUNCTION_SIGNATURE=81;
	public static final int FUNCTION_TEMPLATE=82;
	public static final int GRAPH=83;
	public static final int GRAPH_TOKEN=84;
	public static final int GREATER=85;
	public static final int GREATER_EQUAL=86;
	public static final int GROUP=87;
	public static final int GROUP_BY=88;
	public static final int GROUP_CONCAT=89;
	public static final int GROUP_GRAPH_PATTERN=90;
	public static final int HAVING=91;
	public static final int HOURS=92;
	public static final int IF=93;
	public static final int IMPORT=94;
	public static final int IN=95;
	public static final int INSERT=96;
	public static final int INTEGER=97;
	public static final int INTEGER_NEGATIVE=98;
	public static final int INTEGER_POSITIVE=99;
	public static final int INTO=100;
	public static final int INVERSE=101;
	public static final int IRI=102;
	public static final int IRI_REF=103;
	public static final int IRI_REF_CHARACTERS=104;
	public static final int ISBLANK=105;
	public static final int ISIRI=106;
	public static final int ISLITERAL=107;
	public static final int ISNUMERIC=108;
	public static final int ISURI=109;
	public static final int JOIN_MEMBER=110;
	public static final int LANG=111;
	public static final int LANGMATCHES=112;
	public static final int LANGTAG=113;
	public static final int LCASE=114;
	public static final int LESS=115;
	public static final int LESS_EQUAL=116;
	public static final int LIMIT=117;
	public static final int LOAD=118;
	public static final int MACRO_DEF=119;
	public static final int MAX=120;
	public static final int MD5=121;
	public static final int MIN=122;
	public static final int MINUS=123;
	public static final int MINUS_KEYWORD=124;
	public static final int MINUTES=125;
	public static final int MODIFY=126;
	public static final int MONTH=127;
	public static final int MOVE=128;
	public static final int NAME=129;
	public static final int NAMED=130;
	public static final int NAMED_VIEW_TEMPLATE_DEFINITION=131;
	public static final int NAME_SUFFIX=132;
	public static final int NEGATION=133;
	public static final int NESTED_ML_COMMENT=134;
	public static final int NOT=135;
	public static final int NOT_EQUAL=136;
	public static final int NOT_EXISTS=137;
	public static final int NOW=138;
	public static final int OBJECT=139;
	public static final int OFFSET=140;
	public static final int OPEN_BRACE=141;
	public static final int OPEN_CURLY_BRACE=142;
	public static final int OPEN_SQUARE_BRACKET=143;
	public static final int OPTIONAL=144;
	public static final int OR=145;
	public static final int ORDER=146;
	public static final int ORDER_BY=147;
	public static final int ORDER_CONDITION=148;
	public static final int PARAM_TYPE=149;
	public static final int PARAM_TYPE_LIST=150;
	public static final int PATH=151;
	public static final int PATH_NEGATED=152;
	public static final int PATH_PRIMARY=153;
	public static final int PIPE=154;
	public static final int PLAIN_LITERAL=155;
	public static final int PLUS=156;
	public static final int PNAME_LN=157;
	public static final int PNAME_NS=158;
	public static final int PN_CHARS=159;
	public static final int PN_CHARS_BASE=160;
	public static final int PN_CHARS_U=161;
	public static final int PN_LOCAL=162;
	public static final int PN_PREFIX=163;
	public static final int PREDICATE=164;
	public static final int PREFIX=165;
	public static final int PREFIX_CONSTRAINT=166;
	public static final int PREFIX_DECL=167;
	public static final int PROLOGUE=168;
	public static final int PROPERTY_LIST=169;
	public static final int QUERY=170;
	public static final int QUESTION_MARK=171;
	public static final int RAND=172;
	public static final int REDUCED=173;
	public static final int REFERENCE=174;
	public static final int REGEX=175;
	public static final int REGEX_CONSTRAINT=176;
	public static final int RELATION_REF=177;
	public static final int ROUND=178;
	public static final int SAMETERM=179;
	public static final int SAMPLE=180;
	public static final int SECONDS=181;
	public static final int SELECT=182;
	public static final int SELECT_CLAUSE=183;
	public static final int SEMICOLON=184;
	public static final int SEPARATOR=185;
	public static final int SERVICE=186;
	public static final int SHA1=187;
	public static final int SHA224=188;
	public static final int SHA256=189;
	public static final int SHA384=190;
	public static final int SHA512=191;
	public static final int SIGN=192;
	public static final int SILENT=193;
	public static final int SINGLE_LINE_COMMENT=194;
	public static final int SQL_QUERY=195;
	public static final int SQL_RELATION=196;
	public static final int SQL_TABLE=197;
	public static final int STR=198;
	public static final int STRDT=199;
	public static final int STRENDS=200;
	public static final int STRING_LIST=201;
	public static final int STRING_LITERAL1=202;
	public static final int STRING_LITERAL2=203;
	public static final int STRING_LITERAL_LONG1=204;
	public static final int STRING_LITERAL_LONG2=205;
	public static final int STRLANG=206;
	public static final int STRLEN=207;
	public static final int STRSTARTS=208;
	public static final int SUBJECT=209;
	public static final int SUBSELECT=210;
	public static final int SUBSTR=211;
	public static final int SUM=212;
	public static final int TEMPLATE=213;
	public static final int TIMEZONE=214;
	public static final int TO=215;
	public static final int TODO=216;
	public static final int TRIPLE=217;
	public static final int TRIPLES_BLOCK=218;
	public static final int TRIPLES_TEMPLATE=219;
	public static final int TRUE=220;
	public static final int TYPED_LITERAL=221;
	public static final int TZ=222;
	public static final int UCASE=223;
	public static final int UNARY=224;
	public static final int UNARY_MINUS=225;
	public static final int UNARY_NOT=226;
	public static final int UNARY_PLUS=227;
	public static final int UNDEF=228;
	public static final int UNION=229;
	public static final int UPDATE=230;
	public static final int URI=231;
	public static final int USING=232;
	public static final int VAR=233;
	public static final int VAR1=234;
	public static final int VAR2=235;
	public static final int VAR3=236;
	public static final int VARNAME=237;
	public static final int VAR_BINDING=238;
	public static final int VAR_BINDINGS=239;
	public static final int VAR_HEAD=240;
	public static final int VIEW=241;
	public static final int VIEW_DEFINITION=242;
	public static final int VIEW_TEMPLATE_DEFINITION=243;
	public static final int WHERE=244;
	public static final int WHERE_CLAUSE=245;
	public static final int WITH=246;
	public static final int WS=247;
	public static final int YEAR=248;

	// delegates
	public TreeParser[] getDelegates() {
		return new TreeParser[] {};
	}

	// delegators


	public SparqlifyConfigTree(TreeNodeStream input) {
		this(input, new RecognizerSharedState());
	}
	public SparqlifyConfigTree(TreeNodeStream input, RecognizerSharedState state) {
		super(input, state);
	}

	@Override public String[] getTokenNames() { return SparqlifyConfigTree.tokenNames; }
	@Override public String getGrammarFileName() { return "org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g"; }


		private static final Logger logger = LoggerFactory.getLogger("Parser");



		PrefixMapping prefixMapping = new PrefixMappingImpl();
		
		public PrefixMapping getPrefixMapping() {
			return prefixMapping;
		}

		void registerPrefix(String prefix, String uri) {
			registerPrefix(prefixMapping, new PrefixDecl(prefix, uri));
		}

	/*
		void registerPrefix(Config config, String prefix, String uri) {
			registerPrefix(config.getPrefixMapping(), new PrefixDecl(prefix, uri));
		}

		void registerPrefix(TemplateConfig config, String prefix, String uri) {
			registerPrefix(config.getPrefixMapping(), new PrefixDecl(prefix, uri));
		}

		void registerPrefix(ConstructConfig config, String prefix, String uri) {
			registerPrefix(config.getPrefixMapping(), new PrefixDecl(prefix, uri));
		}
	*/
		
		void registerPrefix(PrefixMapping prefixMapping, PrefixDecl prefixDecl) {
		    // Warn if prefix gets re-registered
		    String uri = prefixMapping.getNsPrefixURI(prefixDecl.getPrefix());
		    
		    if(uri != null) {
				logger.warn("Prefix '" + prefixDecl.getPrefix() + "' remapped from <" + uri + "> to <" + prefixDecl.getUri() + ">");
		    }
		    
		    prefixMapping.setNsPrefix(prefixDecl.getPrefix(), prefixDecl.getUri());
		}


	    public String expandPrefix(String prefix) {
	    	String result = prefixMapping.getNsPrefixMap().get(prefix);

	        if(result == null) {
	            logger.error("Namespace for prefix '" + prefix + "' not declared");
	            result = "http://sparqlify.org/resource/unresolvedNamespace/";
	        }
	        
	        return result;
	    }
	    
	    
	    public String expandUri(String uri) {
	        int index = uri.indexOf(':');
	        if(index < 0) {
	            logger.error("Internal error: Expansion of '" + uri + "' requested although no symbol ':' found.");
	            return uri;
	        }
	        
	        String prefix = uri.substring(0, index);
	        String namespace = expandPrefix(prefix);

	        String result = namespace + uri.substring(index + 1);
	        
	        return result;
	    }

	    public String getErrorMessage(RecognitionException e,
	                                  String[] tokenNames)
	    {
	        List stack = getRuleInvocationStack(e, this.getClass().getName());
	        String msg = null;
	        String inputContext =
	            input.LT(-3) == null ? "" : ((Tree)input.LT(-3)).getText()+" "+
	            input.LT(-2) == null ? "" : ((Tree)input.LT(-2)).getText()+" "+
	            input.LT(-1) == null ? "" : ((Tree)input.LT(-1)).getText()+" >>>"+
	            ((Tree)input.LT(1)).getText()+"<<< "+
	            ((Tree)input.LT(2)).getText()+" "+
	            ((Tree)input.LT(3)).getText();
	        if ( e instanceof NoViableAltException ) {
	           NoViableAltException nvae = (NoViableAltException)e;
	           msg = " no viable alt; token="+e.token+
	              " (decision="+nvae.decisionNumber+
	              " state "+nvae.stateNumber+")"+
	              " decision=<<"+nvae.grammarDecisionDescription+">>";
	        }
	        else {
	           msg = super.getErrorMessage(e, tokenNames);
	        }
	        return stack+" "+msg+" context=..."+inputContext+"...";
	    }
	    public String getTokenErrorDisplay(Token t) {
	        return t.toString();
	    }

	/*
	    void addAsQuad(QuadPattern qp, Template template, Node g) {
	        if(g == null) {
	            g = Quad.defaultGraphNodeGenerated;
	        }
	        
	        for(Triple t : template.getTriples()) {
	            Quad quad = new Quad(g, t);
	            qp.add(quad);
	        }
	    }
	*/

	    public E_Function createUriFunction(ExprList args) {
	        Expr arg;
	       
	        if(args.size() == 1) {
				arg = args.get(0);
	        } else {
				arg = new E_StrConcatPermissive(args);
	        }

	        E_Function result = createFunction(SparqlifyConstants.uriLabel, arg);
	        return result; 
	    }


	    public E_Function createFunction(String label, Expr ... args) {
	        ExprList exprs = new ExprList();
	        for(Expr arg : args) {
	            if(arg != null) {
	                exprs.add(arg);
	            }
	        }
	        
	        return new E_Function(label, exprs);        
	    }




	// $ANTLR start "templateConfig"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:205:1: templateConfig returns [TemplateConfig config] : ( templateConfigItem[config] )+ ;
	public final TemplateConfig templateConfig() throws RecognitionException {
		TemplateConfig config = null;


		 config = new TemplateConfig(); prefixMapping = config.getPrefixMapping(); 
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:207:2: ( ( templateConfigItem[config] )+ )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:207:4: ( templateConfigItem[config] )+
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:207:4: ( templateConfigItem[config] )+
			int cnt1=0;
			loop1:
			while (true) {
				int alt1=2;
				int LA1_0 = input.LA(1);
				if ( (LA1_0==NAMED_VIEW_TEMPLATE_DEFINITION||LA1_0==PREFIX) ) {
					alt1=1;
				}

				switch (alt1) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:207:4: templateConfigItem[config]
					{
					pushFollow(FOLLOW_templateConfigItem_in_templateConfig60);
					templateConfigItem(config);
					state._fsp--;

					}
					break;

				default :
					if ( cnt1 >= 1 ) break loop1;
					EarlyExitException eee = new EarlyExitException(1, input);
					throw eee;
				}
				cnt1++;
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return config;
	}
	// $ANTLR end "templateConfig"



	// $ANTLR start "templateConfigItem"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:210:1: templateConfigItem[TemplateConfig config] : (x= namedViewTemplateDefinition |a= prefixDecl );
	public final void templateConfigItem(TemplateConfig config) throws RecognitionException {
		NamedViewTemplateDefinition x =null;
		TreeRuleReturnScope a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:211:2: (x= namedViewTemplateDefinition |a= prefixDecl )
			int alt2=2;
			int LA2_0 = input.LA(1);
			if ( (LA2_0==NAMED_VIEW_TEMPLATE_DEFINITION) ) {
				alt2=1;
			}
			else if ( (LA2_0==PREFIX) ) {
				alt2=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 2, 0, input);
				throw nvae;
			}

			switch (alt2) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:211:4: x= namedViewTemplateDefinition
					{
					pushFollow(FOLLOW_namedViewTemplateDefinition_in_templateConfigItem76);
					x=namedViewTemplateDefinition();
					state._fsp--;

					 config.getDefinitions().add(x); 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:212:4: a= prefixDecl
					{
					pushFollow(FOLLOW_prefixDecl_in_templateConfigItem85);
					a=prefixDecl();
					state._fsp--;

					 registerPrefix((a!=null?((SparqlifyConfigTree.prefixDecl_return)a).prefix:null), (a!=null?((SparqlifyConfigTree.prefixDecl_return)a).uri:null)); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "templateConfigItem"



	// $ANTLR start "constructConfig"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:216:1: constructConfig returns [ConstructConfig config] : ( constructConfigItem[config] )+ ;
	public final ConstructConfig constructConfig() throws RecognitionException {
		ConstructConfig config = null;


		 config = new ConstructConfig(); prefixMapping = config.getPrefixMapping(); 
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:218:2: ( ( constructConfigItem[config] )+ )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:218:4: ( constructConfigItem[config] )+
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:218:4: ( constructConfigItem[config] )+
			int cnt3=0;
			loop3:
			while (true) {
				int alt3=2;
				int LA3_0 = input.LA(1);
				if ( (LA3_0==CONSTRUCT_VIEW_DEFINITION||LA3_0==PREFIX) ) {
					alt3=1;
				}

				switch (alt3) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:218:4: constructConfigItem[config]
					{
					pushFollow(FOLLOW_constructConfigItem_in_constructConfig108);
					constructConfigItem(config);
					state._fsp--;

					}
					break;

				default :
					if ( cnt3 >= 1 ) break loop3;
					EarlyExitException eee = new EarlyExitException(3, input);
					throw eee;
				}
				cnt3++;
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return config;
	}
	// $ANTLR end "constructConfig"



	// $ANTLR start "constructConfigItem"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:221:1: constructConfigItem[ConstructConfig config] : (x= constructViewDefinition[config] |a= prefixDecl );
	public final void constructConfigItem(ConstructConfig config) throws RecognitionException {
		ConstructViewDefinition x =null;
		TreeRuleReturnScope a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:222:2: (x= constructViewDefinition[config] |a= prefixDecl )
			int alt4=2;
			int LA4_0 = input.LA(1);
			if ( (LA4_0==CONSTRUCT_VIEW_DEFINITION) ) {
				alt4=1;
			}
			else if ( (LA4_0==PREFIX) ) {
				alt4=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 4, 0, input);
				throw nvae;
			}

			switch (alt4) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:222:4: x= constructViewDefinition[config]
					{
					pushFollow(FOLLOW_constructViewDefinition_in_constructConfigItem124);
					x=constructViewDefinition(config);
					state._fsp--;

					 config.getViewDefinitions().add(x); 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:223:4: a= prefixDecl
					{
					pushFollow(FOLLOW_prefixDecl_in_constructConfigItem134);
					a=prefixDecl();
					state._fsp--;

					 registerPrefix((a!=null?((SparqlifyConfigTree.prefixDecl_return)a).prefix:null), (a!=null?((SparqlifyConfigTree.prefixDecl_return)a).uri:null)); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "constructConfigItem"



	// $ANTLR start "constructViewDefinition"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:226:1: constructViewDefinition[ConstructConfig config] returns [ ConstructViewDefinition value ] : ^( CONSTRUCT_VIEW_DEFINITION a= NAME b= SQL_QUERY ) ;
	public final ConstructViewDefinition constructViewDefinition(ConstructConfig config) throws RecognitionException {
		ConstructViewDefinition value = null;


		CommonTree a=null;
		CommonTree b=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:227:2: ( ^( CONSTRUCT_VIEW_DEFINITION a= NAME b= SQL_QUERY ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:227:4: ^( CONSTRUCT_VIEW_DEFINITION a= NAME b= SQL_QUERY )
			{
			match(input,CONSTRUCT_VIEW_DEFINITION,FOLLOW_CONSTRUCT_VIEW_DEFINITION_in_constructViewDefinition153); 
			match(input, Token.DOWN, null); 
			a=(CommonTree)match(input,NAME,FOLLOW_NAME_in_constructViewDefinition157); 
			b=(CommonTree)match(input,SQL_QUERY,FOLLOW_SQL_QUERY_in_constructViewDefinition161); 
			match(input, Token.UP, null); 

			 value = new ConstructViewDefinition((a!=null?a.getText():null), (b!=null?b.getText():null), prefixMapping); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "constructViewDefinition"



	// $ANTLR start "sparqlifyConfig"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:233:1: sparqlifyConfig returns [Config config] : ( sparqlifyConfigItem[config] )+ ;
	public final Config sparqlifyConfig() throws RecognitionException {
		Config config = null;


		 config = new Config(); prefixMapping = config.getPrefixMapping(); 
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:235:2: ( ( sparqlifyConfigItem[config] )+ )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:235:4: ( sparqlifyConfigItem[config] )+
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:235:4: ( sparqlifyConfigItem[config] )+
			int cnt5=0;
			loop5:
			while (true) {
				int alt5=2;
				int LA5_0 = input.LA(1);
				if ( (LA5_0==FUNCTION_DECLARATION||LA5_0==PREFIX||LA5_0==VIEW_DEFINITION) ) {
					alt5=1;
				}

				switch (alt5) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:235:4: sparqlifyConfigItem[config]
					{
					pushFollow(FOLLOW_sparqlifyConfigItem_in_sparqlifyConfig187);
					sparqlifyConfigItem(config);
					state._fsp--;

					}
					break;

				default :
					if ( cnt5 >= 1 ) break loop5;
					EarlyExitException eee = new EarlyExitException(5, input);
					throw eee;
				}
				cnt5++;
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return config;
	}
	// $ANTLR end "sparqlifyConfig"



	// $ANTLR start "sparqlifyConfigItem"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:238:1: sparqlifyConfigItem[Config config] : (x= viewDefinition |a= prefixDecl |b= functionDeclaration );
	public final void sparqlifyConfigItem(Config config) throws RecognitionException {
		ViewDefinition x =null;
		TreeRuleReturnScope a =null;
		FunctionDeclarationTemplate b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:239:2: (x= viewDefinition |a= prefixDecl |b= functionDeclaration )
			int alt6=3;
			switch ( input.LA(1) ) {
			case VIEW_DEFINITION:
				{
				alt6=1;
				}
				break;
			case PREFIX:
				{
				alt6=2;
				}
				break;
			case FUNCTION_DECLARATION:
				{
				alt6=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 6, 0, input);
				throw nvae;
			}
			switch (alt6) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:239:4: x= viewDefinition
					{
					pushFollow(FOLLOW_viewDefinition_in_sparqlifyConfigItem204);
					x=viewDefinition();
					state._fsp--;

					config.getViewDefinitions().add(x);
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:240:4: a= prefixDecl
					{
					pushFollow(FOLLOW_prefixDecl_in_sparqlifyConfigItem218);
					a=prefixDecl();
					state._fsp--;

					registerPrefix((a!=null?((SparqlifyConfigTree.prefixDecl_return)a).prefix:null), (a!=null?((SparqlifyConfigTree.prefixDecl_return)a).uri:null));
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:241:4: b= functionDeclaration
					{
					pushFollow(FOLLOW_functionDeclaration_in_sparqlifyConfigItem236);
					b=functionDeclaration();
					state._fsp--;

					config.getFunctionDeclarations().add(b);
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "sparqlifyConfigItem"



	// $ANTLR start "functionDeclaration"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:246:1: functionDeclaration returns [FunctionDeclarationTemplate value] : ^( FUNCTION_DECLARATION a= functionSignature b= functionTemplate ) ;
	public final FunctionDeclarationTemplate functionDeclaration() throws RecognitionException {
		FunctionDeclarationTemplate value = null;


		FunctionSignature a =null;
		FunctionTemplate b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:247:5: ( ^( FUNCTION_DECLARATION a= functionSignature b= functionTemplate ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:247:7: ^( FUNCTION_DECLARATION a= functionSignature b= functionTemplate )
			{
			match(input,FUNCTION_DECLARATION,FOLLOW_FUNCTION_DECLARATION_in_functionDeclaration259); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_functionSignature_in_functionDeclaration263);
			a=functionSignature();
			state._fsp--;

			pushFollow(FOLLOW_functionTemplate_in_functionDeclaration267);
			b=functionTemplate();
			state._fsp--;

			match(input, Token.UP, null); 

			value = new FunctionDeclarationTemplate(a, b);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "functionDeclaration"



	// $ANTLR start "functionSignature"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:250:1: functionSignature returns [FunctionSignature value] : ^( FUNCTION_SIGNATURE a= NAME b= iriRef c= paramTypeList ) ;
	public final FunctionSignature functionSignature() throws RecognitionException {
		FunctionSignature value = null;


		CommonTree a=null;
		Node b =null;
		ParamTypeList c =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:251:5: ( ^( FUNCTION_SIGNATURE a= NAME b= iriRef c= paramTypeList ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:251:7: ^( FUNCTION_SIGNATURE a= NAME b= iriRef c= paramTypeList )
			{
			match(input,FUNCTION_SIGNATURE,FOLLOW_FUNCTION_SIGNATURE_in_functionSignature292); 
			match(input, Token.DOWN, null); 
			a=(CommonTree)match(input,NAME,FOLLOW_NAME_in_functionSignature296); 
			pushFollow(FOLLOW_iriRef_in_functionSignature300);
			b=iriRef();
			state._fsp--;

			pushFollow(FOLLOW_paramTypeList_in_functionSignature304);
			c=paramTypeList();
			state._fsp--;

			match(input, Token.UP, null); 

			value = new FunctionSignature(b.toString(), (a!=null?a.getText():null), c);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "functionSignature"



	// $ANTLR start "paramTypeList"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:254:1: paramTypeList returns [ParamTypeList value] : ( ^( PARAM_TYPE_LIST (a= paramType )+ ) | ^( PARAM_TYPE_LIST nil ) );
	public final ParamTypeList paramTypeList() throws RecognitionException {
		ParamTypeList value = null;


		ParamType a =null;

		 value = new ParamTypeList(); 
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:256:5: ( ^( PARAM_TYPE_LIST (a= paramType )+ ) | ^( PARAM_TYPE_LIST nil ) )
			int alt8=2;
			int LA8_0 = input.LA(1);
			if ( (LA8_0==PARAM_TYPE_LIST) ) {
				int LA8_1 = input.LA(2);
				if ( (LA8_1==DOWN) ) {
					int LA8_2 = input.LA(3);
					if ( (LA8_2==PARAM_TYPE) ) {
						alt8=1;
					}
					else if ( (LA8_2==OPEN_BRACE) ) {
						alt8=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 8, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 8, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 8, 0, input);
				throw nvae;
			}

			switch (alt8) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:256:7: ^( PARAM_TYPE_LIST (a= paramType )+ )
					{
					match(input,PARAM_TYPE_LIST,FOLLOW_PARAM_TYPE_LIST_in_paramTypeList335); 
					match(input, Token.DOWN, null); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:256:25: (a= paramType )+
					int cnt7=0;
					loop7:
					while (true) {
						int alt7=2;
						int LA7_0 = input.LA(1);
						if ( (LA7_0==PARAM_TYPE) ) {
							alt7=1;
						}

						switch (alt7) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:256:26: a= paramType
							{
							pushFollow(FOLLOW_paramType_in_paramTypeList340);
							a=paramType();
							state._fsp--;

							value.add(a);
							}
							break;

						default :
							if ( cnt7 >= 1 ) break loop7;
							EarlyExitException eee = new EarlyExitException(7, input);
							throw eee;
						}
						cnt7++;
					}

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:257:7: ^( PARAM_TYPE_LIST nil )
					{
					match(input,PARAM_TYPE_LIST,FOLLOW_PARAM_TYPE_LIST_in_paramTypeList354); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_nil_in_paramTypeList356);
					nil();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "paramTypeList"



	// $ANTLR start "paramType"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:261:1: paramType returns [ParamType value] : ^( PARAM_TYPE a= NAME b= var ) ;
	public final ParamType paramType() throws RecognitionException {
		ParamType value = null;


		CommonTree a=null;
		Var b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:262:5: ( ^( PARAM_TYPE a= NAME b= var ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:262:7: ^( PARAM_TYPE a= NAME b= var )
			{
			match(input,PARAM_TYPE,FOLLOW_PARAM_TYPE_in_paramType381); 
			match(input, Token.DOWN, null); 
			a=(CommonTree)match(input,NAME,FOLLOW_NAME_in_paramType385); 
			pushFollow(FOLLOW_var_in_paramType389);
			b=var();
			state._fsp--;

			match(input, Token.UP, null); 

			value = new ParamType((a!=null?a.getText():null), b);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "paramType"



	// $ANTLR start "functionTemplate"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:266:1: functionTemplate returns [FunctionTemplate value] : ^( FUNCTION_TEMPLATE a= NAME b= expressionList ) ;
	public final FunctionTemplate functionTemplate() throws RecognitionException {
		FunctionTemplate value = null;


		CommonTree a=null;
		ExprList b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:267:5: ( ^( FUNCTION_TEMPLATE a= NAME b= expressionList ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:267:7: ^( FUNCTION_TEMPLATE a= NAME b= expressionList )
			{
			match(input,FUNCTION_TEMPLATE,FOLLOW_FUNCTION_TEMPLATE_in_functionTemplate415); 
			match(input, Token.DOWN, null); 
			a=(CommonTree)match(input,NAME,FOLLOW_NAME_in_functionTemplate419); 
			pushFollow(FOLLOW_expressionList_in_functionTemplate423);
			b=expressionList();
			state._fsp--;

			match(input, Token.UP, null); 

			value = new FunctionTemplate((a!=null?a.getText():null), b);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "functionTemplate"



	// $ANTLR start "namedViewTemplateDefinition"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:273:1: namedViewTemplateDefinition returns [NamedViewTemplateDefinition value] : ^( NAMED_VIEW_TEMPLATE_DEFINITION a= NAME b= viewTemplateDefinition ) ;
	public final NamedViewTemplateDefinition namedViewTemplateDefinition() throws RecognitionException {
		NamedViewTemplateDefinition value = null;


		CommonTree a=null;
		ViewTemplateDefinition b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:274:2: ( ^( NAMED_VIEW_TEMPLATE_DEFINITION a= NAME b= viewTemplateDefinition ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:274:4: ^( NAMED_VIEW_TEMPLATE_DEFINITION a= NAME b= viewTemplateDefinition )
			{
			match(input,NAMED_VIEW_TEMPLATE_DEFINITION,FOLLOW_NAMED_VIEW_TEMPLATE_DEFINITION_in_namedViewTemplateDefinition448); 
			match(input, Token.DOWN, null); 
			a=(CommonTree)match(input,NAME,FOLLOW_NAME_in_namedViewTemplateDefinition452); 
			pushFollow(FOLLOW_viewTemplateDefinition_in_namedViewTemplateDefinition456);
			b=viewTemplateDefinition();
			state._fsp--;

			match(input, Token.UP, null); 

			value = new NamedViewTemplateDefinition((a!=null?a.getText():null), b);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "namedViewTemplateDefinition"



	// $ANTLR start "viewTemplateDefinition"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:277:1: viewTemplateDefinition returns [ViewTemplateDefinition value] : ^( VIEW_TEMPLATE_DEFINITION a= constructTemplateQuads (b= varBindings )? ) ;
	public final ViewTemplateDefinition viewTemplateDefinition() throws RecognitionException {
		ViewTemplateDefinition value = null;


		QuadPattern a =null;
		List<Expr> b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:278:2: ( ^( VIEW_TEMPLATE_DEFINITION a= constructTemplateQuads (b= varBindings )? ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:278:4: ^( VIEW_TEMPLATE_DEFINITION a= constructTemplateQuads (b= varBindings )? )
			{
			match(input,VIEW_TEMPLATE_DEFINITION,FOLLOW_VIEW_TEMPLATE_DEFINITION_in_viewTemplateDefinition476); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_constructTemplateQuads_in_viewTemplateDefinition480);
			a=constructTemplateQuads();
			state._fsp--;

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:278:57: (b= varBindings )?
			int alt9=2;
			int LA9_0 = input.LA(1);
			if ( (LA9_0==VAR_BINDINGS) ) {
				alt9=1;
			}
			switch (alt9) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:278:57: b= varBindings
					{
					pushFollow(FOLLOW_varBindings_in_viewTemplateDefinition484);
					b=varBindings();
					state._fsp--;

					}
					break;

			}

			match(input, Token.UP, null); 

			value = new ViewTemplateDefinition(a, b);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "viewTemplateDefinition"



	// $ANTLR start "viewDefinition"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:281:1: viewDefinition returns [ ViewDefinition value ] : ^( VIEW_DEFINITION a= NAME b= viewTemplateDefinition (d= varConstraints )? (c= sqlRelation )? ) ;
	public final ViewDefinition viewDefinition() throws RecognitionException {
		ViewDefinition value = null;


		CommonTree a=null;
		ViewTemplateDefinition b =null;
		List<Constraint> d =null;
		SqlOp c =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:282:2: ( ^( VIEW_DEFINITION a= NAME b= viewTemplateDefinition (d= varConstraints )? (c= sqlRelation )? ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:282:4: ^( VIEW_DEFINITION a= NAME b= viewTemplateDefinition (d= varConstraints )? (c= sqlRelation )? )
			{
			match(input,VIEW_DEFINITION,FOLLOW_VIEW_DEFINITION_in_viewDefinition504); 
			match(input, Token.DOWN, null); 
			a=(CommonTree)match(input,NAME,FOLLOW_NAME_in_viewDefinition508); 
			pushFollow(FOLLOW_viewTemplateDefinition_in_viewDefinition512);
			b=viewTemplateDefinition();
			state._fsp--;

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:282:55: (d= varConstraints )?
			int alt10=2;
			int LA10_0 = input.LA(1);
			if ( (LA10_0==CONSTRAINTS) ) {
				alt10=1;
			}
			switch (alt10) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:282:55: d= varConstraints
					{
					pushFollow(FOLLOW_varConstraints_in_viewDefinition516);
					d=varConstraints();
					state._fsp--;

					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:282:73: (c= sqlRelation )?
			int alt11=2;
			int LA11_0 = input.LA(1);
			if ( (LA11_0==RELATION_REF) ) {
				alt11=1;
			}
			switch (alt11) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:282:73: c= sqlRelation
					{
					pushFollow(FOLLOW_sqlRelation_in_viewDefinition521);
					c=sqlRelation();
					state._fsp--;

					}
					break;

			}

			match(input, Token.UP, null); 

			 value = new ViewDefinition((a!=null?a.getText():null), b, c, d); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "viewDefinition"



	// $ANTLR start "varBindings"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:285:1: varBindings returns [List<Expr> value] : ^( VAR_BINDINGS (a= varBinding )+ ) ;
	public final List<Expr> varBindings() throws RecognitionException {
		List<Expr> value = null;


		Expr a =null;

		value = new ArrayList<Expr>();
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:287:2: ( ^( VAR_BINDINGS (a= varBinding )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:287:4: ^( VAR_BINDINGS (a= varBinding )+ )
			{
			match(input,VAR_BINDINGS,FOLLOW_VAR_BINDINGS_in_varBindings548); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:287:19: (a= varBinding )+
			int cnt12=0;
			loop12:
			while (true) {
				int alt12=2;
				int LA12_0 = input.LA(1);
				if ( (LA12_0==VAR_BINDING) ) {
					alt12=1;
				}

				switch (alt12) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:287:20: a= varBinding
					{
					pushFollow(FOLLOW_varBinding_in_varBindings553);
					a=varBinding();
					state._fsp--;

					value.add(a);
					}
					break;

				default :
					if ( cnt12 >= 1 ) break loop12;
					EarlyExitException eee = new EarlyExitException(12, input);
					throw eee;
				}
				cnt12++;
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "varBindings"



	// $ANTLR start "varBinding"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:291:1: varBinding returns [Expr value] : ^( VAR_BINDING a= var b= typeCtorExpression ) ;
	public final Expr varBinding() throws RecognitionException {
		Expr value = null;


		Var a =null;
		Expr b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:292:2: ( ^( VAR_BINDING a= var b= typeCtorExpression ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:292:4: ^( VAR_BINDING a= var b= typeCtorExpression )
			{
			match(input,VAR_BINDING,FOLLOW_VAR_BINDING_in_varBinding576); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_var_in_varBinding580);
			a=var();
			state._fsp--;

			pushFollow(FOLLOW_typeCtorExpression_in_varBinding584);
			b=typeCtorExpression();
			state._fsp--;

			match(input, Token.UP, null); 

			value = new E_Equals(new ExprVar(a), b);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "varBinding"



	// $ANTLR start "typeCtorExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:295:1: typeCtorExpression returns [Expr value] : ( ^( BNODE a= expression ) | ^( URI c= expressionList ) | ^( PLAIN_LITERAL a= expression (b= expression )? ) | ^( TYPED_LITERAL a= expression b= expression ) );
	public final Expr typeCtorExpression() throws RecognitionException {
		Expr value = null;


		Expr a =null;
		ExprList c =null;
		Expr b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:296:5: ( ^( BNODE a= expression ) | ^( URI c= expressionList ) | ^( PLAIN_LITERAL a= expression (b= expression )? ) | ^( TYPED_LITERAL a= expression b= expression ) )
			int alt14=4;
			switch ( input.LA(1) ) {
			case BNODE:
				{
				alt14=1;
				}
				break;
			case URI:
				{
				alt14=2;
				}
				break;
			case PLAIN_LITERAL:
				{
				alt14=3;
				}
				break;
			case TYPED_LITERAL:
				{
				alt14=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 14, 0, input);
				throw nvae;
			}
			switch (alt14) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:296:7: ^( BNODE a= expression )
					{
					match(input,BNODE,FOLLOW_BNODE_in_typeCtorExpression607); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_typeCtorExpression611);
					a=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					value = createFunction(SparqlifyConstants.blankNodeLabel, a); 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:297:7: ^( URI c= expressionList )
					{
					match(input,URI,FOLLOW_URI_in_typeCtorExpression624); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expressionList_in_typeCtorExpression628);
					c=expressionList();
					state._fsp--;

					match(input, Token.UP, null); 

					value = createUriFunction(c); 
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:298:7: ^( PLAIN_LITERAL a= expression (b= expression )? )
					{
					match(input,PLAIN_LITERAL,FOLLOW_PLAIN_LITERAL_in_typeCtorExpression640); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_typeCtorExpression644);
					a=expression();
					state._fsp--;

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:298:37: (b= expression )?
					int alt13=2;
					int LA13_0 = input.LA(1);
					if ( (LA13_0==AND||LA13_0==ASTERISK||LA13_0==DIVIDE||LA13_0==EQUAL||(LA13_0 >= GREATER && LA13_0 <= GREATER_EQUAL)||LA13_0==IN||(LA13_0 >= LESS && LA13_0 <= LESS_EQUAL)||LA13_0==MINUS||(LA13_0 >= NOT && LA13_0 <= NOT_EQUAL)||LA13_0==OR||LA13_0==PLUS||(LA13_0 >= UNARY && LA13_0 <= UNARY_PLUS)) ) {
						alt13=1;
					}
					switch (alt13) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:298:37: b= expression
							{
							pushFollow(FOLLOW_expression_in_typeCtorExpression648);
							b=expression();
							state._fsp--;

							}
							break;

					}

					match(input, Token.UP, null); 

					value = createFunction(SparqlifyConstants.plainLiteralLabel, a, b); 
					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:299:7: ^( TYPED_LITERAL a= expression b= expression )
					{
					match(input,TYPED_LITERAL,FOLLOW_TYPED_LITERAL_in_typeCtorExpression661); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_typeCtorExpression665);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_typeCtorExpression669);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					value = createFunction(SparqlifyConstants.typedLiteralLabel, a, b); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "typeCtorExpression"



	// $ANTLR start "sqlRelationOld"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:302:1: sqlRelationOld returns [Relation value] : ( ^( SQL_RELATION a= SQL_QUERY ) | ^( SQL_RELATION a= SQL_TABLE ) );
	public final Relation sqlRelationOld() throws RecognitionException {
		Relation value = null;


		CommonTree a=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:303:2: ( ^( SQL_RELATION a= SQL_QUERY ) | ^( SQL_RELATION a= SQL_TABLE ) )
			int alt15=2;
			int LA15_0 = input.LA(1);
			if ( (LA15_0==SQL_RELATION) ) {
				int LA15_1 = input.LA(2);
				if ( (LA15_1==DOWN) ) {
					int LA15_2 = input.LA(3);
					if ( (LA15_2==SQL_QUERY) ) {
						alt15=1;
					}
					else if ( (LA15_2==SQL_TABLE) ) {
						alt15=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 15, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 15, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 15, 0, input);
				throw nvae;
			}

			switch (alt15) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:303:4: ^( SQL_RELATION a= SQL_QUERY )
					{
					match(input,SQL_RELATION,FOLLOW_SQL_RELATION_in_sqlRelationOld692); 
					match(input, Token.DOWN, null); 
					a=(CommonTree)match(input,SQL_QUERY,FOLLOW_SQL_QUERY_in_sqlRelationOld696); 
					match(input, Token.UP, null); 

					value = new QueryString((a!=null?a.getText():null));
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:304:4: ^( SQL_RELATION a= SQL_TABLE )
					{
					match(input,SQL_RELATION,FOLLOW_SQL_RELATION_in_sqlRelationOld705); 
					match(input, Token.DOWN, null); 
					a=(CommonTree)match(input,SQL_TABLE,FOLLOW_SQL_TABLE_in_sqlRelationOld709); 
					match(input, Token.UP, null); 

					value = new RelationRef((a!=null?a.getText():null));
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "sqlRelationOld"



	// $ANTLR start "sqlRelation"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:309:1: sqlRelation returns [SqlOp value] : ^( RELATION_REF a= joinClause (b= expression )? ) ;
	public final SqlOp sqlRelation() throws RecognitionException {
		SqlOp value = null;


		SqlOp a =null;
		Expr b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:310:5: ( ^( RELATION_REF a= joinClause (b= expression )? ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:310:7: ^( RELATION_REF a= joinClause (b= expression )? )
			{
			match(input,RELATION_REF,FOLLOW_RELATION_REF_in_sqlRelation733); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_joinClause_in_sqlRelation737);
			a=joinClause();
			state._fsp--;

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:310:36: (b= expression )?
			int alt16=2;
			int LA16_0 = input.LA(1);
			if ( (LA16_0==AND||LA16_0==ASTERISK||LA16_0==DIVIDE||LA16_0==EQUAL||(LA16_0 >= GREATER && LA16_0 <= GREATER_EQUAL)||LA16_0==IN||(LA16_0 >= LESS && LA16_0 <= LESS_EQUAL)||LA16_0==MINUS||(LA16_0 >= NOT && LA16_0 <= NOT_EQUAL)||LA16_0==OR||LA16_0==PLUS||(LA16_0 >= UNARY && LA16_0 <= UNARY_PLUS)) ) {
				alt16=1;
			}
			switch (alt16) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:310:36: b= expression
					{
					pushFollow(FOLLOW_expression_in_sqlRelation741);
					b=expression();
					state._fsp--;

					}
					break;

			}

			match(input, Token.UP, null); 

			value =(b == null) ? a : new SqlOpFilterExpr(null, a, b);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "sqlRelation"



	// $ANTLR start "joinClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:313:1: joinClause returns [SqlOp value] : (a= joinClauseMember | ^( FULL_JOIN a= joinClauseMember b= joinClauseMember ) );
	public final SqlOp joinClause() throws RecognitionException {
		SqlOp value = null;


		SqlOp a =null;
		SqlOp b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:314:5: (a= joinClauseMember | ^( FULL_JOIN a= joinClauseMember b= joinClauseMember ) )
			int alt17=2;
			int LA17_0 = input.LA(1);
			if ( (LA17_0==JOIN_MEMBER) ) {
				alt17=1;
			}
			else if ( (LA17_0==FULL_JOIN) ) {
				alt17=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 17, 0, input);
				throw nvae;
			}

			switch (alt17) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:314:7: a= joinClauseMember
					{
					pushFollow(FOLLOW_joinClauseMember_in_joinClause768);
					a=joinClauseMember();
					state._fsp--;

					value =a;
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:315:7: ^( FULL_JOIN a= joinClauseMember b= joinClauseMember )
					{
					match(input,FULL_JOIN,FOLLOW_FULL_JOIN_in_joinClause779); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_joinClauseMember_in_joinClause783);
					a=joinClauseMember();
					state._fsp--;

					pushFollow(FOLLOW_joinClauseMember_in_joinClause787);
					b=joinClauseMember();
					state._fsp--;

					match(input, Token.UP, null); 

					value =new SqlOpJoin(null, JoinType.INNER, a, b);
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "joinClause"



	// $ANTLR start "joinClauseMember"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:318:1: joinClauseMember returns [SqlOp value] : ^( JOIN_MEMBER a= sqlLogicalTable (b= NAME )? ) ;
	public final SqlOp joinClauseMember() throws RecognitionException {
		SqlOp value = null;


		CommonTree b=null;
		SqlOp a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:319:5: ( ^( JOIN_MEMBER a= sqlLogicalTable (b= NAME )? ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:319:7: ^( JOIN_MEMBER a= sqlLogicalTable (b= NAME )? )
			{
			match(input,JOIN_MEMBER,FOLLOW_JOIN_MEMBER_in_joinClauseMember817); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_sqlLogicalTable_in_joinClauseMember821);
			a=sqlLogicalTable();
			state._fsp--;

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:319:40: (b= NAME )?
			int alt18=2;
			int LA18_0 = input.LA(1);
			if ( (LA18_0==NAME) ) {
				alt18=1;
			}
			switch (alt18) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:319:40: b= NAME
					{
					b=(CommonTree)match(input,NAME,FOLLOW_NAME_in_joinClauseMember825); 
					}
					break;

			}

			match(input, Token.UP, null); 

			value = a; ((SqlOpLeaf)value).setAliasName((b!=null?b.getText():null));
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "joinClauseMember"



	// $ANTLR start "sqlLogicalTable"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:322:1: sqlLogicalTable returns [SqlOp value] : ( ^( SQL_RELATION a= SQL_QUERY ) | ^( SQL_RELATION a= SQL_TABLE ) );
	public final SqlOp sqlLogicalTable() throws RecognitionException {
		SqlOp value = null;


		CommonTree a=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:323:2: ( ^( SQL_RELATION a= SQL_QUERY ) | ^( SQL_RELATION a= SQL_TABLE ) )
			int alt19=2;
			int LA19_0 = input.LA(1);
			if ( (LA19_0==SQL_RELATION) ) {
				int LA19_1 = input.LA(2);
				if ( (LA19_1==DOWN) ) {
					int LA19_2 = input.LA(3);
					if ( (LA19_2==SQL_QUERY) ) {
						alt19=1;
					}
					else if ( (LA19_2==SQL_TABLE) ) {
						alt19=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 19, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 19, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 19, 0, input);
				throw nvae;
			}

			switch (alt19) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:323:4: ^( SQL_RELATION a= SQL_QUERY )
					{
					match(input,SQL_RELATION,FOLLOW_SQL_RELATION_in_sqlLogicalTable848); 
					match(input, Token.DOWN, null); 
					a=(CommonTree)match(input,SQL_QUERY,FOLLOW_SQL_QUERY_in_sqlLogicalTable852); 
					match(input, Token.UP, null); 

					value = new SqlOpQuery(null, (a!=null?a.getText():null));
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:324:4: ^( SQL_RELATION a= SQL_TABLE )
					{
					match(input,SQL_RELATION,FOLLOW_SQL_RELATION_in_sqlLogicalTable861); 
					match(input, Token.DOWN, null); 
					a=(CommonTree)match(input,SQL_TABLE,FOLLOW_SQL_TABLE_in_sqlLogicalTable865); 
					match(input, Token.UP, null); 

					value = new SqlOpTable(null, (a!=null?a.getText():null));
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "sqlLogicalTable"



	// $ANTLR start "varConstraints"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:328:1: varConstraints returns [List<Constraint> value] : ^( CONSTRAINTS (a= varConstraint )+ ) ;
	public final List<Constraint> varConstraints() throws RecognitionException {
		List<Constraint> value = null;


		Constraint a =null;

		value = new ArrayList<Constraint>();
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:330:5: ( ^( CONSTRAINTS (a= varConstraint )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:330:7: ^( CONSTRAINTS (a= varConstraint )+ )
			{
			match(input,CONSTRAINTS,FOLLOW_CONSTRAINTS_in_varConstraints894); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:330:21: (a= varConstraint )+
			int cnt20=0;
			loop20:
			while (true) {
				int alt20=2;
				int LA20_0 = input.LA(1);
				if ( (LA20_0==PREFIX_CONSTRAINT||LA20_0==REGEX_CONSTRAINT) ) {
					alt20=1;
				}

				switch (alt20) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:330:22: a= varConstraint
					{
					pushFollow(FOLLOW_varConstraint_in_varConstraints899);
					a=varConstraint();
					state._fsp--;

					value.add(a);
					}
					break;

				default :
					if ( cnt20 >= 1 ) break loop20;
					EarlyExitException eee = new EarlyExitException(20, input);
					throw eee;
				}
				cnt20++;
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "varConstraints"



	// $ANTLR start "varConstraint"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:333:1: varConstraint returns [Constraint value] : ( (a= regexVarConstraint ) | (b= prefixVarConstraint ) );
	public final Constraint varConstraint() throws RecognitionException {
		Constraint value = null;


		RegexConstraint a =null;
		PrefixConstraint b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:334:5: ( (a= regexVarConstraint ) | (b= prefixVarConstraint ) )
			int alt21=2;
			int LA21_0 = input.LA(1);
			if ( (LA21_0==REGEX_CONSTRAINT) ) {
				alt21=1;
			}
			else if ( (LA21_0==PREFIX_CONSTRAINT) ) {
				alt21=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 21, 0, input);
				throw nvae;
			}

			switch (alt21) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:334:7: (a= regexVarConstraint )
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:334:7: (a= regexVarConstraint )
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:334:8: a= regexVarConstraint
					{
					pushFollow(FOLLOW_regexVarConstraint_in_varConstraint927);
					a=regexVarConstraint();
					state._fsp--;

					}

					value = a;
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:335:7: (b= prefixVarConstraint )
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:335:7: (b= prefixVarConstraint )
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:335:8: b= prefixVarConstraint
					{
					pushFollow(FOLLOW_prefixVarConstraint_in_varConstraint941);
					b=prefixVarConstraint();
					state._fsp--;

					}

					value = b;
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "varConstraint"



	// $ANTLR start "regexVarConstraint"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:338:1: regexVarConstraint returns [RegexConstraint value] : ^( REGEX_CONSTRAINT a= var b= string ) ;
	public final RegexConstraint regexVarConstraint() throws RecognitionException {
		RegexConstraint value = null;


		Var a =null;
		String b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:339:2: ( ^( REGEX_CONSTRAINT a= var b= string ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:339:4: ^( REGEX_CONSTRAINT a= var b= string )
			{
			match(input,REGEX_CONSTRAINT,FOLLOW_REGEX_CONSTRAINT_in_regexVarConstraint963); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_var_in_regexVarConstraint967);
			a=var();
			state._fsp--;

			pushFollow(FOLLOW_string_in_regexVarConstraint971);
			b=string();
			state._fsp--;

			match(input, Token.UP, null); 

			value = new RegexConstraint(a, "value", b);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "regexVarConstraint"



	// $ANTLR start "prefixVarConstraint"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:342:1: prefixVarConstraint returns [PrefixConstraint value] : ^( PREFIX_CONSTRAINT a= var b= stringList ) ;
	public final PrefixConstraint prefixVarConstraint() throws RecognitionException {
		PrefixConstraint value = null;


		Var a =null;
		List<String> b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:343:2: ( ^( PREFIX_CONSTRAINT a= var b= stringList ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:343:4: ^( PREFIX_CONSTRAINT a= var b= stringList )
			{
			match(input,PREFIX_CONSTRAINT,FOLLOW_PREFIX_CONSTRAINT_in_prefixVarConstraint993); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_var_in_prefixVarConstraint997);
			a=var();
			state._fsp--;

			pushFollow(FOLLOW_stringList_in_prefixVarConstraint1001);
			b=stringList();
			state._fsp--;

			match(input, Token.UP, null); 

			value = new PrefixConstraint(a, "value", b);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "prefixVarConstraint"



	// $ANTLR start "stringList"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:346:1: stringList returns [List<String> value] : ^( STRING_LIST (a= string )+ ) ;
	public final List<String> stringList() throws RecognitionException {
		List<String> value = null;


		String a =null;

		value = new ArrayList<String>();
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:348:5: ( ^( STRING_LIST (a= string )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:348:7: ^( STRING_LIST (a= string )+ )
			{
			match(input,STRING_LIST,FOLLOW_STRING_LIST_in_stringList1032); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:348:21: (a= string )+
			int cnt22=0;
			loop22:
			while (true) {
				int alt22=2;
				int LA22_0 = input.LA(1);
				if ( ((LA22_0 >= STRING_LITERAL1 && LA22_0 <= STRING_LITERAL_LONG2)) ) {
					alt22=1;
				}

				switch (alt22) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:348:22: a= string
					{
					pushFollow(FOLLOW_string_in_stringList1037);
					a=string();
					state._fsp--;

					value.add(a); 
					}
					break;

				default :
					if ( cnt22 >= 1 ) break loop22;
					EarlyExitException eee = new EarlyExitException(22, input);
					throw eee;
				}
				cnt22++;
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "stringList"



	// $ANTLR start "query"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:352:1: query : ( ^( QUERY prologue ( selectQuery )* ( constructQuery )* ( describeQuery )* ( askQuery )* ) ( bindingsClause )* | ^( UPDATE ( update )+ ) );
	public final void query() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:353:5: ( ^( QUERY prologue ( selectQuery )* ( constructQuery )* ( describeQuery )* ( askQuery )* ) ( bindingsClause )* | ^( UPDATE ( update )+ ) )
			int alt29=2;
			int LA29_0 = input.LA(1);
			if ( (LA29_0==QUERY) ) {
				alt29=1;
			}
			else if ( (LA29_0==UPDATE) ) {
				alt29=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 29, 0, input);
				throw nvae;
			}

			switch (alt29) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:353:7: ^( QUERY prologue ( selectQuery )* ( constructQuery )* ( describeQuery )* ( askQuery )* ) ( bindingsClause )*
					{
					match(input,QUERY,FOLLOW_QUERY_in_query1061); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_prologue_in_query1063);
					prologue();
					state._fsp--;

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:353:24: ( selectQuery )*
					loop23:
					while (true) {
						int alt23=2;
						int LA23_0 = input.LA(1);
						if ( (LA23_0==SELECT) ) {
							alt23=1;
						}

						switch (alt23) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:353:24: selectQuery
							{
							pushFollow(FOLLOW_selectQuery_in_query1065);
							selectQuery();
							state._fsp--;

							}
							break;

						default :
							break loop23;
						}
					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:353:37: ( constructQuery )*
					loop24:
					while (true) {
						int alt24=2;
						int LA24_0 = input.LA(1);
						if ( (LA24_0==CONSTRUCT) ) {
							alt24=1;
						}

						switch (alt24) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:353:37: constructQuery
							{
							pushFollow(FOLLOW_constructQuery_in_query1068);
							constructQuery();
							state._fsp--;

							}
							break;

						default :
							break loop24;
						}
					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:353:53: ( describeQuery )*
					loop25:
					while (true) {
						int alt25=2;
						int LA25_0 = input.LA(1);
						if ( (LA25_0==DESCRIBE) ) {
							alt25=1;
						}

						switch (alt25) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:353:53: describeQuery
							{
							pushFollow(FOLLOW_describeQuery_in_query1071);
							describeQuery();
							state._fsp--;

							}
							break;

						default :
							break loop25;
						}
					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:353:68: ( askQuery )*
					loop26:
					while (true) {
						int alt26=2;
						int LA26_0 = input.LA(1);
						if ( (LA26_0==ASK) ) {
							alt26=1;
						}

						switch (alt26) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:353:68: askQuery
							{
							pushFollow(FOLLOW_askQuery_in_query1074);
							askQuery();
							state._fsp--;

							}
							break;

						default :
							break loop26;
						}
					}

					match(input, Token.UP, null); 

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:353:79: ( bindingsClause )*
					loop27:
					while (true) {
						int alt27=2;
						int LA27_0 = input.LA(1);
						if ( (LA27_0==BINDINGS) ) {
							alt27=1;
						}

						switch (alt27) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:353:79: bindingsClause
							{
							pushFollow(FOLLOW_bindingsClause_in_query1078);
							bindingsClause();
							state._fsp--;

							}
							break;

						default :
							break loop27;
						}
					}

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:354:7: ^( UPDATE ( update )+ )
					{
					match(input,UPDATE,FOLLOW_UPDATE_in_query1088); 
					match(input, Token.DOWN, null); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:354:16: ( update )+
					int cnt28=0;
					loop28:
					while (true) {
						int alt28=2;
						int LA28_0 = input.LA(1);
						if ( (LA28_0==PROLOGUE) ) {
							alt28=1;
						}

						switch (alt28) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:354:16: update
							{
							pushFollow(FOLLOW_update_in_query1090);
							update();
							state._fsp--;

							}
							break;

						default :
							if ( cnt28 >= 1 ) break loop28;
							EarlyExitException eee = new EarlyExitException(28, input);
							throw eee;
						}
						cnt28++;
					}

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "query"



	// $ANTLR start "prologue"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:357:1: prologue : ^( PROLOGUE ( baseDecl )* ( prefixDecl )* ) ;
	public final void prologue() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:358:5: ( ^( PROLOGUE ( baseDecl )* ( prefixDecl )* ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:358:7: ^( PROLOGUE ( baseDecl )* ( prefixDecl )* )
			{
			match(input,PROLOGUE,FOLLOW_PROLOGUE_in_prologue1110); 
			if ( input.LA(1)==Token.DOWN ) {
				match(input, Token.DOWN, null); 
				// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:358:18: ( baseDecl )*
				loop30:
				while (true) {
					int alt30=2;
					int LA30_0 = input.LA(1);
					if ( (LA30_0==BASE) ) {
						alt30=1;
					}

					switch (alt30) {
					case 1 :
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:358:18: baseDecl
						{
						pushFollow(FOLLOW_baseDecl_in_prologue1112);
						baseDecl();
						state._fsp--;

						}
						break;

					default :
						break loop30;
					}
				}

				// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:358:28: ( prefixDecl )*
				loop31:
				while (true) {
					int alt31=2;
					int LA31_0 = input.LA(1);
					if ( (LA31_0==PREFIX) ) {
						alt31=1;
					}

					switch (alt31) {
					case 1 :
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:358:28: prefixDecl
						{
						pushFollow(FOLLOW_prefixDecl_in_prologue1115);
						prefixDecl();
						state._fsp--;

						}
						break;

					default :
						break loop31;
					}
				}

				match(input, Token.UP, null); 
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "prologue"



	// $ANTLR start "baseDecl"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:361:1: baseDecl : ^( BASE IRI_REF ) ;
	public final void baseDecl() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:362:5: ( ^( BASE IRI_REF ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:362:7: ^( BASE IRI_REF )
			{
			match(input,BASE,FOLLOW_BASE_in_baseDecl1135); 
			match(input, Token.DOWN, null); 
			match(input,IRI_REF,FOLLOW_IRI_REF_in_baseDecl1137); 
			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "baseDecl"


	public static class prefixDecl_return extends TreeRuleReturnScope {
		public String prefix;
		public String uri;
	};


	// $ANTLR start "prefixDecl"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:365:1: prefixDecl returns [String prefix, String uri] : ^( PREFIX a= PNAME_NS b= IRI_REF ) ;
	public final SparqlifyConfigTree.prefixDecl_return prefixDecl() throws RecognitionException {
		SparqlifyConfigTree.prefixDecl_return retval = new SparqlifyConfigTree.prefixDecl_return();
		retval.start = input.LT(1);

		CommonTree a=null;
		CommonTree b=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:366:5: ( ^( PREFIX a= PNAME_NS b= IRI_REF ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:366:7: ^( PREFIX a= PNAME_NS b= IRI_REF )
			{
			match(input,PREFIX,FOLLOW_PREFIX_in_prefixDecl1160); 
			match(input, Token.DOWN, null); 
			a=(CommonTree)match(input,PNAME_NS,FOLLOW_PNAME_NS_in_prefixDecl1164); 
			b=(CommonTree)match(input,IRI_REF,FOLLOW_IRI_REF_in_prefixDecl1168); 
			match(input, Token.UP, null); 

			 retval.prefix =(a!=null?a.getText():null); retval.uri =(b!=null?b.getText():null); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "prefixDecl"



	// $ANTLR start "selectQuery"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:369:1: selectQuery : ^( SELECT selectClause ( datasetClause )* ( whereClause )* solutionModifier ) ;
	public final void selectQuery() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:370:5: ( ^( SELECT selectClause ( datasetClause )* ( whereClause )* solutionModifier ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:370:7: ^( SELECT selectClause ( datasetClause )* ( whereClause )* solutionModifier )
			{
			match(input,SELECT,FOLLOW_SELECT_in_selectQuery1189); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_selectClause_in_selectQuery1191);
			selectClause();
			state._fsp--;

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:370:29: ( datasetClause )*
			loop32:
			while (true) {
				int alt32=2;
				int LA32_0 = input.LA(1);
				if ( (LA32_0==FROM) ) {
					alt32=1;
				}

				switch (alt32) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:370:29: datasetClause
					{
					pushFollow(FOLLOW_datasetClause_in_selectQuery1193);
					datasetClause();
					state._fsp--;

					}
					break;

				default :
					break loop32;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:370:44: ( whereClause )*
			loop33:
			while (true) {
				int alt33=2;
				int LA33_0 = input.LA(1);
				if ( (LA33_0==WHERE_CLAUSE) ) {
					alt33=1;
				}

				switch (alt33) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:370:44: whereClause
					{
					pushFollow(FOLLOW_whereClause_in_selectQuery1196);
					whereClause();
					state._fsp--;

					}
					break;

				default :
					break loop33;
				}
			}

			pushFollow(FOLLOW_solutionModifier_in_selectQuery1199);
			solutionModifier();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "selectQuery"



	// $ANTLR start "subSelect"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:373:1: subSelect : ^( SUBSELECT ( whereClause )* solutionModifier ) ;
	public final void subSelect() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:374:5: ( ^( SUBSELECT ( whereClause )* solutionModifier ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:374:7: ^( SUBSELECT ( whereClause )* solutionModifier )
			{
			match(input,SUBSELECT,FOLLOW_SUBSELECT_in_subSelect1218); 
			if ( input.LA(1)==Token.DOWN ) {
				match(input, Token.DOWN, null); 
				// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:374:19: ( whereClause )*
				loop34:
				while (true) {
					int alt34=2;
					int LA34_0 = input.LA(1);
					if ( (LA34_0==WHERE_CLAUSE) ) {
						alt34=1;
					}

					switch (alt34) {
					case 1 :
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:374:19: whereClause
						{
						pushFollow(FOLLOW_whereClause_in_subSelect1220);
						whereClause();
						state._fsp--;

						}
						break;

					default :
						break loop34;
					}
				}

				pushFollow(FOLLOW_solutionModifier_in_subSelect1223);
				solutionModifier();
				state._fsp--;

				match(input, Token.UP, null); 
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "subSelect"



	// $ANTLR start "selectClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:377:1: selectClause : ( ^( SELECT_CLAUSE ASTERISK ) | ^( SELECT_CLAUSE DISTINCT ASTERISK ) | ^( SELECT_CLAUSE REDUCED ASTERISK ) | ^( SELECT_CLAUSE ( selectVariables )* ) | ^( SELECT_CLAUSE DISTINCT ( selectVariables )* ) | ^( SELECT_CLAUSE REDUCED ( selectVariables )* ) );
	public final void selectClause() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:378:5: ( ^( SELECT_CLAUSE ASTERISK ) | ^( SELECT_CLAUSE DISTINCT ASTERISK ) | ^( SELECT_CLAUSE REDUCED ASTERISK ) | ^( SELECT_CLAUSE ( selectVariables )* ) | ^( SELECT_CLAUSE DISTINCT ( selectVariables )* ) | ^( SELECT_CLAUSE REDUCED ( selectVariables )* ) )
			int alt38=6;
			int LA38_0 = input.LA(1);
			if ( (LA38_0==SELECT_CLAUSE) ) {
				int LA38_1 = input.LA(2);
				if ( (LA38_1==DOWN) ) {
					switch ( input.LA(3) ) {
					case ASTERISK:
						{
						alt38=1;
						}
						break;
					case DISTINCT:
						{
						int LA38_4 = input.LA(4);
						if ( (LA38_4==ASTERISK) ) {
							alt38=2;
						}
						else if ( (LA38_4==UP||LA38_4==AS||LA38_4==VAR) ) {
							alt38=5;
						}

						else {
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 38, 4, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

						}
						break;
					case REDUCED:
						{
						int LA38_5 = input.LA(4);
						if ( (LA38_5==ASTERISK) ) {
							alt38=3;
						}
						else if ( (LA38_5==UP||LA38_5==AS||LA38_5==VAR) ) {
							alt38=6;
						}

						else {
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 38, 5, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

						}
						break;
					case UP:
					case AS:
					case VAR:
						{
						alt38=4;
						}
						break;
					default:
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 38, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 38, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 38, 0, input);
				throw nvae;
			}

			switch (alt38) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:378:7: ^( SELECT_CLAUSE ASTERISK )
					{
					match(input,SELECT_CLAUSE,FOLLOW_SELECT_CLAUSE_in_selectClause1247); 
					match(input, Token.DOWN, null); 
					match(input,ASTERISK,FOLLOW_ASTERISK_in_selectClause1249); 
					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:379:7: ^( SELECT_CLAUSE DISTINCT ASTERISK )
					{
					match(input,SELECT_CLAUSE,FOLLOW_SELECT_CLAUSE_in_selectClause1259); 
					match(input, Token.DOWN, null); 
					match(input,DISTINCT,FOLLOW_DISTINCT_in_selectClause1261); 
					match(input,ASTERISK,FOLLOW_ASTERISK_in_selectClause1263); 
					match(input, Token.UP, null); 

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:380:7: ^( SELECT_CLAUSE REDUCED ASTERISK )
					{
					match(input,SELECT_CLAUSE,FOLLOW_SELECT_CLAUSE_in_selectClause1273); 
					match(input, Token.DOWN, null); 
					match(input,REDUCED,FOLLOW_REDUCED_in_selectClause1275); 
					match(input,ASTERISK,FOLLOW_ASTERISK_in_selectClause1277); 
					match(input, Token.UP, null); 

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:381:7: ^( SELECT_CLAUSE ( selectVariables )* )
					{
					match(input,SELECT_CLAUSE,FOLLOW_SELECT_CLAUSE_in_selectClause1287); 
					if ( input.LA(1)==Token.DOWN ) {
						match(input, Token.DOWN, null); 
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:381:23: ( selectVariables )*
						loop35:
						while (true) {
							int alt35=2;
							int LA35_0 = input.LA(1);
							if ( (LA35_0==AS||LA35_0==VAR) ) {
								alt35=1;
							}

							switch (alt35) {
							case 1 :
								// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:381:23: selectVariables
								{
								pushFollow(FOLLOW_selectVariables_in_selectClause1289);
								selectVariables();
								state._fsp--;

								}
								break;

							default :
								break loop35;
							}
						}

						match(input, Token.UP, null); 
					}

					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:382:7: ^( SELECT_CLAUSE DISTINCT ( selectVariables )* )
					{
					match(input,SELECT_CLAUSE,FOLLOW_SELECT_CLAUSE_in_selectClause1300); 
					match(input, Token.DOWN, null); 
					match(input,DISTINCT,FOLLOW_DISTINCT_in_selectClause1302); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:382:32: ( selectVariables )*
					loop36:
					while (true) {
						int alt36=2;
						int LA36_0 = input.LA(1);
						if ( (LA36_0==AS||LA36_0==VAR) ) {
							alt36=1;
						}

						switch (alt36) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:382:32: selectVariables
							{
							pushFollow(FOLLOW_selectVariables_in_selectClause1304);
							selectVariables();
							state._fsp--;

							}
							break;

						default :
							break loop36;
						}
					}

					match(input, Token.UP, null); 

					}
					break;
				case 6 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:383:7: ^( SELECT_CLAUSE REDUCED ( selectVariables )* )
					{
					match(input,SELECT_CLAUSE,FOLLOW_SELECT_CLAUSE_in_selectClause1315); 
					match(input, Token.DOWN, null); 
					match(input,REDUCED,FOLLOW_REDUCED_in_selectClause1317); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:383:31: ( selectVariables )*
					loop37:
					while (true) {
						int alt37=2;
						int LA37_0 = input.LA(1);
						if ( (LA37_0==AS||LA37_0==VAR) ) {
							alt37=1;
						}

						switch (alt37) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:383:31: selectVariables
							{
							pushFollow(FOLLOW_selectVariables_in_selectClause1319);
							selectVariables();
							state._fsp--;

							}
							break;

						default :
							break loop37;
						}
					}

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "selectClause"



	// $ANTLR start "selectVariables"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:386:1: selectVariables : ( ^( VAR var ) | ^( AS expression var ) );
	public final void selectVariables() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:387:5: ( ^( VAR var ) | ^( AS expression var ) )
			int alt39=2;
			int LA39_0 = input.LA(1);
			if ( (LA39_0==VAR) ) {
				alt39=1;
			}
			else if ( (LA39_0==AS) ) {
				alt39=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 39, 0, input);
				throw nvae;
			}

			switch (alt39) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:387:7: ^( VAR var )
					{
					match(input,VAR,FOLLOW_VAR_in_selectVariables1339); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_var_in_selectVariables1341);
					var();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:388:7: ^( AS expression var )
					{
					match(input,AS,FOLLOW_AS_in_selectVariables1352); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_selectVariables1354);
					expression();
					state._fsp--;

					pushFollow(FOLLOW_var_in_selectVariables1356);
					var();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "selectVariables"



	// $ANTLR start "constructQuery"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:391:1: constructQuery : ( ^( CONSTRUCT ( constructTemplate )* ( datasetClause )* ( whereClause )* solutionModifier ) | ^( CONSTRUCT ( datasetClause )* ^( WHERE ( triplesTemplate )* ) solutionModifier ) );
	public final void constructQuery() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:392:5: ( ^( CONSTRUCT ( constructTemplate )* ( datasetClause )* ( whereClause )* solutionModifier ) | ^( CONSTRUCT ( datasetClause )* ^( WHERE ( triplesTemplate )* ) solutionModifier ) )
			int alt45=2;
			alt45 = dfa45.predict(input);
			switch (alt45) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:392:7: ^( CONSTRUCT ( constructTemplate )* ( datasetClause )* ( whereClause )* solutionModifier )
					{
					match(input,CONSTRUCT,FOLLOW_CONSTRUCT_in_constructQuery1377); 
					if ( input.LA(1)==Token.DOWN ) {
						match(input, Token.DOWN, null); 
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:392:19: ( constructTemplate )*
						loop40:
						while (true) {
							int alt40=2;
							int LA40_0 = input.LA(1);
							if ( (LA40_0==CONSTRUCT_TRIPLES) ) {
								alt40=1;
							}

							switch (alt40) {
							case 1 :
								// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:392:19: constructTemplate
								{
								pushFollow(FOLLOW_constructTemplate_in_constructQuery1379);
								constructTemplate();
								state._fsp--;

								}
								break;

							default :
								break loop40;
							}
						}

						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:392:38: ( datasetClause )*
						loop41:
						while (true) {
							int alt41=2;
							int LA41_0 = input.LA(1);
							if ( (LA41_0==FROM) ) {
								alt41=1;
							}

							switch (alt41) {
							case 1 :
								// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:392:38: datasetClause
								{
								pushFollow(FOLLOW_datasetClause_in_constructQuery1382);
								datasetClause();
								state._fsp--;

								}
								break;

							default :
								break loop41;
							}
						}

						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:392:53: ( whereClause )*
						loop42:
						while (true) {
							int alt42=2;
							int LA42_0 = input.LA(1);
							if ( (LA42_0==WHERE_CLAUSE) ) {
								alt42=1;
							}

							switch (alt42) {
							case 1 :
								// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:392:53: whereClause
								{
								pushFollow(FOLLOW_whereClause_in_constructQuery1385);
								whereClause();
								state._fsp--;

								}
								break;

							default :
								break loop42;
							}
						}

						pushFollow(FOLLOW_solutionModifier_in_constructQuery1388);
						solutionModifier();
						state._fsp--;

						match(input, Token.UP, null); 
					}

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:393:7: ^( CONSTRUCT ( datasetClause )* ^( WHERE ( triplesTemplate )* ) solutionModifier )
					{
					match(input,CONSTRUCT,FOLLOW_CONSTRUCT_in_constructQuery1398); 
					match(input, Token.DOWN, null); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:393:19: ( datasetClause )*
					loop43:
					while (true) {
						int alt43=2;
						int LA43_0 = input.LA(1);
						if ( (LA43_0==FROM) ) {
							alt43=1;
						}

						switch (alt43) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:393:19: datasetClause
							{
							pushFollow(FOLLOW_datasetClause_in_constructQuery1400);
							datasetClause();
							state._fsp--;

							}
							break;

						default :
							break loop43;
						}
					}

					match(input,WHERE,FOLLOW_WHERE_in_constructQuery1404); 
					if ( input.LA(1)==Token.DOWN ) {
						match(input, Token.DOWN, null); 
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:393:42: ( triplesTemplate )*
						loop44:
						while (true) {
							int alt44=2;
							int LA44_0 = input.LA(1);
							if ( (LA44_0==TRIPLES_TEMPLATE) ) {
								alt44=1;
							}

							switch (alt44) {
							case 1 :
								// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:393:42: triplesTemplate
								{
								pushFollow(FOLLOW_triplesTemplate_in_constructQuery1406);
								triplesTemplate();
								state._fsp--;

								}
								break;

							default :
								break loop44;
							}
						}

						match(input, Token.UP, null); 
					}

					pushFollow(FOLLOW_solutionModifier_in_constructQuery1410);
					solutionModifier();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "constructQuery"



	// $ANTLR start "describeQuery"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:396:1: describeQuery : ^( DESCRIBE ( varOrIRIref )* ( ASTERISK )* ( datasetClause )* ( whereClause )? solutionModifier ) ;
	public final void describeQuery() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:397:5: ( ^( DESCRIBE ( varOrIRIref )* ( ASTERISK )* ( datasetClause )* ( whereClause )? solutionModifier ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:397:7: ^( DESCRIBE ( varOrIRIref )* ( ASTERISK )* ( datasetClause )* ( whereClause )? solutionModifier )
			{
			match(input,DESCRIBE,FOLLOW_DESCRIBE_in_describeQuery1429); 
			if ( input.LA(1)==Token.DOWN ) {
				match(input, Token.DOWN, null); 
				// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:397:18: ( varOrIRIref )*
				loop46:
				while (true) {
					int alt46=2;
					int LA46_0 = input.LA(1);
					if ( (LA46_0==IRI_REF||(LA46_0 >= PNAME_LN && LA46_0 <= PNAME_NS)||LA46_0==VAR) ) {
						alt46=1;
					}

					switch (alt46) {
					case 1 :
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:397:18: varOrIRIref
						{
						pushFollow(FOLLOW_varOrIRIref_in_describeQuery1431);
						varOrIRIref();
						state._fsp--;

						}
						break;

					default :
						break loop46;
					}
				}

				// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:397:31: ( ASTERISK )*
				loop47:
				while (true) {
					int alt47=2;
					int LA47_0 = input.LA(1);
					if ( (LA47_0==ASTERISK) ) {
						alt47=1;
					}

					switch (alt47) {
					case 1 :
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:397:31: ASTERISK
						{
						match(input,ASTERISK,FOLLOW_ASTERISK_in_describeQuery1434); 
						}
						break;

					default :
						break loop47;
					}
				}

				// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:397:41: ( datasetClause )*
				loop48:
				while (true) {
					int alt48=2;
					int LA48_0 = input.LA(1);
					if ( (LA48_0==FROM) ) {
						alt48=1;
					}

					switch (alt48) {
					case 1 :
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:397:41: datasetClause
						{
						pushFollow(FOLLOW_datasetClause_in_describeQuery1437);
						datasetClause();
						state._fsp--;

						}
						break;

					default :
						break loop48;
					}
				}

				// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:397:56: ( whereClause )?
				int alt49=2;
				int LA49_0 = input.LA(1);
				if ( (LA49_0==WHERE_CLAUSE) ) {
					alt49=1;
				}
				switch (alt49) {
					case 1 :
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:397:56: whereClause
						{
						pushFollow(FOLLOW_whereClause_in_describeQuery1440);
						whereClause();
						state._fsp--;

						}
						break;

				}

				pushFollow(FOLLOW_solutionModifier_in_describeQuery1443);
				solutionModifier();
				state._fsp--;

				match(input, Token.UP, null); 
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "describeQuery"



	// $ANTLR start "askQuery"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:400:1: askQuery : ^( ASK ( datasetClause )* whereClause ) ;
	public final void askQuery() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:401:5: ( ^( ASK ( datasetClause )* whereClause ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:401:7: ^( ASK ( datasetClause )* whereClause )
			{
			match(input,ASK,FOLLOW_ASK_in_askQuery1462); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:401:13: ( datasetClause )*
			loop50:
			while (true) {
				int alt50=2;
				int LA50_0 = input.LA(1);
				if ( (LA50_0==FROM) ) {
					alt50=1;
				}

				switch (alt50) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:401:13: datasetClause
					{
					pushFollow(FOLLOW_datasetClause_in_askQuery1464);
					datasetClause();
					state._fsp--;

					}
					break;

				default :
					break loop50;
				}
			}

			pushFollow(FOLLOW_whereClause_in_askQuery1467);
			whereClause();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "askQuery"



	// $ANTLR start "datasetClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:404:1: datasetClause : ^( FROM ( NAMED )? iriRef ) ;
	public final void datasetClause() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:405:5: ( ^( FROM ( NAMED )? iriRef ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:405:7: ^( FROM ( NAMED )? iriRef )
			{
			match(input,FROM,FOLLOW_FROM_in_datasetClause1486); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:405:14: ( NAMED )?
			int alt51=2;
			int LA51_0 = input.LA(1);
			if ( (LA51_0==NAMED) ) {
				alt51=1;
			}
			switch (alt51) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:405:14: NAMED
					{
					match(input,NAMED,FOLLOW_NAMED_in_datasetClause1488); 
					}
					break;

			}

			pushFollow(FOLLOW_iriRef_in_datasetClause1491);
			iriRef();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "datasetClause"



	// $ANTLR start "whereClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:408:1: whereClause : ^( WHERE_CLAUSE groupGraphPattern ) ;
	public final void whereClause() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:409:5: ( ^( WHERE_CLAUSE groupGraphPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:409:7: ^( WHERE_CLAUSE groupGraphPattern )
			{
			match(input,WHERE_CLAUSE,FOLLOW_WHERE_CLAUSE_in_whereClause1510); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_groupGraphPattern_in_whereClause1512);
			groupGraphPattern();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "whereClause"



	// $ANTLR start "solutionModifier"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:412:1: solutionModifier : ( groupClause )? ( havingClause )? ( orderClause )? ( limitOffsetClauses )? ;
	public final void solutionModifier() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:413:5: ( ( groupClause )? ( havingClause )? ( orderClause )? ( limitOffsetClauses )? )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:413:7: ( groupClause )? ( havingClause )? ( orderClause )? ( limitOffsetClauses )?
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:413:7: ( groupClause )?
			int alt52=2;
			int LA52_0 = input.LA(1);
			if ( (LA52_0==GROUP_BY) ) {
				alt52=1;
			}
			switch (alt52) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:413:7: groupClause
					{
					pushFollow(FOLLOW_groupClause_in_solutionModifier1534);
					groupClause();
					state._fsp--;

					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:413:20: ( havingClause )?
			int alt53=2;
			int LA53_0 = input.LA(1);
			if ( (LA53_0==HAVING) ) {
				alt53=1;
			}
			switch (alt53) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:413:20: havingClause
					{
					pushFollow(FOLLOW_havingClause_in_solutionModifier1537);
					havingClause();
					state._fsp--;

					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:413:34: ( orderClause )?
			int alt54=2;
			int LA54_0 = input.LA(1);
			if ( (LA54_0==ORDER_BY) ) {
				alt54=1;
			}
			switch (alt54) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:413:34: orderClause
					{
					pushFollow(FOLLOW_orderClause_in_solutionModifier1540);
					orderClause();
					state._fsp--;

					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:413:47: ( limitOffsetClauses )?
			int alt55=2;
			int LA55_0 = input.LA(1);
			if ( (LA55_0==LIMIT||LA55_0==OFFSET) ) {
				alt55=1;
			}
			switch (alt55) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:413:47: limitOffsetClauses
					{
					pushFollow(FOLLOW_limitOffsetClauses_in_solutionModifier1543);
					limitOffsetClauses();
					state._fsp--;

					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "solutionModifier"



	// $ANTLR start "groupClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:416:1: groupClause : ^( GROUP_BY ( groupCondition )+ ) ;
	public final void groupClause() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:417:5: ( ^( GROUP_BY ( groupCondition )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:417:7: ^( GROUP_BY ( groupCondition )+ )
			{
			match(input,GROUP_BY,FOLLOW_GROUP_BY_in_groupClause1562); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:417:18: ( groupCondition )+
			int cnt56=0;
			loop56:
			while (true) {
				int alt56=2;
				int LA56_0 = input.LA(1);
				if ( (LA56_0==ABS||LA56_0==AS||(LA56_0 >= BNODE && LA56_0 <= BOUND)||LA56_0==CEIL||LA56_0==COALESCE||LA56_0==CONCAT||LA56_0==CONTAINS||(LA56_0 >= DATATYPE && LA56_0 <= DAY)||LA56_0==ENCODE_FOR_URI||LA56_0==EXISTS||LA56_0==FLOOR||LA56_0==FUNCTION||(LA56_0 >= HOURS && LA56_0 <= IF)||LA56_0==IRI||(LA56_0 >= ISBLANK && LA56_0 <= ISURI)||(LA56_0 >= LANG && LA56_0 <= LANGMATCHES)||LA56_0==LCASE||LA56_0==MD5||LA56_0==MINUTES||LA56_0==MONTH||(LA56_0 >= NOT_EXISTS && LA56_0 <= NOW)||LA56_0==RAND||LA56_0==REGEX||(LA56_0 >= ROUND && LA56_0 <= SAMETERM)||LA56_0==SECONDS||(LA56_0 >= SHA1 && LA56_0 <= SHA512)||(LA56_0 >= STR && LA56_0 <= STRENDS)||(LA56_0 >= STRLANG && LA56_0 <= STRSTARTS)||LA56_0==SUBSTR||LA56_0==TIMEZONE||(LA56_0 >= TZ && LA56_0 <= UCASE)||LA56_0==URI||LA56_0==VAR||LA56_0==YEAR) ) {
					alt56=1;
				}

				switch (alt56) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:417:18: groupCondition
					{
					pushFollow(FOLLOW_groupCondition_in_groupClause1564);
					groupCondition();
					state._fsp--;

					}
					break;

				default :
					if ( cnt56 >= 1 ) break loop56;
					EarlyExitException eee = new EarlyExitException(56, input);
					throw eee;
				}
				cnt56++;
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "groupClause"



	// $ANTLR start "groupCondition"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:420:1: groupCondition : ( builtInCall | functionCall | ^( AS expression ( var )* ) | var );
	public final void groupCondition() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:421:5: ( builtInCall | functionCall | ^( AS expression ( var )* ) | var )
			int alt58=4;
			switch ( input.LA(1) ) {
			case ABS:
			case BNODE:
			case BOUND:
			case CEIL:
			case COALESCE:
			case CONCAT:
			case CONTAINS:
			case DATATYPE:
			case DAY:
			case ENCODE_FOR_URI:
			case EXISTS:
			case FLOOR:
			case HOURS:
			case IF:
			case IRI:
			case ISBLANK:
			case ISIRI:
			case ISLITERAL:
			case ISNUMERIC:
			case ISURI:
			case LANG:
			case LANGMATCHES:
			case LCASE:
			case MD5:
			case MINUTES:
			case MONTH:
			case NOT_EXISTS:
			case NOW:
			case RAND:
			case REGEX:
			case ROUND:
			case SAMETERM:
			case SECONDS:
			case SHA1:
			case SHA224:
			case SHA256:
			case SHA384:
			case SHA512:
			case STR:
			case STRDT:
			case STRENDS:
			case STRLANG:
			case STRLEN:
			case STRSTARTS:
			case SUBSTR:
			case TIMEZONE:
			case TZ:
			case UCASE:
			case URI:
			case YEAR:
				{
				alt58=1;
				}
				break;
			case FUNCTION:
				{
				alt58=2;
				}
				break;
			case AS:
				{
				alt58=3;
				}
				break;
			case VAR:
				{
				alt58=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 58, 0, input);
				throw nvae;
			}
			switch (alt58) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:421:7: builtInCall
					{
					pushFollow(FOLLOW_builtInCall_in_groupCondition1590);
					builtInCall();
					state._fsp--;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:422:7: functionCall
					{
					pushFollow(FOLLOW_functionCall_in_groupCondition1598);
					functionCall();
					state._fsp--;

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:423:7: ^( AS expression ( var )* )
					{
					match(input,AS,FOLLOW_AS_in_groupCondition1607); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_groupCondition1609);
					expression();
					state._fsp--;

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:423:23: ( var )*
					loop57:
					while (true) {
						int alt57=2;
						int LA57_0 = input.LA(1);
						if ( (LA57_0==VAR) ) {
							alt57=1;
						}

						switch (alt57) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:423:23: var
							{
							pushFollow(FOLLOW_var_in_groupCondition1611);
							var();
							state._fsp--;

							}
							break;

						default :
							break loop57;
						}
					}

					match(input, Token.UP, null); 

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:424:7: var
					{
					pushFollow(FOLLOW_var_in_groupCondition1621);
					var();
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "groupCondition"



	// $ANTLR start "havingClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:427:1: havingClause : ^( HAVING ( constraint )+ ) ;
	public final void havingClause() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:428:5: ( ^( HAVING ( constraint )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:428:7: ^( HAVING ( constraint )+ )
			{
			match(input,HAVING,FOLLOW_HAVING_in_havingClause1639); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:428:16: ( constraint )+
			int cnt59=0;
			loop59:
			while (true) {
				int alt59=2;
				int LA59_0 = input.LA(1);
				if ( (LA59_0==ABS||LA59_0==AND||LA59_0==ASTERISK||(LA59_0 >= BNODE && LA59_0 <= BOUND)||LA59_0==CEIL||LA59_0==COALESCE||LA59_0==CONCAT||LA59_0==CONTAINS||(LA59_0 >= DATATYPE && LA59_0 <= DAY)||LA59_0==DIVIDE||LA59_0==ENCODE_FOR_URI||(LA59_0 >= EQUAL && LA59_0 <= EXISTS)||LA59_0==FLOOR||LA59_0==FUNCTION||(LA59_0 >= GREATER && LA59_0 <= GREATER_EQUAL)||(LA59_0 >= HOURS && LA59_0 <= IF)||LA59_0==IN||LA59_0==IRI||(LA59_0 >= ISBLANK && LA59_0 <= ISURI)||(LA59_0 >= LANG && LA59_0 <= LANGMATCHES)||(LA59_0 >= LCASE && LA59_0 <= LESS_EQUAL)||LA59_0==MD5||LA59_0==MINUS||LA59_0==MINUTES||LA59_0==MONTH||(LA59_0 >= NOT && LA59_0 <= NOW)||LA59_0==OR||LA59_0==PLUS||LA59_0==RAND||LA59_0==REGEX||(LA59_0 >= ROUND && LA59_0 <= SAMETERM)||LA59_0==SECONDS||(LA59_0 >= SHA1 && LA59_0 <= SHA512)||(LA59_0 >= STR && LA59_0 <= STRENDS)||(LA59_0 >= STRLANG && LA59_0 <= STRSTARTS)||LA59_0==SUBSTR||LA59_0==TIMEZONE||(LA59_0 >= TZ && LA59_0 <= UNARY_PLUS)||LA59_0==URI||LA59_0==YEAR) ) {
					alt59=1;
				}

				switch (alt59) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:428:16: constraint
					{
					pushFollow(FOLLOW_constraint_in_havingClause1641);
					constraint();
					state._fsp--;

					}
					break;

				default :
					if ( cnt59 >= 1 ) break loop59;
					EarlyExitException eee = new EarlyExitException(59, input);
					throw eee;
				}
				cnt59++;
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "havingClause"



	// $ANTLR start "orderClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:431:1: orderClause : ^( ORDER_BY ( orderCondition )+ ) ;
	public final void orderClause() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:432:5: ( ^( ORDER_BY ( orderCondition )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:432:7: ^( ORDER_BY ( orderCondition )+ )
			{
			match(input,ORDER_BY,FOLLOW_ORDER_BY_in_orderClause1666); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:432:18: ( orderCondition )+
			int cnt60=0;
			loop60:
			while (true) {
				int alt60=2;
				int LA60_0 = input.LA(1);
				if ( (LA60_0==ORDER_CONDITION) ) {
					alt60=1;
				}

				switch (alt60) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:432:18: orderCondition
					{
					pushFollow(FOLLOW_orderCondition_in_orderClause1668);
					orderCondition();
					state._fsp--;

					}
					break;

				default :
					if ( cnt60 >= 1 ) break loop60;
					EarlyExitException eee = new EarlyExitException(60, input);
					throw eee;
				}
				cnt60++;
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "orderClause"



	// $ANTLR start "orderCondition"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:435:1: orderCondition : ( ^( ORDER_CONDITION ASC expression ) | ^( ORDER_CONDITION DESC expression ) | ^( ORDER_CONDITION constraint ) | ^( ORDER_CONDITION var ) );
	public final void orderCondition() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:436:5: ( ^( ORDER_CONDITION ASC expression ) | ^( ORDER_CONDITION DESC expression ) | ^( ORDER_CONDITION constraint ) | ^( ORDER_CONDITION var ) )
			int alt61=4;
			int LA61_0 = input.LA(1);
			if ( (LA61_0==ORDER_CONDITION) ) {
				int LA61_1 = input.LA(2);
				if ( (LA61_1==DOWN) ) {
					switch ( input.LA(3) ) {
					case ASC:
						{
						alt61=1;
						}
						break;
					case DESC:
						{
						alt61=2;
						}
						break;
					case ABS:
					case AND:
					case ASTERISK:
					case BNODE:
					case BOUND:
					case CEIL:
					case COALESCE:
					case CONCAT:
					case CONTAINS:
					case DATATYPE:
					case DAY:
					case DIVIDE:
					case ENCODE_FOR_URI:
					case EQUAL:
					case EXISTS:
					case FLOOR:
					case FUNCTION:
					case GREATER:
					case GREATER_EQUAL:
					case HOURS:
					case IF:
					case IN:
					case IRI:
					case ISBLANK:
					case ISIRI:
					case ISLITERAL:
					case ISNUMERIC:
					case ISURI:
					case LANG:
					case LANGMATCHES:
					case LCASE:
					case LESS:
					case LESS_EQUAL:
					case MD5:
					case MINUS:
					case MINUTES:
					case MONTH:
					case NOT:
					case NOT_EQUAL:
					case NOT_EXISTS:
					case NOW:
					case OR:
					case PLUS:
					case RAND:
					case REGEX:
					case ROUND:
					case SAMETERM:
					case SECONDS:
					case SHA1:
					case SHA224:
					case SHA256:
					case SHA384:
					case SHA512:
					case STR:
					case STRDT:
					case STRENDS:
					case STRLANG:
					case STRLEN:
					case STRSTARTS:
					case SUBSTR:
					case TIMEZONE:
					case TZ:
					case UCASE:
					case UNARY:
					case UNARY_MINUS:
					case UNARY_NOT:
					case UNARY_PLUS:
					case URI:
					case YEAR:
						{
						alt61=3;
						}
						break;
					case VAR:
						{
						alt61=4;
						}
						break;
					default:
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 61, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 61, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 61, 0, input);
				throw nvae;
			}

			switch (alt61) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:436:7: ^( ORDER_CONDITION ASC expression )
					{
					match(input,ORDER_CONDITION,FOLLOW_ORDER_CONDITION_in_orderCondition1688); 
					match(input, Token.DOWN, null); 
					match(input,ASC,FOLLOW_ASC_in_orderCondition1690); 
					pushFollow(FOLLOW_expression_in_orderCondition1692);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:437:7: ^( ORDER_CONDITION DESC expression )
					{
					match(input,ORDER_CONDITION,FOLLOW_ORDER_CONDITION_in_orderCondition1702); 
					match(input, Token.DOWN, null); 
					match(input,DESC,FOLLOW_DESC_in_orderCondition1704); 
					pushFollow(FOLLOW_expression_in_orderCondition1706);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:438:7: ^( ORDER_CONDITION constraint )
					{
					match(input,ORDER_CONDITION,FOLLOW_ORDER_CONDITION_in_orderCondition1716); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_constraint_in_orderCondition1718);
					constraint();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:439:7: ^( ORDER_CONDITION var )
					{
					match(input,ORDER_CONDITION,FOLLOW_ORDER_CONDITION_in_orderCondition1728); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_var_in_orderCondition1730);
					var();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "orderCondition"



	// $ANTLR start "limitOffsetClauses"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:442:1: limitOffsetClauses : ( ^( LIMIT INTEGER ) ( ^( OFFSET INTEGER ) )* | ^( OFFSET INTEGER ) ( ^( LIMIT INTEGER ) )* );
	public final void limitOffsetClauses() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:443:5: ( ^( LIMIT INTEGER ) ( ^( OFFSET INTEGER ) )* | ^( OFFSET INTEGER ) ( ^( LIMIT INTEGER ) )* )
			int alt64=2;
			int LA64_0 = input.LA(1);
			if ( (LA64_0==LIMIT) ) {
				alt64=1;
			}
			else if ( (LA64_0==OFFSET) ) {
				alt64=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 64, 0, input);
				throw nvae;
			}

			switch (alt64) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:443:7: ^( LIMIT INTEGER ) ( ^( OFFSET INTEGER ) )*
					{
					match(input,LIMIT,FOLLOW_LIMIT_in_limitOffsetClauses1754); 
					match(input, Token.DOWN, null); 
					match(input,INTEGER,FOLLOW_INTEGER_in_limitOffsetClauses1756); 
					match(input, Token.UP, null); 

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:443:24: ( ^( OFFSET INTEGER ) )*
					loop62:
					while (true) {
						int alt62=2;
						int LA62_0 = input.LA(1);
						if ( (LA62_0==OFFSET) ) {
							alt62=1;
						}

						switch (alt62) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:443:25: ^( OFFSET INTEGER )
							{
							match(input,OFFSET,FOLLOW_OFFSET_in_limitOffsetClauses1761); 
							match(input, Token.DOWN, null); 
							match(input,INTEGER,FOLLOW_INTEGER_in_limitOffsetClauses1763); 
							match(input, Token.UP, null); 

							}
							break;

						default :
							break loop62;
						}
					}

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:444:7: ^( OFFSET INTEGER ) ( ^( LIMIT INTEGER ) )*
					{
					match(input,OFFSET,FOLLOW_OFFSET_in_limitOffsetClauses1775); 
					match(input, Token.DOWN, null); 
					match(input,INTEGER,FOLLOW_INTEGER_in_limitOffsetClauses1777); 
					match(input, Token.UP, null); 

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:444:25: ( ^( LIMIT INTEGER ) )*
					loop63:
					while (true) {
						int alt63=2;
						int LA63_0 = input.LA(1);
						if ( (LA63_0==LIMIT) ) {
							alt63=1;
						}

						switch (alt63) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:444:26: ^( LIMIT INTEGER )
							{
							match(input,LIMIT,FOLLOW_LIMIT_in_limitOffsetClauses1782); 
							match(input, Token.DOWN, null); 
							match(input,INTEGER,FOLLOW_INTEGER_in_limitOffsetClauses1784); 
							match(input, Token.UP, null); 

							}
							break;

						default :
							break loop63;
						}
					}

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "limitOffsetClauses"



	// $ANTLR start "bindingsClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:448:1: bindingsClause : ^( BINDINGS ( var )* ( bindingValueList )* ) ;
	public final void bindingsClause() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:449:5: ( ^( BINDINGS ( var )* ( bindingValueList )* ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:449:7: ^( BINDINGS ( var )* ( bindingValueList )* )
			{
			match(input,BINDINGS,FOLLOW_BINDINGS_in_bindingsClause1806); 
			if ( input.LA(1)==Token.DOWN ) {
				match(input, Token.DOWN, null); 
				// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:449:18: ( var )*
				loop65:
				while (true) {
					int alt65=2;
					int LA65_0 = input.LA(1);
					if ( (LA65_0==VAR) ) {
						alt65=1;
					}

					switch (alt65) {
					case 1 :
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:449:18: var
						{
						pushFollow(FOLLOW_var_in_bindingsClause1808);
						var();
						state._fsp--;

						}
						break;

					default :
						break loop65;
					}
				}

				// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:449:23: ( bindingValueList )*
				loop66:
				while (true) {
					int alt66=2;
					int LA66_0 = input.LA(1);
					if ( (LA66_0==BINDING_VALUE) ) {
						alt66=1;
					}

					switch (alt66) {
					case 1 :
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:449:23: bindingValueList
						{
						pushFollow(FOLLOW_bindingValueList_in_bindingsClause1811);
						bindingValueList();
						state._fsp--;

						}
						break;

					default :
						break loop66;
					}
				}

				match(input, Token.UP, null); 
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "bindingsClause"



	// $ANTLR start "bindingValueList"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:452:1: bindingValueList : ^( BINDING_VALUE ( bindingValue )* ) ;
	public final void bindingValueList() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:453:5: ( ^( BINDING_VALUE ( bindingValue )* ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:453:7: ^( BINDING_VALUE ( bindingValue )* )
			{
			match(input,BINDING_VALUE,FOLLOW_BINDING_VALUE_in_bindingValueList1835); 
			if ( input.LA(1)==Token.DOWN ) {
				match(input, Token.DOWN, null); 
				// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:453:23: ( bindingValue )*
				loop67:
				while (true) {
					int alt67=2;
					int LA67_0 = input.LA(1);
					if ( ((LA67_0 >= DECIMAL && LA67_0 <= DECIMAL_POSITIVE)||(LA67_0 >= DOUBLE && LA67_0 <= DOUBLE_POSITIVE)||LA67_0==FALSE||(LA67_0 >= INTEGER && LA67_0 <= INTEGER_POSITIVE)||LA67_0==IRI_REF||LA67_0==PLAIN_LITERAL||(LA67_0 >= PNAME_LN && LA67_0 <= PNAME_NS)||(LA67_0 >= TRUE && LA67_0 <= TYPED_LITERAL)||LA67_0==UNDEF) ) {
						alt67=1;
					}

					switch (alt67) {
					case 1 :
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:453:23: bindingValue
						{
						pushFollow(FOLLOW_bindingValue_in_bindingValueList1837);
						bindingValue();
						state._fsp--;

						}
						break;

					default :
						break loop67;
					}
				}

				match(input, Token.UP, null); 
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "bindingValueList"



	// $ANTLR start "bindingValue"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:456:1: bindingValue returns [Node value] : (a= iriRef |a= rdfLiteral | numericLiteral | booleanLiteral | UNDEF );
	public final Node bindingValue() throws RecognitionException {
		Node value = null;


		Node a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:457:5: (a= iriRef |a= rdfLiteral | numericLiteral | booleanLiteral | UNDEF )
			int alt68=5;
			switch ( input.LA(1) ) {
			case IRI_REF:
			case PNAME_LN:
			case PNAME_NS:
				{
				alt68=1;
				}
				break;
			case PLAIN_LITERAL:
			case TYPED_LITERAL:
				{
				alt68=2;
				}
				break;
			case DECIMAL:
			case DECIMAL_NEGATIVE:
			case DECIMAL_POSITIVE:
			case DOUBLE:
			case DOUBLE_NEGATIVE:
			case DOUBLE_POSITIVE:
			case INTEGER:
			case INTEGER_NEGATIVE:
			case INTEGER_POSITIVE:
				{
				alt68=3;
				}
				break;
			case FALSE:
			case TRUE:
				{
				alt68=4;
				}
				break;
			case UNDEF:
				{
				alt68=5;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 68, 0, input);
				throw nvae;
			}
			switch (alt68) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:457:7: a= iriRef
					{
					pushFollow(FOLLOW_iriRef_in_bindingValue1867);
					a=iriRef();
					state._fsp--;

					value =a;
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:458:7: a= rdfLiteral
					{
					pushFollow(FOLLOW_rdfLiteral_in_bindingValue1879);
					a=rdfLiteral();
					state._fsp--;

					value =a;
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:459:7: numericLiteral
					{
					pushFollow(FOLLOW_numericLiteral_in_bindingValue1889);
					numericLiteral();
					state._fsp--;

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:460:7: booleanLiteral
					{
					pushFollow(FOLLOW_booleanLiteral_in_bindingValue1897);
					booleanLiteral();
					state._fsp--;

					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:461:7: UNDEF
					{
					match(input,UNDEF,FOLLOW_UNDEF_in_bindingValue1905); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "bindingValue"



	// $ANTLR start "update"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:464:1: update : prologue ( load )* ( clear )* ( drop )* ( add )* ( move )* ( copy )* ( create )* ( insert )* ( delete )* ( modify )* ;
	public final void update() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:5: ( prologue ( load )* ( clear )* ( drop )* ( add )* ( move )* ( copy )* ( create )* ( insert )* ( delete )* ( modify )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:7: prologue ( load )* ( clear )* ( drop )* ( add )* ( move )* ( copy )* ( create )* ( insert )* ( delete )* ( modify )*
			{
			pushFollow(FOLLOW_prologue_in_update1926);
			prologue();
			state._fsp--;

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:16: ( load )*
			loop69:
			while (true) {
				int alt69=2;
				int LA69_0 = input.LA(1);
				if ( (LA69_0==LOAD) ) {
					alt69=1;
				}

				switch (alt69) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:16: load
					{
					pushFollow(FOLLOW_load_in_update1928);
					load();
					state._fsp--;

					}
					break;

				default :
					break loop69;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:22: ( clear )*
			loop70:
			while (true) {
				int alt70=2;
				int LA70_0 = input.LA(1);
				if ( (LA70_0==CLEAR) ) {
					alt70=1;
				}

				switch (alt70) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:22: clear
					{
					pushFollow(FOLLOW_clear_in_update1931);
					clear();
					state._fsp--;

					}
					break;

				default :
					break loop70;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:29: ( drop )*
			loop71:
			while (true) {
				int alt71=2;
				int LA71_0 = input.LA(1);
				if ( (LA71_0==DROP) ) {
					alt71=1;
				}

				switch (alt71) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:29: drop
					{
					pushFollow(FOLLOW_drop_in_update1934);
					drop();
					state._fsp--;

					}
					break;

				default :
					break loop71;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:35: ( add )*
			loop72:
			while (true) {
				int alt72=2;
				int LA72_0 = input.LA(1);
				if ( (LA72_0==ADD) ) {
					alt72=1;
				}

				switch (alt72) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:35: add
					{
					pushFollow(FOLLOW_add_in_update1937);
					add();
					state._fsp--;

					}
					break;

				default :
					break loop72;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:40: ( move )*
			loop73:
			while (true) {
				int alt73=2;
				int LA73_0 = input.LA(1);
				if ( (LA73_0==MOVE) ) {
					alt73=1;
				}

				switch (alt73) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:40: move
					{
					pushFollow(FOLLOW_move_in_update1940);
					move();
					state._fsp--;

					}
					break;

				default :
					break loop73;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:46: ( copy )*
			loop74:
			while (true) {
				int alt74=2;
				int LA74_0 = input.LA(1);
				if ( (LA74_0==COPY) ) {
					alt74=1;
				}

				switch (alt74) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:46: copy
					{
					pushFollow(FOLLOW_copy_in_update1943);
					copy();
					state._fsp--;

					}
					break;

				default :
					break loop74;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:52: ( create )*
			loop75:
			while (true) {
				int alt75=2;
				int LA75_0 = input.LA(1);
				if ( (LA75_0==CREATE) ) {
					alt75=1;
				}

				switch (alt75) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:52: create
					{
					pushFollow(FOLLOW_create_in_update1946);
					create();
					state._fsp--;

					}
					break;

				default :
					break loop75;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:60: ( insert )*
			loop76:
			while (true) {
				int alt76=2;
				int LA76_0 = input.LA(1);
				if ( (LA76_0==INSERT) ) {
					alt76=1;
				}

				switch (alt76) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:60: insert
					{
					pushFollow(FOLLOW_insert_in_update1949);
					insert();
					state._fsp--;

					}
					break;

				default :
					break loop76;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:68: ( delete )*
			loop77:
			while (true) {
				int alt77=2;
				int LA77_0 = input.LA(1);
				if ( (LA77_0==DELETE) ) {
					alt77=1;
				}

				switch (alt77) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:68: delete
					{
					pushFollow(FOLLOW_delete_in_update1952);
					delete();
					state._fsp--;

					}
					break;

				default :
					break loop77;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:76: ( modify )*
			loop78:
			while (true) {
				int alt78=2;
				int LA78_0 = input.LA(1);
				if ( (LA78_0==MODIFY) ) {
					alt78=1;
				}

				switch (alt78) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:76: modify
					{
					pushFollow(FOLLOW_modify_in_update1955);
					modify();
					state._fsp--;

					}
					break;

				default :
					break loop78;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "update"



	// $ANTLR start "load"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:468:1: load : ^( LOAD ( SILENT )* iriRef ( graphRef )* ) ;
	public final void load() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:469:5: ( ^( LOAD ( SILENT )* iriRef ( graphRef )* ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:469:7: ^( LOAD ( SILENT )* iriRef ( graphRef )* )
			{
			match(input,LOAD,FOLLOW_LOAD_in_load1985); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:469:14: ( SILENT )*
			loop79:
			while (true) {
				int alt79=2;
				int LA79_0 = input.LA(1);
				if ( (LA79_0==SILENT) ) {
					alt79=1;
				}

				switch (alt79) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:469:14: SILENT
					{
					match(input,SILENT,FOLLOW_SILENT_in_load1987); 
					}
					break;

				default :
					break loop79;
				}
			}

			pushFollow(FOLLOW_iriRef_in_load1990);
			iriRef();
			state._fsp--;

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:469:29: ( graphRef )*
			loop80:
			while (true) {
				int alt80=2;
				int LA80_0 = input.LA(1);
				if ( (LA80_0==GRAPH) ) {
					alt80=1;
				}

				switch (alt80) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:469:29: graphRef
					{
					pushFollow(FOLLOW_graphRef_in_load1992);
					graphRef();
					state._fsp--;

					}
					break;

				default :
					break loop80;
				}
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "load"



	// $ANTLR start "clear"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:472:1: clear : ^( CLEAR ( SILENT )* graphRefAll ) ;
	public final void clear() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:473:5: ( ^( CLEAR ( SILENT )* graphRefAll ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:473:7: ^( CLEAR ( SILENT )* graphRefAll )
			{
			match(input,CLEAR,FOLLOW_CLEAR_in_clear2016); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:473:15: ( SILENT )*
			loop81:
			while (true) {
				int alt81=2;
				int LA81_0 = input.LA(1);
				if ( (LA81_0==SILENT) ) {
					alt81=1;
				}

				switch (alt81) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:473:15: SILENT
					{
					match(input,SILENT,FOLLOW_SILENT_in_clear2018); 
					}
					break;

				default :
					break loop81;
				}
			}

			pushFollow(FOLLOW_graphRefAll_in_clear2021);
			graphRefAll();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "clear"



	// $ANTLR start "drop"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:476:1: drop : ^( DROP ( SILENT )* graphRefAll ) ;
	public final void drop() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:477:5: ( ^( DROP ( SILENT )* graphRefAll ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:477:7: ^( DROP ( SILENT )* graphRefAll )
			{
			match(input,DROP,FOLLOW_DROP_in_drop2044); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:477:14: ( SILENT )*
			loop82:
			while (true) {
				int alt82=2;
				int LA82_0 = input.LA(1);
				if ( (LA82_0==SILENT) ) {
					alt82=1;
				}

				switch (alt82) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:477:14: SILENT
					{
					match(input,SILENT,FOLLOW_SILENT_in_drop2046); 
					}
					break;

				default :
					break loop82;
				}
			}

			pushFollow(FOLLOW_graphRefAll_in_drop2049);
			graphRefAll();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "drop"



	// $ANTLR start "create"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:480:1: create : ^( CREATE ( SILENT )* graphRef ) ;
	public final void create() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:481:5: ( ^( CREATE ( SILENT )* graphRef ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:481:7: ^( CREATE ( SILENT )* graphRef )
			{
			match(input,CREATE,FOLLOW_CREATE_in_create2069); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:481:16: ( SILENT )*
			loop83:
			while (true) {
				int alt83=2;
				int LA83_0 = input.LA(1);
				if ( (LA83_0==SILENT) ) {
					alt83=1;
				}

				switch (alt83) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:481:16: SILENT
					{
					match(input,SILENT,FOLLOW_SILENT_in_create2071); 
					}
					break;

				default :
					break loop83;
				}
			}

			pushFollow(FOLLOW_graphRef_in_create2074);
			graphRef();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "create"



	// $ANTLR start "add"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:484:1: add : ^( ADD ( SILENT )* graphOrDefault graphOrDefault ) ;
	public final void add() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:485:5: ( ^( ADD ( SILENT )* graphOrDefault graphOrDefault ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:485:7: ^( ADD ( SILENT )* graphOrDefault graphOrDefault )
			{
			match(input,ADD,FOLLOW_ADD_in_add2097); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:485:13: ( SILENT )*
			loop84:
			while (true) {
				int alt84=2;
				int LA84_0 = input.LA(1);
				if ( (LA84_0==SILENT) ) {
					alt84=1;
				}

				switch (alt84) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:485:13: SILENT
					{
					match(input,SILENT,FOLLOW_SILENT_in_add2099); 
					}
					break;

				default :
					break loop84;
				}
			}

			pushFollow(FOLLOW_graphOrDefault_in_add2102);
			graphOrDefault();
			state._fsp--;

			pushFollow(FOLLOW_graphOrDefault_in_add2104);
			graphOrDefault();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "add"



	// $ANTLR start "move"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:488:1: move : ^( MOVE ( SILENT )* graphOrDefault graphOrDefault ) ;
	public final void move() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:489:5: ( ^( MOVE ( SILENT )* graphOrDefault graphOrDefault ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:489:7: ^( MOVE ( SILENT )* graphOrDefault graphOrDefault )
			{
			match(input,MOVE,FOLLOW_MOVE_in_move2127); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:489:14: ( SILENT )*
			loop85:
			while (true) {
				int alt85=2;
				int LA85_0 = input.LA(1);
				if ( (LA85_0==SILENT) ) {
					alt85=1;
				}

				switch (alt85) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:489:14: SILENT
					{
					match(input,SILENT,FOLLOW_SILENT_in_move2129); 
					}
					break;

				default :
					break loop85;
				}
			}

			pushFollow(FOLLOW_graphOrDefault_in_move2132);
			graphOrDefault();
			state._fsp--;

			pushFollow(FOLLOW_graphOrDefault_in_move2134);
			graphOrDefault();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "move"



	// $ANTLR start "copy"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:492:1: copy : ^( COPY ( SILENT )* graphOrDefault graphOrDefault ) ;
	public final void copy() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:493:5: ( ^( COPY ( SILENT )* graphOrDefault graphOrDefault ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:493:7: ^( COPY ( SILENT )* graphOrDefault graphOrDefault )
			{
			match(input,COPY,FOLLOW_COPY_in_copy2157); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:493:14: ( SILENT )*
			loop86:
			while (true) {
				int alt86=2;
				int LA86_0 = input.LA(1);
				if ( (LA86_0==SILENT) ) {
					alt86=1;
				}

				switch (alt86) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:493:14: SILENT
					{
					match(input,SILENT,FOLLOW_SILENT_in_copy2159); 
					}
					break;

				default :
					break loop86;
				}
			}

			pushFollow(FOLLOW_graphOrDefault_in_copy2162);
			graphOrDefault();
			state._fsp--;

			pushFollow(FOLLOW_graphOrDefault_in_copy2164);
			graphOrDefault();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "copy"



	// $ANTLR start "insert"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:496:1: insert : ^( INSERT DATA quadPattern ) ;
	public final void insert() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:497:5: ( ^( INSERT DATA quadPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:497:7: ^( INSERT DATA quadPattern )
			{
			match(input,INSERT,FOLLOW_INSERT_in_insert2183); 
			match(input, Token.DOWN, null); 
			match(input,DATA,FOLLOW_DATA_in_insert2185); 
			pushFollow(FOLLOW_quadPattern_in_insert2187);
			quadPattern();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "insert"



	// $ANTLR start "delete"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:500:1: delete : DELETE ( deleteData | deleteWhere ) ;
	public final void delete() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:501:5: ( DELETE ( deleteData | deleteWhere ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:501:7: DELETE ( deleteData | deleteWhere )
			{
			match(input,DELETE,FOLLOW_DELETE_in_delete2212); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:501:14: ( deleteData | deleteWhere )
			int alt87=2;
			int LA87_0 = input.LA(1);
			if ( (LA87_0==DELETE) ) {
				int LA87_1 = input.LA(2);
				if ( (LA87_1==DOWN) ) {
					int LA87_2 = input.LA(3);
					if ( (LA87_2==DATA) ) {
						alt87=1;
					}
					else if ( (LA87_2==WHERE) ) {
						alt87=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 87, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 87, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 87, 0, input);
				throw nvae;
			}

			switch (alt87) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:501:16: deleteData
					{
					pushFollow(FOLLOW_deleteData_in_delete2216);
					deleteData();
					state._fsp--;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:501:29: deleteWhere
					{
					pushFollow(FOLLOW_deleteWhere_in_delete2220);
					deleteWhere();
					state._fsp--;

					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "delete"



	// $ANTLR start "deleteData"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:504:1: deleteData : ^( DELETE DATA quadPattern ) ;
	public final void deleteData() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:505:5: ( ^( DELETE DATA quadPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:505:7: ^( DELETE DATA quadPattern )
			{
			match(input,DELETE,FOLLOW_DELETE_in_deleteData2240); 
			match(input, Token.DOWN, null); 
			match(input,DATA,FOLLOW_DATA_in_deleteData2242); 
			pushFollow(FOLLOW_quadPattern_in_deleteData2244);
			quadPattern();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "deleteData"



	// $ANTLR start "deleteWhere"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:508:1: deleteWhere : ^( DELETE WHERE quadPattern ) ;
	public final void deleteWhere() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:509:5: ( ^( DELETE WHERE quadPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:509:7: ^( DELETE WHERE quadPattern )
			{
			match(input,DELETE,FOLLOW_DELETE_in_deleteWhere2263); 
			match(input, Token.DOWN, null); 
			match(input,WHERE,FOLLOW_WHERE_in_deleteWhere2265); 
			pushFollow(FOLLOW_quadPattern_in_deleteWhere2267);
			quadPattern();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "deleteWhere"



	// $ANTLR start "modify"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:512:1: modify : ( ^( MODIFY ^( WITH iriRef ) ( deleteClause )* ( insertClause )* ( usingClause )* ^( WHERE groupGraphPattern ) ) | ^( MODIFY ( deleteClause )* ( insertClause )* ( usingClause )* ^( WHERE groupGraphPattern ) ) );
	public final void modify() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:513:5: ( ^( MODIFY ^( WITH iriRef ) ( deleteClause )* ( insertClause )* ( usingClause )* ^( WHERE groupGraphPattern ) ) | ^( MODIFY ( deleteClause )* ( insertClause )* ( usingClause )* ^( WHERE groupGraphPattern ) ) )
			int alt94=2;
			int LA94_0 = input.LA(1);
			if ( (LA94_0==MODIFY) ) {
				int LA94_1 = input.LA(2);
				if ( (LA94_1==DOWN) ) {
					int LA94_2 = input.LA(3);
					if ( (LA94_2==WITH) ) {
						alt94=1;
					}
					else if ( (LA94_2==DELETE||LA94_2==INSERT||LA94_2==USING||LA94_2==WHERE) ) {
						alt94=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 94, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 94, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 94, 0, input);
				throw nvae;
			}

			switch (alt94) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:513:7: ^( MODIFY ^( WITH iriRef ) ( deleteClause )* ( insertClause )* ( usingClause )* ^( WHERE groupGraphPattern ) )
					{
					match(input,MODIFY,FOLLOW_MODIFY_in_modify2290); 
					match(input, Token.DOWN, null); 
					match(input,WITH,FOLLOW_WITH_in_modify2293); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_iriRef_in_modify2295);
					iriRef();
					state._fsp--;

					match(input, Token.UP, null); 

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:513:31: ( deleteClause )*
					loop88:
					while (true) {
						int alt88=2;
						int LA88_0 = input.LA(1);
						if ( (LA88_0==DELETE) ) {
							alt88=1;
						}

						switch (alt88) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:513:31: deleteClause
							{
							pushFollow(FOLLOW_deleteClause_in_modify2298);
							deleteClause();
							state._fsp--;

							}
							break;

						default :
							break loop88;
						}
					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:513:45: ( insertClause )*
					loop89:
					while (true) {
						int alt89=2;
						int LA89_0 = input.LA(1);
						if ( (LA89_0==INSERT) ) {
							alt89=1;
						}

						switch (alt89) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:513:45: insertClause
							{
							pushFollow(FOLLOW_insertClause_in_modify2301);
							insertClause();
							state._fsp--;

							}
							break;

						default :
							break loop89;
						}
					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:513:59: ( usingClause )*
					loop90:
					while (true) {
						int alt90=2;
						int LA90_0 = input.LA(1);
						if ( (LA90_0==USING) ) {
							alt90=1;
						}

						switch (alt90) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:513:59: usingClause
							{
							pushFollow(FOLLOW_usingClause_in_modify2304);
							usingClause();
							state._fsp--;

							}
							break;

						default :
							break loop90;
						}
					}

					match(input,WHERE,FOLLOW_WHERE_in_modify2308); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_groupGraphPattern_in_modify2310);
					groupGraphPattern();
					state._fsp--;

					match(input, Token.UP, null); 

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:514:7: ^( MODIFY ( deleteClause )* ( insertClause )* ( usingClause )* ^( WHERE groupGraphPattern ) )
					{
					match(input,MODIFY,FOLLOW_MODIFY_in_modify2321); 
					match(input, Token.DOWN, null); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:514:16: ( deleteClause )*
					loop91:
					while (true) {
						int alt91=2;
						int LA91_0 = input.LA(1);
						if ( (LA91_0==DELETE) ) {
							alt91=1;
						}

						switch (alt91) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:514:16: deleteClause
							{
							pushFollow(FOLLOW_deleteClause_in_modify2323);
							deleteClause();
							state._fsp--;

							}
							break;

						default :
							break loop91;
						}
					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:514:30: ( insertClause )*
					loop92:
					while (true) {
						int alt92=2;
						int LA92_0 = input.LA(1);
						if ( (LA92_0==INSERT) ) {
							alt92=1;
						}

						switch (alt92) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:514:30: insertClause
							{
							pushFollow(FOLLOW_insertClause_in_modify2326);
							insertClause();
							state._fsp--;

							}
							break;

						default :
							break loop92;
						}
					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:514:44: ( usingClause )*
					loop93:
					while (true) {
						int alt93=2;
						int LA93_0 = input.LA(1);
						if ( (LA93_0==USING) ) {
							alt93=1;
						}

						switch (alt93) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:514:44: usingClause
							{
							pushFollow(FOLLOW_usingClause_in_modify2329);
							usingClause();
							state._fsp--;

							}
							break;

						default :
							break loop93;
						}
					}

					match(input,WHERE,FOLLOW_WHERE_in_modify2333); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_groupGraphPattern_in_modify2335);
					groupGraphPattern();
					state._fsp--;

					match(input, Token.UP, null); 

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "modify"



	// $ANTLR start "deleteClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:1: deleteClause : DELETE quadPattern ;
	public final void deleteClause() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:518:5: ( DELETE quadPattern )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:518:7: DELETE quadPattern
			{
			match(input,DELETE,FOLLOW_DELETE_in_deleteClause2356); 
			pushFollow(FOLLOW_quadPattern_in_deleteClause2358);
			quadPattern();
			state._fsp--;

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "deleteClause"



	// $ANTLR start "insertClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:521:1: insertClause : INSERT quadPattern ;
	public final void insertClause() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:522:5: ( INSERT quadPattern )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:522:7: INSERT quadPattern
			{
			match(input,INSERT,FOLLOW_INSERT_in_insertClause2381); 
			pushFollow(FOLLOW_quadPattern_in_insertClause2383);
			quadPattern();
			state._fsp--;

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "insertClause"



	// $ANTLR start "usingClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:525:1: usingClause : ^( USING ( NAMED )? iriRef ) ;
	public final void usingClause() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:526:5: ( ^( USING ( NAMED )? iriRef ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:526:7: ^( USING ( NAMED )? iriRef )
			{
			match(input,USING,FOLLOW_USING_in_usingClause2401); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:526:15: ( NAMED )?
			int alt95=2;
			int LA95_0 = input.LA(1);
			if ( (LA95_0==NAMED) ) {
				alt95=1;
			}
			switch (alt95) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:526:15: NAMED
					{
					match(input,NAMED,FOLLOW_NAMED_in_usingClause2403); 
					}
					break;

			}

			pushFollow(FOLLOW_iriRef_in_usingClause2406);
			iriRef();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "usingClause"



	// $ANTLR start "graphOrDefault"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:529:1: graphOrDefault : ( DEFAULT | ( GRAPH )? iriRef );
	public final void graphOrDefault() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:530:5: ( DEFAULT | ( GRAPH )? iriRef )
			int alt97=2;
			int LA97_0 = input.LA(1);
			if ( (LA97_0==DEFAULT) ) {
				alt97=1;
			}
			else if ( (LA97_0==GRAPH||LA97_0==IRI_REF||(LA97_0 >= PNAME_LN && LA97_0 <= PNAME_NS)) ) {
				alt97=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 97, 0, input);
				throw nvae;
			}

			switch (alt97) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:530:7: DEFAULT
					{
					match(input,DEFAULT,FOLLOW_DEFAULT_in_graphOrDefault2427); 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:531:7: ( GRAPH )? iriRef
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:531:7: ( GRAPH )?
					int alt96=2;
					int LA96_0 = input.LA(1);
					if ( (LA96_0==GRAPH) ) {
						alt96=1;
					}
					switch (alt96) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:531:7: GRAPH
							{
							match(input,GRAPH,FOLLOW_GRAPH_in_graphOrDefault2436); 
							}
							break;

					}

					pushFollow(FOLLOW_iriRef_in_graphOrDefault2439);
					iriRef();
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "graphOrDefault"



	// $ANTLR start "graphRef"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:534:1: graphRef : GRAPH iriRef ;
	public final void graphRef() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:535:5: ( GRAPH iriRef )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:535:7: GRAPH iriRef
			{
			match(input,GRAPH,FOLLOW_GRAPH_in_graphRef2466); 
			pushFollow(FOLLOW_iriRef_in_graphRef2468);
			iriRef();
			state._fsp--;

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "graphRef"



	// $ANTLR start "graphRefAll"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:538:1: graphRefAll : ( graphRef | DEFAULT | NAMED | ALL );
	public final void graphRefAll() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:539:5: ( graphRef | DEFAULT | NAMED | ALL )
			int alt98=4;
			switch ( input.LA(1) ) {
			case GRAPH:
				{
				alt98=1;
				}
				break;
			case DEFAULT:
				{
				alt98=2;
				}
				break;
			case NAMED:
				{
				alt98=3;
				}
				break;
			case ALL:
				{
				alt98=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 98, 0, input);
				throw nvae;
			}
			switch (alt98) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:539:7: graphRef
					{
					pushFollow(FOLLOW_graphRef_in_graphRefAll2485);
					graphRef();
					state._fsp--;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:539:18: DEFAULT
					{
					match(input,DEFAULT,FOLLOW_DEFAULT_in_graphRefAll2489); 
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:539:28: NAMED
					{
					match(input,NAMED,FOLLOW_NAMED_in_graphRefAll2493); 
					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:539:36: ALL
					{
					match(input,ALL,FOLLOW_ALL_in_graphRefAll2497); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "graphRefAll"



	// $ANTLR start "quadPattern"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:542:1: quadPattern returns [QuadPattern value] : a= quads ;
	public final QuadPattern quadPattern() throws RecognitionException {
		QuadPattern value = null;


		QuadPattern a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:543:5: (a= quads )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:543:7: a= quads
			{
			pushFollow(FOLLOW_quads_in_quadPattern2520);
			a=quads();
			state._fsp--;

			value = a;
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "quadPattern"



	// $ANTLR start "quads"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:546:1: quads returns [QuadPattern value] : (a= triplesTemplate )? ( quadsNotTriples[$value] (c= triplesTemplate )? )* ;
	public final QuadPattern quads() throws RecognitionException {
		QuadPattern value = null;


		BasicPattern a =null;
		BasicPattern c =null;

		value = new QuadPattern();
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:548:5: ( (a= triplesTemplate )? ( quadsNotTriples[$value] (c= triplesTemplate )? )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:548:7: (a= triplesTemplate )? ( quadsNotTriples[$value] (c= triplesTemplate )? )*
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:548:7: (a= triplesTemplate )?
			int alt99=2;
			int LA99_0 = input.LA(1);
			if ( (LA99_0==TRIPLES_TEMPLATE) ) {
				alt99=1;
			}
			switch (alt99) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:548:8: a= triplesTemplate
					{
					pushFollow(FOLLOW_triplesTemplate_in_quads2557);
					a=triplesTemplate();
					state._fsp--;

					value.addAll(QuadPatternUtils.toQuadPattern(a));
					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:548:87: ( quadsNotTriples[$value] (c= triplesTemplate )? )*
			loop101:
			while (true) {
				int alt101=2;
				int LA101_0 = input.LA(1);
				if ( (LA101_0==GRAPH_TOKEN) ) {
					alt101=1;
				}

				switch (alt101) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:548:89: quadsNotTriples[$value] (c= triplesTemplate )?
					{
					pushFollow(FOLLOW_quadsNotTriples_in_quads2565);
					quadsNotTriples(value);
					state._fsp--;

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:548:113: (c= triplesTemplate )?
					int alt100=2;
					int LA100_0 = input.LA(1);
					if ( (LA100_0==TRIPLES_TEMPLATE) ) {
						alt100=1;
					}
					switch (alt100) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:548:114: c= triplesTemplate
							{
							pushFollow(FOLLOW_triplesTemplate_in_quads2571);
							c=triplesTemplate();
							state._fsp--;

							value.addAll(QuadPatternUtils.toQuadPattern(c));
							}
							break;

					}

					}
					break;

				default :
					break loop101;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "quads"



	// $ANTLR start "quadsNotTriples"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:551:1: quadsNotTriples[QuadPattern value] : ^( GRAPH_TOKEN a= varOrIRIref (b= triplesTemplate )? ) ;
	public final void quadsNotTriples(QuadPattern value) throws RecognitionException {
		Node a =null;
		BasicPattern b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:553:5: ( ^( GRAPH_TOKEN a= varOrIRIref (b= triplesTemplate )? ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:553:7: ^( GRAPH_TOKEN a= varOrIRIref (b= triplesTemplate )? )
			{
			match(input,GRAPH_TOKEN,FOLLOW_GRAPH_TOKEN_in_quadsNotTriples2608); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_varOrIRIref_in_quadsNotTriples2612);
			a=varOrIRIref();
			state._fsp--;

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:553:36: (b= triplesTemplate )?
			int alt102=2;
			int LA102_0 = input.LA(1);
			if ( (LA102_0==TRIPLES_TEMPLATE) ) {
				alt102=1;
			}
			switch (alt102) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:553:36: b= triplesTemplate
					{
					pushFollow(FOLLOW_triplesTemplate_in_quadsNotTriples2616);
					b=triplesTemplate();
					state._fsp--;

					}
					break;

			}

			match(input, Token.UP, null); 

			value.addAll(QuadPatternUtils.toQuadPattern(a, b));
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "quadsNotTriples"



	// $ANTLR start "triplesTemplate"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:563:1: triplesTemplate returns [BasicPattern value] : ^( TRIPLES_TEMPLATE a= triples ) ;
	public final BasicPattern triplesTemplate() throws RecognitionException {
		BasicPattern value = null;


		BasicPattern a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:564:5: ( ^( TRIPLES_TEMPLATE a= triples ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:564:7: ^( TRIPLES_TEMPLATE a= triples )
			{
			match(input,TRIPLES_TEMPLATE,FOLLOW_TRIPLES_TEMPLATE_in_triplesTemplate2645); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_triples_in_triplesTemplate2649);
			a=triples();
			state._fsp--;

			value = a;
			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "triplesTemplate"



	// $ANTLR start "groupGraphPattern"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:567:1: groupGraphPattern : ( ^( GROUP_GRAPH_PATTERN subSelect ) | ^( GROUP_GRAPH_PATTERN groupGraphPatternSub ) );
	public final void groupGraphPattern() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:568:5: ( ^( GROUP_GRAPH_PATTERN subSelect ) | ^( GROUP_GRAPH_PATTERN groupGraphPatternSub ) )
			int alt103=2;
			int LA103_0 = input.LA(1);
			if ( (LA103_0==GROUP_GRAPH_PATTERN) ) {
				int LA103_1 = input.LA(2);
				if ( (LA103_1==DOWN) ) {
					int LA103_2 = input.LA(3);
					if ( (LA103_2==SUBSELECT) ) {
						alt103=1;
					}
					else if ( (LA103_2==UP||LA103_2==BIND||LA103_2==FILTER||LA103_2==GRAPH||LA103_2==GROUP_GRAPH_PATTERN||LA103_2==MINUS_KEYWORD||LA103_2==OPTIONAL||LA103_2==SERVICE||LA103_2==TRIPLES_BLOCK||LA103_2==UNION) ) {
						alt103=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 103, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 103, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 103, 0, input);
				throw nvae;
			}

			switch (alt103) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:568:7: ^( GROUP_GRAPH_PATTERN subSelect )
					{
					match(input,GROUP_GRAPH_PATTERN,FOLLOW_GROUP_GRAPH_PATTERN_in_groupGraphPattern2675); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_subSelect_in_groupGraphPattern2677);
					subSelect();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:569:7: ^( GROUP_GRAPH_PATTERN groupGraphPatternSub )
					{
					match(input,GROUP_GRAPH_PATTERN,FOLLOW_GROUP_GRAPH_PATTERN_in_groupGraphPattern2687); 
					if ( input.LA(1)==Token.DOWN ) {
						match(input, Token.DOWN, null); 
						pushFollow(FOLLOW_groupGraphPatternSub_in_groupGraphPattern2689);
						groupGraphPatternSub();
						state._fsp--;

						match(input, Token.UP, null); 
					}

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "groupGraphPattern"



	// $ANTLR start "groupGraphPatternSub"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:572:1: groupGraphPatternSub : ( triplesBlock )? ( groupGraphPatternSubCache )* ;
	public final void groupGraphPatternSub() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:573:5: ( ( triplesBlock )? ( groupGraphPatternSubCache )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:573:7: ( triplesBlock )? ( groupGraphPatternSubCache )*
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:573:7: ( triplesBlock )?
			int alt104=2;
			int LA104_0 = input.LA(1);
			if ( (LA104_0==TRIPLES_BLOCK) ) {
				alt104=1;
			}
			switch (alt104) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:573:7: triplesBlock
					{
					pushFollow(FOLLOW_triplesBlock_in_groupGraphPatternSub2711);
					triplesBlock();
					state._fsp--;

					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:573:21: ( groupGraphPatternSubCache )*
			loop105:
			while (true) {
				int alt105=2;
				int LA105_0 = input.LA(1);
				if ( (LA105_0==BIND||LA105_0==FILTER||LA105_0==GRAPH||LA105_0==GROUP_GRAPH_PATTERN||LA105_0==MINUS_KEYWORD||LA105_0==OPTIONAL||LA105_0==SERVICE||LA105_0==UNION) ) {
					alt105=1;
				}

				switch (alt105) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:573:21: groupGraphPatternSubCache
					{
					pushFollow(FOLLOW_groupGraphPatternSubCache_in_groupGraphPatternSub2714);
					groupGraphPatternSubCache();
					state._fsp--;

					}
					break;

				default :
					break loop105;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "groupGraphPatternSub"



	// $ANTLR start "groupGraphPatternSubCache"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:576:1: groupGraphPatternSubCache : graphPatternNotTriples ( triplesBlock )? ;
	public final void groupGraphPatternSubCache() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:577:5: ( graphPatternNotTriples ( triplesBlock )? )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:577:8: graphPatternNotTriples ( triplesBlock )?
			{
			pushFollow(FOLLOW_graphPatternNotTriples_in_groupGraphPatternSubCache2737);
			graphPatternNotTriples();
			state._fsp--;

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:577:31: ( triplesBlock )?
			int alt106=2;
			int LA106_0 = input.LA(1);
			if ( (LA106_0==TRIPLES_BLOCK) ) {
				alt106=1;
			}
			switch (alt106) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:577:31: triplesBlock
					{
					pushFollow(FOLLOW_triplesBlock_in_groupGraphPatternSubCache2739);
					triplesBlock();
					state._fsp--;

					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "groupGraphPatternSubCache"



	// $ANTLR start "triplesBlock"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:580:1: triplesBlock : ^( TRIPLES_BLOCK ( triplesSameSubjectPath[null] )+ ) ;
	public final void triplesBlock() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:581:5: ( ^( TRIPLES_BLOCK ( triplesSameSubjectPath[null] )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:581:7: ^( TRIPLES_BLOCK ( triplesSameSubjectPath[null] )+ )
			{
			match(input,TRIPLES_BLOCK,FOLLOW_TRIPLES_BLOCK_in_triplesBlock2758); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:581:23: ( triplesSameSubjectPath[null] )+
			int cnt107=0;
			loop107:
			while (true) {
				int alt107=2;
				int LA107_0 = input.LA(1);
				if ( (LA107_0==TRIPLE) ) {
					alt107=1;
				}

				switch (alt107) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:581:23: triplesSameSubjectPath[null]
					{
					pushFollow(FOLLOW_triplesSameSubjectPath_in_triplesBlock2760);
					triplesSameSubjectPath(null);
					state._fsp--;

					}
					break;

				default :
					if ( cnt107 >= 1 ) break loop107;
					EarlyExitException eee = new EarlyExitException(107, input);
					throw eee;
				}
				cnt107++;
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "triplesBlock"



	// $ANTLR start "graphPatternNotTriples"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:584:1: graphPatternNotTriples : ( groupOrUnionGraphPattern | optionalGraphPattern | minusGraphPattern | graphGraphPattern | serviceGraphPattern | filter | bind );
	public final void graphPatternNotTriples() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:585:5: ( groupOrUnionGraphPattern | optionalGraphPattern | minusGraphPattern | graphGraphPattern | serviceGraphPattern | filter | bind )
			int alt108=7;
			switch ( input.LA(1) ) {
			case GROUP_GRAPH_PATTERN:
			case UNION:
				{
				alt108=1;
				}
				break;
			case OPTIONAL:
				{
				alt108=2;
				}
				break;
			case MINUS_KEYWORD:
				{
				alt108=3;
				}
				break;
			case GRAPH:
				{
				alt108=4;
				}
				break;
			case SERVICE:
				{
				alt108=5;
				}
				break;
			case FILTER:
				{
				alt108=6;
				}
				break;
			case BIND:
				{
				alt108=7;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 108, 0, input);
				throw nvae;
			}
			switch (alt108) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:585:7: groupOrUnionGraphPattern
					{
					pushFollow(FOLLOW_groupOrUnionGraphPattern_in_graphPatternNotTriples2780);
					groupOrUnionGraphPattern();
					state._fsp--;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:585:34: optionalGraphPattern
					{
					pushFollow(FOLLOW_optionalGraphPattern_in_graphPatternNotTriples2784);
					optionalGraphPattern();
					state._fsp--;

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:585:57: minusGraphPattern
					{
					pushFollow(FOLLOW_minusGraphPattern_in_graphPatternNotTriples2788);
					minusGraphPattern();
					state._fsp--;

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:585:77: graphGraphPattern
					{
					pushFollow(FOLLOW_graphGraphPattern_in_graphPatternNotTriples2792);
					graphGraphPattern();
					state._fsp--;

					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:585:97: serviceGraphPattern
					{
					pushFollow(FOLLOW_serviceGraphPattern_in_graphPatternNotTriples2796);
					serviceGraphPattern();
					state._fsp--;

					}
					break;
				case 6 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:585:119: filter
					{
					pushFollow(FOLLOW_filter_in_graphPatternNotTriples2800);
					filter();
					state._fsp--;

					}
					break;
				case 7 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:585:128: bind
					{
					pushFollow(FOLLOW_bind_in_graphPatternNotTriples2804);
					bind();
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "graphPatternNotTriples"



	// $ANTLR start "optionalGraphPattern"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:588:1: optionalGraphPattern : ^( OPTIONAL groupGraphPattern ) ;
	public final void optionalGraphPattern() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:589:5: ( ^( OPTIONAL groupGraphPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:589:7: ^( OPTIONAL groupGraphPattern )
			{
			match(input,OPTIONAL,FOLLOW_OPTIONAL_in_optionalGraphPattern2822); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_groupGraphPattern_in_optionalGraphPattern2824);
			groupGraphPattern();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "optionalGraphPattern"



	// $ANTLR start "graphGraphPattern"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:592:1: graphGraphPattern : ^( GRAPH varOrIRIref groupGraphPattern ) ;
	public final void graphGraphPattern() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:593:5: ( ^( GRAPH varOrIRIref groupGraphPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:593:7: ^( GRAPH varOrIRIref groupGraphPattern )
			{
			match(input,GRAPH,FOLLOW_GRAPH_in_graphGraphPattern2843); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_varOrIRIref_in_graphGraphPattern2845);
			varOrIRIref();
			state._fsp--;

			pushFollow(FOLLOW_groupGraphPattern_in_graphGraphPattern2847);
			groupGraphPattern();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "graphGraphPattern"



	// $ANTLR start "serviceGraphPattern"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:596:1: serviceGraphPattern : ^( SERVICE ( SILENT )? varOrIRIref groupGraphPattern ) ;
	public final void serviceGraphPattern() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:597:5: ( ^( SERVICE ( SILENT )? varOrIRIref groupGraphPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:597:7: ^( SERVICE ( SILENT )? varOrIRIref groupGraphPattern )
			{
			match(input,SERVICE,FOLLOW_SERVICE_in_serviceGraphPattern2866); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:597:17: ( SILENT )?
			int alt109=2;
			int LA109_0 = input.LA(1);
			if ( (LA109_0==SILENT) ) {
				alt109=1;
			}
			switch (alt109) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:597:17: SILENT
					{
					match(input,SILENT,FOLLOW_SILENT_in_serviceGraphPattern2868); 
					}
					break;

			}

			pushFollow(FOLLOW_varOrIRIref_in_serviceGraphPattern2871);
			varOrIRIref();
			state._fsp--;

			pushFollow(FOLLOW_groupGraphPattern_in_serviceGraphPattern2873);
			groupGraphPattern();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "serviceGraphPattern"



	// $ANTLR start "bind"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:600:1: bind : ^( BIND expression ^( AS var ) ) ;
	public final void bind() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:601:5: ( ^( BIND expression ^( AS var ) ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:601:7: ^( BIND expression ^( AS var ) )
			{
			match(input,BIND,FOLLOW_BIND_in_bind2896); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_expression_in_bind2898);
			expression();
			state._fsp--;

			match(input,AS,FOLLOW_AS_in_bind2901); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_var_in_bind2903);
			var();
			state._fsp--;

			match(input, Token.UP, null); 

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "bind"



	// $ANTLR start "minusGraphPattern"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:604:1: minusGraphPattern : ^( MINUS_KEYWORD groupGraphPattern ) ;
	public final void minusGraphPattern() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:605:5: ( ^( MINUS_KEYWORD groupGraphPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:605:7: ^( MINUS_KEYWORD groupGraphPattern )
			{
			match(input,MINUS_KEYWORD,FOLLOW_MINUS_KEYWORD_in_minusGraphPattern2929); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_groupGraphPattern_in_minusGraphPattern2931);
			groupGraphPattern();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "minusGraphPattern"



	// $ANTLR start "groupOrUnionGraphPattern"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:608:1: groupOrUnionGraphPattern : ( ^( UNION groupGraphPattern groupGraphPattern ) | groupGraphPattern );
	public final void groupOrUnionGraphPattern() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:609:5: ( ^( UNION groupGraphPattern groupGraphPattern ) | groupGraphPattern )
			int alt110=2;
			int LA110_0 = input.LA(1);
			if ( (LA110_0==UNION) ) {
				alt110=1;
			}
			else if ( (LA110_0==GROUP_GRAPH_PATTERN) ) {
				alt110=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 110, 0, input);
				throw nvae;
			}

			switch (alt110) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:609:7: ^( UNION groupGraphPattern groupGraphPattern )
					{
					match(input,UNION,FOLLOW_UNION_in_groupOrUnionGraphPattern2950); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_groupGraphPattern_in_groupOrUnionGraphPattern2952);
					groupGraphPattern();
					state._fsp--;

					pushFollow(FOLLOW_groupGraphPattern_in_groupOrUnionGraphPattern2954);
					groupGraphPattern();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:610:7: groupGraphPattern
					{
					pushFollow(FOLLOW_groupGraphPattern_in_groupOrUnionGraphPattern2963);
					groupGraphPattern();
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "groupOrUnionGraphPattern"



	// $ANTLR start "filter"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:613:1: filter : ^( FILTER constraint ) ;
	public final void filter() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:614:5: ( ^( FILTER constraint ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:614:7: ^( FILTER constraint )
			{
			match(input,FILTER,FOLLOW_FILTER_in_filter2981); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_constraint_in_filter2983);
			constraint();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "filter"



	// $ANTLR start "constraint"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:617:1: constraint : ( expression | builtInCall | functionCall );
	public final void constraint() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:618:5: ( expression | builtInCall | functionCall )
			int alt111=3;
			switch ( input.LA(1) ) {
			case AND:
			case ASTERISK:
			case DIVIDE:
			case EQUAL:
			case GREATER:
			case GREATER_EQUAL:
			case IN:
			case LESS:
			case LESS_EQUAL:
			case MINUS:
			case NOT:
			case NOT_EQUAL:
			case OR:
			case PLUS:
			case UNARY:
			case UNARY_MINUS:
			case UNARY_NOT:
			case UNARY_PLUS:
				{
				alt111=1;
				}
				break;
			case ABS:
			case BNODE:
			case BOUND:
			case CEIL:
			case COALESCE:
			case CONCAT:
			case CONTAINS:
			case DATATYPE:
			case DAY:
			case ENCODE_FOR_URI:
			case EXISTS:
			case FLOOR:
			case HOURS:
			case IF:
			case IRI:
			case ISBLANK:
			case ISIRI:
			case ISLITERAL:
			case ISNUMERIC:
			case ISURI:
			case LANG:
			case LANGMATCHES:
			case LCASE:
			case MD5:
			case MINUTES:
			case MONTH:
			case NOT_EXISTS:
			case NOW:
			case RAND:
			case REGEX:
			case ROUND:
			case SAMETERM:
			case SECONDS:
			case SHA1:
			case SHA224:
			case SHA256:
			case SHA384:
			case SHA512:
			case STR:
			case STRDT:
			case STRENDS:
			case STRLANG:
			case STRLEN:
			case STRSTARTS:
			case SUBSTR:
			case TIMEZONE:
			case TZ:
			case UCASE:
			case URI:
			case YEAR:
				{
				alt111=2;
				}
				break;
			case FUNCTION:
				{
				alt111=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 111, 0, input);
				throw nvae;
			}
			switch (alt111) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:618:7: expression
					{
					pushFollow(FOLLOW_expression_in_constraint3001);
					expression();
					state._fsp--;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:619:7: builtInCall
					{
					pushFollow(FOLLOW_builtInCall_in_constraint3009);
					builtInCall();
					state._fsp--;

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:620:7: functionCall
					{
					pushFollow(FOLLOW_functionCall_in_constraint3017);
					functionCall();
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "constraint"



	// $ANTLR start "functionCall"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:623:1: functionCall returns [Expr value] : ^( FUNCTION a= iriRef ^( ARG_LIST b= argList ) ) ;
	public final Expr functionCall() throws RecognitionException {
		Expr value = null;


		Node a =null;
		ExprList b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:624:5: ( ^( FUNCTION a= iriRef ^( ARG_LIST b= argList ) ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:624:7: ^( FUNCTION a= iriRef ^( ARG_LIST b= argList ) )
			{
			match(input,FUNCTION,FOLLOW_FUNCTION_in_functionCall3039); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_iriRef_in_functionCall3043);
			a=iriRef();
			state._fsp--;

			match(input,ARG_LIST,FOLLOW_ARG_LIST_in_functionCall3046); 
			if ( input.LA(1)==Token.DOWN ) {
				match(input, Token.DOWN, null); 
				pushFollow(FOLLOW_argList_in_functionCall3050);
				b=argList();
				state._fsp--;

				match(input, Token.UP, null); 
			}

			match(input, Token.UP, null); 

			 value = new E_Function(a.toString(), b); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "functionCall"



	// $ANTLR start "argList"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:628:1: argList returns [ExprList value] : ( nil | ( DISTINCT )? (a= expression )* );
	public final ExprList argList() throws RecognitionException {
		ExprList value = null;


		Expr a =null;

		 value = new ExprList(); 
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:630:5: ( nil | ( DISTINCT )? (a= expression )* )
			int alt114=2;
			int LA114_0 = input.LA(1);
			if ( (LA114_0==OPEN_BRACE) ) {
				alt114=1;
			}
			else if ( (LA114_0==UP||LA114_0==AND||LA114_0==ASTERISK||(LA114_0 >= DISTINCT && LA114_0 <= DIVIDE)||LA114_0==EQUAL||(LA114_0 >= GREATER && LA114_0 <= GREATER_EQUAL)||LA114_0==IN||(LA114_0 >= LESS && LA114_0 <= LESS_EQUAL)||LA114_0==MINUS||(LA114_0 >= NOT && LA114_0 <= NOT_EQUAL)||LA114_0==OR||LA114_0==PLUS||(LA114_0 >= UNARY && LA114_0 <= UNARY_PLUS)) ) {
				alt114=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 114, 0, input);
				throw nvae;
			}

			switch (alt114) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:630:7: nil
					{
					pushFollow(FOLLOW_nil_in_argList3082);
					nil();
					state._fsp--;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:631:7: ( DISTINCT )? (a= expression )*
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:631:7: ( DISTINCT )?
					int alt112=2;
					int LA112_0 = input.LA(1);
					if ( (LA112_0==DISTINCT) ) {
						alt112=1;
					}
					switch (alt112) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:631:7: DISTINCT
							{
							match(input,DISTINCT,FOLLOW_DISTINCT_in_argList3090); 
							}
							break;

					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:631:17: (a= expression )*
					loop113:
					while (true) {
						int alt113=2;
						int LA113_0 = input.LA(1);
						if ( (LA113_0==AND||LA113_0==ASTERISK||LA113_0==DIVIDE||LA113_0==EQUAL||(LA113_0 >= GREATER && LA113_0 <= GREATER_EQUAL)||LA113_0==IN||(LA113_0 >= LESS && LA113_0 <= LESS_EQUAL)||LA113_0==MINUS||(LA113_0 >= NOT && LA113_0 <= NOT_EQUAL)||LA113_0==OR||LA113_0==PLUS||(LA113_0 >= UNARY && LA113_0 <= UNARY_PLUS)) ) {
							alt113=1;
						}

						switch (alt113) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:631:18: a= expression
							{
							pushFollow(FOLLOW_expression_in_argList3096);
							a=expression();
							state._fsp--;

							value.add(a);
							}
							break;

						default :
							break loop113;
						}
					}

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "argList"



	// $ANTLR start "expressionList"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:634:1: expressionList returns [ExprList value] : ( ^( EXPRESSION_LIST (a= expression )+ ) | ^( EXPRESSION_LIST nil ) );
	public final ExprList expressionList() throws RecognitionException {
		ExprList value = null;


		Expr a =null;

		 value = new ExprList(); 
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:636:5: ( ^( EXPRESSION_LIST (a= expression )+ ) | ^( EXPRESSION_LIST nil ) )
			int alt116=2;
			int LA116_0 = input.LA(1);
			if ( (LA116_0==EXPRESSION_LIST) ) {
				int LA116_1 = input.LA(2);
				if ( (LA116_1==DOWN) ) {
					int LA116_2 = input.LA(3);
					if ( (LA116_2==AND||LA116_2==ASTERISK||LA116_2==DIVIDE||LA116_2==EQUAL||(LA116_2 >= GREATER && LA116_2 <= GREATER_EQUAL)||LA116_2==IN||(LA116_2 >= LESS && LA116_2 <= LESS_EQUAL)||LA116_2==MINUS||(LA116_2 >= NOT && LA116_2 <= NOT_EQUAL)||LA116_2==OR||LA116_2==PLUS||(LA116_2 >= UNARY && LA116_2 <= UNARY_PLUS)) ) {
						alt116=1;
					}
					else if ( (LA116_2==OPEN_BRACE) ) {
						alt116=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 116, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 116, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 116, 0, input);
				throw nvae;
			}

			switch (alt116) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:636:7: ^( EXPRESSION_LIST (a= expression )+ )
					{
					match(input,EXPRESSION_LIST,FOLLOW_EXPRESSION_LIST_in_expressionList3128); 
					match(input, Token.DOWN, null); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:636:25: (a= expression )+
					int cnt115=0;
					loop115:
					while (true) {
						int alt115=2;
						int LA115_0 = input.LA(1);
						if ( (LA115_0==AND||LA115_0==ASTERISK||LA115_0==DIVIDE||LA115_0==EQUAL||(LA115_0 >= GREATER && LA115_0 <= GREATER_EQUAL)||LA115_0==IN||(LA115_0 >= LESS && LA115_0 <= LESS_EQUAL)||LA115_0==MINUS||(LA115_0 >= NOT && LA115_0 <= NOT_EQUAL)||LA115_0==OR||LA115_0==PLUS||(LA115_0 >= UNARY && LA115_0 <= UNARY_PLUS)) ) {
							alt115=1;
						}

						switch (alt115) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:636:26: a= expression
							{
							pushFollow(FOLLOW_expression_in_expressionList3133);
							a=expression();
							state._fsp--;

							value.add(a); 
							}
							break;

						default :
							if ( cnt115 >= 1 ) break loop115;
							EarlyExitException eee = new EarlyExitException(115, input);
							throw eee;
						}
						cnt115++;
					}

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:637:7: ^( EXPRESSION_LIST nil )
					{
					match(input,EXPRESSION_LIST,FOLLOW_EXPRESSION_LIST_in_expressionList3147); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_nil_in_expressionList3149);
					nil();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "expressionList"



	// $ANTLR start "constructTemplateQuads"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:649:1: constructTemplateQuads returns [QuadPattern value] : ^( CONSTRUCT_QUADS a= quadPattern ) ;
	public final QuadPattern constructTemplateQuads() throws RecognitionException {
		QuadPattern value = null;


		QuadPattern a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:650:5: ( ^( CONSTRUCT_QUADS a= quadPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:650:7: ^( CONSTRUCT_QUADS a= quadPattern )
			{
			match(input,CONSTRUCT_QUADS,FOLLOW_CONSTRUCT_QUADS_in_constructTemplateQuads3178); 
			if ( input.LA(1)==Token.DOWN ) {
				match(input, Token.DOWN, null); 
				pushFollow(FOLLOW_quadPattern_in_constructTemplateQuads3182);
				a=quadPattern();
				state._fsp--;

				match(input, Token.UP, null); 
			}

			value = a;
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "constructTemplateQuads"



	// $ANTLR start "constructTemplate"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:654:1: constructTemplate returns [Template value] : ^( CONSTRUCT_TRIPLES a= constructTriples ) ;
	public final Template constructTemplate() throws RecognitionException {
		Template value = null;


		BasicPattern a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:656:5: ( ^( CONSTRUCT_TRIPLES a= constructTriples ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:656:7: ^( CONSTRUCT_TRIPLES a= constructTriples )
			{
			match(input,CONSTRUCT_TRIPLES,FOLLOW_CONSTRUCT_TRIPLES_in_constructTemplate3212); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_constructTriples_in_constructTemplate3216);
			a=constructTriples();
			state._fsp--;

			match(input, Token.UP, null); 

			value = new Template(a);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "constructTemplate"



	// $ANTLR start "constructTriples"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:660:1: constructTriples returns [BasicPattern value] : a= triples ;
	public final BasicPattern constructTriples() throws RecognitionException {
		BasicPattern value = null;


		BasicPattern a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:661:5: (a= triples )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:661:7: a= triples
			{
			pushFollow(FOLLOW_triples_in_constructTriples3243);
			a=triples();
			state._fsp--;

			value = a;
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "constructTriples"



	// $ANTLR start "triples"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:666:1: triples returns [BasicPattern value] : ( triple[value] )+ ;
	public final BasicPattern triples() throws RecognitionException {
		BasicPattern value = null;


		value = new BasicPattern();
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:668:2: ( ( triple[value] )+ )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:668:4: ( triple[value] )+
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:668:4: ( triple[value] )+
			int cnt117=0;
			loop117:
			while (true) {
				int alt117=2;
				int LA117_0 = input.LA(1);
				if ( (LA117_0==TRIPLE) ) {
					alt117=1;
				}

				switch (alt117) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:668:4: triple[value]
					{
					pushFollow(FOLLOW_triple_in_triples3275);
					triple(value);
					state._fsp--;

					}
					break;

				default :
					if ( cnt117 >= 1 ) break loop117;
					EarlyExitException eee = new EarlyExitException(117, input);
					throw eee;
				}
				cnt117++;
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "triples"



	// $ANTLR start "triple"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:671:1: triple[BasicPattern triples] : ^( TRIPLE ^( SUBJECT a= varOrTerm ) ^( PREDICATE b= verb ) ^( OBJECT c= graphNode[triples] ) ) ;
	public final void triple(BasicPattern triples) throws RecognitionException {
		Node a =null;
		Node b =null;
		Node c =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:672:5: ( ^( TRIPLE ^( SUBJECT a= varOrTerm ) ^( PREDICATE b= verb ) ^( OBJECT c= graphNode[triples] ) ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:672:7: ^( TRIPLE ^( SUBJECT a= varOrTerm ) ^( PREDICATE b= verb ) ^( OBJECT c= graphNode[triples] ) )
			{
			match(input,TRIPLE,FOLLOW_TRIPLE_in_triple3296); 
			match(input, Token.DOWN, null); 
			match(input,SUBJECT,FOLLOW_SUBJECT_in_triple3299); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_varOrTerm_in_triple3303);
			a=varOrTerm();
			state._fsp--;

			match(input, Token.UP, null); 

			match(input,PREDICATE,FOLLOW_PREDICATE_in_triple3307); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_verb_in_triple3311);
			b=verb();
			state._fsp--;

			match(input, Token.UP, null); 

			match(input,OBJECT,FOLLOW_OBJECT_in_triple3315); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_graphNode_in_triple3319);
			c=graphNode(triples);
			state._fsp--;

			match(input, Token.UP, null); 

			match(input, Token.UP, null); 

			triples.add(new Triple(a, b, c)); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "triple"



	// $ANTLR start "triplesSameSubject"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:677:1: triplesSameSubject[BasicPattern value] : TODO ;
	public final void triplesSameSubject(BasicPattern value) throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:678:5: ( TODO )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:678:7: TODO
			{
			match(input,TODO,FOLLOW_TODO_in_triplesSameSubject3341); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "triplesSameSubject"



	// $ANTLR start "objectList"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:685:1: objectList[BasicPattern triples] : ^( SUBJECT a= varOrTerm ) ^( PREDICATE b= verb ) ^( OBJECT c= graphNode[triples] ) ;
	public final void objectList(BasicPattern triples) throws RecognitionException {
		Node a =null;
		Node b =null;
		Node c =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:686:2: ( ^( SUBJECT a= varOrTerm ) ^( PREDICATE b= verb ) ^( OBJECT c= graphNode[triples] ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:686:4: ^( SUBJECT a= varOrTerm ) ^( PREDICATE b= verb ) ^( OBJECT c= graphNode[triples] )
			{
			match(input,SUBJECT,FOLLOW_SUBJECT_in_objectList3362); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_varOrTerm_in_objectList3366);
			a=varOrTerm();
			state._fsp--;

			match(input, Token.UP, null); 

			match(input,PREDICATE,FOLLOW_PREDICATE_in_objectList3370); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_verb_in_objectList3374);
			b=verb();
			state._fsp--;

			match(input, Token.UP, null); 

			match(input,OBJECT,FOLLOW_OBJECT_in_objectList3378); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_graphNode_in_objectList3382);
			c=graphNode(triples);
			state._fsp--;

			match(input, Token.UP, null); 

			triples.add(new Triple(a, b, c)); System.out.println("Created triple: " + triples); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "objectList"



	// $ANTLR start "verb"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:716:1: verb returns [ Node value ] : (a= varOrIRIref | A | path );
	public final Node verb() throws RecognitionException {
		Node value = null;


		Node a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:717:5: (a= varOrIRIref | A | path )
			int alt118=3;
			switch ( input.LA(1) ) {
			case IRI_REF:
			case PNAME_LN:
			case PNAME_NS:
			case VAR:
				{
				alt118=1;
				}
				break;
			case A:
				{
				alt118=2;
				}
				break;
			case PATH:
				{
				alt118=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 118, 0, input);
				throw nvae;
			}
			switch (alt118) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:717:7: a= varOrIRIref
					{
					pushFollow(FOLLOW_varOrIRIref_in_verb3413);
					a=varOrIRIref();
					state._fsp--;

					 value = a; 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:718:7: A
					{
					match(input,A,FOLLOW_A_in_verb3424); 
					 value = RDF.type.asNode(); 
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:719:7: path
					{
					pushFollow(FOLLOW_path_in_verb3444);
					path();
					state._fsp--;

					 if(true) { throw new NotImplementedException(); } 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "verb"



	// $ANTLR start "triplesSameSubjectPath"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:722:1: triplesSameSubjectPath[BasicPattern value] : ( ^( TRIPLE objectList[value] ) | ^( TRIPLE triplesSameSubjectPath[value] ) );
	public final void triplesSameSubjectPath(BasicPattern value) throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:723:5: ( ^( TRIPLE objectList[value] ) | ^( TRIPLE triplesSameSubjectPath[value] ) )
			int alt119=2;
			int LA119_0 = input.LA(1);
			if ( (LA119_0==TRIPLE) ) {
				int LA119_1 = input.LA(2);
				if ( (LA119_1==DOWN) ) {
					int LA119_2 = input.LA(3);
					if ( (LA119_2==SUBJECT) ) {
						alt119=1;
					}
					else if ( (LA119_2==TRIPLE) ) {
						alt119=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 119, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 119, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 119, 0, input);
				throw nvae;
			}

			switch (alt119) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:723:7: ^( TRIPLE objectList[value] )
					{
					match(input,TRIPLE,FOLLOW_TRIPLE_in_triplesSameSubjectPath3469); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_objectList_in_triplesSameSubjectPath3471);
					objectList(value);
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:724:7: ^( TRIPLE triplesSameSubjectPath[value] )
					{
					match(input,TRIPLE,FOLLOW_TRIPLE_in_triplesSameSubjectPath3482); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_triplesSameSubjectPath_in_triplesSameSubjectPath3484);
					triplesSameSubjectPath(value);
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "triplesSameSubjectPath"



	// $ANTLR start "path"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:727:1: path : PATH pathSequence ( PIPE pathSequence )* ;
	public final void path() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:728:5: ( PATH pathSequence ( PIPE pathSequence )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:728:7: PATH pathSequence ( PIPE pathSequence )*
			{
			match(input,PATH,FOLLOW_PATH_in_path3509); 
			pushFollow(FOLLOW_pathSequence_in_path3511);
			pathSequence();
			state._fsp--;

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:728:25: ( PIPE pathSequence )*
			loop120:
			while (true) {
				int alt120=2;
				int LA120_0 = input.LA(1);
				if ( (LA120_0==PIPE) ) {
					alt120=1;
				}

				switch (alt120) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:728:27: PIPE pathSequence
					{
					match(input,PIPE,FOLLOW_PIPE_in_path3515); 
					pushFollow(FOLLOW_pathSequence_in_path3517);
					pathSequence();
					state._fsp--;

					}
					break;

				default :
					break loop120;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "path"



	// $ANTLR start "pathSequence"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:731:1: pathSequence : pathEltOrInverse ( DIVIDE pathEltOrInverse )* ;
	public final void pathSequence() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:732:5: ( pathEltOrInverse ( DIVIDE pathEltOrInverse )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:732:7: pathEltOrInverse ( DIVIDE pathEltOrInverse )*
			{
			pushFollow(FOLLOW_pathEltOrInverse_in_pathSequence3538);
			pathEltOrInverse();
			state._fsp--;

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:732:24: ( DIVIDE pathEltOrInverse )*
			loop121:
			while (true) {
				int alt121=2;
				int LA121_0 = input.LA(1);
				if ( (LA121_0==DIVIDE) ) {
					alt121=1;
				}

				switch (alt121) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:732:26: DIVIDE pathEltOrInverse
					{
					match(input,DIVIDE,FOLLOW_DIVIDE_in_pathSequence3542); 
					pushFollow(FOLLOW_pathEltOrInverse_in_pathSequence3544);
					pathEltOrInverse();
					state._fsp--;

					}
					break;

				default :
					break loop121;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "pathSequence"



	// $ANTLR start "pathElt"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:735:1: pathElt : pathPrimary ( pathMod )? ;
	public final void pathElt() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:736:5: ( pathPrimary ( pathMod )? )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:736:7: pathPrimary ( pathMod )?
			{
			pushFollow(FOLLOW_pathPrimary_in_pathElt3572);
			pathPrimary();
			state._fsp--;

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:736:19: ( pathMod )?
			int alt122=2;
			int LA122_0 = input.LA(1);
			if ( (LA122_0==ASTERISK||LA122_0==OPEN_CURLY_BRACE||LA122_0==PLUS||LA122_0==QUESTION_MARK) ) {
				alt122=1;
			}
			switch (alt122) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:736:19: pathMod
					{
					pushFollow(FOLLOW_pathMod_in_pathElt3574);
					pathMod();
					state._fsp--;

					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "pathElt"



	// $ANTLR start "pathEltOrInverse"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:739:1: pathEltOrInverse : ( pathElt | INVERSE pathElt );
	public final void pathEltOrInverse() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:740:5: ( pathElt | INVERSE pathElt )
			int alt123=2;
			int LA123_0 = input.LA(1);
			if ( (LA123_0==PATH_PRIMARY) ) {
				alt123=1;
			}
			else if ( (LA123_0==INVERSE) ) {
				alt123=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 123, 0, input);
				throw nvae;
			}

			switch (alt123) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:740:7: pathElt
					{
					pushFollow(FOLLOW_pathElt_in_pathEltOrInverse3596);
					pathElt();
					state._fsp--;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:740:17: INVERSE pathElt
					{
					match(input,INVERSE,FOLLOW_INVERSE_in_pathEltOrInverse3600); 
					pushFollow(FOLLOW_pathElt_in_pathEltOrInverse3602);
					pathElt();
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "pathEltOrInverse"



	// $ANTLR start "pathMod"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:743:1: pathMod : ( ASTERISK | QUESTION_MARK | PLUS | OPEN_CURLY_BRACE ( INTEGER ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE ) | COMMA INTEGER CLOSE_CURLY_BRACE ) ) ;
	public final void pathMod() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:744:5: ( ( ASTERISK | QUESTION_MARK | PLUS | OPEN_CURLY_BRACE ( INTEGER ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE ) | COMMA INTEGER CLOSE_CURLY_BRACE ) ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:744:7: ( ASTERISK | QUESTION_MARK | PLUS | OPEN_CURLY_BRACE ( INTEGER ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE ) | COMMA INTEGER CLOSE_CURLY_BRACE ) )
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:744:7: ( ASTERISK | QUESTION_MARK | PLUS | OPEN_CURLY_BRACE ( INTEGER ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE ) | COMMA INTEGER CLOSE_CURLY_BRACE ) )
			int alt127=4;
			switch ( input.LA(1) ) {
			case ASTERISK:
				{
				alt127=1;
				}
				break;
			case QUESTION_MARK:
				{
				alt127=2;
				}
				break;
			case PLUS:
				{
				alt127=3;
				}
				break;
			case OPEN_CURLY_BRACE:
				{
				alt127=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 127, 0, input);
				throw nvae;
			}
			switch (alt127) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:744:9: ASTERISK
					{
					match(input,ASTERISK,FOLLOW_ASTERISK_in_pathMod3625); 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:744:20: QUESTION_MARK
					{
					match(input,QUESTION_MARK,FOLLOW_QUESTION_MARK_in_pathMod3629); 
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:744:36: PLUS
					{
					match(input,PLUS,FOLLOW_PLUS_in_pathMod3633); 
					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:744:43: OPEN_CURLY_BRACE ( INTEGER ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE ) | COMMA INTEGER CLOSE_CURLY_BRACE )
					{
					match(input,OPEN_CURLY_BRACE,FOLLOW_OPEN_CURLY_BRACE_in_pathMod3637); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:744:60: ( INTEGER ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE ) | COMMA INTEGER CLOSE_CURLY_BRACE )
					int alt126=2;
					int LA126_0 = input.LA(1);
					if ( (LA126_0==INTEGER) ) {
						alt126=1;
					}
					else if ( (LA126_0==COMMA) ) {
						alt126=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 126, 0, input);
						throw nvae;
					}

					switch (alt126) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:744:62: INTEGER ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE )
							{
							match(input,INTEGER,FOLLOW_INTEGER_in_pathMod3641); 
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:744:70: ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE )
							int alt125=2;
							int LA125_0 = input.LA(1);
							if ( (LA125_0==COMMA) ) {
								alt125=1;
							}
							else if ( (LA125_0==CLOSE_CURLY_BRACE) ) {
								alt125=2;
							}

							else {
								NoViableAltException nvae =
									new NoViableAltException("", 125, 0, input);
								throw nvae;
							}

							switch (alt125) {
								case 1 :
									// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:744:72: COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE )
									{
									match(input,COMMA,FOLLOW_COMMA_in_pathMod3645); 
									// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:744:78: ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE )
									int alt124=2;
									int LA124_0 = input.LA(1);
									if ( (LA124_0==CLOSE_CURLY_BRACE) ) {
										alt124=1;
									}
									else if ( (LA124_0==INTEGER) ) {
										alt124=2;
									}

									else {
										NoViableAltException nvae =
											new NoViableAltException("", 124, 0, input);
										throw nvae;
									}

									switch (alt124) {
										case 1 :
											// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:744:80: CLOSE_CURLY_BRACE
											{
											match(input,CLOSE_CURLY_BRACE,FOLLOW_CLOSE_CURLY_BRACE_in_pathMod3649); 
											}
											break;
										case 2 :
											// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:744:100: INTEGER CLOSE_CURLY_BRACE
											{
											match(input,INTEGER,FOLLOW_INTEGER_in_pathMod3653); 
											match(input,CLOSE_CURLY_BRACE,FOLLOW_CLOSE_CURLY_BRACE_in_pathMod3655); 
											}
											break;

									}

									}
									break;
								case 2 :
									// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:744:130: CLOSE_CURLY_BRACE
									{
									match(input,CLOSE_CURLY_BRACE,FOLLOW_CLOSE_CURLY_BRACE_in_pathMod3661); 
									}
									break;

							}

							}
							break;
						case 2 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:744:152: COMMA INTEGER CLOSE_CURLY_BRACE
							{
							match(input,COMMA,FOLLOW_COMMA_in_pathMod3667); 
							match(input,INTEGER,FOLLOW_INTEGER_in_pathMod3669); 
							match(input,CLOSE_CURLY_BRACE,FOLLOW_CLOSE_CURLY_BRACE_in_pathMod3671); 
							}
							break;

					}

					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "pathMod"



	// $ANTLR start "pathPrimary"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:747:1: pathPrimary : ( ^( PATH_PRIMARY iriRef ) | ^( PATH_PRIMARY A ) | ^( PATH_PRIMARY NEGATION pathNegatedPropertySet ) | ^( PATH_PRIMARY path ) );
	public final void pathPrimary() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:748:5: ( ^( PATH_PRIMARY iriRef ) | ^( PATH_PRIMARY A ) | ^( PATH_PRIMARY NEGATION pathNegatedPropertySet ) | ^( PATH_PRIMARY path ) )
			int alt128=4;
			int LA128_0 = input.LA(1);
			if ( (LA128_0==PATH_PRIMARY) ) {
				int LA128_1 = input.LA(2);
				if ( (LA128_1==DOWN) ) {
					switch ( input.LA(3) ) {
					case A:
						{
						alt128=2;
						}
						break;
					case NEGATION:
						{
						alt128=3;
						}
						break;
					case IRI_REF:
					case PNAME_LN:
					case PNAME_NS:
						{
						alt128=1;
						}
						break;
					case PATH:
						{
						alt128=4;
						}
						break;
					default:
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 128, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 128, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 128, 0, input);
				throw nvae;
			}

			switch (alt128) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:748:7: ^( PATH_PRIMARY iriRef )
					{
					match(input,PATH_PRIMARY,FOLLOW_PATH_PRIMARY_in_pathPrimary3693); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_iriRef_in_pathPrimary3695);
					iriRef();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:749:7: ^( PATH_PRIMARY A )
					{
					match(input,PATH_PRIMARY,FOLLOW_PATH_PRIMARY_in_pathPrimary3705); 
					match(input, Token.DOWN, null); 
					match(input,A,FOLLOW_A_in_pathPrimary3707); 
					match(input, Token.UP, null); 

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:750:7: ^( PATH_PRIMARY NEGATION pathNegatedPropertySet )
					{
					match(input,PATH_PRIMARY,FOLLOW_PATH_PRIMARY_in_pathPrimary3717); 
					match(input, Token.DOWN, null); 
					match(input,NEGATION,FOLLOW_NEGATION_in_pathPrimary3719); 
					pushFollow(FOLLOW_pathNegatedPropertySet_in_pathPrimary3721);
					pathNegatedPropertySet();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:751:7: ^( PATH_PRIMARY path )
					{
					match(input,PATH_PRIMARY,FOLLOW_PATH_PRIMARY_in_pathPrimary3731); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_path_in_pathPrimary3733);
					path();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "pathPrimary"



	// $ANTLR start "pathNegatedPropertySet"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:754:1: pathNegatedPropertySet : ^( PATH_NEGATED ( pathOneInPropertySet )+ ) ;
	public final void pathNegatedPropertySet() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:755:5: ( ^( PATH_NEGATED ( pathOneInPropertySet )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:755:7: ^( PATH_NEGATED ( pathOneInPropertySet )+ )
			{
			match(input,PATH_NEGATED,FOLLOW_PATH_NEGATED_in_pathNegatedPropertySet3752); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:755:22: ( pathOneInPropertySet )+
			int cnt129=0;
			loop129:
			while (true) {
				int alt129=2;
				int LA129_0 = input.LA(1);
				if ( (LA129_0==A||LA129_0==INVERSE||LA129_0==IRI_REF||(LA129_0 >= PNAME_LN && LA129_0 <= PNAME_NS)) ) {
					alt129=1;
				}

				switch (alt129) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:755:22: pathOneInPropertySet
					{
					pushFollow(FOLLOW_pathOneInPropertySet_in_pathNegatedPropertySet3754);
					pathOneInPropertySet();
					state._fsp--;

					}
					break;

				default :
					if ( cnt129 >= 1 ) break loop129;
					EarlyExitException eee = new EarlyExitException(129, input);
					throw eee;
				}
				cnt129++;
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "pathNegatedPropertySet"



	// $ANTLR start "pathOneInPropertySet"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:758:1: pathOneInPropertySet : ( INVERSE )? ( iriRef | A ) ;
	public final void pathOneInPropertySet() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:759:5: ( ( INVERSE )? ( iriRef | A ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:759:7: ( INVERSE )? ( iriRef | A )
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:759:7: ( INVERSE )?
			int alt130=2;
			int LA130_0 = input.LA(1);
			if ( (LA130_0==INVERSE) ) {
				alt130=1;
			}
			switch (alt130) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:759:7: INVERSE
					{
					match(input,INVERSE,FOLLOW_INVERSE_in_pathOneInPropertySet3776); 
					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:759:16: ( iriRef | A )
			int alt131=2;
			int LA131_0 = input.LA(1);
			if ( (LA131_0==IRI_REF||(LA131_0 >= PNAME_LN && LA131_0 <= PNAME_NS)) ) {
				alt131=1;
			}
			else if ( (LA131_0==A) ) {
				alt131=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 131, 0, input);
				throw nvae;
			}

			switch (alt131) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:759:18: iriRef
					{
					pushFollow(FOLLOW_iriRef_in_pathOneInPropertySet3781);
					iriRef();
					state._fsp--;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:759:27: A
					{
					match(input,A,FOLLOW_A_in_pathOneInPropertySet3785); 
					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "pathOneInPropertySet"



	// $ANTLR start "triplesNode"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:762:1: triplesNode[BasicPattern triples] returns [Node value] : ( ^( COLLECTION ( graphNode[triples] )+ ) | ^( TRIPLE objectList[triples] ) );
	public final Node triplesNode(BasicPattern triples) throws RecognitionException {
		Node value = null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:763:5: ( ^( COLLECTION ( graphNode[triples] )+ ) | ^( TRIPLE objectList[triples] ) )
			int alt133=2;
			int LA133_0 = input.LA(1);
			if ( (LA133_0==COLLECTION) ) {
				alt133=1;
			}
			else if ( (LA133_0==TRIPLE) ) {
				alt133=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 133, 0, input);
				throw nvae;
			}

			switch (alt133) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:763:7: ^( COLLECTION ( graphNode[triples] )+ )
					{
					match(input,COLLECTION,FOLLOW_COLLECTION_in_triplesNode3811); 
					match(input, Token.DOWN, null); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:763:20: ( graphNode[triples] )+
					int cnt132=0;
					loop132:
					while (true) {
						int alt132=2;
						int LA132_0 = input.LA(1);
						if ( (LA132_0==BLANK_NODE_LABEL||LA132_0==COLLECTION||(LA132_0 >= DECIMAL && LA132_0 <= DECIMAL_POSITIVE)||(LA132_0 >= DOUBLE && LA132_0 <= DOUBLE_POSITIVE)||LA132_0==FALSE||(LA132_0 >= INTEGER && LA132_0 <= INTEGER_POSITIVE)||LA132_0==IRI_REF||LA132_0==OPEN_BRACE||LA132_0==OPEN_SQUARE_BRACKET||LA132_0==PLAIN_LITERAL||(LA132_0 >= PNAME_LN && LA132_0 <= PNAME_NS)||LA132_0==TRIPLE||(LA132_0 >= TRUE && LA132_0 <= TYPED_LITERAL)||LA132_0==VAR) ) {
							alt132=1;
						}

						switch (alt132) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:763:20: graphNode[triples]
							{
							pushFollow(FOLLOW_graphNode_in_triplesNode3813);
							graphNode(triples);
							state._fsp--;

							}
							break;

						default :
							if ( cnt132 >= 1 ) break loop132;
							EarlyExitException eee = new EarlyExitException(132, input);
							throw eee;
						}
						cnt132++;
					}

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:764:7: ^( TRIPLE objectList[triples] )
					{
					match(input,TRIPLE,FOLLOW_TRIPLE_in_triplesNode3825); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_objectList_in_triplesNode3827);
					objectList(triples);
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "triplesNode"



	// $ANTLR start "graphNode"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:767:1: graphNode[BasicPattern triples] returns [Node value] : (a= varOrTerm | triplesNode[triples] );
	public final Node graphNode(BasicPattern triples) throws RecognitionException {
		Node value = null;


		Node a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:768:5: (a= varOrTerm | triplesNode[triples] )
			int alt134=2;
			int LA134_0 = input.LA(1);
			if ( (LA134_0==BLANK_NODE_LABEL||(LA134_0 >= DECIMAL && LA134_0 <= DECIMAL_POSITIVE)||(LA134_0 >= DOUBLE && LA134_0 <= DOUBLE_POSITIVE)||LA134_0==FALSE||(LA134_0 >= INTEGER && LA134_0 <= INTEGER_POSITIVE)||LA134_0==IRI_REF||LA134_0==OPEN_BRACE||LA134_0==OPEN_SQUARE_BRACKET||LA134_0==PLAIN_LITERAL||(LA134_0 >= PNAME_LN && LA134_0 <= PNAME_NS)||(LA134_0 >= TRUE && LA134_0 <= TYPED_LITERAL)||LA134_0==VAR) ) {
				alt134=1;
			}
			else if ( (LA134_0==COLLECTION||LA134_0==TRIPLE) ) {
				alt134=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 134, 0, input);
				throw nvae;
			}

			switch (alt134) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:768:7: a= varOrTerm
					{
					pushFollow(FOLLOW_varOrTerm_in_graphNode3855);
					a=varOrTerm();
					state._fsp--;

					value = a;
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:769:7: triplesNode[triples]
					{
					pushFollow(FOLLOW_triplesNode_in_graphNode3865);
					triplesNode(triples);
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "graphNode"



	// $ANTLR start "varOrTerm"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:772:1: varOrTerm returns [Node value] : (a= var |a= graphTerm );
	public final Node varOrTerm() throws RecognitionException {
		Node value = null;


		Node a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:773:5: (a= var |a= graphTerm )
			int alt135=2;
			int LA135_0 = input.LA(1);
			if ( (LA135_0==VAR) ) {
				alt135=1;
			}
			else if ( (LA135_0==BLANK_NODE_LABEL||(LA135_0 >= DECIMAL && LA135_0 <= DECIMAL_POSITIVE)||(LA135_0 >= DOUBLE && LA135_0 <= DOUBLE_POSITIVE)||LA135_0==FALSE||(LA135_0 >= INTEGER && LA135_0 <= INTEGER_POSITIVE)||LA135_0==IRI_REF||LA135_0==OPEN_BRACE||LA135_0==OPEN_SQUARE_BRACKET||LA135_0==PLAIN_LITERAL||(LA135_0 >= PNAME_LN && LA135_0 <= PNAME_NS)||(LA135_0 >= TRUE && LA135_0 <= TYPED_LITERAL)) ) {
				alt135=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 135, 0, input);
				throw nvae;
			}

			switch (alt135) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:773:7: a= var
					{
					pushFollow(FOLLOW_var_in_varOrTerm3889);
					a=var();
					state._fsp--;

					value = a;
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:774:7: a= graphTerm
					{
					pushFollow(FOLLOW_graphTerm_in_varOrTerm3907);
					a=graphTerm();
					state._fsp--;

					value = a;
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "varOrTerm"



	// $ANTLR start "varOrIRIref"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:777:1: varOrIRIref returns [Node value] : (a= var |a= iriRef );
	public final Node varOrIRIref() throws RecognitionException {
		Node value = null;


		Node a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:778:5: (a= var |a= iriRef )
			int alt136=2;
			int LA136_0 = input.LA(1);
			if ( (LA136_0==VAR) ) {
				alt136=1;
			}
			else if ( (LA136_0==IRI_REF||(LA136_0 >= PNAME_LN && LA136_0 <= PNAME_NS)) ) {
				alt136=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 136, 0, input);
				throw nvae;
			}

			switch (alt136) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:778:7: a= var
					{
					pushFollow(FOLLOW_var_in_varOrIRIref3932);
					a=var();
					state._fsp--;

					value = a;
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:779:7: a= iriRef
					{
					pushFollow(FOLLOW_iriRef_in_varOrIRIref3947);
					a=iriRef();
					state._fsp--;

					value = a;
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "varOrIRIref"



	// $ANTLR start "var"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:782:1: var returns [Var value] : a= VAR ;
	public final Var var() throws RecognitionException {
		Var value = null;


		CommonTree a=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:783:5: (a= VAR )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:783:7: a= VAR
			{
			a=(CommonTree)match(input,VAR,FOLLOW_VAR_in_var3972); 
			value = Var.alloc((a!=null?a.getText():null));
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "var"



	// $ANTLR start "graphTerm"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:786:1: graphTerm returns [Node value] : (a= iriRef |a= rdfLiteral |b= numericLiteral |b= booleanLiteral |a= blankNode | nil );
	public final Node graphTerm() throws RecognitionException {
		Node value = null;


		Node a =null;
		NodeValue b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:787:5: (a= iriRef |a= rdfLiteral |b= numericLiteral |b= booleanLiteral |a= blankNode | nil )
			int alt137=6;
			switch ( input.LA(1) ) {
			case IRI_REF:
			case PNAME_LN:
			case PNAME_NS:
				{
				alt137=1;
				}
				break;
			case PLAIN_LITERAL:
			case TYPED_LITERAL:
				{
				alt137=2;
				}
				break;
			case DECIMAL:
			case DECIMAL_NEGATIVE:
			case DECIMAL_POSITIVE:
			case DOUBLE:
			case DOUBLE_NEGATIVE:
			case DOUBLE_POSITIVE:
			case INTEGER:
			case INTEGER_NEGATIVE:
			case INTEGER_POSITIVE:
				{
				alt137=3;
				}
				break;
			case FALSE:
			case TRUE:
				{
				alt137=4;
				}
				break;
			case BLANK_NODE_LABEL:
			case OPEN_SQUARE_BRACKET:
				{
				alt137=5;
				}
				break;
			case OPEN_BRACE:
				{
				alt137=6;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 137, 0, input);
				throw nvae;
			}
			switch (alt137) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:787:7: a= iriRef
					{
					pushFollow(FOLLOW_iriRef_in_graphTerm3998);
					a=iriRef();
					state._fsp--;

					value = a;
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:788:7: a= rdfLiteral
					{
					pushFollow(FOLLOW_rdfLiteral_in_graphTerm4019);
					a=rdfLiteral();
					state._fsp--;

					value = a;
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:789:7: b= numericLiteral
					{
					pushFollow(FOLLOW_numericLiteral_in_graphTerm4037);
					b=numericLiteral();
					state._fsp--;

					value = b.asNode();
					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:790:7: b= booleanLiteral
					{
					pushFollow(FOLLOW_booleanLiteral_in_graphTerm4049);
					b=booleanLiteral();
					state._fsp--;

					value = b.asNode();
					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:791:7: a= blankNode
					{
					pushFollow(FOLLOW_blankNode_in_graphTerm4061);
					a=blankNode();
					state._fsp--;

					value = a;
					}
					break;
				case 6 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:792:7: nil
					{
					pushFollow(FOLLOW_nil_in_graphTerm4076);
					nil();
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "graphTerm"



	// $ANTLR start "nil"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:795:1: nil : OPEN_BRACE CLOSE_BRACE ;
	public final void nil() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:796:5: ( OPEN_BRACE CLOSE_BRACE )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:796:7: OPEN_BRACE CLOSE_BRACE
			{
			match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_nil4097); 
			match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_nil4099); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "nil"



	// $ANTLR start "expression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:799:1: expression returns [ Expr value ] : ( ^( OR a= expression b= expression ) | ^( AND a= expression b= expression ) | ^( EQUAL a= expression b= expression ) | ^( NOT_EQUAL a= expression b= expression ) | ^( LESS a= expression b= expression ) | ^( GREATER a= expression b= expression ) | ^( LESS_EQUAL a= expression b= expression ) | ^( GREATER_EQUAL a= expression b= expression ) | ^( IN a= expression b= expression ) | ^( NOT IN a= expression b= expression ) | ^( PLUS a= expression b= expression ) | ^( MINUS a= expression b= expression ) | ^( ASTERISK a= expression b= expression ) | ^( DIVIDE a= expression b= expression ) |a= unaryExpression );
	public final Expr expression() throws RecognitionException {
		Expr value = null;


		Expr a =null;
		Expr b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:800:5: ( ^( OR a= expression b= expression ) | ^( AND a= expression b= expression ) | ^( EQUAL a= expression b= expression ) | ^( NOT_EQUAL a= expression b= expression ) | ^( LESS a= expression b= expression ) | ^( GREATER a= expression b= expression ) | ^( LESS_EQUAL a= expression b= expression ) | ^( GREATER_EQUAL a= expression b= expression ) | ^( IN a= expression b= expression ) | ^( NOT IN a= expression b= expression ) | ^( PLUS a= expression b= expression ) | ^( MINUS a= expression b= expression ) | ^( ASTERISK a= expression b= expression ) | ^( DIVIDE a= expression b= expression ) |a= unaryExpression )
			int alt138=15;
			switch ( input.LA(1) ) {
			case OR:
				{
				alt138=1;
				}
				break;
			case AND:
				{
				alt138=2;
				}
				break;
			case EQUAL:
				{
				alt138=3;
				}
				break;
			case NOT_EQUAL:
				{
				alt138=4;
				}
				break;
			case LESS:
				{
				alt138=5;
				}
				break;
			case GREATER:
				{
				alt138=6;
				}
				break;
			case LESS_EQUAL:
				{
				alt138=7;
				}
				break;
			case GREATER_EQUAL:
				{
				alt138=8;
				}
				break;
			case IN:
				{
				alt138=9;
				}
				break;
			case NOT:
				{
				alt138=10;
				}
				break;
			case PLUS:
				{
				alt138=11;
				}
				break;
			case MINUS:
				{
				alt138=12;
				}
				break;
			case ASTERISK:
				{
				alt138=13;
				}
				break;
			case DIVIDE:
				{
				alt138=14;
				}
				break;
			case UNARY:
			case UNARY_MINUS:
			case UNARY_NOT:
			case UNARY_PLUS:
				{
				alt138=15;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 138, 0, input);
				throw nvae;
			}
			switch (alt138) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:800:7: ^( OR a= expression b= expression )
					{
					match(input,OR,FOLLOW_OR_in_expression4121); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4125);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4129);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_LogicalOr         (a, b); 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:801:7: ^( AND a= expression b= expression )
					{
					match(input,AND,FOLLOW_AND_in_expression4152); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4156);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4160);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_LogicalAnd        (a, b); 
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:802:7: ^( EQUAL a= expression b= expression )
					{
					match(input,EQUAL,FOLLOW_EQUAL_in_expression4182); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4186);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4190);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_Equals            (a, b); 
					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:803:7: ^( NOT_EQUAL a= expression b= expression )
					{
					match(input,NOT_EQUAL,FOLLOW_NOT_EQUAL_in_expression4210); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4214);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4218);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_NotEquals         (a, b); 
					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:804:7: ^( LESS a= expression b= expression )
					{
					match(input,LESS,FOLLOW_LESS_in_expression4234); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4238);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4242);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_LessThan          (a, b); 
					}
					break;
				case 6 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:805:7: ^( GREATER a= expression b= expression )
					{
					match(input,GREATER,FOLLOW_GREATER_in_expression4263); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4267);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4271);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_GreaterThan       (a, b); 
					}
					break;
				case 7 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:806:7: ^( LESS_EQUAL a= expression b= expression )
					{
					match(input,LESS_EQUAL,FOLLOW_LESS_EQUAL_in_expression4289); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4293);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4297);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_LessThanOrEqual   (a, b); 
					}
					break;
				case 8 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:807:7: ^( GREATER_EQUAL a= expression b= expression )
					{
					match(input,GREATER_EQUAL,FOLLOW_GREATER_EQUAL_in_expression4312); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4316);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4320);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_GreaterThanOrEqual(a, b); 
					}
					break;
				case 9 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:808:7: ^( IN a= expression b= expression )
					{
					match(input,IN,FOLLOW_IN_in_expression4332); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4336);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4340);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 if(true) { throw new NotImplementedException(); } 
					}
					break;
				case 10 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:809:7: ^( NOT IN a= expression b= expression )
					{
					match(input,NOT,FOLLOW_NOT_in_expression4363); 
					match(input, Token.DOWN, null); 
					match(input,IN,FOLLOW_IN_in_expression4365); 
					pushFollow(FOLLOW_expression_in_expression4369);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4373);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 if(true) { throw new NotImplementedException(); } 
					}
					break;
				case 11 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:810:7: ^( PLUS a= expression b= expression )
					{
					match(input,PLUS,FOLLOW_PLUS_in_expression4392); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4396);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4400);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_Add               (a, b); 
					}
					break;
				case 12 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:811:7: ^( MINUS a= expression b= expression )
					{
					match(input,MINUS,FOLLOW_MINUS_in_expression4421); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4425);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4429);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_Subtract          (a, b); 
					}
					break;
				case 13 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:812:7: ^( ASTERISK a= expression b= expression )
					{
					match(input,ASTERISK,FOLLOW_ASTERISK_in_expression4449); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4453);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4457);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_Multiply          (a, b); 
					}
					break;
				case 14 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:813:7: ^( DIVIDE a= expression b= expression )
					{
					match(input,DIVIDE,FOLLOW_DIVIDE_in_expression4474); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4478);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4482);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_Divide            (a, b); 
					}
					break;
				case 15 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:814:7: a= unaryExpression
					{
					pushFollow(FOLLOW_unaryExpression_in_expression4502);
					a=unaryExpression();
					state._fsp--;

					 value = a; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "expression"



	// $ANTLR start "unaryExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:817:1: unaryExpression returns [ Expr value ] : ( ^( UNARY_NOT a= primaryExpression ) | ^( UNARY_PLUS a= primaryExpression ) | ^( UNARY_MINUS a= primaryExpression ) | ^( UNARY a= primaryExpression ) );
	public final Expr unaryExpression() throws RecognitionException {
		Expr value = null;


		Expr a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:818:5: ( ^( UNARY_NOT a= primaryExpression ) | ^( UNARY_PLUS a= primaryExpression ) | ^( UNARY_MINUS a= primaryExpression ) | ^( UNARY a= primaryExpression ) )
			int alt139=4;
			switch ( input.LA(1) ) {
			case UNARY_NOT:
				{
				alt139=1;
				}
				break;
			case UNARY_PLUS:
				{
				alt139=2;
				}
				break;
			case UNARY_MINUS:
				{
				alt139=3;
				}
				break;
			case UNARY:
				{
				alt139=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 139, 0, input);
				throw nvae;
			}
			switch (alt139) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:818:7: ^( UNARY_NOT a= primaryExpression )
					{
					match(input,UNARY_NOT,FOLLOW_UNARY_NOT_in_unaryExpression4556); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_primaryExpression_in_unaryExpression4560);
					a=primaryExpression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_LogicalNot(a); 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:819:7: ^( UNARY_PLUS a= primaryExpression )
					{
					match(input,UNARY_PLUS,FOLLOW_UNARY_PLUS_in_unaryExpression4580); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_primaryExpression_in_unaryExpression4584);
					a=primaryExpression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_UnaryPlus (a); 
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:820:7: ^( UNARY_MINUS a= primaryExpression )
					{
					match(input,UNARY_MINUS,FOLLOW_UNARY_MINUS_in_unaryExpression4603); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_primaryExpression_in_unaryExpression4607);
					a=primaryExpression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_UnaryMinus(a); 
					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:821:7: ^( UNARY a= primaryExpression )
					{
					match(input,UNARY,FOLLOW_UNARY_in_unaryExpression4625); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_primaryExpression_in_unaryExpression4629);
					a=primaryExpression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = a; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "unaryExpression"



	// $ANTLR start "primaryExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:824:1: primaryExpression returns [Expr value] : (e= builtInCall |e= iriRefOrFunction |n= rdfLiteral |nv= numericLiteral |nv= booleanLiteral |v= var | aggregate );
	public final Expr primaryExpression() throws RecognitionException {
		Expr value = null;


		Expr e =null;
		Node n =null;
		NodeValue nv =null;
		Var v =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:825:5: (e= builtInCall |e= iriRefOrFunction |n= rdfLiteral |nv= numericLiteral |nv= booleanLiteral |v= var | aggregate )
			int alt140=7;
			switch ( input.LA(1) ) {
			case ABS:
			case BNODE:
			case BOUND:
			case CEIL:
			case COALESCE:
			case CONCAT:
			case CONTAINS:
			case DATATYPE:
			case DAY:
			case ENCODE_FOR_URI:
			case EXISTS:
			case FLOOR:
			case HOURS:
			case IF:
			case IRI:
			case ISBLANK:
			case ISIRI:
			case ISLITERAL:
			case ISNUMERIC:
			case ISURI:
			case LANG:
			case LANGMATCHES:
			case LCASE:
			case MD5:
			case MINUTES:
			case MONTH:
			case NOT_EXISTS:
			case NOW:
			case RAND:
			case REGEX:
			case ROUND:
			case SAMETERM:
			case SECONDS:
			case SHA1:
			case SHA224:
			case SHA256:
			case SHA384:
			case SHA512:
			case STR:
			case STRDT:
			case STRENDS:
			case STRLANG:
			case STRLEN:
			case STRSTARTS:
			case SUBSTR:
			case TIMEZONE:
			case TZ:
			case UCASE:
			case URI:
			case YEAR:
				{
				alt140=1;
				}
				break;
			case FUNCTION:
			case IRI_REF:
			case PNAME_LN:
			case PNAME_NS:
				{
				alt140=2;
				}
				break;
			case PLAIN_LITERAL:
			case TYPED_LITERAL:
				{
				alt140=3;
				}
				break;
			case DECIMAL:
			case DECIMAL_NEGATIVE:
			case DECIMAL_POSITIVE:
			case DOUBLE:
			case DOUBLE_NEGATIVE:
			case DOUBLE_POSITIVE:
			case INTEGER:
			case INTEGER_NEGATIVE:
			case INTEGER_POSITIVE:
				{
				alt140=4;
				}
				break;
			case FALSE:
			case TRUE:
				{
				alt140=5;
				}
				break;
			case VAR:
				{
				alt140=6;
				}
				break;
			case AVG:
			case COUNT:
			case GROUP_CONCAT:
			case MAX:
			case MIN:
			case SAMPLE:
			case SUM:
				{
				alt140=7;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 140, 0, input);
				throw nvae;
			}
			switch (alt140) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:825:7: e= builtInCall
					{
					pushFollow(FOLLOW_builtInCall_in_primaryExpression4667);
					e=builtInCall();
					state._fsp--;

					value = e;
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:826:7: e= iriRefOrFunction
					{
					pushFollow(FOLLOW_iriRefOrFunction_in_primaryExpression4685);
					e=iriRefOrFunction();
					state._fsp--;

					value = e;
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:827:7: n= rdfLiteral
					{
					pushFollow(FOLLOW_rdfLiteral_in_primaryExpression4698);
					n=rdfLiteral();
					state._fsp--;

					value = NodeValue.makeNode(n);
					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:828:7: nv= numericLiteral
					{
					pushFollow(FOLLOW_numericLiteral_in_primaryExpression4717);
					nv=numericLiteral();
					state._fsp--;

					value = nv;
					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:829:7: nv= booleanLiteral
					{
					pushFollow(FOLLOW_booleanLiteral_in_primaryExpression4732);
					nv=booleanLiteral();
					state._fsp--;

					value = nv;
					}
					break;
				case 6 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:830:7: v= var
					{
					pushFollow(FOLLOW_var_in_primaryExpression4747);
					v=var();
					state._fsp--;

					value = new ExprVar(v);
					}
					break;
				case 7 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:831:7: aggregate
					{
					pushFollow(FOLLOW_aggregate_in_primaryExpression4771);
					aggregate();
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "primaryExpression"



	// $ANTLR start "builtInCall"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:834:1: builtInCall returns [Expr value] : ( ^( STR a= expression ) | ^( LANG a= expression ) | ^( LANGMATCHES a= expression b= expression ) | ^( DATATYPE a= expression ) | ^( BOUND n= var ) | ^( IRI a= expression ) | ^( URI a= expression ) | ^( BNODE expression ) | RAND | ^( ABS a= expression ) | ^( CEIL a= expression ) | ^( FLOOR a= expression ) | ^( ROUND expression ) | ^( CONCAT l= expressionList ) | subStringExpression | ^( STRLEN expression ) | ^( UCASE expression ) | ^( LCASE expression ) | ^( ENCODE_FOR_URI expression ) | ^( CONTAINS expression ) | ^( STRSTARTS expression ) | ^( STRENDS expression ) | ^( YEAR expression ) | ^( MONTH expression ) | ^( DAY expression ) | ^( HOURS expression ) | ^( MINUTES expression ) | ^( SECONDS expression ) | ^( TIMEZONE expression ) | ^( TZ expression ) | NOW | ^( MD5 expression ) | ^( SHA1 expression ) | ^( SHA224 expression ) | ^( SHA256 expression ) | ^( SHA384 expression ) | ^( SHA512 expression ) | ^( COALESCE expressionList ) | ^( IF expression expression expression ) | ^( STRLANG expression expression ) | ^( STRDT expression expression ) | ^( SAMETERM expression expression ) | ^( ISIRI expression ) | ^( ISURI expression ) | ^( ISBLANK expression ) | ^( ISLITERAL expression ) | ^( ISNUMERIC expression ) | regexExpression | existsFunction | notExistsFunction );
	public final Expr builtInCall() throws RecognitionException {
		Expr value = null;


		Expr a =null;
		Expr b =null;
		Var n =null;
		ExprList l =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:835:5: ( ^( STR a= expression ) | ^( LANG a= expression ) | ^( LANGMATCHES a= expression b= expression ) | ^( DATATYPE a= expression ) | ^( BOUND n= var ) | ^( IRI a= expression ) | ^( URI a= expression ) | ^( BNODE expression ) | RAND | ^( ABS a= expression ) | ^( CEIL a= expression ) | ^( FLOOR a= expression ) | ^( ROUND expression ) | ^( CONCAT l= expressionList ) | subStringExpression | ^( STRLEN expression ) | ^( UCASE expression ) | ^( LCASE expression ) | ^( ENCODE_FOR_URI expression ) | ^( CONTAINS expression ) | ^( STRSTARTS expression ) | ^( STRENDS expression ) | ^( YEAR expression ) | ^( MONTH expression ) | ^( DAY expression ) | ^( HOURS expression ) | ^( MINUTES expression ) | ^( SECONDS expression ) | ^( TIMEZONE expression ) | ^( TZ expression ) | NOW | ^( MD5 expression ) | ^( SHA1 expression ) | ^( SHA224 expression ) | ^( SHA256 expression ) | ^( SHA384 expression ) | ^( SHA512 expression ) | ^( COALESCE expressionList ) | ^( IF expression expression expression ) | ^( STRLANG expression expression ) | ^( STRDT expression expression ) | ^( SAMETERM expression expression ) | ^( ISIRI expression ) | ^( ISURI expression ) | ^( ISBLANK expression ) | ^( ISLITERAL expression ) | ^( ISNUMERIC expression ) | regexExpression | existsFunction | notExistsFunction )
			int alt141=50;
			switch ( input.LA(1) ) {
			case STR:
				{
				alt141=1;
				}
				break;
			case LANG:
				{
				alt141=2;
				}
				break;
			case LANGMATCHES:
				{
				alt141=3;
				}
				break;
			case DATATYPE:
				{
				alt141=4;
				}
				break;
			case BOUND:
				{
				alt141=5;
				}
				break;
			case IRI:
				{
				alt141=6;
				}
				break;
			case URI:
				{
				alt141=7;
				}
				break;
			case BNODE:
				{
				alt141=8;
				}
				break;
			case RAND:
				{
				alt141=9;
				}
				break;
			case ABS:
				{
				alt141=10;
				}
				break;
			case CEIL:
				{
				alt141=11;
				}
				break;
			case FLOOR:
				{
				alt141=12;
				}
				break;
			case ROUND:
				{
				alt141=13;
				}
				break;
			case CONCAT:
				{
				alt141=14;
				}
				break;
			case SUBSTR:
				{
				alt141=15;
				}
				break;
			case STRLEN:
				{
				alt141=16;
				}
				break;
			case UCASE:
				{
				alt141=17;
				}
				break;
			case LCASE:
				{
				alt141=18;
				}
				break;
			case ENCODE_FOR_URI:
				{
				alt141=19;
				}
				break;
			case CONTAINS:
				{
				alt141=20;
				}
				break;
			case STRSTARTS:
				{
				alt141=21;
				}
				break;
			case STRENDS:
				{
				alt141=22;
				}
				break;
			case YEAR:
				{
				alt141=23;
				}
				break;
			case MONTH:
				{
				alt141=24;
				}
				break;
			case DAY:
				{
				alt141=25;
				}
				break;
			case HOURS:
				{
				alt141=26;
				}
				break;
			case MINUTES:
				{
				alt141=27;
				}
				break;
			case SECONDS:
				{
				alt141=28;
				}
				break;
			case TIMEZONE:
				{
				alt141=29;
				}
				break;
			case TZ:
				{
				alt141=30;
				}
				break;
			case NOW:
				{
				alt141=31;
				}
				break;
			case MD5:
				{
				alt141=32;
				}
				break;
			case SHA1:
				{
				alt141=33;
				}
				break;
			case SHA224:
				{
				alt141=34;
				}
				break;
			case SHA256:
				{
				alt141=35;
				}
				break;
			case SHA384:
				{
				alt141=36;
				}
				break;
			case SHA512:
				{
				alt141=37;
				}
				break;
			case COALESCE:
				{
				alt141=38;
				}
				break;
			case IF:
				{
				alt141=39;
				}
				break;
			case STRLANG:
				{
				alt141=40;
				}
				break;
			case STRDT:
				{
				alt141=41;
				}
				break;
			case SAMETERM:
				{
				alt141=42;
				}
				break;
			case ISIRI:
				{
				alt141=43;
				}
				break;
			case ISURI:
				{
				alt141=44;
				}
				break;
			case ISBLANK:
				{
				alt141=45;
				}
				break;
			case ISLITERAL:
				{
				alt141=46;
				}
				break;
			case ISNUMERIC:
				{
				alt141=47;
				}
				break;
			case REGEX:
				{
				alt141=48;
				}
				break;
			case EXISTS:
				{
				alt141=49;
				}
				break;
			case NOT_EXISTS:
				{
				alt141=50;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 141, 0, input);
				throw nvae;
			}
			switch (alt141) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:835:7: ^( STR a= expression )
					{
					match(input,STR,FOLLOW_STR_in_builtInCall4793); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall4797);
					a=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					value = new E_Str(a);
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:836:7: ^( LANG a= expression )
					{
					match(input,LANG,FOLLOW_LANG_in_builtInCall4822); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall4826);
					a=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					value = new E_Lang(a);
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:837:7: ^( LANGMATCHES a= expression b= expression )
					{
					match(input,LANGMATCHES,FOLLOW_LANGMATCHES_in_builtInCall4849); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall4853);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_builtInCall4857);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					value = new E_LangMatches(a, b);
					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:838:7: ^( DATATYPE a= expression )
					{
					match(input,DATATYPE,FOLLOW_DATATYPE_in_builtInCall4872); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall4876);
					a=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:839:7: ^( BOUND n= var )
					{
					match(input,BOUND,FOLLOW_BOUND_in_builtInCall4886); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_var_in_builtInCall4890);
					n=var();
					state._fsp--;

					match(input, Token.UP, null); 

					value = new E_Bound(new ExprVar(n));
					}
					break;
				case 6 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:840:7: ^( IRI a= expression )
					{
					match(input,IRI,FOLLOW_IRI_in_builtInCall4919); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall4923);
					a=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 7 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:841:7: ^( URI a= expression )
					{
					match(input,URI,FOLLOW_URI_in_builtInCall4933); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall4937);
					a=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 8 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:842:7: ^( BNODE expression )
					{
					match(input,BNODE,FOLLOW_BNODE_in_builtInCall4947); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall4949);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 9 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:843:7: RAND
					{
					match(input,RAND,FOLLOW_RAND_in_builtInCall4958); 
					}
					break;
				case 10 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:844:7: ^( ABS a= expression )
					{
					match(input,ABS,FOLLOW_ABS_in_builtInCall4967); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall4971);
					a=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 11 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:845:7: ^( CEIL a= expression )
					{
					match(input,CEIL,FOLLOW_CEIL_in_builtInCall4981); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall4985);
					a=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 12 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:846:7: ^( FLOOR a= expression )
					{
					match(input,FLOOR,FOLLOW_FLOOR_in_builtInCall4995); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall4999);
					a=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 13 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:847:7: ^( ROUND expression )
					{
					match(input,ROUND,FOLLOW_ROUND_in_builtInCall5009); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5011);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 14 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:848:7: ^( CONCAT l= expressionList )
					{
					match(input,CONCAT,FOLLOW_CONCAT_in_builtInCall5021); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expressionList_in_builtInCall5025);
					l=expressionList();
					state._fsp--;

					match(input, Token.UP, null); 

					value = new E_StrConcatPermissive(l);
					}
					break;
				case 15 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:849:7: subStringExpression
					{
					pushFollow(FOLLOW_subStringExpression_in_builtInCall5041);
					subStringExpression();
					state._fsp--;

					}
					break;
				case 16 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:850:7: ^( STRLEN expression )
					{
					match(input,STRLEN,FOLLOW_STRLEN_in_builtInCall5050); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5052);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 17 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:851:7: ^( UCASE expression )
					{
					match(input,UCASE,FOLLOW_UCASE_in_builtInCall5062); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5064);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 18 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:852:7: ^( LCASE expression )
					{
					match(input,LCASE,FOLLOW_LCASE_in_builtInCall5074); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5076);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 19 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:853:7: ^( ENCODE_FOR_URI expression )
					{
					match(input,ENCODE_FOR_URI,FOLLOW_ENCODE_FOR_URI_in_builtInCall5086); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5088);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 20 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:854:7: ^( CONTAINS expression )
					{
					match(input,CONTAINS,FOLLOW_CONTAINS_in_builtInCall5098); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5100);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 21 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:855:7: ^( STRSTARTS expression )
					{
					match(input,STRSTARTS,FOLLOW_STRSTARTS_in_builtInCall5110); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5112);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 22 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:856:7: ^( STRENDS expression )
					{
					match(input,STRENDS,FOLLOW_STRENDS_in_builtInCall5122); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5124);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 23 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:857:7: ^( YEAR expression )
					{
					match(input,YEAR,FOLLOW_YEAR_in_builtInCall5134); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5136);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 24 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:858:7: ^( MONTH expression )
					{
					match(input,MONTH,FOLLOW_MONTH_in_builtInCall5146); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5148);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 25 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:859:7: ^( DAY expression )
					{
					match(input,DAY,FOLLOW_DAY_in_builtInCall5158); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5160);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 26 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:860:7: ^( HOURS expression )
					{
					match(input,HOURS,FOLLOW_HOURS_in_builtInCall5170); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5172);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 27 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:861:7: ^( MINUTES expression )
					{
					match(input,MINUTES,FOLLOW_MINUTES_in_builtInCall5182); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5184);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 28 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:862:7: ^( SECONDS expression )
					{
					match(input,SECONDS,FOLLOW_SECONDS_in_builtInCall5194); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5196);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 29 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:863:7: ^( TIMEZONE expression )
					{
					match(input,TIMEZONE,FOLLOW_TIMEZONE_in_builtInCall5206); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5208);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 30 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:864:7: ^( TZ expression )
					{
					match(input,TZ,FOLLOW_TZ_in_builtInCall5218); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5220);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 31 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:865:7: NOW
					{
					match(input,NOW,FOLLOW_NOW_in_builtInCall5229); 
					}
					break;
				case 32 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:866:7: ^( MD5 expression )
					{
					match(input,MD5,FOLLOW_MD5_in_builtInCall5238); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5240);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 33 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:867:7: ^( SHA1 expression )
					{
					match(input,SHA1,FOLLOW_SHA1_in_builtInCall5250); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5252);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 34 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:868:7: ^( SHA224 expression )
					{
					match(input,SHA224,FOLLOW_SHA224_in_builtInCall5262); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5264);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 35 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:869:7: ^( SHA256 expression )
					{
					match(input,SHA256,FOLLOW_SHA256_in_builtInCall5274); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5276);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 36 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:870:7: ^( SHA384 expression )
					{
					match(input,SHA384,FOLLOW_SHA384_in_builtInCall5286); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5288);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 37 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:871:7: ^( SHA512 expression )
					{
					match(input,SHA512,FOLLOW_SHA512_in_builtInCall5298); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5300);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 38 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:872:7: ^( COALESCE expressionList )
					{
					match(input,COALESCE,FOLLOW_COALESCE_in_builtInCall5310); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expressionList_in_builtInCall5312);
					expressionList();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 39 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:873:7: ^( IF expression expression expression )
					{
					match(input,IF,FOLLOW_IF_in_builtInCall5322); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5324);
					expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_builtInCall5326);
					expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_builtInCall5328);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 40 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:874:7: ^( STRLANG expression expression )
					{
					match(input,STRLANG,FOLLOW_STRLANG_in_builtInCall5338); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5340);
					expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_builtInCall5342);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 41 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:875:7: ^( STRDT expression expression )
					{
					match(input,STRDT,FOLLOW_STRDT_in_builtInCall5352); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5354);
					expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_builtInCall5356);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 42 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:876:7: ^( SAMETERM expression expression )
					{
					match(input,SAMETERM,FOLLOW_SAMETERM_in_builtInCall5366); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5368);
					expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_builtInCall5370);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 43 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:877:7: ^( ISIRI expression )
					{
					match(input,ISIRI,FOLLOW_ISIRI_in_builtInCall5380); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5382);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 44 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:878:7: ^( ISURI expression )
					{
					match(input,ISURI,FOLLOW_ISURI_in_builtInCall5392); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5394);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 45 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:879:7: ^( ISBLANK expression )
					{
					match(input,ISBLANK,FOLLOW_ISBLANK_in_builtInCall5404); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5406);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 46 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:880:7: ^( ISLITERAL expression )
					{
					match(input,ISLITERAL,FOLLOW_ISLITERAL_in_builtInCall5417); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5419);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 47 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:881:7: ^( ISNUMERIC expression )
					{
					match(input,ISNUMERIC,FOLLOW_ISNUMERIC_in_builtInCall5429); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5431);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 48 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:882:7: regexExpression
					{
					pushFollow(FOLLOW_regexExpression_in_builtInCall5440);
					regexExpression();
					state._fsp--;

					}
					break;
				case 49 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:883:7: existsFunction
					{
					pushFollow(FOLLOW_existsFunction_in_builtInCall5448);
					existsFunction();
					state._fsp--;

					}
					break;
				case 50 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:884:7: notExistsFunction
					{
					pushFollow(FOLLOW_notExistsFunction_in_builtInCall5456);
					notExistsFunction();
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "builtInCall"



	// $ANTLR start "regexExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:887:1: regexExpression : ^( REGEX ( expression )+ ) ;
	public final void regexExpression() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:888:5: ( ^( REGEX ( expression )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:888:7: ^( REGEX ( expression )+ )
			{
			match(input,REGEX,FOLLOW_REGEX_in_regexExpression5474); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:888:15: ( expression )+
			int cnt142=0;
			loop142:
			while (true) {
				int alt142=2;
				int LA142_0 = input.LA(1);
				if ( (LA142_0==AND||LA142_0==ASTERISK||LA142_0==DIVIDE||LA142_0==EQUAL||(LA142_0 >= GREATER && LA142_0 <= GREATER_EQUAL)||LA142_0==IN||(LA142_0 >= LESS && LA142_0 <= LESS_EQUAL)||LA142_0==MINUS||(LA142_0 >= NOT && LA142_0 <= NOT_EQUAL)||LA142_0==OR||LA142_0==PLUS||(LA142_0 >= UNARY && LA142_0 <= UNARY_PLUS)) ) {
					alt142=1;
				}

				switch (alt142) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:888:15: expression
					{
					pushFollow(FOLLOW_expression_in_regexExpression5476);
					expression();
					state._fsp--;

					}
					break;

				default :
					if ( cnt142 >= 1 ) break loop142;
					EarlyExitException eee = new EarlyExitException(142, input);
					throw eee;
				}
				cnt142++;
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "regexExpression"



	// $ANTLR start "subStringExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:891:1: subStringExpression : ^( SUBSTR ( expression )+ ) ;
	public final void subStringExpression() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:892:5: ( ^( SUBSTR ( expression )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:892:7: ^( SUBSTR ( expression )+ )
			{
			match(input,SUBSTR,FOLLOW_SUBSTR_in_subStringExpression5500); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:892:16: ( expression )+
			int cnt143=0;
			loop143:
			while (true) {
				int alt143=2;
				int LA143_0 = input.LA(1);
				if ( (LA143_0==AND||LA143_0==ASTERISK||LA143_0==DIVIDE||LA143_0==EQUAL||(LA143_0 >= GREATER && LA143_0 <= GREATER_EQUAL)||LA143_0==IN||(LA143_0 >= LESS && LA143_0 <= LESS_EQUAL)||LA143_0==MINUS||(LA143_0 >= NOT && LA143_0 <= NOT_EQUAL)||LA143_0==OR||LA143_0==PLUS||(LA143_0 >= UNARY && LA143_0 <= UNARY_PLUS)) ) {
					alt143=1;
				}

				switch (alt143) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:892:16: expression
					{
					pushFollow(FOLLOW_expression_in_subStringExpression5502);
					expression();
					state._fsp--;

					}
					break;

				default :
					if ( cnt143 >= 1 ) break loop143;
					EarlyExitException eee = new EarlyExitException(143, input);
					throw eee;
				}
				cnt143++;
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "subStringExpression"



	// $ANTLR start "existsFunction"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:895:1: existsFunction : ^( EXISTS groupGraphPattern ) ;
	public final void existsFunction() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:896:5: ( ^( EXISTS groupGraphPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:896:7: ^( EXISTS groupGraphPattern )
			{
			match(input,EXISTS,FOLLOW_EXISTS_in_existsFunction5526); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_groupGraphPattern_in_existsFunction5528);
			groupGraphPattern();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "existsFunction"



	// $ANTLR start "notExistsFunction"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:899:1: notExistsFunction : ^( NOT_EXISTS groupGraphPattern ) ;
	public final void notExistsFunction() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:900:5: ( ^( NOT_EXISTS groupGraphPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:900:7: ^( NOT_EXISTS groupGraphPattern )
			{
			match(input,NOT_EXISTS,FOLLOW_NOT_EXISTS_in_notExistsFunction5547); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_groupGraphPattern_in_notExistsFunction5549);
			groupGraphPattern();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "notExistsFunction"



	// $ANTLR start "aggregate"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:903:1: aggregate : ( ^( COUNT ( DISTINCT )* ( ASTERISK )* ( expression )* ) | ^( SUM ( DISTINCT )* expression ) | ^( MIN ( DISTINCT )* expression ) | ^( MAX ( DISTINCT )* expression ) | ^( AVG ( DISTINCT )* expression ) | ^( SAMPLE ( DISTINCT )? expression ) | ^( GROUP_CONCAT ( DISTINCT )* expression ( string )? ) );
	public final void aggregate() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:904:5: ( ^( COUNT ( DISTINCT )* ( ASTERISK )* ( expression )* ) | ^( SUM ( DISTINCT )* expression ) | ^( MIN ( DISTINCT )* expression ) | ^( MAX ( DISTINCT )* expression ) | ^( AVG ( DISTINCT )* expression ) | ^( SAMPLE ( DISTINCT )? expression ) | ^( GROUP_CONCAT ( DISTINCT )* expression ( string )? ) )
			int alt154=7;
			switch ( input.LA(1) ) {
			case COUNT:
				{
				alt154=1;
				}
				break;
			case SUM:
				{
				alt154=2;
				}
				break;
			case MIN:
				{
				alt154=3;
				}
				break;
			case MAX:
				{
				alt154=4;
				}
				break;
			case AVG:
				{
				alt154=5;
				}
				break;
			case SAMPLE:
				{
				alt154=6;
				}
				break;
			case GROUP_CONCAT:
				{
				alt154=7;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 154, 0, input);
				throw nvae;
			}
			switch (alt154) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:904:7: ^( COUNT ( DISTINCT )* ( ASTERISK )* ( expression )* )
					{
					match(input,COUNT,FOLLOW_COUNT_in_aggregate5568); 
					if ( input.LA(1)==Token.DOWN ) {
						match(input, Token.DOWN, null); 
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:904:15: ( DISTINCT )*
						loop144:
						while (true) {
							int alt144=2;
							int LA144_0 = input.LA(1);
							if ( (LA144_0==DISTINCT) ) {
								alt144=1;
							}

							switch (alt144) {
							case 1 :
								// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:904:15: DISTINCT
								{
								match(input,DISTINCT,FOLLOW_DISTINCT_in_aggregate5570); 
								}
								break;

							default :
								break loop144;
							}
						}

						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:904:25: ( ASTERISK )*
						loop145:
						while (true) {
							int alt145=2;
							int LA145_0 = input.LA(1);
							if ( (LA145_0==ASTERISK) ) {
								int LA145_2 = input.LA(2);
								if ( (LA145_2==UP||LA145_2==AND||LA145_2==ASTERISK||LA145_2==DIVIDE||LA145_2==EQUAL||(LA145_2 >= GREATER && LA145_2 <= GREATER_EQUAL)||LA145_2==IN||(LA145_2 >= LESS && LA145_2 <= LESS_EQUAL)||LA145_2==MINUS||(LA145_2 >= NOT && LA145_2 <= NOT_EQUAL)||LA145_2==OR||LA145_2==PLUS||(LA145_2 >= UNARY && LA145_2 <= UNARY_PLUS)) ) {
									alt145=1;
								}

							}

							switch (alt145) {
							case 1 :
								// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:904:25: ASTERISK
								{
								match(input,ASTERISK,FOLLOW_ASTERISK_in_aggregate5573); 
								}
								break;

							default :
								break loop145;
							}
						}

						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:904:35: ( expression )*
						loop146:
						while (true) {
							int alt146=2;
							int LA146_0 = input.LA(1);
							if ( (LA146_0==AND||LA146_0==ASTERISK||LA146_0==DIVIDE||LA146_0==EQUAL||(LA146_0 >= GREATER && LA146_0 <= GREATER_EQUAL)||LA146_0==IN||(LA146_0 >= LESS && LA146_0 <= LESS_EQUAL)||LA146_0==MINUS||(LA146_0 >= NOT && LA146_0 <= NOT_EQUAL)||LA146_0==OR||LA146_0==PLUS||(LA146_0 >= UNARY && LA146_0 <= UNARY_PLUS)) ) {
								alt146=1;
							}

							switch (alt146) {
							case 1 :
								// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:904:35: expression
								{
								pushFollow(FOLLOW_expression_in_aggregate5576);
								expression();
								state._fsp--;

								}
								break;

							default :
								break loop146;
							}
						}

						match(input, Token.UP, null); 
					}

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:905:7: ^( SUM ( DISTINCT )* expression )
					{
					match(input,SUM,FOLLOW_SUM_in_aggregate5587); 
					match(input, Token.DOWN, null); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:905:13: ( DISTINCT )*
					loop147:
					while (true) {
						int alt147=2;
						int LA147_0 = input.LA(1);
						if ( (LA147_0==DISTINCT) ) {
							alt147=1;
						}

						switch (alt147) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:905:13: DISTINCT
							{
							match(input,DISTINCT,FOLLOW_DISTINCT_in_aggregate5589); 
							}
							break;

						default :
							break loop147;
						}
					}

					pushFollow(FOLLOW_expression_in_aggregate5592);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:906:7: ^( MIN ( DISTINCT )* expression )
					{
					match(input,MIN,FOLLOW_MIN_in_aggregate5602); 
					match(input, Token.DOWN, null); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:906:13: ( DISTINCT )*
					loop148:
					while (true) {
						int alt148=2;
						int LA148_0 = input.LA(1);
						if ( (LA148_0==DISTINCT) ) {
							alt148=1;
						}

						switch (alt148) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:906:13: DISTINCT
							{
							match(input,DISTINCT,FOLLOW_DISTINCT_in_aggregate5604); 
							}
							break;

						default :
							break loop148;
						}
					}

					pushFollow(FOLLOW_expression_in_aggregate5607);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:907:7: ^( MAX ( DISTINCT )* expression )
					{
					match(input,MAX,FOLLOW_MAX_in_aggregate5617); 
					match(input, Token.DOWN, null); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:907:13: ( DISTINCT )*
					loop149:
					while (true) {
						int alt149=2;
						int LA149_0 = input.LA(1);
						if ( (LA149_0==DISTINCT) ) {
							alt149=1;
						}

						switch (alt149) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:907:13: DISTINCT
							{
							match(input,DISTINCT,FOLLOW_DISTINCT_in_aggregate5619); 
							}
							break;

						default :
							break loop149;
						}
					}

					pushFollow(FOLLOW_expression_in_aggregate5622);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:908:7: ^( AVG ( DISTINCT )* expression )
					{
					match(input,AVG,FOLLOW_AVG_in_aggregate5632); 
					match(input, Token.DOWN, null); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:908:13: ( DISTINCT )*
					loop150:
					while (true) {
						int alt150=2;
						int LA150_0 = input.LA(1);
						if ( (LA150_0==DISTINCT) ) {
							alt150=1;
						}

						switch (alt150) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:908:13: DISTINCT
							{
							match(input,DISTINCT,FOLLOW_DISTINCT_in_aggregate5634); 
							}
							break;

						default :
							break loop150;
						}
					}

					pushFollow(FOLLOW_expression_in_aggregate5637);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 6 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:909:7: ^( SAMPLE ( DISTINCT )? expression )
					{
					match(input,SAMPLE,FOLLOW_SAMPLE_in_aggregate5647); 
					match(input, Token.DOWN, null); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:909:16: ( DISTINCT )?
					int alt151=2;
					int LA151_0 = input.LA(1);
					if ( (LA151_0==DISTINCT) ) {
						alt151=1;
					}
					switch (alt151) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:909:16: DISTINCT
							{
							match(input,DISTINCT,FOLLOW_DISTINCT_in_aggregate5649); 
							}
							break;

					}

					pushFollow(FOLLOW_expression_in_aggregate5652);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 7 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:910:7: ^( GROUP_CONCAT ( DISTINCT )* expression ( string )? )
					{
					match(input,GROUP_CONCAT,FOLLOW_GROUP_CONCAT_in_aggregate5662); 
					match(input, Token.DOWN, null); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:910:22: ( DISTINCT )*
					loop152:
					while (true) {
						int alt152=2;
						int LA152_0 = input.LA(1);
						if ( (LA152_0==DISTINCT) ) {
							alt152=1;
						}

						switch (alt152) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:910:22: DISTINCT
							{
							match(input,DISTINCT,FOLLOW_DISTINCT_in_aggregate5664); 
							}
							break;

						default :
							break loop152;
						}
					}

					pushFollow(FOLLOW_expression_in_aggregate5667);
					expression();
					state._fsp--;

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:910:43: ( string )?
					int alt153=2;
					int LA153_0 = input.LA(1);
					if ( ((LA153_0 >= STRING_LITERAL1 && LA153_0 <= STRING_LITERAL_LONG2)) ) {
						alt153=1;
					}
					switch (alt153) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:910:43: string
							{
							pushFollow(FOLLOW_string_in_aggregate5669);
							string();
							state._fsp--;

							}
							break;

					}

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "aggregate"



	// $ANTLR start "iriRefOrFunction"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:913:1: iriRefOrFunction returns [Expr value] : (a= iriRef | ^( FUNCTION a= iriRef ^( ARG_LIST b= argList ) ) );
	public final Expr iriRefOrFunction() throws RecognitionException {
		Expr value = null;


		Node a =null;
		ExprList b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:914:5: (a= iriRef | ^( FUNCTION a= iriRef ^( ARG_LIST b= argList ) ) )
			int alt155=2;
			int LA155_0 = input.LA(1);
			if ( (LA155_0==IRI_REF||(LA155_0 >= PNAME_LN && LA155_0 <= PNAME_NS)) ) {
				alt155=1;
			}
			else if ( (LA155_0==FUNCTION) ) {
				alt155=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 155, 0, input);
				throw nvae;
			}

			switch (alt155) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:914:7: a= iriRef
					{
					pushFollow(FOLLOW_iriRef_in_iriRefOrFunction5698);
					a=iriRef();
					state._fsp--;

					value = NodeValue.makeNode(a);
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:915:7: ^( FUNCTION a= iriRef ^( ARG_LIST b= argList ) )
					{
					match(input,FUNCTION,FOLLOW_FUNCTION_in_iriRefOrFunction5744); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_iriRef_in_iriRefOrFunction5748);
					a=iriRef();
					state._fsp--;

					match(input,ARG_LIST,FOLLOW_ARG_LIST_in_iriRefOrFunction5751); 
					if ( input.LA(1)==Token.DOWN ) {
						match(input, Token.DOWN, null); 
						pushFollow(FOLLOW_argList_in_iriRefOrFunction5755);
						b=argList();
						state._fsp--;

						match(input, Token.UP, null); 
					}

					match(input, Token.UP, null); 

					value = new E_Function(a.toString(), b);
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "iriRefOrFunction"



	// $ANTLR start "rdfLiteral"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:918:1: rdfLiteral returns [Node value] : ( ^( PLAIN_LITERAL a= string (b= LANGTAG )? ) | ^( TYPED_LITERAL a= string c= iriRef ) );
	public final Node rdfLiteral() throws RecognitionException {
		Node value = null;


		CommonTree b=null;
		String a =null;
		Node c =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:919:5: ( ^( PLAIN_LITERAL a= string (b= LANGTAG )? ) | ^( TYPED_LITERAL a= string c= iriRef ) )
			int alt157=2;
			int LA157_0 = input.LA(1);
			if ( (LA157_0==PLAIN_LITERAL) ) {
				alt157=1;
			}
			else if ( (LA157_0==TYPED_LITERAL) ) {
				alt157=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 157, 0, input);
				throw nvae;
			}

			switch (alt157) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:919:7: ^( PLAIN_LITERAL a= string (b= LANGTAG )? )
					{
					match(input,PLAIN_LITERAL,FOLLOW_PLAIN_LITERAL_in_rdfLiteral5781); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_string_in_rdfLiteral5785);
					a=string();
					state._fsp--;

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:919:33: (b= LANGTAG )?
					int alt156=2;
					int LA156_0 = input.LA(1);
					if ( (LA156_0==LANGTAG) ) {
						alt156=1;
					}
					switch (alt156) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:919:33: b= LANGTAG
							{
							b=(CommonTree)match(input,LANGTAG,FOLLOW_LANGTAG_in_rdfLiteral5789); 
							}
							break;

					}

					match(input, Token.UP, null); 

					value = Node.createLiteral(a, (b!=null?b.getText():null), null);
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:920:7: ^( TYPED_LITERAL a= string c= iriRef )
					{
					match(input,TYPED_LITERAL,FOLLOW_TYPED_LITERAL_in_rdfLiteral5802); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_string_in_rdfLiteral5806);
					a=string();
					state._fsp--;

					pushFollow(FOLLOW_iriRef_in_rdfLiteral5810);
					c=iriRef();
					state._fsp--;

					match(input, Token.UP, null); 

					value = Node.createLiteral(a, null, TypeMapper.getInstance().getSafeTypeByName(c == null ? null : c.toString()));
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "rdfLiteral"



	// $ANTLR start "numericLiteral"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:925:1: numericLiteral returns [ NodeValue value ] : (a= numericLiteralUnsigned |a= numericLiteralPositive |a= numericLiteralNegative );
	public final NodeValue numericLiteral() throws RecognitionException {
		NodeValue value = null;


		NodeValue a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:926:5: (a= numericLiteralUnsigned |a= numericLiteralPositive |a= numericLiteralNegative )
			int alt158=3;
			switch ( input.LA(1) ) {
			case DECIMAL:
			case DOUBLE:
			case INTEGER:
				{
				alt158=1;
				}
				break;
			case DECIMAL_POSITIVE:
			case DOUBLE_POSITIVE:
			case INTEGER_POSITIVE:
				{
				alt158=2;
				}
				break;
			case DECIMAL_NEGATIVE:
			case DOUBLE_NEGATIVE:
			case INTEGER_NEGATIVE:
				{
				alt158=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 158, 0, input);
				throw nvae;
			}
			switch (alt158) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:926:7: a= numericLiteralUnsigned
					{
					pushFollow(FOLLOW_numericLiteralUnsigned_in_numericLiteral5846);
					a=numericLiteralUnsigned();
					state._fsp--;

					 value = a; 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:927:7: a= numericLiteralPositive
					{
					pushFollow(FOLLOW_numericLiteralPositive_in_numericLiteral5859);
					a=numericLiteralPositive();
					state._fsp--;

					 value = a; 
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:928:7: a= numericLiteralNegative
					{
					pushFollow(FOLLOW_numericLiteralNegative_in_numericLiteral5871);
					a=numericLiteralNegative();
					state._fsp--;

					 value = a; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "numericLiteral"



	// $ANTLR start "numericLiteralUnsigned"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:931:1: numericLiteralUnsigned returns [ NodeValue value ] : (a= INTEGER |a= DECIMAL |a= DOUBLE );
	public final NodeValue numericLiteralUnsigned() throws RecognitionException {
		NodeValue value = null;


		CommonTree a=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:932:5: (a= INTEGER |a= DECIMAL |a= DOUBLE )
			int alt159=3;
			switch ( input.LA(1) ) {
			case INTEGER:
				{
				alt159=1;
				}
				break;
			case DECIMAL:
				{
				alt159=2;
				}
				break;
			case DOUBLE:
				{
				alt159=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 159, 0, input);
				throw nvae;
			}
			switch (alt159) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:932:7: a= INTEGER
					{
					a=(CommonTree)match(input,INTEGER,FOLLOW_INTEGER_in_numericLiteralUnsigned5896); 
					 value =NodeValue.makeInteger((a!=null?a.getText():null)); 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:933:7: a= DECIMAL
					{
					a=(CommonTree)match(input,DECIMAL,FOLLOW_DECIMAL_in_numericLiteralUnsigned5908); 
					 value =NodeValue.makeDecimal((a!=null?a.getText():null)); 
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:934:7: a= DOUBLE
					{
					a=(CommonTree)match(input,DOUBLE,FOLLOW_DOUBLE_in_numericLiteralUnsigned5920); 
					 value =NodeValue.makeDouble(Double.parseDouble((a!=null?a.getText():null))); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "numericLiteralUnsigned"



	// $ANTLR start "numericLiteralPositive"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:937:1: numericLiteralPositive returns [ NodeValue value ] : (a= INTEGER_POSITIVE |a= DECIMAL_POSITIVE |a= DOUBLE_POSITIVE );
	public final NodeValue numericLiteralPositive() throws RecognitionException {
		NodeValue value = null;


		CommonTree a=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:938:5: (a= INTEGER_POSITIVE |a= DECIMAL_POSITIVE |a= DOUBLE_POSITIVE )
			int alt160=3;
			switch ( input.LA(1) ) {
			case INTEGER_POSITIVE:
				{
				alt160=1;
				}
				break;
			case DECIMAL_POSITIVE:
				{
				alt160=2;
				}
				break;
			case DOUBLE_POSITIVE:
				{
				alt160=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 160, 0, input);
				throw nvae;
			}
			switch (alt160) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:938:7: a= INTEGER_POSITIVE
					{
					a=(CommonTree)match(input,INTEGER_POSITIVE,FOLLOW_INTEGER_POSITIVE_in_numericLiteralPositive5946); 
					 value =NodeValue.makeInteger((a!=null?a.getText():null)); 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:939:7: a= DECIMAL_POSITIVE
					{
					a=(CommonTree)match(input,DECIMAL_POSITIVE,FOLLOW_DECIMAL_POSITIVE_in_numericLiteralPositive5958); 
					 value =NodeValue.makeDecimal((a!=null?a.getText():null)); 
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:940:7: a= DOUBLE_POSITIVE
					{
					a=(CommonTree)match(input,DOUBLE_POSITIVE,FOLLOW_DOUBLE_POSITIVE_in_numericLiteralPositive5970); 
					 value =NodeValue.makeDouble(Double.parseDouble((a!=null?a.getText():null))); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "numericLiteralPositive"



	// $ANTLR start "numericLiteralNegative"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:943:1: numericLiteralNegative returns [ NodeValue value ] : (a= INTEGER_NEGATIVE |a= DECIMAL_NEGATIVE |a= DOUBLE_NEGATIVE );
	public final NodeValue numericLiteralNegative() throws RecognitionException {
		NodeValue value = null;


		CommonTree a=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:944:5: (a= INTEGER_NEGATIVE |a= DECIMAL_NEGATIVE |a= DOUBLE_NEGATIVE )
			int alt161=3;
			switch ( input.LA(1) ) {
			case INTEGER_NEGATIVE:
				{
				alt161=1;
				}
				break;
			case DECIMAL_NEGATIVE:
				{
				alt161=2;
				}
				break;
			case DOUBLE_NEGATIVE:
				{
				alt161=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 161, 0, input);
				throw nvae;
			}
			switch (alt161) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:944:7: a= INTEGER_NEGATIVE
					{
					a=(CommonTree)match(input,INTEGER_NEGATIVE,FOLLOW_INTEGER_NEGATIVE_in_numericLiteralNegative5996); 
					 value =NodeValue.makeInteger((a!=null?a.getText():null)); 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:945:7: a= DECIMAL_NEGATIVE
					{
					a=(CommonTree)match(input,DECIMAL_NEGATIVE,FOLLOW_DECIMAL_NEGATIVE_in_numericLiteralNegative6008); 
					 value =NodeValue.makeDecimal((a!=null?a.getText():null)); 
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:946:7: a= DOUBLE_NEGATIVE
					{
					a=(CommonTree)match(input,DOUBLE_NEGATIVE,FOLLOW_DOUBLE_NEGATIVE_in_numericLiteralNegative6020); 
					 value =NodeValue.makeDouble(Double.parseDouble((a!=null?a.getText():null))); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "numericLiteralNegative"



	// $ANTLR start "booleanLiteral"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:949:1: booleanLiteral returns [ NodeValue value ] : ( TRUE | FALSE );
	public final NodeValue booleanLiteral() throws RecognitionException {
		NodeValue value = null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:950:5: ( TRUE | FALSE )
			int alt162=2;
			int LA162_0 = input.LA(1);
			if ( (LA162_0==TRUE) ) {
				alt162=1;
			}
			else if ( (LA162_0==FALSE) ) {
				alt162=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 162, 0, input);
				throw nvae;
			}

			switch (alt162) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:950:7: TRUE
					{
					match(input,TRUE,FOLLOW_TRUE_in_booleanLiteral6044); 
					 value = NodeValue.TRUE; 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:951:7: FALSE
					{
					match(input,FALSE,FOLLOW_FALSE_in_booleanLiteral6055); 
					 value = NodeValue.FALSE; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "booleanLiteral"



	// $ANTLR start "string"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:954:1: string returns [String value] : (a= STRING_LITERAL1 |a= STRING_LITERAL2 |a= STRING_LITERAL_LONG1 |a= STRING_LITERAL_LONG2 );
	public final String string() throws RecognitionException {
		String value = null;


		CommonTree a=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:955:5: (a= STRING_LITERAL1 |a= STRING_LITERAL2 |a= STRING_LITERAL_LONG1 |a= STRING_LITERAL_LONG2 )
			int alt163=4;
			switch ( input.LA(1) ) {
			case STRING_LITERAL1:
				{
				alt163=1;
				}
				break;
			case STRING_LITERAL2:
				{
				alt163=2;
				}
				break;
			case STRING_LITERAL_LONG1:
				{
				alt163=3;
				}
				break;
			case STRING_LITERAL_LONG2:
				{
				alt163=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 163, 0, input);
				throw nvae;
			}
			switch (alt163) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:955:7: a= STRING_LITERAL1
					{
					a=(CommonTree)match(input,STRING_LITERAL1,FOLLOW_STRING_LITERAL1_in_string6080); 
					value = (a!=null?a.getText():null);
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:956:7: a= STRING_LITERAL2
					{
					a=(CommonTree)match(input,STRING_LITERAL2,FOLLOW_STRING_LITERAL2_in_string6097); 
					value = (a!=null?a.getText():null);
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:957:7: a= STRING_LITERAL_LONG1
					{
					a=(CommonTree)match(input,STRING_LITERAL_LONG1,FOLLOW_STRING_LITERAL_LONG1_in_string6114); 
					value = (a!=null?a.getText():null);
					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:958:7: a= STRING_LITERAL_LONG2
					{
					a=(CommonTree)match(input,STRING_LITERAL_LONG2,FOLLOW_STRING_LITERAL_LONG2_in_string6126); 
					value = (a!=null?a.getText():null);
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "string"



	// $ANTLR start "iriRef"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:961:1: iriRef returns [Node value] : (a= IRI_REF |b= prefixedName );
	public final Node iriRef() throws RecognitionException {
		Node value = null;


		CommonTree a=null;
		Node b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:962:5: (a= IRI_REF |b= prefixedName )
			int alt164=2;
			int LA164_0 = input.LA(1);
			if ( (LA164_0==IRI_REF) ) {
				alt164=1;
			}
			else if ( ((LA164_0 >= PNAME_LN && LA164_0 <= PNAME_NS)) ) {
				alt164=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 164, 0, input);
				throw nvae;
			}

			switch (alt164) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:962:7: a= IRI_REF
					{
					a=(CommonTree)match(input,IRI_REF,FOLLOW_IRI_REF_in_iriRef6151); 
					value = Node.createURI((a!=null?a.getText():null));
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:963:7: b= prefixedName
					{
					pushFollow(FOLLOW_prefixedName_in_iriRef6169);
					b=prefixedName();
					state._fsp--;

					value = b;
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "iriRef"



	// $ANTLR start "prefixedName"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:966:1: prefixedName returns [Node value] : (a= PNAME_LN |a= PNAME_NS );
	public final Node prefixedName() throws RecognitionException {
		Node value = null;


		CommonTree a=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:967:5: (a= PNAME_LN |a= PNAME_NS )
			int alt165=2;
			int LA165_0 = input.LA(1);
			if ( (LA165_0==PNAME_LN) ) {
				alt165=1;
			}
			else if ( (LA165_0==PNAME_NS) ) {
				alt165=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 165, 0, input);
				throw nvae;
			}

			switch (alt165) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:967:7: a= PNAME_LN
					{
					a=(CommonTree)match(input,PNAME_LN,FOLLOW_PNAME_LN_in_prefixedName6194); 
					value = Node.createURI(expandUri((a!=null?a.getText():null)));
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:968:7: a= PNAME_NS
					{
					a=(CommonTree)match(input,PNAME_NS,FOLLOW_PNAME_NS_in_prefixedName6207); 
					value = Node.createURI(expandPrefix((a!=null?a.getText():null)));
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "prefixedName"



	// $ANTLR start "blankNode"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:971:1: blankNode returns [Node value] : (a= BLANK_NODE_LABEL | anon );
	public final Node blankNode() throws RecognitionException {
		Node value = null;


		CommonTree a=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:972:5: (a= BLANK_NODE_LABEL | anon )
			int alt166=2;
			int LA166_0 = input.LA(1);
			if ( (LA166_0==BLANK_NODE_LABEL) ) {
				alt166=1;
			}
			else if ( (LA166_0==OPEN_SQUARE_BRACKET) ) {
				alt166=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 166, 0, input);
				throw nvae;
			}

			switch (alt166) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:972:7: a= BLANK_NODE_LABEL
					{
					a=(CommonTree)match(input,BLANK_NODE_LABEL,FOLLOW_BLANK_NODE_LABEL_in_blankNode6233); 
					value = Node.createAnon(new AnonId((a!=null?a.getText():null)));
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:973:7: anon
					{
					pushFollow(FOLLOW_anon_in_blankNode6243);
					anon();
					state._fsp--;

					value = Node.createAnon();
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "blankNode"



	// $ANTLR start "anon"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:976:1: anon : OPEN_SQUARE_BRACKET CLOSE_SQUARE_BRACKET ;
	public final void anon() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:977:5: ( OPEN_SQUARE_BRACKET CLOSE_SQUARE_BRACKET )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:977:7: OPEN_SQUARE_BRACKET CLOSE_SQUARE_BRACKET
			{
			match(input,OPEN_SQUARE_BRACKET,FOLLOW_OPEN_SQUARE_BRACKET_in_anon6262); 
			match(input,CLOSE_SQUARE_BRACKET,FOLLOW_CLOSE_SQUARE_BRACKET_in_anon6264); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "anon"

	// Delegated rules


	protected DFA45 dfa45 = new DFA45(this);
	static final String DFA45_eotS =
		"\14\uffff";
	static final String DFA45_eofS =
		"\14\uffff";
	static final String DFA45_minS =
		"\1\47\1\2\1\3\1\uffff\1\2\1\uffff\2\147\4\3";
	static final String DFA45_maxS =
		"\1\47\1\2\1\u00f5\1\uffff\1\2\1\uffff\2\u009e\3\3\1\u00f5";
	static final String DFA45_acceptS =
		"\3\uffff\1\1\1\uffff\1\2\6\uffff";
	static final String DFA45_specialS =
		"\14\uffff}>";
	static final String[] DFA45_transitionS = {
			"\1\1",
			"\1\2",
			"\1\3\45\uffff\1\3\43\uffff\1\4\12\uffff\1\3\2\uffff\1\3\31\uffff\1\3"+
			"\26\uffff\1\3\6\uffff\1\3\140\uffff\1\5\1\3",
			"",
			"\1\6",
			"",
			"\1\10\32\uffff\1\7\32\uffff\1\11\1\12",
			"\1\10\65\uffff\1\11\1\12",
			"\1\13",
			"\1\13",
			"\1\13",
			"\1\3\111\uffff\1\4\12\uffff\1\3\2\uffff\1\3\31\uffff\1\3\26\uffff\1"+
			"\3\6\uffff\1\3\140\uffff\1\5\1\3"
	};

	static final short[] DFA45_eot = DFA.unpackEncodedString(DFA45_eotS);
	static final short[] DFA45_eof = DFA.unpackEncodedString(DFA45_eofS);
	static final char[] DFA45_min = DFA.unpackEncodedStringToUnsignedChars(DFA45_minS);
	static final char[] DFA45_max = DFA.unpackEncodedStringToUnsignedChars(DFA45_maxS);
	static final short[] DFA45_accept = DFA.unpackEncodedString(DFA45_acceptS);
	static final short[] DFA45_special = DFA.unpackEncodedString(DFA45_specialS);
	static final short[][] DFA45_transition;

	static {
		int numStates = DFA45_transitionS.length;
		DFA45_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA45_transition[i] = DFA.unpackEncodedString(DFA45_transitionS[i]);
		}
	}

	protected class DFA45 extends DFA {

		public DFA45(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 45;
			this.eot = DFA45_eot;
			this.eof = DFA45_eof;
			this.min = DFA45_min;
			this.max = DFA45_max;
			this.accept = DFA45_accept;
			this.special = DFA45_special;
			this.transition = DFA45_transition;
		}
		@Override
		public String getDescription() {
			return "391:1: constructQuery : ( ^( CONSTRUCT ( constructTemplate )* ( datasetClause )* ( whereClause )* solutionModifier ) | ^( CONSTRUCT ( datasetClause )* ^( WHERE ( triplesTemplate )* ) solutionModifier ) );";
		}
	}

	public static final BitSet FOLLOW_templateConfigItem_in_templateConfig60 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000002000000008L});
	public static final BitSet FOLLOW_namedViewTemplateDefinition_in_templateConfigItem76 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prefixDecl_in_templateConfigItem85 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_constructConfigItem_in_constructConfig108 = new BitSet(new long[]{0x0000040000000002L,0x0000000000000000L,0x0000002000000000L});
	public static final BitSet FOLLOW_constructViewDefinition_in_constructConfigItem124 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prefixDecl_in_constructConfigItem134 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CONSTRUCT_VIEW_DEFINITION_in_constructViewDefinition153 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_NAME_in_constructViewDefinition157 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_SQL_QUERY_in_constructViewDefinition161 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_sparqlifyConfigItem_in_sparqlifyConfig187 = new BitSet(new long[]{0x0000000000000002L,0x0000000000010000L,0x0000002000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_viewDefinition_in_sparqlifyConfigItem204 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prefixDecl_in_sparqlifyConfigItem218 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_functionDeclaration_in_sparqlifyConfigItem236 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FUNCTION_DECLARATION_in_functionDeclaration259 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_functionSignature_in_functionDeclaration263 = new BitSet(new long[]{0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_functionTemplate_in_functionDeclaration267 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_FUNCTION_SIGNATURE_in_functionSignature292 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_NAME_in_functionSignature296 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x0000000060000000L});
	public static final BitSet FOLLOW_iriRef_in_functionSignature300 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000400000L});
	public static final BitSet FOLLOW_paramTypeList_in_functionSignature304 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PARAM_TYPE_LIST_in_paramTypeList335 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_paramType_in_paramTypeList340 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_PARAM_TYPE_LIST_in_paramTypeList354 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_nil_in_paramTypeList356 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PARAM_TYPE_in_paramType381 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_NAME_in_paramType385 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000020000000000L});
	public static final BitSet FOLLOW_var_in_paramType389 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_FUNCTION_TEMPLATE_in_functionTemplate415 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_NAME_in_functionTemplate419 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_expressionList_in_functionTemplate423 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_NAMED_VIEW_TEMPLATE_DEFINITION_in_namedViewTemplateDefinition448 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_NAME_in_namedViewTemplateDefinition452 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_viewTemplateDefinition_in_namedViewTemplateDefinition456 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_VIEW_TEMPLATE_DEFINITION_in_viewTemplateDefinition476 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_constructTemplateQuads_in_viewTemplateDefinition480 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000000L,0x0000800000000000L});
	public static final BitSet FOLLOW_varBindings_in_viewTemplateDefinition484 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_VIEW_DEFINITION_in_viewDefinition504 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_NAME_in_viewDefinition508 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_viewTemplateDefinition_in_viewDefinition512 = new BitSet(new long[]{0x0000004000000008L,0x0000000000000000L,0x0002000000000000L});
	public static final BitSet FOLLOW_varConstraints_in_viewDefinition516 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0002000000000000L});
	public static final BitSet FOLLOW_sqlRelation_in_viewDefinition521 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_VAR_BINDINGS_in_varBindings548 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_varBinding_in_varBindings553 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_VAR_BINDING_in_varBinding576 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_var_in_varBinding580 = new BitSet(new long[]{0x0000000001000000L,0x0000000000000000L,0x0000000008000000L,0x0000008020000000L});
	public static final BitSet FOLLOW_typeCtorExpression_in_varBinding584 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_BNODE_in_typeCtorExpression607 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_typeCtorExpression611 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_URI_in_typeCtorExpression624 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expressionList_in_typeCtorExpression628 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PLAIN_LITERAL_in_typeCtorExpression640 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_typeCtorExpression644 = new BitSet(new long[]{0x2000000000010408L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_expression_in_typeCtorExpression648 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_TYPED_LITERAL_in_typeCtorExpression661 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_typeCtorExpression665 = new BitSet(new long[]{0x2000000000010400L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_expression_in_typeCtorExpression669 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SQL_RELATION_in_sqlRelationOld692 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SQL_QUERY_in_sqlRelationOld696 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SQL_RELATION_in_sqlRelationOld705 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SQL_TABLE_in_sqlRelationOld709 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_RELATION_REF_in_sqlRelation733 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_joinClause_in_sqlRelation737 = new BitSet(new long[]{0x2000000000010408L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_expression_in_sqlRelation741 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_joinClauseMember_in_joinClause768 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FULL_JOIN_in_joinClause779 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_joinClauseMember_in_joinClause783 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_joinClauseMember_in_joinClause787 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_JOIN_MEMBER_in_joinClauseMember817 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_sqlLogicalTable_in_joinClauseMember821 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_NAME_in_joinClauseMember825 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SQL_RELATION_in_sqlLogicalTable848 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SQL_QUERY_in_sqlLogicalTable852 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SQL_RELATION_in_sqlLogicalTable861 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SQL_TABLE_in_sqlLogicalTable865 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_CONSTRAINTS_in_varConstraints894 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_varConstraint_in_varConstraints899 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0001004000000000L});
	public static final BitSet FOLLOW_regexVarConstraint_in_varConstraint927 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prefixVarConstraint_in_varConstraint941 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_REGEX_CONSTRAINT_in_regexVarConstraint963 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_var_in_regexVarConstraint967 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000003C00L});
	public static final BitSet FOLLOW_string_in_regexVarConstraint971 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PREFIX_CONSTRAINT_in_prefixVarConstraint993 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_var_in_prefixVarConstraint997 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_stringList_in_prefixVarConstraint1001 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_STRING_LIST_in_stringList1032 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_string_in_stringList1037 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000000L,0x0000000000003C00L});
	public static final BitSet FOLLOW_QUERY_in_query1061 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_prologue_in_query1063 = new BitSet(new long[]{0x0400008000008008L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_selectQuery_in_query1065 = new BitSet(new long[]{0x0400008000008008L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_constructQuery_in_query1068 = new BitSet(new long[]{0x0400008000008008L});
	public static final BitSet FOLLOW_describeQuery_in_query1071 = new BitSet(new long[]{0x0400000000008008L});
	public static final BitSet FOLLOW_askQuery_in_query1074 = new BitSet(new long[]{0x0000000000008008L});
	public static final BitSet FOLLOW_bindingsClause_in_query1078 = new BitSet(new long[]{0x0000000000100002L});
	public static final BitSet FOLLOW_UPDATE_in_query1088 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_update_in_query1090 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000010000000000L});
	public static final BitSet FOLLOW_PROLOGUE_in_prologue1110 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_baseDecl_in_prologue1112 = new BitSet(new long[]{0x0000000000040008L,0x0000000000000000L,0x0000002000000000L});
	public static final BitSet FOLLOW_prefixDecl_in_prologue1115 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000002000000000L});
	public static final BitSet FOLLOW_BASE_in_baseDecl1135 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_IRI_REF_in_baseDecl1137 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PREFIX_in_prefixDecl1160 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_PNAME_NS_in_prefixDecl1164 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L});
	public static final BitSet FOLLOW_IRI_REF_in_prefixDecl1168 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SELECT_in_selectQuery1189 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_selectClause_in_selectQuery1191 = new BitSet(new long[]{0x0000000000000008L,0x0020000009002000L,0x0000000000081000L,0x0020000000000000L});
	public static final BitSet FOLLOW_datasetClause_in_selectQuery1193 = new BitSet(new long[]{0x0000000000000008L,0x0020000009002000L,0x0000000000081000L,0x0020000000000000L});
	public static final BitSet FOLLOW_whereClause_in_selectQuery1196 = new BitSet(new long[]{0x0000000000000008L,0x0020000009000000L,0x0000000000081000L,0x0020000000000000L});
	public static final BitSet FOLLOW_solutionModifier_in_selectQuery1199 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SUBSELECT_in_subSelect1218 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_whereClause_in_subSelect1220 = new BitSet(new long[]{0x0000000000000008L,0x0020000009000000L,0x0000000000081000L,0x0020000000000000L});
	public static final BitSet FOLLOW_solutionModifier_in_subSelect1223 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SELECT_CLAUSE_in_selectClause1247 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ASTERISK_in_selectClause1249 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SELECT_CLAUSE_in_selectClause1259 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DISTINCT_in_selectClause1261 = new BitSet(new long[]{0x0000000000010000L});
	public static final BitSet FOLLOW_ASTERISK_in_selectClause1263 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SELECT_CLAUSE_in_selectClause1273 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_REDUCED_in_selectClause1275 = new BitSet(new long[]{0x0000000000010000L});
	public static final BitSet FOLLOW_ASTERISK_in_selectClause1277 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SELECT_CLAUSE_in_selectClause1287 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_selectVariables_in_selectClause1289 = new BitSet(new long[]{0x0000000000002008L,0x0000000000000000L,0x0000000000000000L,0x0000020000000000L});
	public static final BitSet FOLLOW_SELECT_CLAUSE_in_selectClause1300 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DISTINCT_in_selectClause1302 = new BitSet(new long[]{0x0000000000002008L,0x0000000000000000L,0x0000000000000000L,0x0000020000000000L});
	public static final BitSet FOLLOW_selectVariables_in_selectClause1304 = new BitSet(new long[]{0x0000000000002008L,0x0000000000000000L,0x0000000000000000L,0x0000020000000000L});
	public static final BitSet FOLLOW_SELECT_CLAUSE_in_selectClause1315 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_REDUCED_in_selectClause1317 = new BitSet(new long[]{0x0000000000002008L,0x0000000000000000L,0x0000000000000000L,0x0000020000000000L});
	public static final BitSet FOLLOW_selectVariables_in_selectClause1319 = new BitSet(new long[]{0x0000000000002008L,0x0000000000000000L,0x0000000000000000L,0x0000020000000000L});
	public static final BitSet FOLLOW_VAR_in_selectVariables1339 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_var_in_selectVariables1341 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_AS_in_selectVariables1352 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_selectVariables1354 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000020000000000L});
	public static final BitSet FOLLOW_var_in_selectVariables1356 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_CONSTRUCT_in_constructQuery1377 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_constructTemplate_in_constructQuery1379 = new BitSet(new long[]{0x0000020000000008L,0x0020000009002000L,0x0000000000081000L,0x0020000000000000L});
	public static final BitSet FOLLOW_datasetClause_in_constructQuery1382 = new BitSet(new long[]{0x0000000000000008L,0x0020000009002000L,0x0000000000081000L,0x0020000000000000L});
	public static final BitSet FOLLOW_whereClause_in_constructQuery1385 = new BitSet(new long[]{0x0000000000000008L,0x0020000009000000L,0x0000000000081000L,0x0020000000000000L});
	public static final BitSet FOLLOW_solutionModifier_in_constructQuery1388 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_CONSTRUCT_in_constructQuery1398 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_datasetClause_in_constructQuery1400 = new BitSet(new long[]{0x0000000000000000L,0x0000000000002000L,0x0000000000000000L,0x0010000000000000L});
	public static final BitSet FOLLOW_WHERE_in_constructQuery1404 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_triplesTemplate_in_constructQuery1406 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_solutionModifier_in_constructQuery1410 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_DESCRIBE_in_describeQuery1429 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_varOrIRIref_in_describeQuery1431 = new BitSet(new long[]{0x0000000000010008L,0x0020008009002000L,0x0000000060081000L,0x0020020000000000L});
	public static final BitSet FOLLOW_ASTERISK_in_describeQuery1434 = new BitSet(new long[]{0x0000000000010008L,0x0020000009002000L,0x0000000000081000L,0x0020000000000000L});
	public static final BitSet FOLLOW_datasetClause_in_describeQuery1437 = new BitSet(new long[]{0x0000000000000008L,0x0020000009002000L,0x0000000000081000L,0x0020000000000000L});
	public static final BitSet FOLLOW_whereClause_in_describeQuery1440 = new BitSet(new long[]{0x0000000000000008L,0x0020000009000000L,0x0000000000081000L});
	public static final BitSet FOLLOW_solutionModifier_in_describeQuery1443 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ASK_in_askQuery1462 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_datasetClause_in_askQuery1464 = new BitSet(new long[]{0x0000000000000000L,0x0000000000002000L,0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_whereClause_in_askQuery1467 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_FROM_in_datasetClause1486 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_NAMED_in_datasetClause1488 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x0000000060000000L});
	public static final BitSet FOLLOW_iriRef_in_datasetClause1491 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_WHERE_CLAUSE_in_whereClause1510 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_groupGraphPattern_in_whereClause1512 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_groupClause_in_solutionModifier1534 = new BitSet(new long[]{0x0000000000000002L,0x0020000008000000L,0x0000000000081000L});
	public static final BitSet FOLLOW_havingClause_in_solutionModifier1537 = new BitSet(new long[]{0x0000000000000002L,0x0020000000000000L,0x0000000000081000L});
	public static final BitSet FOLLOW_orderClause_in_solutionModifier1540 = new BitSet(new long[]{0x0000000000000002L,0x0020000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_limitOffsetClauses_in_solutionModifier1543 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GROUP_BY_in_groupClause1562 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_groupCondition_in_groupClause1564 = new BitSet(new long[]{0x000308110B002028L,0xA205BE4030009090L,0xF82C900000000600L,0x01000280C049C1C0L});
	public static final BitSet FOLLOW_builtInCall_in_groupCondition1590 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_functionCall_in_groupCondition1598 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_AS_in_groupCondition1607 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_groupCondition1609 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000000L,0x0000020000000000L});
	public static final BitSet FOLLOW_var_in_groupCondition1611 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000000L,0x0000020000000000L});
	public static final BitSet FOLLOW_var_in_groupCondition1621 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_HAVING_in_havingClause1639 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_constraint_in_havingClause1641 = new BitSet(new long[]{0x200308110B010428L,0xAA1DBE40B06090D0L,0xF82C900010020780L,0x0100008FC049C1C0L});
	public static final BitSet FOLLOW_ORDER_BY_in_orderClause1666 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_orderCondition_in_orderClause1668 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_ORDER_CONDITION_in_orderCondition1688 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ASC_in_orderCondition1690 = new BitSet(new long[]{0x2000000000010400L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_expression_in_orderCondition1692 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ORDER_CONDITION_in_orderCondition1702 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DESC_in_orderCondition1704 = new BitSet(new long[]{0x2000000000010400L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_expression_in_orderCondition1706 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ORDER_CONDITION_in_orderCondition1716 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_constraint_in_orderCondition1718 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ORDER_CONDITION_in_orderCondition1728 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_var_in_orderCondition1730 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_LIMIT_in_limitOffsetClauses1754 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_INTEGER_in_limitOffsetClauses1756 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_OFFSET_in_limitOffsetClauses1761 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_INTEGER_in_limitOffsetClauses1763 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_OFFSET_in_limitOffsetClauses1775 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_INTEGER_in_limitOffsetClauses1777 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_LIMIT_in_limitOffsetClauses1782 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_INTEGER_in_limitOffsetClauses1784 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_BINDINGS_in_bindingsClause1806 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_var_in_bindingsClause1808 = new BitSet(new long[]{0x0000000000200008L,0x0000000000000000L,0x0000000000000000L,0x0000020000000000L});
	public static final BitSet FOLLOW_bindingValueList_in_bindingsClause1811 = new BitSet(new long[]{0x0000000000200008L});
	public static final BitSet FOLLOW_BINDING_VALUE_in_bindingValueList1835 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_bindingValue_in_bindingValueList1837 = new BitSet(new long[]{0x801C000000000008L,0x0000008E00000403L,0x0000000068000000L,0x0000001030000000L});
	public static final BitSet FOLLOW_iriRef_in_bindingValue1867 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_rdfLiteral_in_bindingValue1879 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_numericLiteral_in_bindingValue1889 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_booleanLiteral_in_bindingValue1897 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UNDEF_in_bindingValue1905 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prologue_in_update1926 = new BitSet(new long[]{0x0100500010000042L,0x4040000100000004L,0x0000000000000001L});
	public static final BitSet FOLLOW_load_in_update1928 = new BitSet(new long[]{0x0100500010000042L,0x4040000100000004L,0x0000000000000001L});
	public static final BitSet FOLLOW_clear_in_update1931 = new BitSet(new long[]{0x0100500010000042L,0x4000000100000004L,0x0000000000000001L});
	public static final BitSet FOLLOW_drop_in_update1934 = new BitSet(new long[]{0x0100500000000042L,0x4000000100000004L,0x0000000000000001L});
	public static final BitSet FOLLOW_add_in_update1937 = new BitSet(new long[]{0x0100500000000042L,0x4000000100000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_move_in_update1940 = new BitSet(new long[]{0x0100500000000002L,0x4000000100000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_copy_in_update1943 = new BitSet(new long[]{0x0100500000000002L,0x4000000100000000L});
	public static final BitSet FOLLOW_create_in_update1946 = new BitSet(new long[]{0x0100400000000002L,0x4000000100000000L});
	public static final BitSet FOLLOW_insert_in_update1949 = new BitSet(new long[]{0x0100000000000002L,0x4000000100000000L});
	public static final BitSet FOLLOW_delete_in_update1952 = new BitSet(new long[]{0x0100000000000002L,0x4000000000000000L});
	public static final BitSet FOLLOW_modify_in_update1955 = new BitSet(new long[]{0x0000000000000002L,0x4000000000000000L});
	public static final BitSet FOLLOW_LOAD_in_load1985 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SILENT_in_load1987 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x0000000060000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_iriRef_in_load1990 = new BitSet(new long[]{0x0000000000000008L,0x0000000000080000L});
	public static final BitSet FOLLOW_graphRef_in_load1992 = new BitSet(new long[]{0x0000000000000008L,0x0000000000080000L});
	public static final BitSet FOLLOW_CLEAR_in_clear2016 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SILENT_in_clear2018 = new BitSet(new long[]{0x0040000000000200L,0x0000000000080000L,0x0000000000000004L,0x0000000000000002L});
	public static final BitSet FOLLOW_graphRefAll_in_clear2021 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_DROP_in_drop2044 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SILENT_in_drop2046 = new BitSet(new long[]{0x0040000000000200L,0x0000000000080000L,0x0000000000000004L,0x0000000000000002L});
	public static final BitSet FOLLOW_graphRefAll_in_drop2049 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_CREATE_in_create2069 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SILENT_in_create2071 = new BitSet(new long[]{0x0000000000000000L,0x0000000000080000L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_graphRef_in_create2074 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ADD_in_add2097 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SILENT_in_add2099 = new BitSet(new long[]{0x0040000000000000L,0x0000008000080000L,0x0000000060000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_graphOrDefault_in_add2102 = new BitSet(new long[]{0x0040000000000000L,0x0000008000080000L,0x0000000060000000L});
	public static final BitSet FOLLOW_graphOrDefault_in_add2104 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_MOVE_in_move2127 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SILENT_in_move2129 = new BitSet(new long[]{0x0040000000000000L,0x0000008000080000L,0x0000000060000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_graphOrDefault_in_move2132 = new BitSet(new long[]{0x0040000000000000L,0x0000008000080000L,0x0000000060000000L});
	public static final BitSet FOLLOW_graphOrDefault_in_move2134 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_COPY_in_copy2157 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SILENT_in_copy2159 = new BitSet(new long[]{0x0040000000000000L,0x0000008000080000L,0x0000000060000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_graphOrDefault_in_copy2162 = new BitSet(new long[]{0x0040000000000000L,0x0000008000080000L,0x0000000060000000L});
	public static final BitSet FOLLOW_graphOrDefault_in_copy2164 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_INSERT_in_insert2183 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DATA_in_insert2185 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_quadPattern_in_insert2187 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_DELETE_in_delete2212 = new BitSet(new long[]{0x0100000000000000L});
	public static final BitSet FOLLOW_deleteData_in_delete2216 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_deleteWhere_in_delete2220 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DELETE_in_deleteData2240 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DATA_in_deleteData2242 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_quadPattern_in_deleteData2244 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_DELETE_in_deleteWhere2263 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_WHERE_in_deleteWhere2265 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_quadPattern_in_deleteWhere2267 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_MODIFY_in_modify2290 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_WITH_in_modify2293 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_iriRef_in_modify2295 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_deleteClause_in_modify2298 = new BitSet(new long[]{0x0100000000000000L,0x0000000100000000L,0x0000000000000000L,0x0010010000000000L});
	public static final BitSet FOLLOW_insertClause_in_modify2301 = new BitSet(new long[]{0x0000000000000000L,0x0000000100000000L,0x0000000000000000L,0x0010010000000000L});
	public static final BitSet FOLLOW_usingClause_in_modify2304 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0010010000000000L});
	public static final BitSet FOLLOW_WHERE_in_modify2308 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_groupGraphPattern_in_modify2310 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_MODIFY_in_modify2321 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_deleteClause_in_modify2323 = new BitSet(new long[]{0x0100000000000000L,0x0000000100000000L,0x0000000000000000L,0x0010010000000000L});
	public static final BitSet FOLLOW_insertClause_in_modify2326 = new BitSet(new long[]{0x0000000000000000L,0x0000000100000000L,0x0000000000000000L,0x0010010000000000L});
	public static final BitSet FOLLOW_usingClause_in_modify2329 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0010010000000000L});
	public static final BitSet FOLLOW_WHERE_in_modify2333 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_groupGraphPattern_in_modify2335 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_DELETE_in_deleteClause2356 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_quadPattern_in_deleteClause2358 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INSERT_in_insertClause2381 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_quadPattern_in_insertClause2383 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_USING_in_usingClause2401 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_NAMED_in_usingClause2403 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x0000000060000000L});
	public static final BitSet FOLLOW_iriRef_in_usingClause2406 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_DEFAULT_in_graphOrDefault2427 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GRAPH_in_graphOrDefault2436 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x0000000060000000L});
	public static final BitSet FOLLOW_iriRef_in_graphOrDefault2439 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GRAPH_in_graphRef2466 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x0000000060000000L});
	public static final BitSet FOLLOW_iriRef_in_graphRef2468 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_graphRef_in_graphRefAll2485 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DEFAULT_in_graphRefAll2489 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NAMED_in_graphRefAll2493 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALL_in_graphRefAll2497 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_quads_in_quadPattern2520 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_triplesTemplate_in_quads2557 = new BitSet(new long[]{0x0000000000000002L,0x0000000000100000L});
	public static final BitSet FOLLOW_quadsNotTriples_in_quads2565 = new BitSet(new long[]{0x0000000000000002L,0x0000000000100000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_triplesTemplate_in_quads2571 = new BitSet(new long[]{0x0000000000000002L,0x0000000000100000L});
	public static final BitSet FOLLOW_GRAPH_TOKEN_in_quadsNotTriples2608 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_varOrIRIref_in_quadsNotTriples2612 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_triplesTemplate_in_quadsNotTriples2616 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_TRIPLES_TEMPLATE_in_triplesTemplate2645 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_triples_in_triplesTemplate2649 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_GROUP_GRAPH_PATTERN_in_groupGraphPattern2675 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_subSelect_in_groupGraphPattern2677 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_GROUP_GRAPH_PATTERN_in_groupGraphPattern2687 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_groupGraphPatternSub_in_groupGraphPattern2689 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_triplesBlock_in_groupGraphPatternSub2711 = new BitSet(new long[]{0x0000000000080002L,0x1000000004080800L,0x0400000000010000L,0x0000002000000000L});
	public static final BitSet FOLLOW_groupGraphPatternSubCache_in_groupGraphPatternSub2714 = new BitSet(new long[]{0x0000000000080002L,0x1000000004080800L,0x0400000000010000L,0x0000002000000000L});
	public static final BitSet FOLLOW_graphPatternNotTriples_in_groupGraphPatternSubCache2737 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_triplesBlock_in_groupGraphPatternSubCache2739 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TRIPLES_BLOCK_in_triplesBlock2758 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_triplesSameSubjectPath_in_triplesBlock2760 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000000L,0x0000000002000000L});
	public static final BitSet FOLLOW_groupOrUnionGraphPattern_in_graphPatternNotTriples2780 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_optionalGraphPattern_in_graphPatternNotTriples2784 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_minusGraphPattern_in_graphPatternNotTriples2788 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_graphGraphPattern_in_graphPatternNotTriples2792 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_serviceGraphPattern_in_graphPatternNotTriples2796 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_filter_in_graphPatternNotTriples2800 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_in_graphPatternNotTriples2804 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPTIONAL_in_optionalGraphPattern2822 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_groupGraphPattern_in_optionalGraphPattern2824 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_GRAPH_in_graphGraphPattern2843 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_varOrIRIref_in_graphGraphPattern2845 = new BitSet(new long[]{0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_groupGraphPattern_in_graphGraphPattern2847 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SERVICE_in_serviceGraphPattern2866 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SILENT_in_serviceGraphPattern2868 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x0000000060000000L,0x0000020000000000L});
	public static final BitSet FOLLOW_varOrIRIref_in_serviceGraphPattern2871 = new BitSet(new long[]{0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_groupGraphPattern_in_serviceGraphPattern2873 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_BIND_in_bind2896 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_bind2898 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_AS_in_bind2901 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_var_in_bind2903 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_MINUS_KEYWORD_in_minusGraphPattern2929 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_groupGraphPattern_in_minusGraphPattern2931 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_UNION_in_groupOrUnionGraphPattern2950 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_groupGraphPattern_in_groupOrUnionGraphPattern2952 = new BitSet(new long[]{0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_groupGraphPattern_in_groupOrUnionGraphPattern2954 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_groupGraphPattern_in_groupOrUnionGraphPattern2963 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FILTER_in_filter2981 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_constraint_in_filter2983 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_expression_in_constraint3001 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_builtInCall_in_constraint3009 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_functionCall_in_constraint3017 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FUNCTION_in_functionCall3039 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_iriRef_in_functionCall3043 = new BitSet(new long[]{0x0000000000001000L});
	public static final BitSet FOLLOW_ARG_LIST_in_functionCall3046 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_argList_in_functionCall3050 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_nil_in_argList3082 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DISTINCT_in_argList3090 = new BitSet(new long[]{0x2000000000010402L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_expression_in_argList3096 = new BitSet(new long[]{0x2000000000010402L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_EXPRESSION_LIST_in_expressionList3128 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expressionList3133 = new BitSet(new long[]{0x2000000000010408L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_EXPRESSION_LIST_in_expressionList3147 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_nil_in_expressionList3149 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_CONSTRUCT_QUADS_in_constructTemplateQuads3178 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_quadPattern_in_constructTemplateQuads3182 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_CONSTRUCT_TRIPLES_in_constructTemplate3212 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_constructTriples_in_constructTemplate3216 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_triples_in_constructTriples3243 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_triple_in_triples3275 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000002000000L});
	public static final BitSet FOLLOW_TRIPLE_in_triple3296 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SUBJECT_in_triple3299 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_varOrTerm_in_triple3303 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PREDICATE_in_triple3307 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_verb_in_triple3311 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_OBJECT_in_triple3315 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_graphNode_in_triple3319 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_TODO_in_triplesSameSubject3341 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SUBJECT_in_objectList3362 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_varOrTerm_in_objectList3366 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PREDICATE_in_objectList3370 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_verb_in_objectList3374 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_OBJECT_in_objectList3378 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_graphNode_in_objectList3382 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_varOrIRIref_in_verb3413 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_A_in_verb3424 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_path_in_verb3444 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TRIPLE_in_triplesSameSubjectPath3469 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_objectList_in_triplesSameSubjectPath3471 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_TRIPLE_in_triplesSameSubjectPath3482 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_triplesSameSubjectPath_in_triplesSameSubjectPath3484 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PATH_in_path3509 = new BitSet(new long[]{0x0000000000000000L,0x0000002000000000L,0x0000000002000000L});
	public static final BitSet FOLLOW_pathSequence_in_path3511 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_PIPE_in_path3515 = new BitSet(new long[]{0x0000000000000000L,0x0000002000000000L,0x0000000002000000L});
	public static final BitSet FOLLOW_pathSequence_in_path3517 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_pathEltOrInverse_in_pathSequence3538 = new BitSet(new long[]{0x2000000000000002L});
	public static final BitSet FOLLOW_DIVIDE_in_pathSequence3542 = new BitSet(new long[]{0x0000000000000000L,0x0000002000000000L,0x0000000002000000L});
	public static final BitSet FOLLOW_pathEltOrInverse_in_pathSequence3544 = new BitSet(new long[]{0x2000000000000002L});
	public static final BitSet FOLLOW_pathPrimary_in_pathElt3572 = new BitSet(new long[]{0x0000000000010002L,0x0000000000000000L,0x0000080010004000L});
	public static final BitSet FOLLOW_pathMod_in_pathElt3574 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_pathElt_in_pathEltOrInverse3596 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INVERSE_in_pathEltOrInverse3600 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000002000000L});
	public static final BitSet FOLLOW_pathElt_in_pathEltOrInverse3602 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ASTERISK_in_pathMod3625 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUESTION_MARK_in_pathMod3629 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PLUS_in_pathMod3633 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_CURLY_BRACE_in_pathMod3637 = new BitSet(new long[]{0x0000000400000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_INTEGER_in_pathMod3641 = new BitSet(new long[]{0x0000000440000000L});
	public static final BitSet FOLLOW_COMMA_in_pathMod3645 = new BitSet(new long[]{0x0000000040000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_CLOSE_CURLY_BRACE_in_pathMod3649 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INTEGER_in_pathMod3653 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_CLOSE_CURLY_BRACE_in_pathMod3655 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CLOSE_CURLY_BRACE_in_pathMod3661 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COMMA_in_pathMod3667 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_INTEGER_in_pathMod3669 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_CLOSE_CURLY_BRACE_in_pathMod3671 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PATH_PRIMARY_in_pathPrimary3693 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_iriRef_in_pathPrimary3695 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PATH_PRIMARY_in_pathPrimary3705 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_A_in_pathPrimary3707 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PATH_PRIMARY_in_pathPrimary3717 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_NEGATION_in_pathPrimary3719 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_pathNegatedPropertySet_in_pathPrimary3721 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PATH_PRIMARY_in_pathPrimary3731 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_path_in_pathPrimary3733 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PATH_NEGATED_in_pathNegatedPropertySet3752 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_pathOneInPropertySet_in_pathNegatedPropertySet3754 = new BitSet(new long[]{0x0000000000000018L,0x000000A000000000L,0x0000000060000000L});
	public static final BitSet FOLLOW_INVERSE_in_pathOneInPropertySet3776 = new BitSet(new long[]{0x0000000000000010L,0x0000008000000000L,0x0000000060000000L});
	public static final BitSet FOLLOW_iriRef_in_pathOneInPropertySet3781 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_A_in_pathOneInPropertySet3785 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COLLECTION_in_triplesNode3811 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_graphNode_in_triplesNode3813 = new BitSet(new long[]{0x801C000200800008L,0x0000008E00000403L,0x000000006800A000L,0x0000020032000000L});
	public static final BitSet FOLLOW_TRIPLE_in_triplesNode3825 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_objectList_in_triplesNode3827 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_varOrTerm_in_graphNode3855 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_triplesNode_in_graphNode3865 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_var_in_varOrTerm3889 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_graphTerm_in_varOrTerm3907 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_var_in_varOrIRIref3932 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_iriRef_in_varOrIRIref3947 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_VAR_in_var3972 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_iriRef_in_graphTerm3998 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_rdfLiteral_in_graphTerm4019 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_numericLiteral_in_graphTerm4037 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_booleanLiteral_in_graphTerm4049 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_blankNode_in_graphTerm4061 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_nil_in_graphTerm4076 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_nil4097 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_nil4099 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OR_in_expression4121 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4125 = new BitSet(new long[]{0x2000000000010400L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_expression_in_expression4129 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_AND_in_expression4152 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4156 = new BitSet(new long[]{0x2000000000010400L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_expression_in_expression4160 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_EQUAL_in_expression4182 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4186 = new BitSet(new long[]{0x2000000000010400L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_expression_in_expression4190 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_NOT_EQUAL_in_expression4210 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4214 = new BitSet(new long[]{0x2000000000010400L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_expression_in_expression4218 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_LESS_in_expression4234 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4238 = new BitSet(new long[]{0x2000000000010400L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_expression_in_expression4242 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_GREATER_in_expression4263 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4267 = new BitSet(new long[]{0x2000000000010400L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_expression_in_expression4271 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_LESS_EQUAL_in_expression4289 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4293 = new BitSet(new long[]{0x2000000000010400L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_expression_in_expression4297 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_GREATER_EQUAL_in_expression4312 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4316 = new BitSet(new long[]{0x2000000000010400L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_expression_in_expression4320 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_IN_in_expression4332 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4336 = new BitSet(new long[]{0x2000000000010400L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_expression_in_expression4340 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_NOT_in_expression4363 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_IN_in_expression4365 = new BitSet(new long[]{0x2000000000010400L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_expression_in_expression4369 = new BitSet(new long[]{0x2000000000010400L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_expression_in_expression4373 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PLUS_in_expression4392 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4396 = new BitSet(new long[]{0x2000000000010400L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_expression_in_expression4400 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_MINUS_in_expression4421 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4425 = new BitSet(new long[]{0x2000000000010400L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_expression_in_expression4429 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ASTERISK_in_expression4449 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4453 = new BitSet(new long[]{0x2000000000010400L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_expression_in_expression4457 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_DIVIDE_in_expression4474 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4478 = new BitSet(new long[]{0x2000000000010400L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_expression_in_expression4482 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_unaryExpression_in_expression4502 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UNARY_NOT_in_unaryExpression4556 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_primaryExpression_in_unaryExpression4560 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_UNARY_PLUS_in_unaryExpression4580 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_primaryExpression_in_unaryExpression4584 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_UNARY_MINUS_in_unaryExpression4603 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_primaryExpression_in_unaryExpression4607 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_UNARY_in_unaryExpression4625 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_primaryExpression_in_unaryExpression4629 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_builtInCall_in_primaryExpression4667 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_iriRefOrFunction_in_primaryExpression4685 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_rdfLiteral_in_primaryExpression4698 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_numericLiteral_in_primaryExpression4717 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_booleanLiteral_in_primaryExpression4732 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_var_in_primaryExpression4747 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_aggregate_in_primaryExpression4771 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STR_in_builtInCall4793 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall4797 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_LANG_in_builtInCall4822 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall4826 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_LANGMATCHES_in_builtInCall4849 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall4853 = new BitSet(new long[]{0x2000000000010400L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_expression_in_builtInCall4857 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_DATATYPE_in_builtInCall4872 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall4876 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_BOUND_in_builtInCall4886 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_var_in_builtInCall4890 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_IRI_in_builtInCall4919 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall4923 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_URI_in_builtInCall4933 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall4937 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_BNODE_in_builtInCall4947 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall4949 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_RAND_in_builtInCall4958 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ABS_in_builtInCall4967 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall4971 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_CEIL_in_builtInCall4981 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall4985 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_FLOOR_in_builtInCall4995 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall4999 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ROUND_in_builtInCall5009 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5011 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_CONCAT_in_builtInCall5021 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expressionList_in_builtInCall5025 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_subStringExpression_in_builtInCall5041 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRLEN_in_builtInCall5050 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5052 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_UCASE_in_builtInCall5062 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5064 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_LCASE_in_builtInCall5074 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5076 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ENCODE_FOR_URI_in_builtInCall5086 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5088 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_CONTAINS_in_builtInCall5098 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5100 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_STRSTARTS_in_builtInCall5110 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5112 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_STRENDS_in_builtInCall5122 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5124 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_YEAR_in_builtInCall5134 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5136 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_MONTH_in_builtInCall5146 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5148 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_DAY_in_builtInCall5158 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5160 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_HOURS_in_builtInCall5170 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5172 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_MINUTES_in_builtInCall5182 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5184 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SECONDS_in_builtInCall5194 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5196 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_TIMEZONE_in_builtInCall5206 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5208 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_TZ_in_builtInCall5218 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5220 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_NOW_in_builtInCall5229 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MD5_in_builtInCall5238 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5240 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SHA1_in_builtInCall5250 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5252 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SHA224_in_builtInCall5262 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5264 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SHA256_in_builtInCall5274 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5276 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SHA384_in_builtInCall5286 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5288 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SHA512_in_builtInCall5298 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5300 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_COALESCE_in_builtInCall5310 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expressionList_in_builtInCall5312 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_IF_in_builtInCall5322 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5324 = new BitSet(new long[]{0x2000000000010400L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_expression_in_builtInCall5326 = new BitSet(new long[]{0x2000000000010400L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_expression_in_builtInCall5328 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_STRLANG_in_builtInCall5338 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5340 = new BitSet(new long[]{0x2000000000010400L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_expression_in_builtInCall5342 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_STRDT_in_builtInCall5352 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5354 = new BitSet(new long[]{0x2000000000010400L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_expression_in_builtInCall5356 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SAMETERM_in_builtInCall5366 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5368 = new BitSet(new long[]{0x2000000000010400L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_expression_in_builtInCall5370 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ISIRI_in_builtInCall5380 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5382 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ISURI_in_builtInCall5392 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5394 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ISBLANK_in_builtInCall5404 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5406 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ISLITERAL_in_builtInCall5417 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5419 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ISNUMERIC_in_builtInCall5429 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5431 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_regexExpression_in_builtInCall5440 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_existsFunction_in_builtInCall5448 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_notExistsFunction_in_builtInCall5456 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_REGEX_in_regexExpression5474 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_regexExpression5476 = new BitSet(new long[]{0x2000000000010408L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_SUBSTR_in_subStringExpression5500 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_subStringExpression5502 = new BitSet(new long[]{0x2000000000010408L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_EXISTS_in_existsFunction5526 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_groupGraphPattern_in_existsFunction5528 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_NOT_EXISTS_in_notExistsFunction5547 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_groupGraphPattern_in_notExistsFunction5549 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_COUNT_in_aggregate5568 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DISTINCT_in_aggregate5570 = new BitSet(new long[]{0x3000000000010408L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_ASTERISK_in_aggregate5573 = new BitSet(new long[]{0x2000000000010408L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_expression_in_aggregate5576 = new BitSet(new long[]{0x2000000000010408L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_SUM_in_aggregate5587 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DISTINCT_in_aggregate5589 = new BitSet(new long[]{0x3000000000010400L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_expression_in_aggregate5592 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_MIN_in_aggregate5602 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DISTINCT_in_aggregate5604 = new BitSet(new long[]{0x3000000000010400L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_expression_in_aggregate5607 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_MAX_in_aggregate5617 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DISTINCT_in_aggregate5619 = new BitSet(new long[]{0x3000000000010400L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_expression_in_aggregate5622 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_AVG_in_aggregate5632 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DISTINCT_in_aggregate5634 = new BitSet(new long[]{0x3000000000010400L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_expression_in_aggregate5637 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SAMPLE_in_aggregate5647 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DISTINCT_in_aggregate5649 = new BitSet(new long[]{0x2000000000010400L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_expression_in_aggregate5652 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_GROUP_CONCAT_in_aggregate5662 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DISTINCT_in_aggregate5664 = new BitSet(new long[]{0x3000000000010400L,0x0818000080600040L,0x0000000010020180L,0x0000000F00000000L});
	public static final BitSet FOLLOW_expression_in_aggregate5667 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000000L,0x0000000000003C00L});
	public static final BitSet FOLLOW_string_in_aggregate5669 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_iriRef_in_iriRefOrFunction5698 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FUNCTION_in_iriRefOrFunction5744 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_iriRef_in_iriRefOrFunction5748 = new BitSet(new long[]{0x0000000000001000L});
	public static final BitSet FOLLOW_ARG_LIST_in_iriRefOrFunction5751 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_argList_in_iriRefOrFunction5755 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PLAIN_LITERAL_in_rdfLiteral5781 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_string_in_rdfLiteral5785 = new BitSet(new long[]{0x0000000000000008L,0x0002000000000000L});
	public static final BitSet FOLLOW_LANGTAG_in_rdfLiteral5789 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_TYPED_LITERAL_in_rdfLiteral5802 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_string_in_rdfLiteral5806 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x0000000060000000L});
	public static final BitSet FOLLOW_iriRef_in_rdfLiteral5810 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_numericLiteralUnsigned_in_numericLiteral5846 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_numericLiteralPositive_in_numericLiteral5859 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_numericLiteralNegative_in_numericLiteral5871 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INTEGER_in_numericLiteralUnsigned5896 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DECIMAL_in_numericLiteralUnsigned5908 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOUBLE_in_numericLiteralUnsigned5920 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INTEGER_POSITIVE_in_numericLiteralPositive5946 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DECIMAL_POSITIVE_in_numericLiteralPositive5958 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOUBLE_POSITIVE_in_numericLiteralPositive5970 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INTEGER_NEGATIVE_in_numericLiteralNegative5996 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DECIMAL_NEGATIVE_in_numericLiteralNegative6008 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOUBLE_NEGATIVE_in_numericLiteralNegative6020 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TRUE_in_booleanLiteral6044 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FALSE_in_booleanLiteral6055 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL1_in_string6080 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL2_in_string6097 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_LONG1_in_string6114 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_LONG2_in_string6126 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IRI_REF_in_iriRef6151 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prefixedName_in_iriRef6169 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PNAME_LN_in_prefixedName6194 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PNAME_NS_in_prefixedName6207 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BLANK_NODE_LABEL_in_blankNode6233 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_anon_in_blankNode6243 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_SQUARE_BRACKET_in_anon6262 = new BitSet(new long[]{0x0000000080000000L});
	public static final BitSet FOLLOW_CLOSE_SQUARE_BRACKET_in_anon6264 = new BitSet(new long[]{0x0000000000000002L});
}
