/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.web;

import com.google.common.collect.Multimap;
import com.hp.hpl.jena.sparql.core.QuadPattern;
import com.hp.hpl.jena.sparql.core.Var;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOp;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpQuery;
import org.aksw.sparqlify.core.domain.input.Mapping;
import org.aksw.sparqlify.core.domain.input.RestrictedExpr;
import org.aksw.sparqlify.core.domain.input.ViewDefinition;
import org.aksw.sparqlify.core.interfaces.SqlOpSelectBlockCollector;
import org.aksw.sparqlify.core.interfaces.SqlOpSerializer;
import org.aksw.sparqlify.web.ViewDefinitionStr;

class ViewDefinitionStrFactory {
    private SqlOpSelectBlockCollector sqlOpSelectBlockCollector;
    private SqlOpSerializer sqlOpSerializer;

    public ViewDefinitionStrFactory(SqlOpSelectBlockCollector sqlOpSelectBlockCollector, SqlOpSerializer sqlOpSerializer) {
        this.sqlOpSelectBlockCollector = sqlOpSelectBlockCollector;
        this.sqlOpSerializer = sqlOpSerializer;
    }

    public ViewDefinitionStr createView(ViewDefinition viewDefinition) {
        String name = viewDefinition.getName();
        QuadPattern template = viewDefinition.getTemplate();
        Mapping mapping = viewDefinition.getMapping();
        SqlOp sqlOp = mapping.getSqlOp();
        Multimap sparqlVarMap = viewDefinition.getVarDefinition().getMap();
        SqlOp tmp = sqlOp instanceof SqlOpQuery ? sqlOp : this.sqlOpSelectBlockCollector.transform(sqlOp);
        String sqlQueryString = this.sqlOpSerializer.serialize(tmp);
        ViewDefinitionStr result = new ViewDefinitionStr(name, template, (Multimap<Var, RestrictedExpr>)sparqlVarMap, sqlQueryString);
        return result;
    }
}

