/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.web;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.aksw.commons.util.MapReader;
import org.aksw.commons.util.strings.StringUtils;
import org.aksw.sparqlify.batch.MasterDumper;
import org.aksw.sparqlify.config.syntax.Config;
import org.aksw.sparqlify.core.RdfViewSystemOld;
import org.aksw.sparqlify.core.algorithms.SqlOpSelectBlockCollectorImpl;
import org.aksw.sparqlify.core.algorithms.SqlOpSerializerImpl;
import org.aksw.sparqlify.core.cast.SqlExprSerializerSystem;
import org.aksw.sparqlify.core.cast.TypeSystem;
import org.aksw.sparqlify.core.domain.input.ViewDefinition;
import org.aksw.sparqlify.core.interfaces.SqlExprSerializer;
import org.aksw.sparqlify.core.interfaces.SqlOpSelectBlockCollector;
import org.aksw.sparqlify.core.interfaces.SqlOpSerializer;
import org.aksw.sparqlify.core.sparql.QueryExecutionFactoryEx;
import org.aksw.sparqlify.core.sparql.RowMapperSparqlifyBinding;
import org.aksw.sparqlify.util.SparqlifyCoreInit;
import org.aksw.sparqlify.util.SparqlifyUtils;
import org.aksw.sparqlify.validation.LoggerCount;
import org.aksw.sparqlify.web.DumpConfig;
import org.aksw.sparqlify.web.DumpConfigProvider;
import org.aksw.sparqlify.web.Main;
import org.aksw.sparqlify.web.MyItemProcessor;
import org.aksw.sparqlify.web.SparqlifyCliHelper;
import org.aksw.sparqlify.web.ViewDefinitionStr;
import org.aksw.sparqlify.web.ViewDefinitionStrFactory;
import org.antlr.runtime.RecognitionException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.eclipse.jetty.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.explore.support.JobExplorerFactoryBean;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.job.builder.SimpleJobBuilder;
import org.springframework.batch.core.job.flow.Flow;
import org.springframework.batch.core.job.flow.FlowExecutionStatus;
import org.springframework.batch.core.job.flow.FlowJob;
import org.springframework.batch.core.job.flow.FlowStep;
import org.springframework.batch.core.job.flow.State;
import org.springframework.batch.core.job.flow.support.SimpleFlow;
import org.springframework.batch.core.job.flow.support.StateTransition;
import org.springframework.batch.core.job.flow.support.state.EndState;
import org.springframework.batch.core.job.flow.support.state.SplitState;
import org.springframework.batch.core.job.flow.support.state.StepState;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.database.JdbcCursorItemReader;
import org.springframework.batch.item.file.FlatFileItemWriter;
import org.springframework.batch.item.file.transform.LineAggregator;
import org.springframework.batch.item.file.transform.PassThroughLineAggregator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jdbc.core.RowMapper;

@Configuration
@EnableBatchProcessing
public class MainSparqlifyBatchDumper {
    @Autowired
    private JobBuilderFactory jobs;
    @Autowired
    private StepBuilderFactory steps;
    @Autowired
    private DumpConfig dumpConfig;
    @Autowired
    private JobLauncher jobLauncher;
    @Autowired
    private JobRepository jobRepository;
    @Autowired
    private TaskExecutor taskExecutor;
    private static final Logger logger = LoggerFactory.getLogger(MasterDumper.class);
    private static final Options cliOptions = new Options();

    public SimpleFlow create(List<Step> steps) throws Exception {
        ArrayList<SimpleFlow> flows = new ArrayList<SimpleFlow>();
        int i = 1;
        for (Step step : steps) {
            ArrayList<StateTransition> stateTransitions = new ArrayList<StateTransition>();
            String nextStateName = "state-" + i;
            StepState stepState = new StepState(step);
            stateTransitions.add(StateTransition.createStateTransition((State)stepState, (String)nextStateName));
            stateTransitions.add(StateTransition.createEndStateTransition((State)new EndState(FlowExecutionStatus.COMPLETED, nextStateName)));
            SimpleFlow flow = new SimpleFlow("flow-" + i);
            flow.setStateTransitions(stateTransitions);
            flow.afterPropertiesSet();
            flows.add(flow);
        }
        SplitState splitState = new SplitState(flows, "splitState");
        splitState.setTaskExecutor(this.taskExecutor);
        SimpleFlow outerFlow = new SimpleFlow("main");
        ArrayList<StateTransition> outerTransitions = new ArrayList<StateTransition>();
        outerTransitions.add(StateTransition.createStateTransition((State)splitState, (String)"fullEnd"));
        outerTransitions.add(StateTransition.createEndStateTransition((State)new EndState(FlowExecutionStatus.COMPLETED, "fullEnd")));
        outerFlow.setStateTransitions(outerTransitions);
        outerFlow.afterPropertiesSet();
        return outerFlow;
    }

    @Bean
    public Job job() throws Exception {
        Job result;
        JobExplorerFactoryBean jobExplorerFactory = new JobExplorerFactoryBean();
        jobExplorerFactory.setDataSource(this.dumpConfig.getJobDataSource());
        jobExplorerFactory.afterPropertiesSet();
        JobExplorer jobExplorer = jobExplorerFactory.getObject();
        Date endTime = new Date();
        List jobNames = jobExplorer.getJobNames();
        for (String jobName : jobNames) {
            List jobInstances = jobExplorer.getJobInstances(jobName, 0, 1000000);
            for (JobInstance jobInstance : jobInstances) {
                List jobExecutions = jobExplorer.getJobExecutions(jobInstance);
                for (JobExecution jobExecution : jobExecutions) {
                    Collection stepExecutions = jobExecution.getStepExecutions();
                    for (StepExecution stepExecution : stepExecutions) {
                        BatchStatus stepStatus = stepExecution.getStatus();
                        if (!stepStatus.equals((Object)BatchStatus.STARTED)) continue;
                        stepExecution.setStatus(BatchStatus.STOPPED);
                        stepExecution.setEndTime(endTime);
                        this.jobRepository.update(stepExecution);
                    }
                    BatchStatus jobStatus = jobExecution.getStatus();
                    if (!jobStatus.equals((Object)BatchStatus.STARTED)) continue;
                    jobExecution.setStatus(BatchStatus.STOPPED);
                    jobExecution.setEndTime(endTime);
                    this.jobRepository.update(jobExecution);
                }
            }
        }
        String jobName = "dumpJob";
        ArrayList<ViewDefinitionStr> viewDefinitionStrs = new ArrayList<ViewDefinitionStr>(this.dumpConfig.getViewDefinitionStrs());
        Collections.sort(viewDefinitionStrs, new Comparator<ViewDefinitionStr>(){

            @Override
            public int compare(ViewDefinitionStr a, ViewDefinitionStr b) {
                return a.getName().compareTo(b.getName());
            }
        });
        DataSource userDataSource = this.dumpConfig.getUserDataSource();
        JobBuilder jobBuilder = this.jobs.get(jobName);
        SimpleJobBuilder sjb = null;
        FlowJob flowJob = new FlowJob(jobName);
        ArrayList transitions = new ArrayList();
        boolean isSequentialStepExecution = false;
        ArrayList<Step> steps = new ArrayList<Step>();
        for (ViewDefinitionStr vds : viewDefinitionStrs) {
            String baseName = StringUtils.urlEncode((String)vds.getName());
            String flowName = "flow-" + baseName;
            System.out.println("Creating step for " + vds);
            Step step = this.createStep("foobar-", userDataSource, vds, this.dumpConfig.getOutBaseDir());
            if (isSequentialStepExecution) {
                if (sjb == null) {
                    sjb = jobBuilder.start(step);
                    continue;
                }
                sjb.next(step);
                continue;
            }
            steps.add(step);
        }
        if (isSequentialStepExecution) {
            result = sjb.build();
        } else {
            SimpleFlow flow = this.create(steps);
            FlowStep flowStep = new FlowStep((Flow)flow);
            flowStep.setFlow((Flow)flow);
            flowStep.setJobRepository(this.jobRepository);
            flowStep.afterPropertiesSet();
            result = jobBuilder.start((Step)flowStep).build();
        }
        JobParameters jobParameters = new JobParameters();
        this.jobLauncher.run(result, jobParameters);
        return result;
    }

    protected Step createStep(String stepName, DataSource dataSource, ViewDefinitionStr vds, String outBaseDir) throws Exception {
        String baseName = StringUtils.urlEncode((String)vds.getName());
        String outFileName = outBaseDir + "/" + baseName + ".nt";
        FileSystemResource outResource = new FileSystemResource(outFileName);
        RowMapperSparqlifyBinding rowMapper = new RowMapperSparqlifyBinding();
        JdbcCursorItemReader itemReader = new JdbcCursorItemReader();
        itemReader.setFetchSize(50000);
        itemReader.setSaveState(false);
        itemReader.setVerifyCursorPosition(false);
        itemReader.setSql(vds.getSqlQueryString());
        itemReader.setDataSource(dataSource);
        itemReader.setRowMapper((RowMapper)rowMapper);
        itemReader.afterPropertiesSet();
        FlatFileItemWriter itemWriter = new FlatFileItemWriter();
        itemWriter.setLineAggregator((LineAggregator)new PassThroughLineAggregator());
        itemWriter.setResource((Resource)outResource);
        itemWriter.setShouldDeleteIfExists(false);
        itemWriter.setForceSync(false);
        itemWriter.setTransactional(false);
        itemWriter.afterPropertiesSet();
        MyItemProcessor itemProcessor = new MyItemProcessor(vds.getTemplate(), vds.getSparqlVarMap());
        TaskletStep result = this.steps.get(vds.getName()).chunk(10000).reader((ItemReader)itemReader).processor((ItemProcessor)itemProcessor).writer((ItemWriter)itemWriter).build();
        return result;
    }

    public static DumpConfig parseCliArgs(String[] args) throws ClassNotFoundException, ParseException, IOException, RecognitionException, SQLException {
        LoggerCount loggerCount = new LoggerCount(logger);
        Class.forName("org.postgresql.Driver");
        GnuParser cliParser = new GnuParser();
        CommandLine commandLine = cliParser.parse(cliOptions, args);
        File outBaseDir = SparqlifyCliHelper.parseFile((CommandLine)commandLine, (String)"o", (boolean)false, (Logger)loggerCount);
        String outBaseDirName = outBaseDir.getAbsolutePath();
        if (outBaseDir.exists() && !outBaseDir.isDirectory()) {
            loggerCount.error("Folder required; " + outBaseDirName + " is refers to file.");
        } else if (!outBaseDir.exists()) {
            outBaseDir.mkdirs();
        }
        Integer threadCount = SparqlifyCliHelper.parseInt((CommandLine)commandLine, (String)"T", (boolean)false, (Logger)loggerCount);
        DataSource userDataSource = SparqlifyCliHelper.parseDataSource((CommandLine)commandLine, (Logger)loggerCount);
        Config config = SparqlifyCliHelper.parseSmlConfig((CommandLine)commandLine, (Logger)loggerCount);
        SparqlifyCliHelper.onErrorPrintHelpAndExit((Options)cliOptions, (LoggerCount)loggerCount, (int)-1);
        TypeSystem typeSystem = SparqlifyCoreInit.createDefaultDatatypeSystem();
        SqlExprSerializerSystem serializerSystem = SparqlifyUtils.createSerializerSystem((TypeSystem)typeSystem);
        SqlOpSelectBlockCollectorImpl sqlOpSelectBlockCollector = new SqlOpSelectBlockCollectorImpl();
        SqlOpSerializerImpl sqlOpSerializer = new SqlOpSerializerImpl((SqlExprSerializer)serializerSystem);
        Map typeAlias = MapReader.readFromResource((String)"/type-map.h2.tsv");
        List viewDefinitions = SparqlifyCliHelper.extractViewDefinitions((List)config.getViewDefinitions(), (DataSource)userDataSource, (TypeSystem)typeSystem, (Map)typeAlias, (Logger)loggerCount);
        SparqlifyCliHelper.onErrorPrintHelpAndExit((Options)cliOptions, (LoggerCount)loggerCount, (int)-1);
        ViewDefinitionStrFactory vdsFactory = new ViewDefinitionStrFactory((SqlOpSelectBlockCollector)sqlOpSelectBlockCollector, (SqlOpSerializer)sqlOpSerializer);
        ArrayList<ViewDefinitionStr> viewDefinitionStrs = new ArrayList<ViewDefinitionStr>();
        for (ViewDefinition viewDefinition : viewDefinitions) {
            ViewDefinitionStr vds = vdsFactory.createView(viewDefinition);
            viewDefinitionStrs.add(vds);
        }
        DataSource jobDataSource = MasterDumper.createJobDataSource((String)"sparqlify-dump");
        MasterDumper.populateSpringBatchH2((DataSource)jobDataSource);
        DumpConfig dumpConfig = new DumpConfig(jobDataSource, userDataSource, outBaseDirName, viewDefinitionStrs, threadCount);
        return dumpConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        DumpConfig dumpConfig;
        DumpConfigProvider.dumpConfig = dumpConfig = MainSparqlifyBatchDumper.parseCliArgs(args);
        ClassPathResource springBatchSml = new ClassPathResource("org/springframework/batch/rdb2rdf/rdf-mapping-h2.sml");
        Config config = SparqlifyUtils.parseSmlConfig((InputStream)springBatchSml.getInputStream(), (Logger)logger);
        logger.info("Processing init parameters complete, preparing launch ...");
        DataSource jobDataSource = dumpConfig.getJobDataSource();
        QueryExecutionFactoryEx qef = SparqlifyUtils.createDefaultSparqlifyEngine((DataSource)jobDataSource, (Config)config, (Long)1000L, (Integer)30);
        final Server server = Main.createSparqlEndpoint(qef, 5544);
        try {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        server.start();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            thread.start();
            Thread.sleep(2000L);
            AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext(new Class[]{DumpConfigProvider.class, MainSparqlifyBatchDumper.class});
            context.getBean("job");
        }
        finally {
            server.stop();
        }
    }

    static {
        cliOptions.addOption("t", "type", true, "Database type (posgres, mysql,...)");
        cliOptions.addOption("d", "database", true, "Database name");
        cliOptions.addOption("u", "username", true, "");
        cliOptions.addOption("p", "password", true, "");
        cliOptions.addOption("h", "hostname", true, "");
        cliOptions.addOption("c", "class", true, "JDBC driver class");
        cliOptions.addOption("j", "jdbcurl", true, "JDBC URL");
        cliOptions.addOption("o", "outfolder", true, "Folder where to write the output");
        cliOptions.addOption("T", "threads", true, "Number of threads to use for dumping views in parallel");
        cliOptions.addOption("m", "mapping", true, "Sparqlify mapping file");
        RdfViewSystemOld.initSparqlifyFunctions();
    }
}

