/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.web;

import org.aksw.jena_sparql_api.compare.QueryExecutionFactoryCompare;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.http.QueryExecutionFactoryHttp;
import org.aksw.sparqlify.core.sparql.QueryExecutionFactoryExWrapper;
import org.aksw.sparqlify.web.HttpSparqlEndpoint;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompareMain {
    private static final Logger logger = LoggerFactory.getLogger(HttpSparqlEndpoint.class);
    private static final Options cliOptions = new Options();

    public static void printHelpAndExit(int exitCode) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(HttpSparqlEndpoint.class.getName(), cliOptions);
        System.exit(exitCode);
    }

    public static void main(String[] args) throws Exception {
        GnuParser cliParser = new GnuParser();
        cliOptions.addOption("P", "port", true, "Server port");
        cliOptions.addOption("C", "context", true, "Context e.g. /sparqlify");
        cliOptions.addOption("B", "backlog", true, "Maximum number of connections");
        CommandLine commandLine = cliParser.parse(cliOptions, args);
        String[] serviceArgs = commandLine.getArgs();
        if (serviceArgs.length != 2) {
            throw new RuntimeException("Expecting two URL to SPARQL endpoints which to compare as result");
        }
        String serviceUrlA = serviceArgs[0];
        String serviceUrlB = serviceArgs[1];
        String portStr = commandLine.getOptionValue("P", "3333");
        int port = Integer.parseInt(portStr);
        QueryExecutionFactoryHttp qefA = new QueryExecutionFactoryHttp(serviceUrlA);
        QueryExecutionFactoryHttp qefB = new QueryExecutionFactoryHttp(serviceUrlB);
        QueryExecutionFactoryCompare qef = new QueryExecutionFactoryCompare((QueryExecutionFactory)qefA, (QueryExecutionFactory)qefB, true);
        HttpSparqlEndpoint.sparqler = QueryExecutionFactoryExWrapper.wrap((QueryExecutionFactory)qef);
        ServletHolder sh = new ServletHolder(ServletContainer.class);
        sh.setInitParameter("com.sun.jersey.config.property.resourceConfigClass", "com.sun.jersey.api.core.PackagesResourceConfig");
        sh.setInitParameter("com.sun.jersey.config.property.packages", "org.aksw.sparqlify.web");
        Server server = new Server(port);
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)server, "/", 1);
        context.addServlet(sh, "/*");
        server.start();
    }
}

