/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.glisten;

import com.carrotsearch.hppc.ObjectLongOpenHashMap;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;

public class WikidataSubclassCountingTool {
    private static final String INPUT_COUNT_CSV_FILE = "/home/micha/data/WikidataClassCounts.csv";
    private static final String INPUT_SUBCLASS_HIERARCHY = "/home/micha/data/WikidataSubclasses.nt";
    private static final String OUTPUT_CSV_FILE = "";

    public static void main(String[] args) throws FileNotFoundException, IOException {
        ObjectLongOpenHashMap counts = new ObjectLongOpenHashMap();
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(INPUT_COUNT_CSV_FILE));
             Scanner scanner = new Scanner((InputStream)is, StandardCharsets.UTF_8);){
            scanner.useDelimiter("\n");
            while (scanner.hasNext()) {
                String[] fields;
                String line = scanner.next();
                if (line == null || line.isEmpty() || (fields = line.split(",")).length <= 1 || "count".equals(fields[1])) continue;
                counts.put((Object)fields[0], Long.parseLong(fields[1]));
            }
        }
        System.out.println("Read " + counts.size() + " counts.");
        Model model = ModelFactory.createDefaultModel();
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(INPUT_SUBCLASS_HIERARCHY));){
            model.read((InputStream)is, OUTPUT_CSV_FILE, "NT");
        }
        System.out.println("Read " + model.size() + " triples.");
    }
}

