/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.tapioca.gen;

import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dice_research.topicmodeling.algorithm.mallet.MalletLdaWrapper;
import org.dice_research.topicmodeling.algorithms.ProbTopicModelingAlgorithmStateSupplier;
import org.dice_research.topicmodeling.io.CorpusReader;
import org.dice_research.topicmodeling.io.gzip.GZipCorpusReaderDecorator;
import org.dice_research.topicmodeling.io.gzip.GZipProbTopicModelingAlgorithmStateWriter;
import org.dice_research.topicmodeling.io.java.CorpusObjectReader;
import org.dice_research.topicmodeling.utils.corpus.Corpus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelGenerator.class);
    private static final int DEFAULT_NUMBER_OF_STEPS = 1040;
    private static final String DEFAULT_MODEL_OBJECT_FILE_NAME = "probAlgState.object";
    private int numberOfTopics;
    private int numberOfSteps;

    public static void main(String[] args) {
        Options options = new Options();
        options.addOption("t", "topics", true, "the number of topics");
        options.addOption("i", "iterations", true, "the number of iterations used for generating the model");
        options.addOption("o", "output-folder", true, "the folder to which the output will be written to");
        options.addOption("c", "corpus", true, "the corpus file");
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            LOGGER.error("Couldn't parse commands. Aborting.", (Throwable)e);
            return;
        }
        if (!cmd.hasOption("c")) {
            LOGGER.error("The input corpus file is not defined. Please provide a corpus file.");
            return;
        }
        String inputFile = cmd.getOptionValue("c");
        if (!cmd.hasOption("o")) {
            LOGGER.error("Output file is not defined. Please provide an output directory.");
            return;
        }
        File outputFolder = new File(cmd.getOptionValue("o"));
        if (!cmd.hasOption("t")) {
            LOGGER.error("The number of topics is not defined. Please provide it.");
            return;
        }
        int numberOfTopics = Integer.parseInt(cmd.getOptionValue("t"));
        int iterations = 1040;
        if (!cmd.hasOption("i")) {
            LOGGER.info("The number of iterations is not defined. The default value {} will be used", (Object)iterations);
        } else {
            iterations = Integer.parseInt(cmd.getOptionValue("i"));
        }
        if (!outputFolder.exists()) {
            outputFolder.mkdirs();
        }
        String modelObjFile = outputFolder.getAbsolutePath() + File.separator + DEFAULT_MODEL_OBJECT_FILE_NAME;
        ModelGenerator generator = new ModelGenerator(numberOfTopics, iterations);
        generator.run(inputFile, modelObjFile);
    }

    public ModelGenerator(int numberOfTopics, int numberOfSteps) {
        this.numberOfTopics = numberOfTopics;
        this.numberOfSteps = numberOfSteps;
    }

    public void run(String corpusFile, String modelFile) {
        GZipCorpusReaderDecorator reader = new GZipCorpusReaderDecorator((CorpusReader)new CorpusObjectReader());
        reader.readCorpus(new File(corpusFile));
        Corpus corpus = reader.getCorpus();
        if (corpus == null) {
            LOGGER.error("Couldn't load corpus from file. Aborting.");
            return;
        }
        this.run(corpus, modelFile);
    }

    public void run(Corpus corpus, String modelFile) {
        MalletLdaWrapper algorithm = new MalletLdaWrapper(this.numberOfTopics);
        algorithm.initialize(corpus);
        for (int i = 0; i < this.numberOfSteps; ++i) {
            algorithm.performNextStep();
        }
        File mFile = new File(modelFile);
        GZipProbTopicModelingAlgorithmStateWriter writer = new GZipProbTopicModelingAlgorithmStateWriter();
        writer.writeProbTopicModelState((ProbTopicModelingAlgorithmStateSupplier)algorithm, mFile);
    }
}

