/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.tapioca.preprocessing.labelretrieving;

import com.mongodb.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Indexes;
import java.util.List;
import org.aksw.simba.tapioca.preprocessing.labelretrieving.AbstractTokenizedLabelRetriever;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoDBBasedTokenizedLabelRetriever
extends AbstractTokenizedLabelRetriever
implements AutoCloseable {
    public static final String DB_NAME = "tapioca";
    public static final String COLLECTION_URIS = "uris";
    public static final String URI_FIELD = "uri";
    public static final String TOKENS_FIELD = "tokens";
    protected MongoClient client;
    protected MongoCollection<Document> uriCollection;

    public MongoDBBasedTokenizedLabelRetriever(MongoClient client) {
        this.client = client;
        this.uriCollection = MongoDBBasedTokenizedLabelRetriever.open(client);
    }

    public List<String> getTokenizedLabel(String uri, String namespace) {
        Document query = new Document(URI_FIELD, (Object)uri);
        MongoCursor iterator = this.uriCollection.find((Bson)query).iterator();
        if (iterator.hasNext()) {
            return (List)((Document)iterator.next()).get((Object)TOKENS_FIELD);
        }
        return null;
    }

    @Override
    public void close() throws Exception {
        this.client.close();
    }

    public static MongoDBBasedTokenizedLabelRetriever create(String dbHost, int dbPort) {
        return new MongoDBBasedTokenizedLabelRetriever(new MongoClient(dbHost, dbPort));
    }

    public static MongoCollection<Document> open(MongoClient client) {
        MongoDatabase mongoDB = client.getDatabase(DB_NAME);
        if (!MongoDBBasedTokenizedLabelRetriever.queueTableExists(mongoDB)) {
            return MongoDBBasedTokenizedLabelRetriever.initDB(mongoDB);
        }
        return mongoDB.getCollection(COLLECTION_URIS);
    }

    public static boolean queueTableExists(MongoDatabase mongoDB) {
        for (String collection : mongoDB.listCollectionNames()) {
            if (!collection.toLowerCase().equals(COLLECTION_URIS.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static MongoCollection<Document> initDB(MongoDatabase mongoDB) {
        mongoDB.createCollection(COLLECTION_URIS);
        MongoCollection uriCollection = mongoDB.getCollection(COLLECTION_URIS);
        uriCollection.createIndex(Indexes.ascending((String[])new String[]{URI_FIELD}));
        return uriCollection;
    }
}

