/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.tapioca.gen;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempSeedListCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(TempSeedListCreator.class);

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Not enough arguments. Call the program as:");
            System.err.println("TempSeedListCreator <laundromat-tsv-file> <output-seed-file>");
            return;
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(args[1]), StandardCharsets.UTF_8);
             InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(args[0])), StandardCharsets.UTF_8);){
            StringBuilder builder = new StringBuilder();
            int state = 0;
            block20: while (((Reader)reader).ready()) {
                char c = (char)((Reader)reader).read();
                switch (state) {
                    case 0: {
                        if (!Character.isWhitespace(c)) continue block20;
                        state = 1;
                        continue block20;
                    }
                    case 1: {
                        if (Character.isWhitespace(c)) continue block20;
                        ++state;
                        continue block20;
                    }
                    case 2: {
                        if (!Character.isWhitespace(c)) continue block20;
                        state = 3;
                        continue block20;
                    }
                    case 3: {
                        if (Character.isWhitespace(c)) continue block20;
                        ++state;
                        builder.append(c);
                        continue block20;
                    }
                    case 4: {
                        if (Character.isWhitespace(c)) {
                            writer.write(builder.toString());
                            builder.delete(0, builder.length());
                            state = 5;
                            continue block20;
                        }
                        builder.append(c);
                        continue block20;
                    }
                    case 5: {
                        if (c != '\n') continue block20;
                        state = 0;
                        continue block20;
                    }
                }
                throw new IllegalStateException("Unknown state " + state);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception while creating seed list from laundromat.tsv. Aborting.", (Throwable)e);
        }
    }
}

