/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.tapioca.gen;

import com.github.jsonldjava.shaded.com.google.common.collect.Streams;
import com.google.gson.Gson;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoWriteException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.simba.tapioca.preprocessing.labelretrieving.MongoDBBasedTokenizedLabelRetriever;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelMongoDBGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(LabelMongoDBGenerator.class);

    public static void main(String[] args) throws InterruptedException {
        if (args.length < 3) {
            LOGGER.error("Not enough arguments:\nLabelDBGenerator <mongo-db-host> <mongo-db-port> <input-file>");
            return;
        }
        LabelMongoDBGenerator summarizer = new LabelMongoDBGenerator();
        summarizer.readTsv(args[0], Integer.parseInt(args[1]), args[2]);
    }

    protected void readTsv(String dbHost, int dbPort, String inputFile) {
        try (MongoClient client = new MongoClient(dbHost, dbPort);){
            MongoCollection<Document> uriCollection = MongoDBBasedTokenizedLabelRetriever.open(client);
            SimpleBuffer buffer = new SimpleBuffer();
            TSVReader tReader = new TSVReader();
            Gson gson = new Gson();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFile), StandardCharsets.UTF_8));){
                tReader.read(reader, buffer, uriCollection, gson);
            }
            catch (IOException e) {
                LOGGER.error("Error while reading labels from file.", (Throwable)e);
            }
            if (buffer.getUri() != null) {
                LabelMongoDBGenerator.store(buffer, uriCollection, gson);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while processing file.", (Throwable)e);
        }
    }

    protected static void store(SimpleBuffer buffer, MongoCollection<Document> uriCollection, Gson gson) throws SQLException {
        if (buffer.tokens.isEmpty() || buffer.uri == null || buffer.uri.isEmpty()) {
            return;
        }
        Document query = new Document("uri", (Object)buffer.uri);
        MongoCursor iterator = uriCollection.find((Bson)query).iterator();
        if (iterator.hasNext()) {
            Document document = (Document)iterator.next();
            List tokens = (List)document.get((Object)"tokens");
            tokens = Streams.concat((Stream[])new Stream[]{tokens.stream(), buffer.tokens.stream()}).distinct().collect(Collectors.toList());
            Document update = new Document().append("$set", (Object)new BasicDBObject().append("tokens", tokens));
            uriCollection.updateOne((Bson)query, (Bson)update);
        } else {
            query.append("tokens", buffer.tokens);
            try {
                uriCollection.insertOne((Object)query);
            }
            catch (MongoWriteException e) {
                if (e.getMessage().contains("key too large to index")) {
                    LOGGER.error("The following URI is too long and will be ignored: {}", (Object)buffer.uri);
                }
                throw e;
            }
        }
    }

    public static class SimpleBuffer {
        protected String uri;
        protected List<String> tokens = new ArrayList<String>();

        public void add(String token) {
            this.tokens.add(token);
        }

        public void clear() {
            this.uri = null;
            this.tokens.clear();
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public List<String> getTokens() {
            return this.tokens;
        }

        public void setTokens(List<String> tokens) {
            this.tokens = tokens;
        }
    }

    public static class TSVReader {
        public void read(Reader reader, SimpleBuffer buffer, MongoCollection<Document> uriCollection, Gson gson) throws IOException {
            StringBuilder builder = new StringBuilder();
            block4: while (reader.ready()) {
                char c = (char)reader.read();
                switch (c) {
                    case '\t': {
                        this.handleUri(builder.toString(), buffer, uriCollection, gson);
                        builder.delete(0, builder.length());
                        continue block4;
                    }
                    case '\n': {
                        this.handleToken(builder.toString(), buffer);
                        builder.delete(0, builder.length());
                        continue block4;
                    }
                }
                builder.append(c);
            }
        }

        protected void handleUri(String uri, SimpleBuffer buffer, MongoCollection<Document> uriCollection, Gson gson) {
            if (!uri.equals(buffer.getUri())) {
                try {
                    LabelMongoDBGenerator.store(buffer, uriCollection, gson);
                }
                catch (SQLException e) {
                    LOGGER.error("Error while storing labels in DB.", (Throwable)e);
                }
                buffer.clear();
                buffer.setUri(uri);
            }
        }

        protected void handleToken(String token, SimpleBuffer buffer) {
            buffer.add(token);
        }
    }

    public static class PreparedInsertStmts
    implements AutoCloseable {
        public PreparedStatement insertUriStmt;
        public PreparedStatement insertTokenStmt;
        public PreparedStatement insertUriTokenConnectionStmt;

        protected PreparedInsertStmts(PreparedStatement insertUriStmt, PreparedStatement insertTokenStmt, PreparedStatement insertUriTokenConnectionStmt) {
            this.insertUriStmt = insertUriStmt;
            this.insertTokenStmt = insertTokenStmt;
            this.insertUriTokenConnectionStmt = insertUriTokenConnectionStmt;
        }

        @Override
        public void close() throws Exception {
            if (this.insertUriStmt != null) {
                this.insertUriStmt.close();
            }
            if (this.insertTokenStmt != null) {
                this.insertTokenStmt.close();
            }
            if (this.insertUriTokenConnectionStmt != null) {
                this.insertUriTokenConnectionStmt.close();
            }
        }

        public static PreparedInsertStmts create(Connection connection) {
            PreparedStatement insertUriTokenConnectionStmt;
            PreparedStatement insertTokenStmt;
            PreparedStatement insertUriStmt;
            try {
                insertUriStmt = connection.prepareStatement("INSERT INTO uris(uri) VALUES(?)");
            }
            catch (SQLException e) {
                LOGGER.error("Error while creating prepared statement.", (Throwable)e);
                return null;
            }
            try {
                insertTokenStmt = connection.prepareStatement("INSERT INTO tokens(token) VALUES(?)");
            }
            catch (SQLException e) {
                LOGGER.error("Error while creating prepared statement.", (Throwable)e);
                return null;
            }
            try {
                insertUriTokenConnectionStmt = connection.prepareStatement("INSERT INTO uriTokens(uriId, tokenId) SELECT uriId, tokenId FROM (SELECT id as uriId FROM uris WHERE uri=?),(SELECT id as tokenId FROM tokens WHERE token=?)");
            }
            catch (SQLException e) {
                LOGGER.error("Error while creating prepared statement.", (Throwable)e);
                return null;
            }
            return new PreparedInsertStmts(insertUriStmt, insertTokenStmt, insertUriTokenConnectionStmt);
        }
    }
}

