/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.tapioca.gen;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.dice_research.topicmodeling.commons.io.StorageHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelFileSummarizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(LabelFileSummarizer.class);
    private static final String LABEL_FILE_SUFFIX = "labels.out";
    private static final String TEMP_FILE = "temp-labels.csv";
    protected File tempFile = new File("temp-labels.csv");
    protected Map<String, ? super Collection<String>> labels = new HashMap<String, Collection<String>>();
    protected ExecutorService service = Executors.newFixedThreadPool(32);

    public static void main(String[] args) throws InterruptedException {
        if (args.length < 2) {
            LOGGER.error("Not enough arguments:\nLabelFileSummarizer <output-file> <input-directory>");
        }
        LabelFileSummarizer summarizer = new LabelFileSummarizer();
        summarizer.readTsv();
        summarizer.writeToFile(args[0]);
    }

    private void writeIntoSingleFile(File directory) {
        try (FileWriter tempWriter = new FileWriter(this.tempFile);){
            for (File f : directory.listFiles()) {
                String[][] labels = (String[][])StorageHelper.readFromFileSavely((String)f.getAbsolutePath());
                if (labels == null || labels.length <= 0) continue;
                for (int i = 0; i < labels.length; ++i) {
                    for (int j = 1; j < labels[i].length; ++j) {
                        tempWriter.write(labels[i][0]);
                        ((Writer)tempWriter).write(9);
                        tempWriter.write(labels[i][j]);
                        ((Writer)tempWriter).write(10);
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readTsv() {
        this.labels = new HashMap<String, Collection<String>>();
        try (Stream<String> stream = Files.lines(Paths.get(TEMP_FILE, new String[0]));){
            ((Stream)stream.parallel()).forEach(l -> this.addTsvLine((String)l));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTsvLine(String line) {
        Set labelsOfUri;
        int pos = line.indexOf(9);
        if (pos < 0) {
            return;
        }
        String uri = line.substring(0, pos);
        String label = line.substring(pos + 1);
        Map<String, ? super Collection<String>> map = this.labels;
        synchronized (map) {
            if (this.labels.containsKey(uri)) {
                labelsOfUri = (Set)this.labels.get(uri);
            } else {
                labelsOfUri = Collections.synchronizedSet(new HashSet());
                this.labels.put(new String(uri), labelsOfUri);
            }
        }
        labelsOfUri.add(new String(label));
    }

    protected static String get1stTsvField(String line) {
        int end = line.indexOf(9);
        if (end < 0) {
            return line;
        }
        return line.substring(0, end);
    }

    protected static List<String> get2ndTsvField(String line) {
        int start = line.indexOf(9);
        if (start < 0) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<String> result = new LinkedList<String>();
        result.add(line.substring(start + 1));
        return result;
    }

    public void addFileOrDir(final File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.addFileOrDir(files[i]);
            }
        } else {
            this.service.execute(new Runnable(){

                @Override
                public void run() {
                    LabelFileSummarizer.this.addLabels(file);
                }
            });
        }
    }

    public void processAsStream(File directory) {
        this.labels = ((Stream)Arrays.stream(directory.listFiles()).parallel()).filter(f -> f.getName().endsWith(LABEL_FILE_SUFFIX)).map(f -> (String[][])StorageHelper.readFromFileSavely((String)f.getAbsolutePath())).filter(a -> a != null && ((String[][])a).length > 0).flatMap(a -> this.createSets((String[][])a).stream()).collect(Collectors.toConcurrentMap(p -> (String)p.getLeft(), p -> (Collection)p.getRight(), (s1, s2) -> {
            s1.addAll(s2);
            return s1;
        }));
    }

    public List<Pair<String, Set<String>>> createSets(String[][] uriToLabel) {
        ArrayList<Pair<String, Set<String>>> sets = new ArrayList<Pair<String, Set<String>>>();
        for (int i = 0; i < uriToLabel.length; ++i) {
            HashSet<String> labelsOfUri = new HashSet<String>();
            for (int j = 1; j < uriToLabel[i].length; ++j) {
                labelsOfUri.add(uriToLabel[i][j]);
            }
            sets.add((Pair<String, Set<String>>)new ImmutablePair((Object)uriToLabel[i][0], labelsOfUri));
        }
        return sets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLabels(File file) {
        String[][] uriToLabel = (String[][])StorageHelper.readFromFileSavely((String)file.getAbsolutePath());
        if (uriToLabel == null) {
            LOGGER.error("Couldn't load labels from \"" + file + "\". Returning null.");
            return;
        }
        for (int i = 0; i < uriToLabel.length; ++i) {
            Set labelsOfUri;
            Map<String, ? super Collection<String>> map = this.labels;
            synchronized (map) {
                if (this.labels.containsKey(uriToLabel[i][0])) {
                    labelsOfUri = (Set)this.labels.get(uriToLabel[i][0]);
                } else {
                    labelsOfUri = Collections.synchronizedSet(new HashSet());
                    this.labels.put(uriToLabel[i][0], labelsOfUri);
                }
            }
            for (int j = 1; j < uriToLabel[i].length; ++j) {
                labelsOfUri.add(uriToLabel[i][j]);
            }
        }
    }

    public static String[][] generateArray(Map<String, Collection<String>> labels) {
        String[][] uriToLabel = new String[labels.size()][];
        int pos = 0;
        for (Map.Entry<String, Collection<String>> labelsOfUri : labels.entrySet()) {
            String[] tokenizedLabel = new String[labelsOfUri.getValue().size() + 1];
            int pos2 = 0;
            tokenizedLabel[0] = labelsOfUri.getKey();
            for (String label : labelsOfUri.getValue()) {
                tokenizedLabel[++pos2] = label;
            }
            uriToLabel[pos] = tokenizedLabel;
            ++pos;
        }
        return uriToLabel;
    }

    public void writeToFile(String file) throws InterruptedException {
        this.service.shutdown();
        this.service.awaitTermination(10L, TimeUnit.DAYS);
        StorageHelper.storeToFileSavely((Serializable)LabelFileSummarizer.generateArray(this.labels), (String)file);
    }
}

