/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.tapioca.gen;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelDBGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(LabelDBGenerator.class);

    public static void main(String[] args) throws InterruptedException {
        if (args.length < 2) {
            LOGGER.error("Not enough arguments:\nLabelDBGenerator <output-db-path> <input-file>");
            return;
        }
        LabelDBGenerator summarizer = new LabelDBGenerator();
        summarizer.readTsv(args[0], args[1]);
    }

    protected void readTsv(String dbPath, String inputFile) {
        try {
            Class.forName("org.hsqldb.jdbc.JDBCDriver");
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Couldn't find JDBC driver class.", (Throwable)e);
            return;
        }
        File dbFile = new File(dbPath);
        try (Connection connection = DriverManager.getConnection("jdbc:hsqldb:file:" + dbFile.getAbsolutePath(), "SA", "");){
            this.initDB(connection);
            try (PreparedInsertStmts preparedStmts = PreparedInsertStmts.create(connection);){
                SimpleBuffer buffer = new SimpleBuffer();
                TSVReader tReader = new TSVReader();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFile), StandardCharsets.UTF_8));){
                    tReader.read(reader, buffer, preparedStmts);
                }
                catch (IOException e) {
                    LOGGER.error("Error while reading labels from file.", (Throwable)e);
                }
                if (buffer.getUri() != null) {
                    LabelDBGenerator.store(buffer, preparedStmts);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while processing file.", (Throwable)e);
        }
    }

    protected void initDB(Connection connection) throws SQLException {
        connection.createStatement().executeUpdate("CREATE TABLE IF NOT EXISTS uris (id int GENERATED BY DEFAULT AS IDENTITY (START WITH 1 INCREMENT BY 1) PRIMARY KEY,uri VARCHAR(1000) UNIQUE)");
        connection.createStatement().executeUpdate("CREATE TABLE IF NOT EXISTS tokens (id int GENERATED BY DEFAULT AS IDENTITY (START WITH 1 INCREMENT BY 1) PRIMARY KEY,token VARCHAR(50) UNIQUE)");
        int changes = connection.createStatement().executeUpdate("CREATE TABLE IF NOT EXISTS uriTokens (uriId int NOT NULL FOREIGN KEY REFERENCES uris(id),tokenId int NOT NULL FOREIGN KEY REFERENCES tokens(id))");
        if (changes > 0) {
            connection.createStatement().executeUpdate("CREATE INDEX uriIndex ON uris (uri)");
            connection.createStatement().executeUpdate("CREATE INDEX tokenIndex ON tokens (token)");
        }
    }

    @Deprecated
    protected void addTsvLine(String line, SimpleBuffer buffer, PreparedInsertStmts preparedStmts) {
        int pos = line.indexOf(9);
        if (pos < 0) {
            return;
        }
        String uri = line.substring(0, pos);
        String label = line.substring(pos + 1);
        if (!uri.equals(buffer.getUri())) {
            try {
                LabelDBGenerator.store(buffer, preparedStmts);
            }
            catch (SQLException e) {
                LOGGER.error("Error while storing labels in DB.", (Throwable)e);
            }
            buffer.clear();
            buffer.setUri(uri);
        }
        buffer.add(label);
    }

    protected static void store(SimpleBuffer buffer, PreparedInsertStmts preparedStmts) throws SQLException {
        block6: {
            if (buffer.tokens.isEmpty()) {
                return;
            }
            try {
                preparedStmts.insertUriStmt.setString(1, buffer.uri);
                preparedStmts.insertUriStmt.executeUpdate();
            }
            catch (SQLException e) {
                if (e.getMessage().contains("integrity constraint violation")) break block6;
                LOGGER.info("Exception while adding uri: " + e.getMessage());
            }
        }
        for (String token : buffer.tokens) {
            block7: {
                try {
                    preparedStmts.insertTokenStmt.setString(1, token);
                    preparedStmts.insertTokenStmt.executeUpdate();
                }
                catch (SQLException e) {
                    if (e.getMessage().contains("integrity constraint violation")) break block7;
                    LOGGER.info("Exception while adding token: " + e.getMessage());
                }
            }
            preparedStmts.insertUriTokenConnectionStmt.setString(1, buffer.uri);
            preparedStmts.insertUriTokenConnectionStmt.setString(2, token);
            preparedStmts.insertUriTokenConnectionStmt.addBatch();
        }
        preparedStmts.insertUriTokenConnectionStmt.executeBatch();
    }

    public static class PreparedInsertStmts
    implements AutoCloseable {
        public PreparedStatement insertUriStmt;
        public PreparedStatement insertTokenStmt;
        public PreparedStatement insertUriTokenConnectionStmt;

        protected PreparedInsertStmts(PreparedStatement insertUriStmt, PreparedStatement insertTokenStmt, PreparedStatement insertUriTokenConnectionStmt) {
            this.insertUriStmt = insertUriStmt;
            this.insertTokenStmt = insertTokenStmt;
            this.insertUriTokenConnectionStmt = insertUriTokenConnectionStmt;
        }

        @Override
        public void close() throws Exception {
            if (this.insertUriStmt != null) {
                this.insertUriStmt.close();
            }
            if (this.insertTokenStmt != null) {
                this.insertTokenStmt.close();
            }
            if (this.insertUriTokenConnectionStmt != null) {
                this.insertUriTokenConnectionStmt.close();
            }
        }

        public static PreparedInsertStmts create(Connection connection) {
            PreparedStatement insertUriTokenConnectionStmt;
            PreparedStatement insertTokenStmt;
            PreparedStatement insertUriStmt;
            try {
                insertUriStmt = connection.prepareStatement("INSERT INTO uris(uri) VALUES(?)");
            }
            catch (SQLException e) {
                LOGGER.error("Error while creating prepared statement.", (Throwable)e);
                return null;
            }
            try {
                insertTokenStmt = connection.prepareStatement("INSERT INTO tokens(token) VALUES(?)");
            }
            catch (SQLException e) {
                LOGGER.error("Error while creating prepared statement.", (Throwable)e);
                return null;
            }
            try {
                insertUriTokenConnectionStmt = connection.prepareStatement("INSERT INTO uriTokens(uriId, tokenId) SELECT uriId, tokenId FROM (SELECT id as uriId FROM uris WHERE uri=?),(SELECT id as tokenId FROM tokens WHERE token=?)");
            }
            catch (SQLException e) {
                LOGGER.error("Error while creating prepared statement.", (Throwable)e);
                return null;
            }
            return new PreparedInsertStmts(insertUriStmt, insertTokenStmt, insertUriTokenConnectionStmt);
        }
    }

    public static class SimpleBuffer {
        protected String uri;
        protected List<String> tokens = new ArrayList<String>();

        public void add(String token) {
            this.tokens.add(token);
        }

        public void clear() {
            this.uri = null;
            this.tokens.clear();
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public List<String> getTokens() {
            return this.tokens;
        }

        public void setTokens(List<String> tokens) {
            this.tokens = tokens;
        }
    }

    public static class TSVReader {
        public void read(Reader reader, SimpleBuffer buffer, PreparedInsertStmts preparedStmts) throws IOException {
            StringBuilder builder = new StringBuilder();
            block4: while (reader.ready()) {
                char c = (char)reader.read();
                switch (c) {
                    case '\t': {
                        this.handleUri(builder.toString(), buffer, preparedStmts);
                        builder.delete(0, builder.length());
                        continue block4;
                    }
                    case '\n': {
                        this.handleToken(builder.toString(), buffer);
                        builder.delete(0, builder.length());
                        continue block4;
                    }
                }
                builder.append(c);
            }
        }

        protected void handleUri(String uri, SimpleBuffer buffer, PreparedInsertStmts preparedStmts) {
            if (!uri.equals(buffer.getUri())) {
                try {
                    LabelDBGenerator.store(buffer, preparedStmts);
                }
                catch (SQLException e) {
                    LOGGER.error("Error while storing labels in DB.", (Throwable)e);
                }
                buffer.clear();
                buffer.setUri(uri);
            }
        }

        protected void handleToken(String token, SimpleBuffer buffer) {
            buffer.add(token);
        }
    }
}

