/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.tapioca.gen;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.dice_research.topicmodeling.io.gzip.GZipCorpusObjectReader;
import org.dice_research.topicmodeling.utils.corpus.Corpus;
import org.dice_research.topicmodeling.utils.doc.Document;
import org.dice_research.topicmodeling.utils.doc.DocumentURI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinalCorpusExporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FinalCorpusExporter.class);
    private static final String LOD_STATS_DOC_BASE_URI = "http://lodstats.aksw.org/rdfdocs/";

    public static void main(String[] args) {
        FinalCorpusExporter exporter = new FinalCorpusExporter();
        exporter.run("/Daten/tapioca/lodStats_model" + File.separator + "lodStats_final.corpus", "/Daten/tapioca/export.nt", "/Daten/tapioca/lodStats_model" + File.separator + "lodstats.nt");
    }

    public void run(String corpusFile, String outputFile, String metaDataModelFile) {
        block6: {
            Corpus corpus = this.readCorpus(corpusFile);
            Model model = this.readModel(metaDataModelFile);
            Model exportModel = ModelFactory.createDefaultModel();
            for (Document document : corpus) {
                ResourceImpl datasetResource;
                DocumentURI uri = (DocumentURI)document.getProperty(DocumentURI.class);
                if (uri == null || !model.containsResource((RDFNode)(datasetResource = new ResourceImpl((String)uri.get())))) continue;
                exportModel.add(model.listStatements((Resource)datasetResource, null, null));
            }
            FileOutputStream fout = null;
            try {
                try {
                    fout = new FileOutputStream(outputFile);
                    RDFDataMgr.write((OutputStream)fout, (Model)exportModel, (RDFFormat)RDFFormat.NTRIPLES);
                }
                catch (Exception e) {
                    LOGGER.error("Error while writing result.", (Throwable)e);
                    IOUtils.closeQuietly((OutputStream)fout);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fout);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)fout);
        }
    }

    protected Corpus readCorpus(String corpusFile) {
        GZipCorpusObjectReader reader = new GZipCorpusObjectReader(new File(corpusFile));
        return reader.getCorpus();
    }

    protected Model readModel(String metaDataModelFile) {
        Model model = ModelFactory.createDefaultModel();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(metaDataModelFile));){
                model.read((InputStream)in, LOD_STATS_DOC_BASE_URI, "Turtle");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error("Couldn't read model with additional meta data from file. Ignoring this file.", (Throwable)e);
            return null;
        }
        return model;
    }
}

