package org.dice_research.glisten;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;

import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;

import com.carrotsearch.hppc.ObjectLongOpenHashMap;

public class WikidataSubclassCountingTool {

    private static final String INPUT_COUNT_CSV_FILE = "/home/micha/data/WikidataClassCounts.csv";
    private static final String INPUT_SUBCLASS_HIERARCHY = "/home/micha/data/WikidataSubclasses.nt";

    private static final String OUTPUT_CSV_FILE = "";

    public static void main(String[] args) throws FileNotFoundException, IOException {
        // Read counts
        ObjectLongOpenHashMap<String> counts = new ObjectLongOpenHashMap<String>();
        try (InputStream is = new BufferedInputStream(new FileInputStream(INPUT_COUNT_CSV_FILE));
                Scanner scanner = new Scanner(is, StandardCharsets.UTF_8)) {
            scanner.useDelimiter("\n");
            String line;
            String[] fields;
            while (scanner.hasNext()) {
                line = scanner.next();
                if ((line != null) && (!line.isEmpty())) {
                    fields = line.split(",");
                    if ((fields.length > 1) && (!"count".equals(fields[1]))) {
                        counts.put(fields[0], Long.parseLong(fields[1]));
                    }
                }
            }
        }
        System.out.println("Read " + counts.size() + " counts.");

        Model model = ModelFactory.createDefaultModel();
        try (InputStream is = new BufferedInputStream(new FileInputStream(INPUT_SUBCLASS_HIERARCHY))) {
            model.read(is, "","NT");
        }
        System.out.println("Read " + model.size() + " triples.");
        
//        try (PrintStream out = new PrintStream(fileName))
    }
}
