/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.glisten;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDFS;

public class WikipediaCategoryReporter {
    private static final String INPUT_COUNT_CSV_FILE = "/home/micha/data/WikidataClassCounts.csv";
    private static final String INPUT_SUBCLASS_HIERARCHY = "/home/micha/data/WikidataSubclasses.nt";
    private static final String OUTPUT_CSV_FILE = "";
    private static final long MIN_COUNT = 100L;

    public static void main(String[] args) throws FileNotFoundException, IOException {
        Model model = ModelFactory.createDefaultModel();
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(INPUT_SUBCLASS_HIERARCHY));){
            model.read((InputStream)is, OUTPUT_CSV_FILE, "TTL");
        }
        System.out.println("Read " + model.size() + " triples.");
        StmtIterator iterator = model.listStatements(null, model.getProperty(OUTPUT_CSV_FILE), (RDFNode)null);
        while (iterator.hasNext()) {
            long count;
            Statement s = (Statement)iterator.next();
            if (!s.getObject().isLiteral() || (count = s.getObject().asLiteral().getLong()) < 100L) continue;
            System.out.print(s.getSubject().getURI());
            System.out.print("\t");
            System.out.print(WikipediaCategoryReporter.getLabel(model, s.getSubject()));
            System.out.print("\t");
            System.out.println(count);
        }
    }

    public static String getLabel(Model model, Resource resource) {
        return WikipediaCategoryReporter.getStringValue(model, resource, RDFS.label);
    }

    public static String getStringValue(Model model, Resource subject, Property predicate) {
        if (model == null) {
            return null;
        }
        NodeIterator nodeIterator = model.listObjectsOfProperty(subject, predicate);
        if (nodeIterator.hasNext()) {
            RDFNode node = nodeIterator.next();
            if (node.isLiteral()) {
                return node.asLiteral().getString();
            }
            return node.toString();
        }
        return null;
    }
}

