/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.glisten;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDF2;
import org.apache.jena.riot.system.StreamRDFBase;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class DBpediaDumpCreator {
    private static final String DBO_NAMEPSACE = "http://dbpedia.org/ontology/";
    private static final String DBP_NAMEPSACE = "http://dbpedia.org/properties/";
    private static final String DBR_NAMEPSACE = "http://dbpedia.org/resource/";
    private static final String RDF_TYPE_URI = RDF.type.getURI();
    private static final String RDFS_LABEL_URI = RDFS.label.getURI();
    private static final int DBO_NAMEPSACE_LENGTH = "http://dbpedia.org/ontology/".length();
    private static final int DBP_NAMEPSACE_LENGTH = "http://dbpedia.org/properties/".length();
    private static final int DBR_NAMEPSACE_LENGTH = "http://dbpedia.org/resource/".length();
    private static final String EXPECTED_LANG_TAG = "en";

    public static void main(String[] args) throws FileNotFoundException, IOException {
        if (args.length < 5) {
            System.err.println("Argument missing! Usage:\nDBpediaDumpCreator <input-dir> <type-file> <ontology-file> <properties-file> <output-dir> <class-name> [<class-name>]");
        }
        System.out.println(Arrays.toString(args));
        String inputDir = args[0].endsWith("/") ? args[0] : String.valueOf(args[0]) + '/';
        String typeFile = args[1];
        String ontologyFile = args[2];
        String propertiesFile = args[3];
        String outputDir = args[4].endsWith("/") ? args[4] : String.valueOf(args[4]) + '/';
        int i = 5;
        while (i < args.length) {
            DBpediaDumpCreator.createDump(inputDir, typeFile, ontologyFile, propertiesFile, outputDir, args[i]);
            ++i;
        }
    }

    private static void createDump(String inputDir, String typeFile, String ontologyFile, String propertiesFile, String outputDir, String clazz) throws FileNotFoundException, IOException {
        System.out.println("Starting with class " + clazz + " ...");
        Set<String> instances = DBpediaDumpCreator.collectInstances(typeFile, clazz);
        if (instances.size() == 0) {
            System.out.println("Found no instances. Aborting.");
            return;
        }
        System.out.println("Found " + instances.size() + " instances.");
        File outputFile = new File(String.valueOf(outputDir) + clazz + ".nt");
        HashSet<String> dboInstances = new HashSet<String>();
        HashSet<String> dbpInstances = new HashSet<String>();
        HashSet<String> dbrInstances = new HashSet<String>();
        Throwable throwable = null;
        Object var12_13 = null;
        try (FileWriter out = new FileWriter(outputFile);){
            StreamRDF writeStream = StreamRDFLib.writer((Writer)out);
            writeStream.start();
            DBpediaDumpCreator.writeCBDs(inputDir, clazz, instances, dboInstances, dbpInstances, dbrInstances, writeStream);
            DBpediaDumpCreator.addClasses(typeFile, dboInstances, dbrInstances, writeStream);
            DBpediaDumpCreator.writeOntologyLabels(ontologyFile, dboInstances, DBO_NAMEPSACE, writeStream);
            DBpediaDumpCreator.writeOntologyLabels(propertiesFile, dbpInstances, DBP_NAMEPSACE, writeStream);
            writeStream.finish();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static Set<String> collectInstances(String typeFile, String clazz) throws FileNotFoundException, IOException {
        String classUri = DBO_NAMEPSACE + clazz;
        HashSet<String> instances = new HashSet<String>();
        ProcessHandler ph = DBpediaDumpCreator.grepFromFile(typeFile, classUri);
        Throwable throwable = null;
        Object var6_7 = null;
        try (InputStream is = ph.getInputStream();){
            SimpleTripleHandler instanceCollector = new SimpleTripleHandler(t -> RDF_TYPE_URI.equals(t.getPredicate().getURI()) && classUri.equals(t.getObject().getURI()), t -> {
                boolean bl = instances.add(new String(t.getSubject().getURI().substring(DBR_NAMEPSACE_LENGTH)));
            });
            RDFDataMgr.parse((StreamRDF)instanceCollector, (InputStream)is, (Lang)Lang.TURTLE);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (!ph.exitedCleanly()) {
            throw new IllegalStateException("Error while reading types of class " + clazz);
        }
        return instances;
    }

    private static void writeCBDs(String inputDir, String clazz, Set<String> instances, Set<String> dboInstances, Set<String> dbpInstances, Set<String> dbrInstances, StreamRDF writeStream) throws FileNotFoundException, IOException {
        File[] inputFiles = new File(inputDir).listFiles(f -> f.getName().endsWith(".ttl.bz2") || f.getName().endsWith(".ttl.gz") || f.getName().endsWith(".ttl"));
        SimpleTripleHandler dboPropCollector = new SimpleTripleHandler(t -> t.getPredicate().getURI().startsWith(DBO_NAMEPSACE), t -> {
            boolean bl = dboInstances.add(new String(t.getPredicate().getURI().substring(DBO_NAMEPSACE_LENGTH)));
        });
        SimpleTripleHandler dboObjCollector = new SimpleTripleHandler(t -> t.getObject().isURI() && t.getObject().getURI().startsWith(DBO_NAMEPSACE), t -> {
            boolean bl = dboInstances.add(new String(t.getObject().getURI().substring(DBO_NAMEPSACE_LENGTH)));
        });
        SimpleTripleHandler dbpPropCollector = new SimpleTripleHandler(t -> t.getPredicate().getURI().startsWith(DBP_NAMEPSACE), t -> {
            boolean bl = dbpInstances.add(new String(t.getPredicate().getURI().substring(DBP_NAMEPSACE_LENGTH)));
        });
        SimpleTripleHandler dbpObjCollector = new SimpleTripleHandler(t -> t.getObject().isURI() && t.getObject().getURI().startsWith(DBP_NAMEPSACE), t -> {
            boolean bl = dbpInstances.add(new String(t.getObject().getURI().substring(DBP_NAMEPSACE_LENGTH)));
        });
        SimpleTripleHandler dbrCollector = new SimpleTripleHandler(t -> t.getObject().isURI() && t.getObject().getURI().startsWith(DBR_NAMEPSACE) && !instances.contains(t.getObject().getURI().substring(DBR_NAMEPSACE_LENGTH)), t -> {
            boolean bl = dbrInstances.add(new String(t.getObject().getURI().substring(DBR_NAMEPSACE_LENGTH)));
        });
        Object stream = writeStream;
        stream = new StreamRDF2(stream, (StreamRDF)dbrCollector);
        stream = new StreamRDF2(stream, (StreamRDF)dbpObjCollector);
        stream = new StreamRDF2(stream, (StreamRDF)dbpPropCollector);
        stream = new StreamRDF2(stream, (StreamRDF)dboObjCollector);
        stream = new StreamRDF2(stream, (StreamRDF)dboPropCollector);
        stream = new SimpleStreamFilter(t -> t.getSubject().getURI().startsWith(DBR_NAMEPSACE) && instances.contains(t.getSubject().getURI().substring(DBR_NAMEPSACE_LENGTH)) && DBpediaDumpCreator.checkObjectLang(t, EXPECTED_LANG_TAG), (StreamRDF)stream);
        int i = 0;
        while (i < inputFiles.length) {
            System.out.print("Reading " + inputFiles[i].getName() + " ...");
            long time = System.currentTimeMillis();
            ProcessHandler ph = DBpediaDumpCreator.grepFromFile(inputFiles[i].getAbsolutePath(), DBR_NAMEPSACE, instances);
            Throwable throwable = null;
            Object var19_19 = null;
            try (InputStream is = ph.getInputStream();){
                RDFDataMgr.parse((StreamRDF)stream, (InputStream)is, (Lang)Lang.TURTLE);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (!ph.exitedCleanly()) {
                throw new IllegalStateException("Error while reading file " + inputFiles[i].getName());
            }
            time = System.currentTimeMillis() - time;
            System.out.print(" done (");
            System.out.print(time);
            System.out.println("ms)");
            ++i;
        }
    }

    private static void addClasses(String typeFile, Set<String> dboInstances, Set<String> dbrInstances, StreamRDF writeStream) throws FileNotFoundException, IOException {
        System.out.print("Adding classes for " + dbrInstances.size() + " additional instances ...");
        long time = System.currentTimeMillis();
        SimpleTripleHandler dboObjCollector = new SimpleTripleHandler(t -> t.getObject().getURI().startsWith(DBO_NAMEPSACE), t -> {
            boolean bl = dboInstances.add(new String(t.getObject().getURI().substring(DBO_NAMEPSACE_LENGTH)));
        });
        Object stream = writeStream;
        stream = new StreamRDF2(stream, (StreamRDF)dboObjCollector);
        stream = new SimpleStreamFilter(t -> RDF_TYPE_URI.equals(t.getPredicate().getURI()) && t.getSubject().getURI().startsWith(DBR_NAMEPSACE) && dbrInstances.contains(t.getSubject().getURI().substring(DBR_NAMEPSACE_LENGTH)), (StreamRDF)stream);
        ProcessHandler ph = DBpediaDumpCreator.grepFromFile(typeFile, DBR_NAMEPSACE, dbrInstances);
        Throwable throwable = null;
        Object var10_10 = null;
        try (InputStream is = ph.getInputStream();){
            RDFDataMgr.parse((StreamRDF)stream, (InputStream)is, (Lang)Lang.TURTLE);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (!ph.exitedCleanly()) {
            throw new IllegalStateException("Error while reading file types of additional instances.");
        }
        time = System.currentTimeMillis() - time;
        System.out.print(" done (");
        System.out.print(time);
        System.out.println("ms)");
    }

    private static void writeOntologyLabels(String ontologyFile, Set<String> ontologyIris, String ontologyNamespace, StreamRDF writeStream) throws FileNotFoundException, IOException {
        System.out.print("Adding labels of " + ontologyIris.size() + " ontology IRIs ...");
        long time = System.currentTimeMillis();
        int namespaceLength = ontologyNamespace.length();
        Object stream = writeStream;
        stream = new SimpleStreamFilter(t -> RDFS_LABEL_URI.equals(t.getPredicate().getURI()) && t.getSubject().getURI().startsWith(ontologyNamespace) && ontologyIris.contains(t.getSubject().getURI().substring(namespaceLength)) && DBpediaDumpCreator.checkObjectLang(t, EXPECTED_LANG_TAG), (StreamRDF)stream);
        Throwable throwable = null;
        Object var9_9 = null;
        try (InputStream is = DBpediaDumpCreator.openFile(ontologyFile);){
            RDFDataMgr.parse((StreamRDF)stream, (InputStream)is, (Lang)Lang.NT);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        time = System.currentTimeMillis() - time;
        System.out.print(" done (");
        System.out.print(time);
        System.out.println("ms)");
    }

    protected static InputStream openFile(String file) throws IOException {
        FilterInputStream is = new BufferedInputStream(new FileInputStream(file));
        if (file.endsWith(".bz2")) {
            is = new BZip2CompressorInputStream((InputStream)is);
        } else if (file.endsWith(".gz")) {
            is = new GZIPInputStream(is);
        }
        return is;
    }

    protected static ProcessHandler grepFromFile(String file, String searchString) throws IOException {
        String grep = file.endsWith(".bz2") ? "bzfgrep" : "fgrep";
        return ProcessHandler.create(grep, searchString, file);
    }

    protected static ProcessHandler grepFromFile(String file, Collection<String> searchStrings) throws IOException {
        return DBpediaDumpCreator.grepFromFile(file, "", searchStrings);
    }

    protected static ProcessHandler grepFromFile(String file, String searchPrefix, Collection<String> searchStrings) throws IOException {
        if (searchStrings.size() < 1000) {
            return DBpediaDumpCreator.grepFromFileWithLongCmd(file, searchPrefix, searchStrings);
        }
        return DBpediaDumpCreator.grepFromFileWithTempFile(file, searchPrefix, searchStrings);
    }

    protected static ProcessHandler grepFromFileWithLongCmd(String file, String searchPrefix, Collection<String> searchStrings) throws IOException {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String searchString : searchStrings) {
            if (first) {
                builder.append('\"');
                first = false;
            } else {
                builder.append('\n');
            }
            builder.append(searchPrefix);
            builder.append(searchString);
        }
        builder.append('\"');
        return DBpediaDumpCreator.grepFromFile(file, builder.toString());
    }

    protected static ProcessHandler grepFromFileWithTempFile(String file, String searchPrefix, Collection<String> searchStrings) throws IOException {
        File tempFile = File.createTempFile("grep", ".txt");
        tempFile.deleteOnExit();
        Throwable throwable = null;
        Object var5_6 = null;
        try (PrintStream out = new PrintStream(tempFile);){
            for (String searchString : searchStrings) {
                out.println(searchString);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String grep = file.endsWith(".bz2") ? "bzfgrep" : "fgrep";
        return ProcessHandler.create(grep, "-f", tempFile.getAbsolutePath(), file);
    }

    protected static boolean checkObjectLang(Triple t, String expectedLang) {
        Node object = t.getObject();
        if (!object.isLiteral()) {
            return true;
        }
        String lang = object.getLiteralLanguage();
        return lang.isEmpty() || expectedLang.equals(lang);
    }

    public static class ProcessHandler {
        private Process process;
        private Thread errorThread;

        public ProcessHandler(Process process, Thread errorThread) {
            this.process = process;
            this.errorThread = errorThread;
        }

        public boolean exitedCleanly() {
            try {
                this.process.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            try {
                this.errorThread.join(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.errorThread.isAlive()) {
                System.err.println("Warning, an error thread is still running.");
            }
            return this.process.exitValue() == 0 || this.process.exitValue() == 1;
        }

        public InputStream getInputStream() {
            return this.process.getInputStream();
        }

        public static ProcessHandler create(String ... commands) throws IOException {
            return ProcessHandler.create(Arrays.asList(commands));
        }

        public static ProcessHandler create(List<String> commands) throws IOException {
            final Process process = new ProcessBuilder(commands).start();
            Thread errorThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        IOUtils.copy((InputStream)process.getErrorStream(), (OutputStream)System.err);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            errorThread.start();
            return new ProcessHandler(process, errorThread);
        }
    }

    public static class SimpleStreamFilter
    extends SimpleTripleHandler {
        public SimpleStreamFilter(Predicate<Triple> check, StreamRDF consumer) {
            super(check, (Triple t) -> consumer.triple(t));
        }
    }

    public static class SimpleTripleHandler
    extends StreamRDFBase {
        private Predicate<Triple> check;
        private Consumer<Triple> consumer;

        public SimpleTripleHandler(Predicate<Triple> check, Consumer<Triple> consumer) {
            this.check = check;
            this.consumer = consumer;
        }

        public void triple(Triple triple) {
            if (this.check.test(triple)) {
                this.consumer.accept(triple);
            }
        }

        public void quad(Quad quad) {
            this.triple(quad.asTriple());
        }
    }
}

