/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.tapioca.gen.preprocessing;

import com.carrotsearch.hppc.IntObjectOpenHashMap;
import com.carrotsearch.hppc.IntOpenHashSet;
import com.carrotsearch.hppc.ObjectObjectOpenHashMap;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Timestamp;
import org.aksw.simba.tapioca.extraction.AbstractExtractor;
import org.aksw.simba.tapioca.extraction.Extractor;
import org.aksw.simba.tapioca.extraction.RDF2ExtractionStreamer;
import org.aksw.simba.tapioca.gen.data.StatResult;
import org.aksw.simba.tapioca.gen.util.StatResultComparator;
import org.apache.commons.io.IOUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.sparql.vocabulary.FOAF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatResultsReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatResultsReader.class);
    public static final String LOD_STATS_STAT_RESULT_BASE_URI = "http://lodstats.aksw.org/stat_result/";
    private RDF2ExtractionStreamer streamer = new RDF2ExtractionStreamer();

    public IntObjectOpenHashMap<StatResult> read(String statResultsFile) {
        IntObjectOpenHashMap<StatResult> statResults = this.readStatResults(statResultsFile);
        statResults = this.removeOldstatResults(statResults);
        return statResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IntObjectOpenHashMap<StatResult> readStatResults(String statResultsFile) {
        StatResultsExtractor extractor = new StatResultsExtractor();
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(statResultsFile);
            this.streamer.runExtraction((InputStream)fin, LOD_STATS_STAT_RESULT_BASE_URI, RDFLanguages.filenameToLang((String)statResultsFile), new Extractor[]{extractor});
        }
        catch (Exception e) {
            IntObjectOpenHashMap<StatResult> intObjectOpenHashMap;
            try {
                LOGGER.error("Error while parsing file \"" + statResultsFile + "\". Aborting.", (Throwable)e);
                intObjectOpenHashMap = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fin);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fin);
            return intObjectOpenHashMap;
        }
        IOUtils.closeQuietly((InputStream)fin);
        return extractor.statResults;
    }

    protected IntObjectOpenHashMap<StatResult> removeOldstatResults(IntObjectOpenHashMap<StatResult> statResults) {
        ObjectObjectOpenHashMap datasetStatResultsMapping = new ObjectObjectOpenHashMap();
        IntOpenHashSet removedStatResults = new IntOpenHashSet();
        StatResultComparator comparator = new StatResultComparator();
        for (int i = 0; i < statResults.allocated.length; ++i) {
            if (!statResults.allocated[i]) continue;
            StatResult statResult = (StatResult)statResults.values[i];
            if (datasetStatResultsMapping.containsKey((Object)statResult.datasetUri)) {
                StatResult statResult2 = (StatResult)datasetStatResultsMapping.get((Object)statResult.datasetUri);
                if (comparator.compare(statResult, statResult2) > 0) {
                    datasetStatResultsMapping.put((Object)statResult.datasetUri, (Object)statResult);
                    removedStatResults.add(statResult2.id);
                    continue;
                }
                removedStatResults.add(statResult.id);
                continue;
            }
            datasetStatResultsMapping.put((Object)statResult.datasetUri, (Object)statResult);
        }
        datasetStatResultsMapping = null;
        IntObjectOpenHashMap newStatResults = new IntObjectOpenHashMap();
        for (int i = 0; i < statResults.allocated.length; ++i) {
            if (!statResults.allocated[i] || removedStatResults.contains(statResults.keys[i])) continue;
            newStatResults.put(statResults.keys[i], (Object)((StatResult)statResults.values[i]));
        }
        return newStatResults;
    }

    protected static class StatResultsExtractor
    extends AbstractExtractor {
        public static final String FOAF_PRIMARY_TOPIC_URI = FOAF.primaryTopic.getURI();
        public static final String LAST_UPDATED_URI = "http://lodstats.aksw.org/ontology/lastUpdated";
        public IntObjectOpenHashMap<StatResult> statResults = new IntObjectOpenHashMap();

        protected StatResultsExtractor() {
        }

        public void handleTriple(Triple triple) {
            int statId;
            String subjUri;
            Node subject = triple.getSubject();
            if (!subject.isBlank() && (subjUri = subject.getURI()).startsWith(StatResultsReader.LOD_STATS_STAT_RESULT_BASE_URI) && (statId = StatResultsExtractor.getDatasetIdFromUri(subjUri)) >= 0) {
                StatResult statResult;
                if (this.statResults.containsKey(statId)) {
                    statResult = (StatResult)this.statResults.get(statId);
                } else {
                    statResult = new StatResult(statId, subjUri);
                    this.statResults.put(statId, (Object)statResult);
                }
                if (triple.getPredicate().equals((Object)FOAF.primaryTopic.asNode())) {
                    statResult.datasetUri = triple.getObject().getURI();
                } else if (LAST_UPDATED_URI.equals(triple.getPredicate().getURI())) {
                    try {
                        statResult.timestamp = Timestamp.valueOf(triple.getObject().toString().replace('T', ' '));
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.error("Couldn't parse time stamp \"" + triple.getObject() + "\". Ignoring this time stamp.");
                    }
                }
            }
        }

        protected static int getDatasetIdFromUri(String uri) {
            try {
                return Integer.parseInt(uri.substring(StatResultsReader.LOD_STATS_STAT_RESULT_BASE_URI.length()));
            }
            catch (NumberFormatException e) {
                LOGGER.error("Couldn't extract the stat result id from URI \"" + uri + "\". Returning -1.", (Throwable)e);
                return -1;
            }
        }
    }
}

