/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.tapioca.analyzer.sparql;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.util.StreamUtils;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.simba.tapioca.analyzer.sparql.AbstractSPARQLClient;
import org.aksw.simba.tapioca.analyzer.sparql.EndpointConfig;
import org.aksw.simba.tapioca.data.vocabularies.EVOID;
import org.aksw.simba.tapioca.data.vocabularies.VOID;
import org.aksw.simba.tapioca.extraction.voidex.VoidExtractor;
import org.apache.commons.io.FileUtils;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPARQLEndpointAnalyzer
extends AbstractSPARQLClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SPARQLEndpointAnalyzer.class);
    private static final String VOCABULARY_BLACKLIST_FILE = "vocabulary_blacklist.txt";
    private static final String SPECIAL_CLASSES_LIST_FILE = "special_classes.txt";
    private static final String LIST_NAME = "LIST";
    private static final String COUNT_NAME = "COUNT";
    private static final String URI_REPLACEMENT = "%URI%";
    private static final String FROM_CLAUSE_REPLACEMENT = "%FROM%";
    private static final String CLASS_LIST_QUERY = "SELECT DISTINCT ?LIST %FROM% WHERE { ?a <" + RDF.type.getURI() + "> ?" + "LIST" + " }";
    private static final String SPARQL_11_COUNT_QUERY = "SELECT (COUNT(*) AS ?COUNT) %FROM% WHERE ";
    private static final String SPARQL_10_COUNT_QUERY = "SELECT *  %FROM% WHERE ";
    private static final String COUNT_CLASS_WHERE_CLAUSE = "{ ?a <" + RDF.type.getURI() + "> <" + "%URI%" + "> }";
    private static final String PROPERTY_LIST_QUERY = "SELECT DISTINCT ?LIST %FROM% WHERE { ?a ?LIST ?b }";
    private static final String COUNT_PROPERTY_WHERE_CLAUSE = "{ ?a <%URI%> ?b }";
    private static final String REQUEST_ENTITIES_QUERY = "SELECT ?LIST %FROM% WHERE { ?LIST <" + RDF.type.getURI() + "> <" + "%URI%" + "> }";

    public SPARQLEndpointAnalyzer() {
    }

    public SPARQLEndpointAnalyzer(String cacheDirectory) {
        super(cacheDirectory);
    }

    public Model extractVoidInfo(EndpointConfig endpointCfg) {
        ResourceImpl blank;
        Resource[] instances;
        QueryExecutionFactory qef = null;
        try {
            qef = this.initQueryExecution(endpointCfg);
        }
        catch (Exception e) {
            LOGGER.error("Couldn't create QueryExecutionFactory. Aborting. Exception: {}", (Object)e.getLocalizedMessage());
            return null;
        }
        Set<String> specialClasses = SPARQLEndpointAnalyzer.loadSpecialClassesList();
        String fromClause = endpointCfg.graph == null ? "" : "FROM <" + endpointCfg.graph + ">";
        LOGGER.info("Requesting classes from " + endpointCfg + " ...");
        Resource[] resources = this.queryList(qef, CLASS_LIST_QUERY.replace(FROM_CLAUSE_REPLACEMENT, fromClause));
        if (resources == null) {
            if (fromClause.isEmpty()) {
                LOGGER.error("Couldn't get class list. Returning null.");
                return null;
            }
            LOGGER.warn("Got no result. Retrying it without FROM clause...");
            resources = this.queryList(qef, CLASS_LIST_QUERY.replace(FROM_CLAUSE_REPLACEMENT, ""));
            if (resources == null) {
                LOGGER.error("Couldn't get class list. Returning null.");
                return null;
            }
            fromClause = "";
        }
        LOGGER.info("Requesting class counts from " + endpointCfg + " ...");
        long[] counts = null;
        try {
            counts = this.queryCounts(qef, fromClause, COUNT_CLASS_WHERE_CLAUSE, resources);
        }
        catch (Exception e) {
            LOGGER.error("Exception while requesting class clounts from " + endpointCfg + ". returning null.", (Throwable)e);
            return null;
        }
        LOGGER.info("Checking special classes for " + endpointCfg + " ...");
        ArrayList<Resource[]> specialClassInstances = new ArrayList<Resource[]>();
        int i = 0;
        while (i < resources.length) {
            if (specialClasses.contains(resources[i].getURI())) {
                instances = this.queryList(qef, REQUEST_ENTITIES_QUERY.replaceAll(URI_REPLACEMENT, resources[i].getURI()).replace(FROM_CLAUSE_REPLACEMENT, fromClause));
                if (instances == null) {
                    LOGGER.warn("Couldn't get instances of \"{}\".", (Object)resources[i].getURI());
                }
                specialClassInstances.add(instances);
            }
            ++i;
        }
        Model voidModel = ModelFactory.createDefaultModel();
        ResourceImpl endpointAsResource = new ResourceImpl(endpointCfg.graph == null ? endpointCfg.uri : endpointCfg.graph);
        voidModel.add((Resource)endpointAsResource, RDF.type, (RDFNode)VOID.Dataset);
        long entities = 0L;
        int i2 = 0;
        while (i2 < resources.length) {
            blank = new ResourceImpl();
            voidModel.add((Resource)endpointAsResource, VOID.classPartition, (RDFNode)blank);
            voidModel.add((Resource)blank, VOID.clazz, (RDFNode)resources[i2]);
            if (counts != null) {
                voidModel.addLiteral((Resource)blank, VOID.entities, counts[i2]);
                entities += counts[i2];
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < specialClassInstances.size()) {
            instances = (Resource[])specialClassInstances.get(i2);
            if (instances != null) {
                int j = 0;
                while (j < instances.length) {
                    if (!voidModel.containsResource((RDFNode)instances[j])) {
                        blank = new ResourceImpl();
                        voidModel.add((Resource)endpointAsResource, EVOID.classPartition, (RDFNode)blank);
                        voidModel.add((Resource)blank, EVOID.specialClass, (RDFNode)instances[j]);
                        voidModel.addLiteral((Resource)blank, EVOID.entities, 0);
                    }
                    ++j;
                }
            }
            ++i2;
        }
        voidModel.addLiteral((Resource)endpointAsResource, VOID.classes, resources.length);
        if (counts != null) {
            voidModel.addLiteral((Resource)endpointAsResource, VOID.entities, entities);
        }
        LOGGER.info("Requesting properties from " + endpointCfg + " ...");
        resources = this.queryList(qef, PROPERTY_LIST_QUERY.replace(FROM_CLAUSE_REPLACEMENT, fromClause));
        if (resources == null) {
            LOGGER.error("Couldn't get properties list. Returning null.");
            return null;
        }
        LOGGER.info("Requesting property counts from " + endpointCfg + " ...");
        counts = null;
        try {
            counts = this.queryCounts(qef, fromClause, COUNT_PROPERTY_WHERE_CLAUSE, resources);
        }
        catch (Exception e) {
            LOGGER.error("Exception while requesting class property counts from " + endpointCfg + ". returning null.", (Throwable)e);
            return null;
        }
        int triples = 0;
        int i3 = 0;
        while (i3 < resources.length) {
            blank = new ResourceImpl();
            voidModel.add((Resource)endpointAsResource, VOID.propertyPartition, (RDFNode)blank);
            voidModel.add((Resource)blank, VOID.property, (RDFNode)resources[i3]);
            if (counts != null) {
                voidModel.addLiteral((Resource)blank, VOID.triples, counts[i3]);
                triples = (int)((long)triples + counts[i3]);
            }
            ++i3;
        }
        if (entities == 0L && triples == 0) {
            LOGGER.error("Got an empty VOID model without an entity and a triple. Returning null.");
            return null;
        }
        voidModel.addLiteral((Resource)endpointAsResource, VOID.properties, resources.length);
        if (counts != null) {
            voidModel.addLiteral((Resource)endpointAsResource, VOID.triples, triples);
        }
        return voidModel;
    }

    private Resource[] queryList(QueryExecutionFactory qef, String query) {
        QueryExecution exec = qef.createQueryExecution(query);
        ResultSet resultSet = null;
        try {
            resultSet = exec.execSelect();
        }
        catch (Exception e) {
            LOGGER.error("Couldn't query list. Returning null for query \"" + query + "\".", (Throwable)e);
            return null;
        }
        ArrayList<Object> results = new ArrayList<Object>();
        QuerySolution result = null;
        while (resultSet.hasNext()) {
            try {
                result = resultSet.next();
                results.add(result.getResource(LIST_NAME));
            }
            catch (ClassCastException e) {
                RDFNode node = result.get(LIST_NAME);
                LOGGER.error("One of the results is not a resource as which it has been expected. " + node.getClass().getSimpleName() + "(\"" + node.toString() + "\"). Trying to create a resource from it.");
                results.add(new ResourceImpl(result.get(LIST_NAME).toString()));
            }
        }
        return results.toArray(new Resource[results.size()]);
    }

    private long[] queryCounts(QueryExecutionFactory qef, String fromClause, String whereClause, Resource[] list) {
        long[] counts = new long[list.length];
        String query10 = SPARQL_10_COUNT_QUERY + whereClause;
        String query11 = SPARQL_11_COUNT_QUERY + whereClause;
        String localQuery = null;
        boolean understandsSPARQL11 = true;
        try {
            int i = 0;
            while (i < counts.length) {
                ResultSet resultSet;
                QueryExecution exec;
                if (understandsSPARQL11) {
                    try {
                        localQuery = query11.replaceAll(FROM_CLAUSE_REPLACEMENT, fromClause);
                        localQuery = localQuery.replaceAll(URI_REPLACEMENT, list[i].getURI());
                        exec = qef.createQueryExecution(localQuery);
                        if (exec == null) {
                            throw new NullPointerException("Couldn't create query execution object.");
                        }
                        resultSet = exec.execSelect();
                        if (resultSet.hasNext()) {
                            counts[i] = resultSet.next().getLiteral(COUNT_NAME).getLong();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.warn("Couldn't execute SPARQL 1.1 query. Trying SPARQL 1.0. query:\n" + localQuery + "\n", (Throwable)e);
                        --i;
                        understandsSPARQL11 = false;
                    }
                } else {
                    localQuery = query10.replaceAll(FROM_CLAUSE_REPLACEMENT, fromClause);
                    exec = qef.createQueryExecution(localQuery = localQuery.replaceAll(URI_REPLACEMENT, list[i].getURI()));
                    if (exec == null) {
                        throw new NullPointerException("Couldn't create query execution object.");
                    }
                    resultSet = exec.execSelect();
                    while (resultSet.hasNext()) {
                        resultSet.next();
                        int n = i;
                        counts[n] = counts[n] + 1L;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            LOGGER.error("Couldn't execute query. Aborting. query:\n" + localQuery + "\n", (Throwable)e);
            return null;
        }
        return counts;
    }

    public static Set<String> loadVocabBlacklist() {
        return SPARQLEndpointAnalyzer.loadList(VOCABULARY_BLACKLIST_FILE);
    }

    public static Set<String> loadSpecialClassesList() {
        return SPARQLEndpointAnalyzer.loadList(SPECIAL_CLASSES_LIST_FILE);
    }

    protected static Set<String> loadList(String listName) {
        InputStream is = VoidExtractor.class.getClassLoader().getResourceAsStream(listName);
        if (is == null) {
            LOGGER.error("Couldn't load list from resources. Returning null.");
            return new HashSet<String>();
        }
        String content = StreamUtils.toStringSafe((InputStream)is);
        if (content == null) {
            LOGGER.error("Couldn't load list from resources. Returning null.");
            return new HashSet<String>();
        }
        String[] lines = content.split("\n");
        HashSet<String> list = new HashSet<String>();
        int i = 0;
        while (i < lines.length) {
            lines[i] = lines[i].trim();
            if (lines[i].length() > 0) {
                list.add(lines[i]);
            }
            ++i;
        }
        return list;
    }

    @Deprecated
    protected static String[][] readEndpointsFile(File file) throws IOException {
        List lines = FileUtils.readLines((File)file);
        ArrayList<String> endpoints = new ArrayList<String>(lines.size());
        ArrayList<String> endpointNames = new ArrayList<String>(lines.size());
        ArrayList<String> graphs = new ArrayList<String>(lines.size());
        for (String line : lines) {
            String[] parts;
            if (line.isEmpty() || (parts = line.split("\t")).length < 2) continue;
            endpointNames.add(parts[0]);
            endpoints.add(parts[1]);
            graphs.add(parts.length >= 3 ? parts[2] : null);
        }
        return new String[][]{endpoints.toArray(new String[endpoints.size()]), endpointNames.toArray(new String[endpointNames.size()]), graphs.toArray(new String[graphs.size()])};
    }

    @Deprecated
    protected static Map<EndpointConfig, String> filterEndpoints(String[] endpoints, String[] names, String[] graphs) {
        HashMap<EndpointConfig, String> endpointNameMapping = new HashMap<EndpointConfig, String>();
        int i = 0;
        while (i < endpoints.length) {
            EndpointConfig endpointCfg = new EndpointConfig(endpoints[i], graphs[i]);
            String name = endpointNameMapping.containsKey(endpointCfg) ? String.valueOf((String)endpointNameMapping.get(endpointCfg)) + ',' + names[i] : names[i];
            if (!name.equals("kupkb")) {
                endpointNameMapping.put(endpointCfg, name);
            }
            ++i;
        }
        return endpointNameMapping;
    }
}

