/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.tapioca.analyzer.sparql;

import java.io.File;
import java.io.Serializable;
import java.util.Set;
import org.aksw.simba.tapioca.analyzer.label.LabelExtractionUtils;
import org.aksw.simba.tapioca.analyzer.sparql.EndpointConfig;
import org.aksw.simba.tapioca.analyzer.sparql.SPARQLEndpointLabelExtractor;
import org.dice_research.topicmodeling.commons.io.StorageHelper;
import org.dice_research.topicmodeling.concurrent.tasks.Task;

public class EndpointLabelExtractionTask
implements Task {
    private EndpointConfig endpointCfg;
    private File voidFile;
    private File outputFile;
    private String cacheDirectory;

    public EndpointLabelExtractionTask(EndpointConfig endpointCfg, File voidFile, File outputFile) {
        this(endpointCfg, voidFile, outputFile, null);
    }

    public EndpointLabelExtractionTask(EndpointConfig endpointCfg, File voidFile, File outputFile, String cacheDirectory) {
        this.endpointCfg = endpointCfg;
        this.voidFile = voidFile;
        this.outputFile = outputFile;
        this.cacheDirectory = cacheDirectory;
    }

    public void run() {
        Set<String> uris = LabelExtractionUtils.readUris(this.voidFile);
        if (uris == null) {
            return;
        }
        SPARQLEndpointLabelExtractor extractor = new SPARQLEndpointLabelExtractor(this.cacheDirectory);
        String[][] labels = extractor.requestLabels(uris, this.endpointCfg);
        if (labels != null) {
            StorageHelper.storeToFileSavely((Serializable)labels, (String)this.outputFile.getAbsolutePath());
            labels = null;
        }
    }

    public String getId() {
        return this.endpointCfg.uri;
    }

    public String getProgress() {
        return "";
    }
}

