/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.tapioca.analyzer.sparql;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.aksw.simba.tapioca.analyzer.sparql.EndpointConfig;
import org.aksw.simba.tapioca.analyzer.sparql.SPARQLEndpointAnalyzer;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.dice_research.topicmodeling.concurrent.tasks.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointAnalyzingTask
implements Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(EndpointAnalyzingTask.class);
    private EndpointConfig endpointCfg;
    private String endpointName;
    private File outputFile;
    private String cacheDirectory;

    public EndpointAnalyzingTask(String endpoint, File outputFile) {
        this(new EndpointConfig(endpoint), endpoint, null, outputFile);
    }

    public EndpointAnalyzingTask(EndpointConfig endpointCfg, String endpointName, File outputFile) {
        this(endpointCfg, endpointName, null, outputFile);
    }

    public EndpointAnalyzingTask(EndpointConfig endpointCfg, String endpointName, String cacheDirectory, File outputFile) {
        this.endpointCfg = endpointCfg;
        this.endpointName = endpointName;
        this.outputFile = outputFile;
        this.cacheDirectory = cacheDirectory;
    }

    public void run() {
        block7: {
            LOGGER.info("Starting extraction from \"" + this.endpointName + "\"...");
            SPARQLEndpointAnalyzer analyzer = new SPARQLEndpointAnalyzer(this.cacheDirectory);
            try {
                try {
                    if (this.outputFile.exists()) {
                        LOGGER.info("There already is a file for \"" + this.endpointName + "\". Jumping over this endpoint.");
                        break block7;
                    }
                    Model voidModel = analyzer.extractVoidInfo(this.endpointCfg);
                    if (voidModel != null) {
                        voidModel.setNsPrefix("void", "http://rdfs.org/ns/void#");
                        FileOutputStream fout = new FileOutputStream(this.outputFile);
                        RDFDataMgr.write((OutputStream)fout, (Model)voidModel, (RDFFormat)RDFFormat.TURTLE_PRETTY);
                        fout.close();
                        break block7;
                    }
                    LOGGER.error("Error while requesting the void information of \"" + this.endpointName + "\".");
                }
                catch (Exception e) {
                    LOGGER.error("Error while requesting and storing the void information of \"" + this.endpointName + "\".", (Throwable)e);
                    LOGGER.info("Finished extraction from \"" + this.endpointName + "\"...");
                }
            }
            finally {
                LOGGER.info("Finished extraction from \"" + this.endpointName + "\"...");
            }
        }
    }

    public String getId() {
        return this.endpointName;
    }

    public String getProgress() {
        return "";
    }
}

