/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.tapioca.analyzer.sparql;

import java.sql.SQLException;
import org.aksw.jena_sparql_api.cache.core.QueryExecutionFactoryCacheEx;
import org.aksw.jena_sparql_api.cache.extra.CacheBackend;
import org.aksw.jena_sparql_api.cache.extra.CacheFrontend;
import org.aksw.jena_sparql_api.cache.extra.CacheFrontendImpl;
import org.aksw.jena_sparql_api.cache.h2.CacheCoreH2;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.delay.core.QueryExecutionFactoryDelay;
import org.aksw.jena_sparql_api.http.QueryExecutionFactoryHttp;
import org.aksw.jena_sparql_api.pagination.core.QueryExecutionFactoryPaginated;
import org.aksw.simba.tapioca.analyzer.sparql.EndpointConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSPARQLClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSPARQLClient.class);
    private static final int DELAY = 5000;
    private static final long CACHE_TIME_TO_LIVE = 2678400000L;
    private String cacheDirectory;

    public AbstractSPARQLClient() {
    }

    public AbstractSPARQLClient(String cacheDirectory) {
        this.cacheDirectory = cacheDirectory;
    }

    protected QueryExecutionFactory initQueryExecution(EndpointConfig endpointCfg) throws ClassNotFoundException, SQLException {
        QueryExecutionFactoryHttp qef = endpointCfg.graph != null ? new QueryExecutionFactoryHttp(endpointCfg.uri, endpointCfg.graph) : new QueryExecutionFactoryHttp(endpointCfg.uri);
        qef = new QueryExecutionFactoryDelay((QueryExecutionFactory)qef, 5000L);
        if (this.cacheDirectory != null) {
            CacheBackend cacheBackend = CacheCoreH2.create((boolean)true, (String)this.cacheDirectory, (String)endpointCfg.uri.replaceAll("[:/]", "_"), (long)2678400000L, (boolean)true);
            CacheFrontendImpl cacheFrontend = new CacheFrontendImpl(cacheBackend);
            qef = new QueryExecutionFactoryCacheEx((QueryExecutionFactory)qef, (CacheFrontend)cacheFrontend);
        } else {
            LOGGER.info("The cache directory has not been set. Creating an uncached SPARQL client.");
        }
        try {
            return new QueryExecutionFactoryPaginated((QueryExecutionFactory)qef, 100L);
        }
        catch (Exception e) {
            LOGGER.warn("Couldn't create Factory with pagination. Returning Factory without pagination. Exception: {}", (Object)e.getLocalizedMessage());
            return qef;
        }
    }
}

